/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LIFReader
extends FormatReader {
    public static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    protected Vector offsets;
    private int[] bitsPerPixel;
    private int[] extraDimensions;
    private int bpp;
    private Vector xcal;
    private Vector ycal;
    private Vector zcal;
    private Vector seriesNames;
    private Vector containerNames;
    private Vector containerCounts;

    public LIFReader() {
        super("Leica Image File Format", "lif");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 112;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        long offset = (Long)this.offsets.get(this.series);
        this.in.seek(offset + (long)(this.core.sizeX[this.series] * this.core.sizeY[this.series] * no * FormatTools.getBytesPerPixel(this.getPixelType()) * this.getRGBChannelCount()));
        this.in.read(buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LIFReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.offsets = new Vector();
        this.core.littleEndian[0] = true;
        this.in.order(this.core.littleEndian[0]);
        this.xcal = new Vector();
        this.ycal = new Vector();
        this.zcal = new Vector();
        this.status("Reading header");
        byte checkOne = (byte)this.in.read();
        this.in.skipBytes(2);
        byte checkTwo = (byte)this.in.read();
        if (checkOne != 112 && checkTwo != 112) {
            throw new FormatException(id + " is not a valid Leica LIF file");
        }
        this.in.skipBytes(4);
        if (this.in.read() != 42) {
            throw new FormatException("Invalid XML description");
        }
        int nc = this.in.readInt();
        String xml = DataTools.stripString(this.in.readString(nc * 2));
        this.status("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            if (this.in.readInt() != 112) {
                throw new FormatException("Invalid Memory Block");
            }
            this.in.skipBytes(4);
            if (this.in.read() != 42) {
                throw new FormatException("Invalid Memory Description");
            }
            long blockLength = this.in.readInt();
            if (this.in.read() != 42) {
                this.in.seek(this.in.getFilePointer() - 5L);
                blockLength = this.in.readLong();
                if (this.in.read() != 42) {
                    throw new FormatException("Invalid Memory Description");
                }
            }
            int descrLength = this.in.readInt();
            this.in.skipBytes(descrLength * 2);
            if (blockLength > 0L) {
                this.offsets.add(new Long(this.in.getFilePointer()));
            }
            long skipped = 0L;
            while (skipped < blockLength) {
                if (blockLength - skipped > 4096L) {
                    skipped += (long)this.in.skipBytes(4096);
                    continue;
                }
                skipped += (long)this.in.skipBytes((int)(blockLength - skipped));
            }
        }
        this.initMetadata(xml);
    }

    private void initMetadata(String xml) throws FormatException, IOException {
        String token;
        this.containerNames = new Vector();
        this.containerCounts = new Vector();
        this.seriesNames = new Vector();
        LIFHandler handler = new LIFHandler();
        xml = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>" + xml + "</LEICA>";
        for (int i = 0; i < xml.length(); ++i) {
            char c = xml.charAt(i);
            if (!Character.isISOControl(c) && Character.isDefined(c)) continue;
            xml = xml.replace(c, ' ');
        }
        try {
            SAXParser parser = SAX_FACTORY.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException exc) {
            throw new FormatException(exc);
        }
        catch (SAXException exc) {
            throw new FormatException(exc);
        }
        Vector<String> elements = new Vector<String>();
        this.status("Populating native metadata");
        StringTokenizer st = new StringTokenizer(xml, ">");
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            elements.add(token.substring(1));
        }
        token = (String)elements.get(0);
        String key = token.substring(0, token.indexOf("\""));
        String value = token.substring(token.indexOf("\"") + 1, token.length() - 1);
        this.addMeta(key, value);
        int numDatasets = 0;
        Vector<Integer> widths = new Vector<Integer>();
        Vector<Integer> heights = new Vector<Integer>();
        Vector<Integer> zs = new Vector<Integer>();
        Vector<Integer> ts = new Vector<Integer>();
        Vector<Integer> channels = new Vector<Integer>();
        Vector<Integer> bps = new Vector<Integer>();
        Vector<Integer> extraDims = new Vector<Integer>();
        for (int ndx = 1; ndx < elements.size(); ++ndx) {
            token = (String)elements.get(ndx);
            if (token.startsWith("ScannerSettingRecord")) {
                int index;
                if (token.indexOf("csScanMode") != -1) {
                    index = token.indexOf("Variant") + 7;
                    String ordering = token.substring(index + 2, token.indexOf("\"", index + 3));
                    if ((ordering = ordering.toLowerCase()).indexOf("x") != -1 && ordering.indexOf("y") != -1 && ordering.indexOf("xy") != -1) continue;
                    int xPos = ordering.indexOf("x");
                    int yPos = ordering.indexOf("y");
                    int zPos = ordering.indexOf("z");
                    int tPos = ordering.indexOf("t");
                    if (xPos < 0) {
                        xPos = 0;
                    }
                    if (yPos < 0) {
                        yPos = 1;
                    }
                    if (zPos < 0) {
                        zPos = 2;
                    }
                    if (tPos < 0) {
                        tPos = 3;
                    }
                    int x = (Integer)widths.get(widths.size() - 1);
                    int y = (Integer)heights.get(widths.size() - 1);
                    int z = (Integer)zs.get(widths.size() - 1);
                    int t = (Integer)ts.get(widths.size() - 1);
                    int[] dimensions = new int[]{x, y, z, t};
                    x = dimensions[xPos];
                    y = dimensions[yPos];
                    z = dimensions[zPos];
                    t = dimensions[tPos];
                    widths.setElementAt(new Integer(x), widths.size() - 1);
                    heights.setElementAt(new Integer(y), heights.size() - 1);
                    zs.setElementAt(new Integer(z), zs.size() - 1);
                    ts.setElementAt(new Integer(t), ts.size() - 1);
                    continue;
                }
                if (token.indexOf("dblVoxel") == -1) continue;
                index = token.indexOf("Variant") + 7;
                String size = token.substring(index + 2, token.indexOf("\"", index + 3));
                float cal = Float.parseFloat(size) * 1000000.0f;
                if (token.indexOf("X") != -1) {
                    this.xcal.add(new Float(cal));
                    continue;
                }
                if (token.indexOf("Y") != -1) {
                    this.ycal.add(new Float(cal));
                    continue;
                }
                if (token.indexOf("Z") == -1) continue;
                this.zcal.add(new Float(cal));
                continue;
            }
            if (!token.startsWith("Element Name")) continue;
            ++numDatasets;
            int numChannels = 0;
            int extras = 1;
            while (token.indexOf("/ImageDescription") == -1) {
                if (token.indexOf("=") != -1) {
                    int idx;
                    if (token.startsWith("Element Name") && (idx = numDatasets - 1) >= this.seriesNames.size()) {
                        numDatasets = this.seriesNames.size();
                        idx = numDatasets - 1;
                    }
                    Hashtable<String, String> tmp = new Hashtable<String, String>();
                    while (token.length() > 2) {
                        key = token.substring(0, token.indexOf("\"") - 1);
                        value = token.substring(token.indexOf("\"") + 1, token.indexOf("\"", token.indexOf("\"") + 1));
                        token = token.substring(key.length() + value.length() + 3);
                        key = key.trim();
                        value = value.trim();
                        tmp.put(key, value);
                    }
                    if (tmp.get("ChannelDescription DataType") != null) {
                        if (++numChannels == 1) {
                            bps.add(new Integer((String)tmp.get("Resolution")));
                        }
                    } else if (tmp.get("DimensionDescription DimID") != null) {
                        int w = Integer.parseInt((String)tmp.get("NumberOfElements"));
                        int id = Integer.parseInt((String)tmp.get("DimensionDescription DimID"));
                        switch (id) {
                            case 1: {
                                widths.add(new Integer(w));
                                break;
                            }
                            case 2: {
                                heights.add(new Integer(w));
                                break;
                            }
                            case 3: {
                                zs.add(new Integer(w));
                                break;
                            }
                            case 4: {
                                ts.add(new Integer(w));
                                break;
                            }
                            default: {
                                extras *= w;
                            }
                        }
                    }
                }
                if (elements == null || ++ndx >= elements.size()) break;
                token = (String)elements.get(ndx);
            }
            extraDims.add(new Integer(extras));
            if (numChannels == 0) {
                ++numChannels;
            }
            channels.add(new Integer(numChannels));
            if (widths.size() < numDatasets && heights.size() < numDatasets) {
                --numDatasets;
                continue;
            }
            if (widths.size() < numDatasets) {
                widths.add(new Integer(1));
            }
            if (heights.size() < numDatasets) {
                heights.add(new Integer(1));
            }
            if (zs.size() < numDatasets) {
                zs.add(new Integer(1));
            }
            if (ts.size() < numDatasets) {
                ts.add(new Integer(1));
            }
            if (bps.size() >= numDatasets) continue;
            bps.add(new Integer(8));
        }
        numDatasets = widths.size();
        this.bitsPerPixel = new int[numDatasets];
        this.extraDimensions = new int[numDatasets];
        this.status("Populating metadata");
        MetadataStore store = this.getMetadataStore();
        this.core = new CoreMetadata(numDatasets);
        Arrays.fill(this.core.orderCertain, true);
        for (int i = 0; i < numDatasets; ++i) {
            this.core.sizeX[i] = (Integer)widths.get(i);
            this.core.sizeY[i] = (Integer)heights.get(i);
            this.core.sizeZ[i] = (Integer)zs.get(i);
            this.core.sizeC[i] = (Integer)channels.get(i);
            this.core.sizeT[i] = (Integer)ts.get(i);
            this.core.currentOrder[i] = this.core.sizeZ[i] > this.core.sizeT[i] ? "XYCZT" : "XYCTZ";
            this.bitsPerPixel[i] = (Integer)bps.get(i);
            this.extraDimensions[i] = (Integer)extraDims.get(i);
            if (this.extraDimensions[i] > 1) {
                if (this.core.sizeZ[i] == 1) {
                    this.core.sizeZ[i] = this.extraDimensions[i];
                } else {
                    int n = i;
                    this.core.sizeT[n] = this.core.sizeT[n] * this.extraDimensions[i];
                }
                this.extraDimensions[i] = 1;
            }
            this.core.metadataComplete[i] = true;
            this.core.littleEndian[i] = true;
            this.core.rgb[i] = false;
            this.core.interleaved[i] = false;
            this.core.imageCount[i] = this.core.sizeZ[i] * this.core.sizeT[i];
            int n = i;
            this.core.imageCount[n] = this.core.imageCount[n] * this.core.sizeC[i];
            this.core.indexed[i] = false;
            this.core.falseColor[i] = false;
            while (this.bitsPerPixel[i] % 8 != 0) {
                int n2 = i;
                this.bitsPerPixel[n2] = this.bitsPerPixel[n2] + 1;
            }
            switch (this.bitsPerPixel[i]) {
                case 8: {
                    this.core.pixelType[i] = 1;
                    break;
                }
                case 16: {
                    this.core.pixelType[i] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[i] = 6;
                }
            }
            Integer ii = new Integer(i);
            String seriesName = (String)this.seriesNames.get(i);
            if (seriesName == null || seriesName.trim().length() == 0) {
                seriesName = "Series " + (i + 1);
            }
            store.setImage(seriesName, null, null, ii);
            FormatTools.populatePixels(store, this);
            Float xf = i < this.xcal.size() ? (Float)this.xcal.get(i) : null;
            Float yf = i < this.ycal.size() ? (Float)this.ycal.get(i) : null;
            Float zf = i < this.zcal.size() ? (Float)this.zcal.get(i) : null;
            store.setDimensions(xf, yf, zf, null, null, ii);
            for (int j = 0; j < this.core.sizeC[i]; ++j) {
                store.setLogicalChannel(j, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, ii);
            }
            String zoom = (String)this.getMeta(seriesName + " - dblZoom");
            store.setDisplayOptions(zoom == null ? null : new Float(zoom), new Boolean(this.core.sizeC[i] > 1), new Boolean(this.core.sizeC[i] > 1), new Boolean(this.core.sizeC[i] > 2), new Boolean(this.isRGB()), null, null, null, null, null, ii, null, null, null, null, null);
            Enumeration keys = this.metadata.keys();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                if (!k.startsWith((String)this.seriesNames.get(i) + " ")) continue;
                this.core.seriesMetadata[i].put(k, this.metadata.get(k));
            }
        }
    }

    class LIFHandler
    extends DefaultHandler {
        private String series;
        private String fullSeries;
        private int count = 0;
        private boolean firstElement = true;
        private boolean dcroiOpen = false;

        LIFHandler() {
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("Element")) {
                if (this.dcroiOpen) {
                    this.dcroiOpen = false;
                    return;
                }
                this.fullSeries = this.fullSeries.indexOf("/") != -1 ? this.fullSeries.substring(0, this.fullSeries.lastIndexOf("/")) : "";
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Element")) {
                if (!attributes.getValue("Name").equals("DCROISet") && !this.firstElement) {
                    this.series = attributes.getValue("Name");
                    LIFReader.this.containerNames.add(this.series);
                    this.fullSeries = this.fullSeries == null || this.fullSeries.equals("") ? this.series : this.fullSeries + "/" + this.series;
                } else if (this.firstElement) {
                    this.firstElement = false;
                }
                if (attributes.getValue("Name").equals("DCROISet")) {
                    this.dcroiOpen = true;
                }
            } else if (qName.equals("Experiment")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    LIFReader.this.addMeta(attributes.getQName(i), attributes.getValue(i));
                }
            } else if (qName.equals("Image")) {
                LIFReader.this.containerNames.remove(this.series);
                if (LIFReader.this.containerCounts.size() < LIFReader.this.containerNames.size()) {
                    LIFReader.this.containerCounts.add(new Integer(1));
                } else if (LIFReader.this.containerCounts.size() > 0) {
                    int ndx = LIFReader.this.containerCounts.size() - 1;
                    int n = (Integer)LIFReader.this.containerCounts.get(ndx);
                    LIFReader.this.containerCounts.setElementAt(new Integer(n + 1), ndx);
                }
                if (this.fullSeries == null || this.fullSeries.equals("")) {
                    this.fullSeries = this.series;
                }
                LIFReader.this.seriesNames.add(this.fullSeries);
            } else if (qName.equals("ChannelDescription")) {
                String prefix = this.fullSeries + " - Channel " + this.count + " - ";
                LIFReader.this.addMeta(prefix + "Min", attributes.getValue("Min"));
                LIFReader.this.addMeta(prefix + "Max", attributes.getValue("Max"));
                LIFReader.this.addMeta(prefix + "Resolution", attributes.getValue("Resolution"));
                LIFReader.this.addMeta(prefix + "LUTName", attributes.getValue("LUTName"));
                LIFReader.this.addMeta(prefix + "IsLUTInverted", attributes.getValue("IsLUTInverted"));
                ++this.count;
            } else if (qName.equals("DimensionDescription")) {
                String prefix = this.fullSeries + " - Dimension " + this.count + " - ";
                LIFReader.this.addMeta(prefix + "NumberOfElements", attributes.getValue("NumberOfElements"));
                LIFReader.this.addMeta(prefix + "Length", attributes.getValue("Length"));
                LIFReader.this.addMeta(prefix + "Origin", attributes.getValue("Origin"));
                LIFReader.this.addMeta(prefix + "DimID", attributes.getValue("DimID"));
            } else if (qName.equals("ScannerSettingRecord")) {
                String key = attributes.getValue("Identifier") + " - " + attributes.getValue("Description");
                LIFReader.this.addMeta(this.fullSeries + " - " + key, attributes.getValue("Variant"));
            } else if (qName.equals("FilterSettingRecord")) {
                String key = attributes.getValue("ObjectName") + " - " + attributes.getValue("Description") + " - " + attributes.getValue("Attribute");
                LIFReader.this.addMeta(this.fullSeries + " - " + key, attributes.getValue("Variant"));
            } else if (qName.equals("ATLConfocalSettingDefinition")) {
                if (this.fullSeries.endsWith(" - Master sequential setting")) {
                    this.fullSeries = this.fullSeries.replaceAll(" - Master sequential setting", " - Sequential Setting 0");
                }
                if (this.fullSeries.indexOf("- Sequential Setting ") == -1) {
                    this.fullSeries = this.fullSeries + " - Master sequential setting";
                } else {
                    int ndx = this.fullSeries.indexOf(" - Sequential Setting ") + 22;
                    int n = Integer.parseInt(this.fullSeries.substring(ndx));
                    this.fullSeries = this.fullSeries.substring(0, ndx) + String.valueOf(++n);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    LIFReader.this.addMeta(this.fullSeries + " - " + attributes.getQName(i), attributes.getValue(i));
                }
            } else if (qName.equals("Wheel")) {
                String prefix = this.fullSeries + " - Wheel " + this.count + " - ";
                LIFReader.this.addMeta(prefix + "Qualifier", attributes.getValue("Qualifier"));
                LIFReader.this.addMeta(prefix + "FilterIndex", attributes.getValue("FilterIndex"));
                LIFReader.this.addMeta(prefix + "FilterSpectrumPos", attributes.getValue("FilterSpectrumPos"));
                LIFReader.this.addMeta(prefix + "IsSpectrumTurnMode", attributes.getValue("IsSpectrumTurnMode"));
                LIFReader.this.addMeta(prefix + "IndexChanged", attributes.getValue("IndexChanged"));
                LIFReader.this.addMeta(prefix + "SpectrumChanged", attributes.getValue("SpectrumChanged"));
                ++this.count;
            } else if (qName.equals("WheelName")) {
                String prefix = this.fullSeries + " - Wheel " + (this.count - 1) + " - WheelName ";
                int ndx = 0;
                while (LIFReader.this.getMeta(prefix + ndx) != null) {
                    ++ndx;
                }
                LIFReader.this.addMeta(prefix + ndx, attributes.getValue("FilterName"));
            } else if (qName.equals("MultiBand")) {
                String prefix = this.fullSeries + " - MultiBand Channel " + attributes.getValue("Channel") + " - ";
                LIFReader.this.addMeta(prefix + "LeftWorld", attributes.getValue("LeftWorld"));
                LIFReader.this.addMeta(prefix + "RightWorld", attributes.getValue("RightWorld"));
                LIFReader.this.addMeta(prefix + "DyeName", attributes.getValue("DyeName"));
            } else if (qName.equals("LaserLineSetting")) {
                String prefix = this.fullSeries + " - LaserLine " + attributes.getValue("LaserLine") + " - ";
                LIFReader.this.addMeta(prefix + "IntensityDev", attributes.getValue("IntensityDev"));
                LIFReader.this.addMeta(prefix + "IntensityLowDev", attributes.getValue("IntensityLowDev"));
                LIFReader.this.addMeta(prefix + "AOBSIntensityDev", attributes.getValue("AOBSIntensityDev"));
                LIFReader.this.addMeta(prefix + "AOBSIntensityLowDev", attributes.getValue("AOBSIntensityLowDev"));
                LIFReader.this.addMeta(prefix + "EnableDoubleMode", attributes.getValue("EnableDoubleMode"));
                LIFReader.this.addMeta(prefix + "LineIndex", attributes.getValue("LineIndex"));
                LIFReader.this.addMeta(prefix + "Qualifier", attributes.getValue("Qualifier"));
                LIFReader.this.addMeta(prefix + "SequenceIndex", attributes.getValue("SequenceIndex"));
            } else if (qName.equals("Detector")) {
                String prefix = this.fullSeries + " - Detector Channel " + attributes.getValue("Channel") + " - ";
                LIFReader.this.addMeta(prefix + "IsActive", attributes.getValue("IsActive"));
                LIFReader.this.addMeta(prefix + "IsReferenceUnitActivatedForCorrection", attributes.getValue("IsReferenceUnitActivatedForCorrection"));
                LIFReader.this.addMeta(prefix + "Gain", attributes.getValue("Gain"));
                LIFReader.this.addMeta(prefix + "Offset", attributes.getValue("Offset"));
            } else if (qName.equals("Laser")) {
                String prefix = this.fullSeries + " Laser " + attributes.getValue("LaserName") + " - ";
                LIFReader.this.addMeta(prefix + "CanDoLinearOutputPower", attributes.getValue("CanDoLinearOutputPower"));
                LIFReader.this.addMeta(prefix + "OutputPower", attributes.getValue("OutputPower"));
                LIFReader.this.addMeta(prefix + "Wavelength", attributes.getValue("Wavelength"));
            } else if (qName.equals("TimeStamp")) {
                long high = Long.parseLong(attributes.getValue("HighInteger"));
                long low = Long.parseLong(attributes.getValue("LowInteger"));
                long stamp = 0L;
                high <<= 32;
                if ((int)low < 0) {
                    low &= 0xFFFFFFFFL;
                }
                stamp = high + low;
                long ms = stamp / 10000L;
                String n = String.valueOf(this.count);
                while (n.length() < 4) {
                    n = "0" + n;
                }
                LIFReader.this.addMeta(this.fullSeries + " - TimeStamp " + n, DataTools.convertDate(ms, 1));
                ++this.count;
            } else if (qName.equals("ChannelScalingInfo")) {
                String prefix = this.fullSeries + " - ChannelScalingInfo " + this.count + " - ";
                LIFReader.this.addMeta(prefix + "WhiteValue", attributes.getValue("WhiteValue"));
                LIFReader.this.addMeta(prefix + "BlackValue", attributes.getValue("BlackValue"));
                LIFReader.this.addMeta(prefix + "GammaValue", attributes.getValue("GammaValue"));
                LIFReader.this.addMeta(prefix + "Automatic", attributes.getValue("Automatic"));
            } else if (qName.equals("RelTimeStamp")) {
                LIFReader.this.addMeta(this.fullSeries + " RelTimeStamp " + attributes.getValue("Frame"), attributes.getValue("Time"));
            } else {
                this.count = 0;
            }
        }
    }
}

