/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import thredds.ui.BAMutil;
import thredds.ui.SuperComboBox;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class WmsViewer
extends JPanel {
    private Namespace wmsNamespace = Namespace.getNamespace("http://www.opengis.net/wms");
    private PreferencesExt prefs;
    private JPanel imagePanel;
    private SuperComboBox crsChooser;
    private SuperComboBox formatChooser;
    private SuperComboBox styleChooser;
    private SuperComboBox timeChooser;
    private SuperComboBox levelChooser;
    private BeanTableSorted ftTable;
    private JSplitPane split;
    private StringBuilder info = new StringBuilder();
    private String version;
    private String endpoint;
    private BufferedImage currImage = null;
    private static HttpClient httpClient = null;

    public WmsViewer(PreferencesExt prefs, RootPaneContainer root) {
        this.prefs = prefs;
        JPanel chooserPanel = new JPanel();
        chooserPanel.setLayout(new FlowLayout(0, 0, 0));
        this.crsChooser = new SuperComboBox(root, "crs", false, null);
        chooserPanel.add(new JLabel("CRS:"));
        chooserPanel.add(this.crsChooser);
        this.formatChooser = new SuperComboBox(root, "format", false, null);
        chooserPanel.add(new JLabel("format:"));
        chooserPanel.add(this.formatChooser);
        this.styleChooser = new SuperComboBox(root, "style", false, null);
        chooserPanel.add(new JLabel("Style:"));
        chooserPanel.add(this.styleChooser);
        this.timeChooser = new SuperComboBox(root, "time", false, null);
        chooserPanel.add(new JLabel("Time:"));
        chooserPanel.add(this.timeChooser);
        this.levelChooser = new SuperComboBox(root, "level", false, null);
        chooserPanel.add(new JLabel("Level:"));
        chooserPanel.add(this.levelChooser);
        AbstractButton mapButton = BAMutil.makeButtcon("WorldDetailMap", "getMap", false);
        mapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LayerBean ftb = (LayerBean)WmsViewer.this.ftTable.getSelectedBean();
                WmsViewer.this.getMap(ftb);
            }
        });
        chooserPanel.add(mapButton);
        AbstractButton redrawButton = BAMutil.makeButtcon("alien", "redraw image", false);
        redrawButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WmsViewer.this.showImage(WmsViewer.this.currImage);
            }
        });
        chooserPanel.add(redrawButton);
        this.imagePanel = new JPanel();
        this.ftTable = new BeanTableSorted(LayerBean.class, (PreferencesExt)prefs.node("LayerBeans"), false);
        this.ftTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                LayerBean ftb = (LayerBean)WmsViewer.this.ftTable.getSelectedBean();
                WmsViewer.this.styleChooser.setCollection(ftb.styles.iterator());
                WmsViewer.this.timeChooser.setCollection(ftb.times.iterator());
                WmsViewer.this.levelChooser.setCollection(ftb.levels.iterator());
            }
        });
        this.ftTable.setBeans(new ArrayList());
        this.split = new JSplitPane(1, false, this.ftTable, this.imagePanel);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)chooserPanel, "North");
        this.add((Component)this.split, "Center");
    }

    public boolean setDataset(String version, String endpoint) {
        this.version = version;
        this.endpoint = endpoint;
        return this.getCapabilities();
    }

    public String getDetailInfo() {
        return this.info.toString();
    }

    public void save() {
        this.ftTable.saveState(false);
    }

    private void showImage(BufferedImage img) {
        if (img != null) {
            Graphics g = this.imagePanel.getGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
            this.currImage = img;
        } else {
            Graphics2D g = (Graphics2D)this.imagePanel.getGraphics();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.dispose();
            this.currImage = img;
        }
    }

    public static void setHttpClient(HttpClient client) {
        httpClient = client;
    }

    private synchronized void initHttpClient() {
        if (httpClient != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        httpClient = new HttpClient(connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCapabilities() {
        this.initHttpClient();
        Formatter f = new Formatter();
        f.format("%s?request=GetCapabilities&service=WMS&version=%s", this.endpoint, this.version);
        String url = f.toString();
        this.info.setLength(0);
        this.info.append(url + "\n");
        GetMethod method = null;
        try {
            method = new GetMethod(url);
            method.setFollowRedirects(true);
            int statusCode = httpClient.executeMethod(method);
            this.info.append(" Status = " + method.getStatusCode() + " " + method.getStatusText() + "\n");
            this.info.append(" Status Line = " + method.getStatusLine() + "\n");
            this.printHeaders(" Response Headers = ", method.getResponseHeaders());
            this.info.append("GetCapabilities:\n\n");
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            String contents = IO.readContents(method.getResponseBodyAsStream());
            this.info.append(contents);
            StringBufferInputStream is = new StringBufferInputStream(contents);
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(is);
            Element root = tdoc.getRootElement();
            this.parseGetCapabilities(root);
        }
        catch (Exception e) {
            this.info.append(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return true;
    }

    private void parseGetCapabilities(Element root) {
        Element capElem = root.getChild("Capability", this.wmsNamespace);
        Element layer1Elem = capElem.getChild("Layer", this.wmsNamespace);
        ArrayList<String> crsList = new ArrayList<String>(100);
        for (Element crsElem : layer1Elem.getChildren("CRS", this.wmsNamespace)) {
            crsList.add(crsElem.getText());
        }
        this.crsChooser.setCollection(crsList.iterator());
        Element reqElem = capElem.getChild("Request", this.wmsNamespace);
        Element mapElem = reqElem.getChild("GetMap", this.wmsNamespace);
        ArrayList<String> formatList = new ArrayList<String>(100);
        for (Element formatElem : mapElem.getChildren("Format", this.wmsNamespace)) {
            formatList.add(formatElem.getText());
        }
        this.formatChooser.setCollection(formatList.iterator());
        ArrayList<LayerBean> beans = new ArrayList<LayerBean>(100);
        Element layer2Elem = layer1Elem.getChild("Layer", this.wmsNamespace);
        for (Element layer3Elem : layer2Elem.getChildren("Layer", this.wmsNamespace)) {
            beans.add(new LayerBean(layer3Elem));
        }
        this.ftTable.setBeans(beans);
        this.ftTable.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMap(LayerBean layer) {
        this.initHttpClient();
        Formatter f = new Formatter();
        f.format("%s?request=GetMap&service=WMS&version=%s&", this.endpoint, this.version);
        f.format("layers=%s&CRS=%s&", layer.getName(), layer.getCRS());
        f.format("bbox=%s,%s,%s,%s&", layer.getMinx(), layer.getMiny(), layer.getMaxx(), layer.getMaxy());
        f.format("width=500&height=500&", new Object[0]);
        f.format("styles=%s&", this.styleChooser.getSelectedObject());
        f.format("format=%s&", this.formatChooser.getSelectedObject());
        if (layer.hasTime) {
            f.format("time=%s&", this.timeChooser.getSelectedObject());
        }
        if (layer.hasLevel) {
            f.format("elevation=%s&", this.levelChooser.getSelectedObject());
        }
        String url = f.toString();
        this.info.setLength(0);
        this.info.append(url + "\n");
        GetMethod method = null;
        try {
            method = new GetMethod(url);
            method.setFollowRedirects(true);
            int statusCode = httpClient.executeMethod(method);
            this.info.append(" Status = " + method.getStatusCode() + " " + method.getStatusText() + "\n");
            this.info.append(" Status Line = " + method.getStatusLine() + "\n");
            this.printHeaders(" Response Headers = ", method.getResponseHeaders());
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            Header h = method.getResponseHeader("Content-Type");
            String mimeType = h == null ? "" : h.getValue();
            this.info.append(" mimeType = " + mimeType + "\n");
            byte[] contents = IO.readContentsToByteArray(method.getResponseBodyAsStream());
            this.info.append(" content len = " + contents.length + "\n");
            ByteArrayInputStream is = new ByteArrayInputStream(contents);
            BufferedImage img = ImageIO.read(is);
            this.showImage(img);
            if (img == null) {
                this.info.append("getMap:\n\n");
                if (mimeType.equals("application/vnd.google-earth.kmz")) {
                    File temp = File.createTempFile("Temp", ".kmz");
                    IO.writeToFile(contents, temp);
                    contents = null;
                    ZipFile zfile = new ZipFile(temp);
                    Enumeration<? extends ZipEntry> entries = zfile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        this.info.append(" entry=" + entry + "\n");
                        if (!entry.getName().endsWith(".kml")) continue;
                        InputStream kml = zfile.getInputStream(entry);
                        contents = IO.readContentsToByteArray(kml);
                    }
                }
                if (contents != null) {
                    this.info.append(new String(contents) + "\n");
                }
            }
        }
        catch (Exception e) {
            this.info.append(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return true;
    }

    private void printHeaders(String title, Header[] heads) {
        this.info.append(title + "\n");
        for (int i = 0; i < heads.length; ++i) {
            Header head = heads[i];
            this.info.append("  " + head.toString());
        }
        this.info.append("\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LayerBean {
        String name;
        String title;
        String CRS;
        String minx;
        String maxx;
        String miny;
        String maxy;
        boolean hasTime;
        boolean hasLevel;
        List<String> styles = new ArrayList<String>();
        List<String> levels = new ArrayList<String>();
        List<String> times = new ArrayList<String>();

        public LayerBean() {
        }

        LayerBean(Element layer3Elem) {
            this.name = this.getVal(layer3Elem, "Name");
            this.title = this.getVal(layer3Elem, "Title");
            Element bbElem = layer3Elem.getChild("BoundingBox", WmsViewer.this.wmsNamespace);
            this.CRS = bbElem.getAttributeValue("CRS");
            this.minx = bbElem.getAttributeValue("minx");
            this.maxx = bbElem.getAttributeValue("maxx");
            this.miny = bbElem.getAttributeValue("miny");
            this.maxy = bbElem.getAttributeValue("maxy");
            for (Element elem : layer3Elem.getChildren("Style", WmsViewer.this.wmsNamespace)) {
                Element nameElem = elem.getChild("Name", WmsViewer.this.wmsNamespace);
                this.styles.add(nameElem.getText());
            }
            for (Element elem : layer3Elem.getChildren("Dimension", WmsViewer.this.wmsNamespace)) {
                String[] st;
                String name = elem.getAttributeValue("name");
                if (name.equals("time")) {
                    for (String s : st = elem.getText().split(",")) {
                        this.times.add(StringUtil.removeWhitespace(s));
                    }
                    boolean bl = this.hasTime = this.times.size() > 0;
                }
                if (!name.equals("elevation")) continue;
                for (String s : st = elem.getText().split(",")) {
                    this.levels.add(StringUtil.removeWhitespace(s));
                }
                this.hasLevel = this.levels.size() > 0;
            }
        }

        String getVal(Element parent, String name) {
            Element elem = parent.getChild(name, WmsViewer.this.wmsNamespace);
            return name == null ? "" : elem.getText();
        }

        List<String> getVals(Element parent, String name) {
            ArrayList<String> result = new ArrayList<String>(10);
            for (Element elem : parent.getChildren(name, WmsViewer.this.wmsNamespace)) {
                result.add(elem.getText());
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getCRS() {
            return this.CRS;
        }

        public String getMinx() {
            return this.minx;
        }

        public String getMaxx() {
            return this.maxx;
        }

        public String getMiny() {
            return this.miny;
        }

        public String getMaxy() {
            return this.maxy;
        }
    }
}

