/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

class XMLInputStream
extends InputStream {
    private Segment segment = new Segment();
    private Document document = null;
    private int end = 0;
    private int pos = 0;
    private int index = 0;

    public XMLInputStream(Document doc) {
        this.document = doc;
        this.end = this.document.getLength();
        this.pos = 0;
        try {
            this.loadSegment();
        }
        catch (IOException ioe) {
            throw new Error("unexpected: " + ioe);
        }
    }

    public void setRange(int start, int end) {
        this.end = end;
        this.pos = start;
        try {
            this.loadSegment();
        }
        catch (IOException ioe) {
            throw new Error("unexpected: " + ioe);
        }
    }

    public int read() throws IOException {
        if (this.index >= this.segment.offset + this.segment.count) {
            if (this.pos >= this.end) {
                return -1;
            }
            this.loadSegment();
        }
        return this.segment.array[this.index++];
    }

    public int read(char[] chars) throws IOException {
        return this.read(chars, 0, chars.length);
    }

    public int read(char[] chars, int i, int j) throws IOException {
        int i1;
        if (chars == null) {
            throw new NullPointerException();
        }
        if (i < 0 || j < 0 || j > chars.length - i) {
            throw new IndexOutOfBoundsException();
        }
        if (j == 0) {
            return 0;
        }
        int k = this.read();
        if (k == -1) {
            return -1;
        }
        chars[i] = (char)k;
        try {
            int l;
            for (i1 = 1; i1 < j && (l = this.read()) != -1; ++i1) {
                chars[i + i1] = (char)l;
            }
        }
        catch (IOException ioexception) {
        }
        return i1;
    }

    private void loadSegment() throws IOException {
        try {
            int n = Math.min(1024, this.end - this.pos);
            this.document.getText(this.pos, n, this.segment);
            this.pos += n;
            this.index = this.segment.offset;
        }
        catch (BadLocationException e) {
            throw new IOException("Bad location");
        }
    }
}

