/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStreamReader;

public class CdmRemote
extends NetcdfFile {
    public static final String SCHEME = "cdmremote:";
    private static Logger logger = LoggerFactory.getLogger(CdmRemote.class);
    private static HttpClient httpClient;
    private static boolean showRequest;
    private final String remoteURI;

    public static String canonicalURL(String urlName) {
        if (urlName.startsWith("http:")) {
            return SCHEME + urlName.substring(5);
        }
        return urlName;
    }

    public static void setHttpClient(HttpClient client) {
        httpClient = client;
    }

    private static synchronized void initHttpClient() {
        if (httpClient != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        httpClient = new HttpClient(connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdmRemote(String _remoteURI) throws IOException {
        String temp = _remoteURI;
        try {
            if (temp.startsWith(SCHEME)) {
                temp = temp.substring(SCHEME.length());
            }
            if (!temp.startsWith("http:")) {
                temp = "http:" + temp;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.remoteURI = temp;
        CdmRemote.initHttpClient();
        HttpMethod method = null;
        try {
            int statusCode;
            String url = this.remoteURI + "?req=header";
            method = new GetMethod(url);
            method.setFollowRedirects(true);
            if (showRequest) {
                System.out.printf(" ncstream request %s %n", url);
            }
            if ((statusCode = httpClient.executeMethod(method)) == 404) {
                throw new FileNotFoundException(method.getURI() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getURI() + " " + method.getStatusLine());
            }
            InputStream is = method.getResponseBodyAsStream();
            NcStreamReader reader = new NcStreamReader();
            reader.readStream(is, this);
            this.location = SCHEME + this.remoteURI;
            Object var9_9 = null;
            if (method != null) {
                method.releaseConnection();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (method != null) {
                method.releaseConnection();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        if (this.unlocked) {
            throw new IllegalStateException("File is unlocked - cannot use");
        }
        StringBuilder sbuff = new StringBuilder(this.remoteURI);
        sbuff.append("?var=");
        sbuff.append(URLEncoder.encode(v.getShortName(), "UTF-8"));
        sbuff.append("(");
        sbuff.append(section.toString());
        sbuff.append(")");
        if (showRequest) {
            System.out.println("CdmRemote data request for variable: " + v.getName() + " section= " + section + " url=" + sbuff);
        }
        GetMethod method = null;
        try {
            String s;
            int readLen;
            method = new GetMethod(sbuff.toString());
            method.setFollowRedirects(true);
            int statusCode = httpClient.executeMethod(method);
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            int wantSize = (int)((long)v.getElementSize() * section.computeSize());
            Header h = method.getResponseHeader("Content-Length");
            if (h != null && (readLen = Integer.parseInt(s = h.getValue())) != wantSize) {
                throw new IOException("content-length= " + readLen + " not equal expected Size= " + wantSize);
            }
            InputStream is = method.getResponseBodyAsStream();
            NcStreamReader reader = new NcStreamReader();
            NcStreamReader.DataResult result = reader.readData(is, this);
            assert (v.getName().equals(result.varName));
            result.data.setUnsigned(v.isUnsigned());
            Array array = result.data;
            Object var13_13 = null;
            if (method != null) {
                method.releaseConnection();
            }
            return array;
        }
        catch (Throwable throwable) {
            block9: {
                Object var13_14 = null;
                if (method == null) break block9;
                method.releaseConnection();
            }
            throw throwable;
        }
    }

    public static HttpMethod sendQuery(String remoteURI, String query) throws IOException {
        CdmRemote.initHttpClient();
        StringBuilder sbuff = new StringBuilder(remoteURI);
        sbuff.append("?");
        sbuff.append(query);
        if (showRequest) {
            System.out.println("CdmRemote sendQuery=" + sbuff);
        }
        GetMethod method = new GetMethod(sbuff.toString());
        method.setFollowRedirects(true);
        int statusCode = httpClient.executeMethod(method);
        if (statusCode == 404) {
            throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
        }
        if (statusCode >= 300) {
            throw new IOException(method.getPath() + " " + method.getStatusLine());
        }
        return method;
    }

    public String getFileTypeId() {
        return "ncstreamRemote";
    }

    public String getFileTypeDescription() {
        return "ncstreamRemote";
    }

    static {
        showRequest = true;
    }
}

