/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class PSnav
extends AREAnav {
    private boolean isEastPositive = true;
    int iwest;
    int ihem;
    double xrow;
    double xcol;
    double xpole;
    double xlat1;
    double xspace;
    double xqlon;
    double xblat;
    double fac;

    public PSnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1347624992) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.xrow = iparms[1];
        this.xcol = iparms[2];
        int ipole = iparms[10];
        if (ipole == 0) {
            ipole = 900000;
        }
        this.ihem = 1;
        if (ipole < 0) {
            this.ihem = -1;
        }
        this.xpole = McIDASUtil.integerLatLonToDouble(ipole);
        this.xlat1 = McIDASUtil.integerLatLonToDouble(ipole - iparms[3]) * (Math.PI / 180);
        this.xspace = (double)iparms[4] / 1000.0;
        this.xqlon = McIDASUtil.integerLatLonToDouble(iparms[5]);
        double r = (double)iparms[6] / 1000.0;
        this.iwest = iparms[9];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.xblat = r * Math.sin(this.xlat1) / (this.xspace * Math.tan(this.xlat1 * 0.5));
        this.fac = 1.0;
    }

    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double radius;
            double xlon;
            double xldif = (double)this.ihem * (imglinele[1][point] - this.xrow) / this.xblat;
            double xedif = (this.xcol - imglinele[0][point]) / this.xblat;
            double xrlon = 0.0;
            if (xldif != 0.0 || xedif != 0.0) {
                xrlon = Math.atan2(xedif, xldif);
            }
            if ((xlon = (double)this.iwest * xrlon / (Math.PI / 180) + this.xqlon) > 180.0) {
                xlon -= 360.0;
            }
            if (xlon < -180.0) {
                xlon += 360.0;
            }
            double xlat = Math.abs(radius = Math.sqrt(xldif * xldif + xedif * xedif)) < 1.0E-10 ? (double)(this.ihem * 90) : (double)this.ihem * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(radius / this.fac))) / (Math.PI / 180));
            latlon[0][point] = xlat;
            latlon[1][point] = this.iwest == 1 ? -xlon : xlon;
        }
        return latlon;
    }

    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xlat = latlon[0][point];
            double xlon = this.iwest == 1 ? -latlon[1][point] : latlon[1][point];
            double xrlon = (double)this.ihem * (xlon - this.xqlon);
            if (xrlon > 180.0) {
                xrlon -= 360.0;
            }
            if (xrlon < -180.0) {
                xrlon += 360.0;
            }
            xrlon = (double)this.iwest * xrlon * (Math.PI / 180);
            double xclat = (this.xpole - xlat) * (Math.PI / 180) * 0.5;
            double xrlat = this.xblat * Math.tan(xclat);
            linele[1][point] = xrlat * Math.cos(xrlon) + this.xrow;
            linele[0][point] = -xrlat * Math.sin(xrlon) + this.xcol;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

