# _dicom_dict.py
"""DICOM data dictionary auto-generated by C:\co\pydicomtemp\source\generate_dict\csv2dict.py"""

DicomDictionary = {
0x00020000: ('UL', '1', "File Meta Information Group Length", ''),
0x00020001: ('OB', '1', "File Meta Information Version", ''),
0x00020002: ('UI', '1', "Media Storage SOP Class UID", ''),
0x00020003: ('UI', '1', "Media Storage SOP Instance UID", ''),
0x00020010: ('UI', '1', "Transfer Syntax UID", ''),
0x00020012: ('UI', '1', "Implementation Class UID", ''),
0x00020013: ('SH', '1', "Implementation Version Name", ''),
0x00020016: ('AE', '1', "Source Application Entity Title", ''),
0x00020100: ('UI', '1', "Private Information Creator UID", ''),
0x00020102: ('OB', '1', "Private Information", ''),
0x00041130: ('CS', '1', "File-set ID", ''),
0x00041141: ('CS', '1-8', "File-set Descriptor File ID", ''),
0x00041142: ('CS', '1', "Specific Character Set of File-set Descriptor File", ''),
0x00041200: ('UL', '1', "Offset of the First Directory Record of the Root Directory Entity", ''),
0x00041202: ('UL', '1', "Offset of the Last Directory Record of the Root Directory Entity", ''),
0x00041212: ('US', '1', "File-set Consistency Flag", ''),
0x00041220: ('SQ', '1', "Directory Record Sequence", ''),
0x00041400: ('UL', '1', "Offset of the Next Directory Record", ''),
0x00041410: ('US', '1', "Record In-use Flag", ''),
0x00041420: ('UL', '1', "Offset of Referenced Lower-Level Directory Entity", ''),
0x00041430: ('CS', '1', "Directory Record Type", ''),
0x00041432: ('UI', '1', "Private Record UID", ''),
0x00041500: ('CS', '1-8', "Referenced File ID", ''),
0x00041504: ('UL', '1', "MRDR Directory Record Offset", 'Retired'),
0x00041510: ('UI', '1', "Referenced SOP Class UID in File", ''),
0x00041511: ('UI', '1', "Referenced SOP Instance UID in File", ''),
0x00041512: ('UI', '1', "Referenced Transfer Syntax UID in File", ''),
0x0004151A: ('UI', '1-n', "Referenced Related General SOP Class UID in File", ''),
0x00041600: ('UL', '1', "Number of References", 'Retired'),
0x00080001: ('UL', '1', "Length to End", 'Retired'),
0x00080005: ('CS', '1-n', "Specific Character Set", ''),
0x00080008: ('CS', '2-n', "Image Type", ''),
0x00080010: ('CS', '1', "Recognition Code", 'Retired'),
0x00080012: ('DA', '1', "Instance Creation Date", ''),
0x00080013: ('TM', '1', "Instance Creation Time", ''),
0x00080014: ('UI', '1', "Instance Creator UID", ''),
0x00080016: ('UI', '1', "SOP Class UID", ''),
0x00080018: ('UI', '1', "SOP Instance UID", ''),
0x0008001A: ('UI', '1-n', "Related General SOP Class UID", ''),
0x0008001B: ('UI', '1', "Original Specialized SOP Class UID", ''),
0x00080020: ('DA', '1', "Study Date", ''),
0x00080021: ('DA', '1', "Series Date", ''),
0x00080022: ('DA', '1', "Acquisition Date", ''),
0x00080023: ('DA', '1', "Content Date", ''),
0x00080024: ('DA', '1', "Overlay Date", 'Retired'),
0x00080025: ('DA', '1', "Curve Date", 'Retired'),
0x0008002A: ('DT', '1', "Acquisition DateTime", ''),
0x00080030: ('TM', '1', "Study Time", ''),
0x00080031: ('TM', '1', "Series Time", ''),
0x00080032: ('TM', '1', "Acquisition Time", ''),
0x00080033: ('TM', '1', "Content Time", ''),
0x00080034: ('TM', '1', "Overlay Time", 'Retired'),
0x00080035: ('TM', '1', "Curve Time", 'Retired'),
0x00080040: ('US', '1', "Data Set Type", 'Retired'),
0x00080041: ('LO', '1', "Data Set Subtype", 'Retired'),
0x00080042: ('CS', '1', "Nuclear Medicine Series Type", 'Retired'),
0x00080050: ('SH', '1', "Accession Number", ''),
0x00080052: ('CS', '1', "Query/Retrieve Level", ''),
0x00080054: ('AE', '1-n', "Retrieve AE Title", ''),
0x00080056: ('CS', '1', "Instance Availability", ''),
0x00080058: ('UI', '1-n', "Failed SOP Instance UID List", ''),
0x00080060: ('CS', '1', "Modality", ''),
0x00080061: ('CS', '1-n', "Modalities in Study", ''),
0x00080062: ('UI', '1-n', "SOP Classes in Study", ''),
0x00080064: ('CS', '1', "Conversion Type", ''),
0x00080068: ('CS', '1', "Presentation Intent Type", ''),
0x00080070: ('LO', '1', "Manufacturer", ''),
0x00080080: ('LO', '1', "Institution Name", ''),
0x00080081: ('ST', '1', "Institution Address", ''),
0x00080082: ('SQ', '1', "Institution Code Sequence", ''),
0x00080090: ('PN', '1', "Referring Physician's Name", ''),
0x00080092: ('ST', '1', "Referring Physician's Address", ''),
0x00080094: ('SH', '1-n', "Referring Physician's Telephone Numbers", ''),
0x00080096: ('SQ', '1', "Referring Physician Identification Sequence", ''),
0x00080100: ('SH', '1', "Code Value", ''),
0x00080102: ('SH', '1', "Coding Scheme Designator", ''),
0x00080103: ('SH', '1', "Coding Scheme Version", ''),
0x00080104: ('LO', '1', "Code Meaning", ''),
0x00080105: ('CS', '1', "Mapping Resource", ''),
0x00080106: ('DT', '1', "Context Group Version", ''),
0x00080107: ('DT', '1', "Context Group Local Version", ''),
0x0008010B: ('CS', '1', "Context Group Extension Flag", ''),
0x0008010C: ('UI', '1', "Coding Scheme UID", ''),
0x0008010D: ('UI', '1', "Context Group Extension Creator UID", ''),
0x0008010F: ('CS', '1', "Context Identifier", ''),
0x00080110: ('SQ', '1', "Coding Scheme Identification Sequence", ''),
0x00080112: ('LO', '1', "Coding Scheme Registry", ''),
0x00080114: ('ST', '1', "Coding Scheme External ID", ''),
0x00080115: ('ST', '1', "Coding Scheme Name", ''),
0x00080116: ('ST', '1', "Coding Scheme Responsible Organization", ''),
0x00080201: ('SH', '1', "Timezone Offset From UTC", ''),
0x00081000: ('AE', '1', "Network ID", 'Retired'),
0x00081010: ('SH', '1', "Station Name", ''),
0x00081030: ('LO', '1', "Study Description", ''),
0x00081032: ('SQ', '1', "Procedure Code Sequence", ''),
0x0008103E: ('LO', '1', "Series Description", ''),
0x00081040: ('LO', '1', "Institutional Department Name", ''),
0x00081048: ('PN', '1-n', "Physician(s) of Record", ''),
0x00081049: ('SQ', '1', "Physician(s) of Record Identification Sequence", ''),
0x00081050: ('PN', '1-n', "Performing Physician's Name", ''),
0x00081052: ('SQ', '1', "Performing Physician Identification Sequence", ''),
0x00081060: ('PN', '1-n', "Name of  Physician(s) Reading Study", ''),
0x00081062: ('SQ', '1', "Physician(s) Reading Study Identification Sequence", ''),
0x00081070: ('PN', '1-n', "Operators' Name", ''),
0x00081072: ('SQ', '1', "Operator Identification Sequence", ''),
0x00081080: ('LO', '1-n', "Admitting Diagnoses Description", ''),
0x00081084: ('SQ', '1', "Admitting Diagnoses Code Sequence", ''),
0x00081090: ('LO', '1', "Manufacturer's Model Name", ''),
0x00081100: ('SQ', '1', "Referenced Results Sequence", 'Retired'),
0x00081110: ('SQ', '1', "Referenced Study Sequence", ''),
0x00081111: ('SQ', '1', "Referenced Performed Procedure Step Sequence", ''),
0x00081115: ('SQ', '1', "Referenced Series Sequence", ''),
0x00081120: ('SQ', '1', "Referenced Patient Sequence", ''),
0x00081125: ('SQ', '1', "Referenced Visit Sequence", ''),
0x00081130: ('SQ', '1', "Referenced Overlay Sequence", 'Retired'),
0x0008113A: ('SQ', '1', "Referenced Waveform Sequence", ''),
0x00081140: ('SQ', '1', "Referenced Image Sequence", ''),
0x00081145: ('SQ', '1', "Referenced Curve Sequence", 'Retired'),
0x0008114A: ('SQ', '1', "Referenced Instance Sequence", ''),
0x0008114B: ('SQ', '1', "Referenced Real World Value Mapping Instance Sequence", ''),
0x00081150: ('UI', '1', "Referenced SOP Class UID", ''),
0x00081155: ('UI', '1', "Referenced SOP Instance UID", ''),
0x0008115A: ('UI', '1-n', "SOP Classes Supported", ''),
0x00081160: ('IS', '1-n', "Referenced Frame Number", ''),
# From Supp 119
0x00081161: ('UL', '1-n', "Simple Frame List", ''),
0x00081162: ('UL', '3-3n', "Calculated Frame List", ''),
0x00081163: ('FD', '2', "Time Range", ''),
0x00081164: ('SQ', '1', "Frame Extraction Sequence", ''),
0x00081167: ('IS', '1', "Multi-Frame Source SOP Instance UID", ''),
# End From Supp 119
0x00081195: ('UI', '1', "Transaction UID", ''),
0x00081197: ('US', '1', "Failure Reason", ''),
0x00081198: ('SQ', '1', "Failed SOP Sequence", ''),
0x00081199: ('SQ', '1', "Referenced SOP Sequence", ''),
0x00081200: ('SQ', '1', "Studies Containing Other Referenced Instances Sequence", ''),
0x00081250: ('SQ', '1', "Related Series Sequence", ''),
0x00082110: ('CS', '1', "Lossy Image Compression (Retired)", 'Retired'),
0x00082111: ('ST', '1', "Derivation Description", ''),
0x00082112: ('SQ', '1', "Source Image Sequence", ''),
0x00082120: ('SH', '1', "Stage Name", ''),
0x00082122: ('IS', '1', "Stage Number", ''),
0x00082124: ('IS', '1', "Number of Stages", ''),
0x00082127: ('SH', '1', "View Name", ''),
0x00082128: ('IS', '1', "View Number", ''),
0x00082129: ('IS', '1', "Number of Event Timers", ''),
0x0008212A: ('IS', '1', "Number of Views in Stage", ''),
0x00082130: ('DS', '1-n', "Event Elapsed Time(s)", ''),
0x00082132: ('LO', '1-n', "Event Timer Name(s)", ''),
# From Supp 43
0x00082133: ('SQ', '1', "Event Timer Sequence", ''),
0x00082134: ('FD', '1', "Event Time Offset", ''),
0x00082135: ('SQ', '1', "Event Code Sequence", ''),
# End From Supp 43
0x00082142: ('IS', '1', "Start Trim", ''),
0x00082143: ('IS', '1', "Stop Trim", ''),
0x00082144: ('IS', '1', "Recommended Display Frame Rate", ''),
0x00082200: ('CS', '1', "Transducer Position", 'Retired'),
0x00082204: ('CS', '1', "Transducer Orientation", 'Retired'),
0x00082208: ('CS', '1', "Anatomic Structure", 'Retired'),
0x00082218: ('SQ', '1', "Anatomic Region Sequence", ''),
0x00082220: ('SQ', '1', "Anatomic Region Modifier Sequence", ''),
0x00082228: ('SQ', '1', "Primary Anatomic Structure Sequence", ''),
0x00082229: ('SQ', '1', "Anatomic Structure, Space or Region Sequence", ''),
0x00082230: ('SQ', '1', "Primary Anatomic Structure Modifier Sequence", ''),
0x00082240: ('SQ', '1', "Transducer Position Sequence", 'Retired'),
0x00082242: ('SQ', '1', "Transducer Position Modifier Sequence", 'Retired'),
0x00082244: ('SQ', '1', "Transducer Orientation Sequence", 'Retired'),
0x00082246: ('SQ', '1', "Transducer Orientation Modifier Sequence", 'Retired'),
0x00082251: ('SQ', '1', "Anatomic Structure Space Or Region Code Sequence (Trial)", 'Retired'),
0x00082253: ('SQ', '1', "Anatomic Portal Of Entrance Code Sequence (Trial)", 'Retired'),
0x00082255: ('SQ', '1', "Anatomic Approach Direction Code Sequence (Trial)", 'Retired'),
0x00082256: ('ST', '1', "Anatomic Perspective Description (Trial)", 'Retired'),
0x00082257: ('SQ', '1', "Anatomic Perspective Code Sequence (Trial)", 'Retired'),
0x00082258: ('ST', '1', "Anatomic Location Of Examining Instrument Description (Trial)", 'Retired'),
0x00082259: ('SQ', '1', "Anatomic Location Of Examining Instrument Code Sequence (Trial)", 'Retired'),
0x0008225A: ('SQ', '1', "Anatomic Structure Space Or Region Modifier Code Sequence (Trial)", 'Retired'),
0x0008225C: ('SQ', '1', "OnAxis Background Anatomic Structure Code Sequence (Trial)", 'Retired'),
0x00083001: ('SQ', '1', "Alternate Representation Sequence", ''),
0x00083010: ('UI', '1', "Irradiation Event UID", ''),
0x00084000: ('LT', '1', "Identifying Comments", 'Retired'),
0x00089007: ('CS', '4', "Frame Type", ''),
0x00089092: ('SQ', '1', "Referenced Image Evidence Sequence", ''),
0x00089121: ('SQ', '1', "Referenced Raw Data Sequence", ''),
0x00089123: ('UI', '1', "Creator-Version UID", ''),
0x00089124: ('SQ', '1', "Derivation Image Sequence", ''),
0x00089154: ('SQ', '1', "Source Image Evidence Sequence", ''),
0x00089205: ('CS', '1', "Pixel Presentation", ''),
0x00089206: ('CS', '1', "Volumetric Properties", ''),
0x00089207: ('CS', '1', "Volume Based Calculation Technique", ''),
0x00089208: ('CS', '1', "Complex Image Component", ''),
0x00089209: ('CS', '1', "Acquisition Contrast", ''),
0x00089215: ('SQ', '1', "Derivation Code Sequence", ''),
0x00089237: ('SQ', '1', "Referenced Grayscale Presentation State Sequence", ''),
0x00089410: ('SQ', '1', "Referenced Other Plane Sequence", ''),
0x00089458: ('SQ', '1', "Frame Display Sequence", ''),
0x00089459: ('FL', '1', "Recommended Display Frame Rate in Float", ''),
0x00089460: ('CS', '1', "Skip Frame Range Flag", ''),
0x00100010: ('PN', '1', "Patient's Name", ''),
0x00100020: ('LO', '1', "Patient ID", ''),
0x00100021: ('LO', '1', "Issuer of Patient ID", ''),
0x00100022: ('CS', '1', "Type of Patient ID", ''),
0x00100030: ('DA', '1', "Patient's Birth Date", ''),
0x00100032: ('TM', '1', "Patient's Birth Time", ''),
0x00100040: ('CS', '1', "Patient's Sex", ''),
0x00100050: ('SQ', '1', "Patient's Insurance Plan Code Sequence", ''),
0x00100101: ('SQ', '1', "Patient's Primary Language Code Sequence", ''),
0x00100102: ('SQ', '1', "Patient's Primary Language Code Modifier Sequence", ''),
0x00101000: ('LO', '1-n', "Other Patient IDs", ''),
0x00101001: ('PN', '1-n', "Other Patient Names", ''),
0x00101002: ('SQ', '1', "Other Patient IDs Sequence", ''),
0x00101005: ('PN', '1', "Patient's Birth Name", ''),
0x00101010: ('AS', '1', "Patient's Age", ''),
0x00101020: ('DS', '1', "Patient's Size", ''),
0x00101030: ('DS', '1', "Patient's Weight", ''),
0x00101040: ('LO', '1', "Patient's Address", ''),
0x00101050: ('LO', '1-n', "Insurance Plan Identification", 'Retired'),
0x00101060: ('PN', '1', "Patient's Mother's Birth Name", ''),
0x00101080: ('LO', '1', "Military Rank", ''),
0x00101081: ('LO', '1', "Branch of Service", ''),
0x00101090: ('LO', '1', "Medical Record Locator", ''),
0x00102000: ('LO', '1-n', "Medical Alerts", ''),
0x00102110: ('LO', '1-n', "Allergies", ''),
0x00102150: ('LO', '1', "Country of Residence", ''),
0x00102152: ('LO', '1', "Region of Residence", ''),
0x00102154: ('SH', '1-n', "Patient's Telephone Numbers", ''),
0x00102160: ('SH', '1', "Ethnic Group", ''),
0x00102180: ('SH', '1', "Occupation", ''),
0x001021A0: ('CS', '1', "Smoking Status", ''),
0x001021B0: ('LT', '1', "Additional Patient History", ''),
0x001021C0: ('US', '1', "Pregnancy Status", ''),
0x001021D0: ('DA', '1', "Last Menstrual Date", ''),
0x001021F0: ('LO', '1', "Patient's Religious Preference", ''),
0x00102201: ('LO', '1', "Patient Species Description", ''),
0x00102202: ('SQ', '1', "Patient Species Code Sequence", ''),
0x00102203: ('CS', '1', "Patient's Sex Neutered", ''),
0x00102292: ('LO', '1', "Patient Breed Description", ''),
0x00102293: ('SQ', '1', "Patient Breed Code Sequence", ''),
0x00102294: ('SQ', '1', "Breed Registration Sequence", ''),
0x00102295: ('LO', '1', "Breed Registration Number", ''),
0x00102296: ('SQ', '1', "Breed Registry Code Sequence", ''),
0x00102297: ('PN', '1', "Responsible Person", ''),
0x00102298: ('CS', '1', "Responsible Person Role", ''),
0x00102299: ('LO', '1', "Responsible Organization", ''),
0x00104000: ('LT', '1', "Patient Comments", ''),
0x00109431: ('FL', '1', "Examined Body Thickness", ''),
0x00120010: ('LO', '1', "Clinical Trial Sponsor Name", ''),
0x00120020: ('LO', '1', "Clinical Trial Protocol ID", ''),
0x00120021: ('LO', '1', "Clinical Trial Protocol Name", ''),
0x00120030: ('LO', '1', "Clinical Trial Site ID", ''),
0x00120031: ('LO', '1', "Clinical Trial Site Name", ''),
0x00120040: ('LO', '1', "Clinical Trial Subject ID", ''),
0x00120042: ('LO', '1', "Clinical Trial Subject Reading ID", ''),
0x00120050: ('LO', '1', "Clinical Trial Time Point ID", ''),
0x00120051: ('ST', '1', "Clinical Trial Time Point Description", ''),
0x00120060: ('LO', '1', "Clinical Trial Coordinating Center Name", ''),
0x00120062: ('CS', '1', "Patient Identity Removed", ''),
0x00120063: ('LO', '1-n', "De-identification Method", ''),
0x00120064: ('SQ', '1', "De-identification Method Code Sequence", ''),
0x00120071: ('LO', '1', "Clinical Trial Series ID", ''),
0x00120072: ('LO', '1', "Clinical Trial Series Description", ''),
0x00180010: ('LO', '1', "Contrast/Bolus Agent", ''),
0x00180012: ('SQ', '1', "Contrast/Bolus Agent Sequence", ''),
0x00180014: ('SQ', '1', "Contrast/Bolus Administration Route Sequence", ''),
0x00180015: ('CS', '1', "Body Part Examined", ''),
0x00180020: ('CS', '1-n', "Scanning Sequence", ''),
0x00180021: ('CS', '1-n', "Sequence Variant", ''),
0x00180022: ('CS', '1-n', "Scan Options", ''),
0x00180023: ('CS', '1', "MR Acquisition Type", ''),
0x00180024: ('SH', '1', "Sequence Name", ''),
0x00180025: ('CS', '1', "Angio Flag", ''),
0x00180026: ('SQ', '1', "Intervention Drug Information Sequence", ''),
0x00180027: ('TM', '1', "Intervention Drug Stop Time", ''),
0x00180028: ('DS', '1', "Intervention Drug Dose", ''),
0x00180029: ('SQ', '1', "Intervention Drug Sequence", ''),
0x0018002A: ('SQ', '1', "Additional Drug Sequence", ''),
0x00180030: ('LO', '1-n', "Radionuclide", 'Retired'),
0x00180031: ('LO', '1', "Radiopharmaceutical", ''),
0x00180032: ('DS', '1', "Energy Window Centerline", 'Retired'),
0x00180033: ('DS', '1-n', "Energy Window Total Width", 'Retired'),
0x00180034: ('LO', '1', "Intervention Drug Name", ''),
0x00180035: ('TM', '1', "Intervention Drug Start Time", ''),
0x00180036: ('SQ', '1', "Intervention Sequence", ''),
0x00180037: ('CS', '1', "Therapy Type", 'Retired'),
0x00180038: ('CS', '1', "Intervention Status", ''),
0x00180039: ('CS', '1', "Therapy Description", 'Retired'),
0x0018003A: ('ST', '1', "Intervention Description", ''),
0x00180040: ('IS', '1', "Cine Rate ", ''),
0x00180050: ('DS', '1', "Slice Thickness", ''),
0x00180060: ('DS', '1', "KVP", ''),
0x00180070: ('IS', '1', "Counts Accumulated", ''),
0x00180071: ('CS', '1', "Acquisition Termination Condition", ''),
0x00180072: ('DS', '1', "Effective Duration", ''),
0x00180073: ('CS', '1', "Acquisition Start Condition", ''),
0x00180074: ('IS', '1', "Acquisition Start Condition Data", ''),
0x00180075: ('IS', '1', "Acquisition Termination Condition Data", ''),
0x00180080: ('DS', '1', "Repetition Time", ''),
0x00180081: ('DS', '1', "Echo Time", ''),
0x00180082: ('DS', '1', "Inversion Time", ''),
0x00180083: ('DS', '1', "Number of Averages", ''),
0x00180084: ('DS', '1', "Imaging Frequency", ''),
0x00180085: ('SH', '1', "Imaged Nucleus", ''),
0x00180086: ('IS', '1-n', "Echo Number(s)", ''),
0x00180087: ('DS', '1', "Magnetic Field Strength", ''),
0x00180088: ('DS', '1', "Spacing Between Slices", ''),
0x00180089: ('IS', '1', "Number of Phase Encoding Steps", ''),
0x00180090: ('DS', '1', "Data Collection Diameter", ''),
0x00180091: ('IS', '1', "Echo Train Length", ''),
0x00180093: ('DS', '1', "Percent Sampling", ''),
0x00180094: ('DS', '1', "Percent Phase Field of View", ''),
0x00180095: ('DS', '1', "Pixel Bandwidth", ''),
0x00181000: ('LO', '1', "Device Serial Number", ''),
0x00181002: ('UI', '1', "Device UID", ''),
0x00181003: ('LO', '1', "Device ID", ''),
0x00181004: ('LO', '1', "Plate ID", ''),
0x00181005: ('LO', '1', "Generator ID", ''),
0x00181006: ('LO', '1', "Grid ID", ''),
0x00181007: ('LO', '1', "Cassette ID", ''),
0x00181008: ('LO', '1', "Gantry ID", ''),
0x00181010: ('LO', '1', "Secondary Capture Device ID", ''),
0x00181011: ('LO', '1', "Hardcopy Creation Device ID", 'Retired'),
0x00181012: ('DA', '1', "Date of Secondary Capture", ''),
0x00181014: ('TM', '1', "Time of Secondary Capture", ''),
0x00181016: ('LO', '1', "Secondary Capture Device Manufacturers", ''),
0x00181017: ('LO', '1', "Hardcopy Device Manufacturer", 'Retired'),
0x00181018: ('LO', '1', "Secondary Capture Device Manufacturer's Model Name", ''),
0x00181019: ('LO', '1-n', "Secondary Capture Device Software Version(s)", ''),
0x0018101A: ('LO', '1-n', "Hardcopy Device Software Version", 'Retired'),
0x0018101B: ('LO', '1', "Hardcopy Device Manufacturer's Model Name", 'Retired'),
0x00181020: ('LO', '1-n', "Software Version(s)", ''),
0x00181022: ('SH', '1', "Video Image Format Acquired", ''),
0x00181023: ('LO', '1', "Digital Image Format Acquired", ''),
0x00181030: ('LO', '1', "Protocol Name", ''),
0x00181040: ('LO', '1', "Contrast/Bolus Route", ''),
0x00181041: ('DS', '1', "Contrast/Bolus Volume", ''),
0x00181042: ('TM', '1', "Contrast/Bolus Start Time ", ''),
0x00181043: ('TM', '1', "Contrast/Bolus Stop Time ", ''),
0x00181044: ('DS', '1', "Contrast/Bolus Total Dose", ''),
0x00181045: ('IS', '1', "Syringe Counts", ''),
0x00181046: ('DS', '1-n', "Contrast Flow Rate", ''),
0x00181047: ('DS', '1-n', "Contrast Flow Duration", ''),
0x00181048: ('CS', '1', "Contrast/Bolus Ingredient", ''),
0x00181049: ('DS', '1', "Contrast/Bolus Ingredient Concentration", ''),
0x00181050: ('DS', '1', "Spatial Resolution", ''),
0x00181060: ('DS', '1', "Trigger Time", ''),
0x00181061: ('LO', '1', "Trigger Source or Type", ''),
0x00181062: ('IS', '1', "Nominal Interval", ''),
0x00181063: ('DS', '1', "Frame Time", ''),
0x00181064: ('LO', '1', "Cardiac Framing Type", ''),
0x00181065: ('DS', '1-n', "Frame Time Vector", ''),
0x00181066: ('DS', '1', "Frame Delay", ''),
0x00181067: ('DS', '1', "Image Trigger Delay", ''),
0x00181068: ('DS', '1', "Multiplex Group Time Offset", ''),
0x00181069: ('DS', '1', "Trigger Time Offset", ''),
0x0018106A: ('CS', '1', "Synchronization Trigger", ''),
0x0018106C: ('US', '2', "Synchronization Channel", ''),
0x0018106E: ('UL', '1', "Trigger Sample Position", ''),
0x00181070: ('LO', '1', "Radiopharmaceutical Route", ''),
0x00181071: ('DS', '1', "Radiopharmaceutical Volume", ''),
0x00181072: ('TM', '1', "Radiopharmaceutical Start Time", ''),
0x00181073: ('TM', '1', "Radiopharmaceutical Stop Time", ''),
0x00181074: ('DS', '1', "Radionuclide Total Dose", ''),
0x00181075: ('DS', '1', "Radionuclide Half Life", ''),
0x00181076: ('DS', '1', "Radionuclide Positron Fraction", ''),
0x00181077: ('DS', '1', "Radiopharmaceutical Specific Activity", ''),
0x00181078: ('DT', '1', "Radiopharmaceutical Start DateTime", ''),
0x00181079: ('DT', '1', "Radiopharmaceutical Stop DateTime", ''),
0x00181080: ('CS', '1', "Beat Rejection Flag", ''),
0x00181081: ('IS', '1', "Low R-R Value", ''),
0x00181082: ('IS', '1', "High R-R Value", ''),
0x00181083: ('IS', '1', "Intervals Acquired", ''),
0x00181084: ('IS', '1', "Intervals Rejected", ''),
0x00181085: ('LO', '1', "PVC Rejection", ''),
0x00181086: ('IS', '1', "Skip Beats", ''),
0x00181088: ('IS', '1', "Heart Rate", ''),
0x00181090: ('IS', '1', "Cardiac Number of Images", ''),
0x00181094: ('IS', '1', "Trigger Window", ''),
0x00181100: ('DS', '1', "Reconstruction Diameter", ''),
0x00181110: ('DS', '1', "Distance Source to Detector", ''),
0x00181111: ('DS', '1', "Distance Source to Patient", ''),
0x00181114: ('DS', '1', "Estimated Radiographic Magnification Factor", ''),
0x00181120: ('DS', '1', "Gantry/Detector Tilt", ''),
0x00181121: ('DS', '1', "Gantry/Detector Slew", ''),
0x00181130: ('DS', '1', "Table Height", ''),
0x00181131: ('DS', '1', "Table Traverse", ''),
0x00181134: ('CS', '1', "Table Motion", ''),
0x00181135: ('DS', '1-n', "Table Vertical Increment", ''),
0x00181136: ('DS', '1-n', "Table Lateral Increment", ''),
0x00181137: ('DS', '1-n', "Table Longitudinal Increment", ''),
0x00181138: ('DS', '1', "Table Angle", ''),
0x0018113A: ('CS', '1', "Table Type", ''),
0x00181140: ('CS', '1', "Rotation Direction", ''),
0x00181141: ('DS', '1', "Angular Position", 'Retired'),
0x00181142: ('DS', '1-n', "Radial Position", ''),
0x00181143: ('DS', '1', "Scan Arc", ''),
0x00181144: ('DS', '1', "Angular Step", ''),
0x00181145: ('DS', '1', "Center of Rotation Offset", ''),
0x00181146: ('DS', '1-n', "Rotation Offset", 'Retired'),
0x00181147: ('CS', '1', "Field of View Shape", ''),
0x00181149: ('IS', '1-2', "Field of View Dimension(s)", ''),
0x00181150: ('IS', '1', "Exposure Time", ''),
0x00181151: ('IS', '1', "X-Ray Tube Current", ''),
0x00181152: ('IS', '1', "Exposure ", ''),
0x00181153: ('IS', '1', "Exposure in ?As", ''),
0x00181154: ('DS', '1', "Average Pulse Width", ''),
0x00181155: ('CS', '1', "Radiation Setting", ''),
0x00181156: ('CS', '1', "Rectification Type", ''),
0x0018115A: ('CS', '1', "Radiation Mode", ''),
0x0018115E: ('DS', '1', "Image and Fluoroscopy Area Dose Product", ''),
0x00181160: ('SH', '1', "Filter Type", ''),
0x00181161: ('LO', '1-n', "Type of Filters", ''),
0x00181162: ('DS', '1', "Intensifier Size", ''),
0x00181164: ('DS', '2', "Imager Pixel Spacing", ''),
0x00181166: ('CS', '1-n', "Grid", ''),
0x00181170: ('IS', '1', "Generator Power", ''),
0x00181180: ('SH', '1', "Collimator/grid Name ", ''),
0x00181181: ('CS', '1', "Collimator Type", ''),
0x00181182: ('IS', '1-2', "Focal Distance", ''),
0x00181183: ('DS', '1-2', "X Focus Center", ''),
0x00181184: ('DS', '1-2', "Y Focus Center", ''),
0x00181190: ('DS', '1-n', "Focal Spot(s)", ''),
0x00181191: ('CS', '1', "Anode Target Material", ''),
0x001811A0: ('DS', '1', "Body Part Thickness", ''),
0x001811A2: ('DS', '1', "Compression Force", ''),
0x00181200: ('DA', '1-n', "Date of Last Calibration", ''),
0x00181201: ('TM', '1-n', "Time of Last Calibration", ''),
0x00181210: ('SH', '1-n', "Convolution Kernel", ''),
0x00181240: ('IS', '1-n', "Upper/Lower Pixel Values", 'Retired'),
0x00181242: ('IS', '1', "Actual Frame Duration", ''),
0x00181243: ('IS', '1', "Count Rate", ''),
0x00181244: ('US', '1', "Preferred Playback Sequencing", ''),
0x00181250: ('SH', '1', "Receive Coil Name", ''),
0x00181251: ('SH', '1', "Transmit Coil Name", ''),
0x00181260: ('SH', '1', "Plate Type", ''),
0x00181261: ('LO', '1', "Phosphor Type", ''),
0x00181300: ('DS', '1', "Scan Velocity", ''),
0x00181301: ('CS', '1-n', "Whole Body Technique", ''),
0x00181302: ('IS', '1', "Scan Length", ''),
0x00181310: ('US', '4', "Acquisition Matrix", ''),
0x00181312: ('CS', '1', "In-plane Phase Encoding Direction", ''),
0x00181314: ('DS', '1', "Flip Angle", ''),
0x00181315: ('CS', '1', "Variable Flip Angle Flag", ''),
0x00181316: ('DS', '1', "SAR", ''),
0x00181318: ('DS', '1', "dB/dt", ''),
0x00181400: ('LO', '1', "Acquisition Device Processing Description ", ''),
0x00181401: ('LO', '1', "Acquisition Device Processing Code", ''),
0x00181402: ('CS', '1', "Cassette Orientation", ''),
0x00181403: ('CS', '1', "Cassette Size", ''),
0x00181404: ('US', '1', "Exposures on Plate", ''),
0x00181405: ('IS', '1', "Relative X-Ray Exposure", ''),
0x00181450: ('DS', '1', "Column Angulation", ''),
0x00181460: ('DS', '1', "Tomo Layer Height", ''),
0x00181470: ('DS', '1', "Tomo Angle", ''),
0x00181480: ('DS', '1', "Tomo Time", ''),
0x00181490: ('CS', '1', "Tomo Type", ''),
0x00181491: ('CS', '1', "Tomo Class", ''),
0x00181495: ('IS', '1', "Number of Tomosynthesis Source Images", ''),
0x00181500: ('CS', '1', "Positioner Motion", ''),
0x00181508: ('CS', '1', "Positioner Type", ''),
0x00181510: ('DS', '1', "Positioner Primary Angle", ''),
0x00181511: ('DS', '1', "Positioner Secondary Angle", ''),
0x00181520: ('DS', '1-n', "Positioner Primary Angle Increment", ''),
0x00181521: ('DS', '1-n', "Positioner Secondary Angle Increment", ''),
0x00181530: ('DS', '1', "Detector Primary Angle", ''),
0x00181531: ('DS', '1', "Detector Secondary Angle", ''),
0x00181600: ('CS', '1-3', "Shutter Shape", ''),
0x00181602: ('IS', '1', "Shutter Left Vertical Edge", ''),
0x00181604: ('IS', '1', "Shutter Right Vertical Edge", ''),
0x00181606: ('IS', '1', "Shutter Upper Horizontal Edge", ''),
0x00181608: ('IS', '1', "Shutter Lower Horizontal Edge", ''),
0x00181610: ('IS', '2', "Center of Circular Shutter", ''),
0x00181612: ('IS', '1', "Radius of Circular Shutter", ''),
0x00181620: ('IS', '2-2n', "Vertices of the Polygonal Shutter", ''),
0x00181622: ('US', '1', "Shutter Presentation Value", ''),
0x00181623: ('US', '1', "Shutter Overlay Group", ''),
0x00181624: ('US', '3', "Shutter Presentation Color CIELab Value", ''),
0x00181700: ('CS', '1-3', "Collimator Shape", ''),
0x00181702: ('IS', '1', "Collimator Left Vertical Edge", ''),
0x00181704: ('IS', '1', "Collimator Right Vertical Edge", ''),
0x00181706: ('IS', '1', "Collimator Upper Horizontal Edge", ''),
0x00181708: ('IS', '1', "Collimator Lower Horizontal Edge", ''),
0x00181710: ('IS', '2', "Center of Circular Collimator", ''),
0x00181712: ('IS', '1', "Radius of Circular Collimator", ''),
0x00181720: ('IS', '2-2n', "Vertices of the Polygonal Collimator", ''),
0x00181800: ('CS', '1', "Acquisition Time Synchronized", ''),
0x00181801: ('SH', '1', "Time Source", ''),
0x00181802: ('CS', '1', "Time Distribution Protocol", ''),
0x00181803: ('LO', '1', "NTP Source Address", ''),
0x00182001: ('IS', '1-n', "Page Number Vector", ''),
0x00182002: ('SH', '1-n', "Frame Label Vector", ''),
0x00182003: ('DS', '1-n', "Frame Primary Angle Vector", ''),
0x00182004: ('DS', '1-n', "Frame Secondary Angle Vector", ''),
0x00182005: ('DS', '1-n', "Slice Location Vector", ''),
0x00182006: ('SH', '1-n', "Display Window Label Vector", ''),
0x00182010: ('DS', '2', "Nominal Scanned Pixel Spacing", ''),
0x00182020: ('CS', '1', "Digitizing Device Transport Direction", ''),
0x00182030: ('DS', '1', "Rotation of Scanned Film", ''),
0x00183100: ('CS', '1', "IVUS Acquisition", ''),
0x00183101: ('DS', '1', "IVUS Pullback Rate", ''),
0x00183102: ('DS', '1', "IVUS Gated Rate", ''),
0x00183103: ('IS', '1', "IVUS Pullback Start Frame Number", ''),
0x00183104: ('IS', '1', "IVUS Pullback Stop Frame Number", ''),
0x00183105: ('IS', '1-n', "Lesion Number ", ''),
0x00184000: ('LT', '1', "Acquisition Comments", 'Retired'),
0x00185000: ('SH', '1-n', "Output Power", ''),
0x00185010: ('LO', '3', "Transducer Data", ''),
0x00185012: ('DS', '1', "Focus Depth", ''),
0x00185020: ('LO', '1', "Processing Function", ''),
0x00185021: ('LO', '1', "Postprocessing Function", 'Retired'),
0x00185022: ('DS', '1', "Mechanical Index", ''),
0x00185024: ('DS', '1', "Bone Thermal Index", ''),
0x00185026: ('DS', '1', "Cranial Thermal Index", ''),
0x00185027: ('DS', '1', "Soft Tissue Thermal Index", ''),
0x00185028: ('DS', '1', "Soft Tissue-focus Thermal Index", ''),
0x00185029: ('DS', '1', "Soft Tissue-surface Thermal Index", ''),
0x00185030: ('DS', '1', "Dynamic Range", 'Retired'),
0x00185040: ('DS', '1', "Total Gain", 'Retired'),
0x00185050: ('IS', '1', "Depth of Scan Field", ''),
0x00185100: ('CS', '1', "Patient Position", ''),
0x00185101: ('CS', '1', "View Position", ''),
0x00185104: ('SQ', '1', "Projection Eponymous Name Code Sequence", ''),
0x00185210: ('DS', '6', "Image Transformation Matrix", 'Retired'),
0x00185212: ('DS', '3', "Image Translation Vector", 'Retired'),
0x00186000: ('DS', '1', "Sensitivity", ''),
0x00186011: ('SQ', '1', "Sequence of Ultrasound Regions", ''),
0x00186012: ('US', '1', "Region Spatial Format", ''),
0x00186014: ('US', '1', "Region Data Type", ''),
0x00186016: ('UL', '1', "Region Flags", ''),
0x00186018: ('UL', '1', "Region Location Min X0", ''),
0x0018601A: ('UL', '1', "Region Location Min Y0", ''),
0x0018601C: ('UL', '1', "Region Location Max X1", ''),
0x0018601E: ('UL', '1', "Region Location Max Y1", ''),
0x00186020: ('SL', '1', "Reference Pixel X0", ''),
0x00186022: ('SL', '1', "Reference Pixel Y0", ''),
0x00186024: ('US', '1', "Physical Units X Direction", ''),
0x00186026: ('US', '1', "Physical Units Y Direction", ''),
0x00186028: ('FD', '1', "Reference Pixel Physical Value X", ''),
0x0018602A: ('FD', '1', "Reference Pixel Physical Value Y", ''),
0x0018602C: ('FD', '1', "Physical Delta X", ''),
0x0018602E: ('FD', '1', "Physical Delta Y", ''),
0x00186030: ('UL', '1', "Transducer Frequency", ''),
0x00186031: ('CS', '1', "Transducer Type", ''),
0x00186032: ('UL', '1', "Pulse Repetition Frequency", ''),
0x00186034: ('FD', '1', "Doppler Correction Angle", ''),
0x00186036: ('FD', '1', "Steering Angle", ''),
0x00186038: ('UL', '1', "Doppler Sample Volume X Position (Retired)", 'Retired'),
0x00186039: ('SL', '1', "Doppler Sample Volume X Position", ''),
0x0018603A: ('UL', '1', "Doppler Sample Volume Y Position (Retired)", 'Retired'),
0x0018603B: ('SL', '1', "Doppler Sample Volume Y Position", ''),
0x0018603C: ('UL', '1', "TM-Line Position X0 (Retired)", 'Retired'),
0x0018603D: ('SL', '1', "TM-Line Position X0", ''),
0x0018603E: ('UL', '1', "TM-Line Position Y0 (Retired)", 'Retired'),
0x0018603F: ('SL', '1', "TM-Line Position Y0", ''),
0x00186040: ('UL', '1', "TM-Line Position X1 (Retired)", 'Retired'),
0x00186041: ('SL', '1', "TM-Line Position X1", ''),
0x00186042: ('UL', '1', "TM-Line Position Y1 (Retired)", 'Retired'),
0x00186043: ('SL', '1', "TM-Line Position Y1", ''),
0x00186044: ('US', '1', "Pixel Component Organization", ''),
0x00186046: ('UL', '1', "Pixel Component Mask", ''),
0x00186048: ('UL', '1', "Pixel Component Range Start", ''),
0x0018604A: ('UL', '1', "Pixel Component Range Stop", ''),
0x0018604C: ('US', '1', "Pixel Component Physical Units", ''),
0x0018604E: ('US', '1', "Pixel Component Data Type", ''),
0x00186050: ('UL', '1', "Number of Table Break Points", ''),
0x00186052: ('UL', '1-n', "Table of X Break Points", ''),
0x00186054: ('FD', '1-n', "Table of Y Break Points", ''),
0x00186056: ('UL', '1', "Number of Table Entries", ''),
0x00186058: ('UL', '1-n', "Table of Pixel Values", ''),
0x0018605A: ('FL', '1-n', "Table of Parameter Values", ''),
0x00186060: ('FL', '1-n', "R Wave Time Vector", ''),
0x00187000: ('CS', '1', "Detector Conditions Nominal Flag ", ''),
0x00187001: ('DS', '1', "Detector Temperature", ''),
0x00187004: ('CS', '1', "Detector Type", ''),
0x00187005: ('CS', '1', "Detector Configuration", ''),
0x00187006: ('LT', '1', "Detector Description", ''),
0x00187008: ('LT', '1', "Detector Mode", ''),
0x0018700A: ('SH', '1', "Detector ID", ''),
0x0018700C: ('DA', '1', "Date of Last Detector Calibration ", ''),
0x0018700E: ('TM', '1', "Time of Last Detector Calibration", ''),
0x00187010: ('IS', '1', "Exposures on Detector Since Last Calibration ", ''),
0x00187011: ('IS', '1', "Exposures on Detector Since Manufactured ", ''),
0x00187012: ('DS', '1', "Detector Time Since Last Exposure ", ''),
0x00187014: ('DS', '1', "Detector Active Time ", ''),
0x00187016: ('DS', '1', "Detector Activation Offset From Exposure", ''),
0x0018701A: ('DS', '2', "Detector Binning ", ''),
0x00187020: ('DS', '2', "Detector Element Physical Size", ''),
0x00187022: ('DS', '2', "Detector Element Spacing", ''),
0x00187024: ('CS', '1', "Detector Active Shape", ''),
0x00187026: ('DS', '1-2', "Detector Active Dimension(s)", ''),
0x00187028: ('DS', '2', "Detector Active Origin", ''),
0x0018702A: ('LO', '1', "Detector Manufacturer Name", ''),
0x0018702B: ('LO', '1', "Detector Manufacturer's Model Name", ''),
0x00187030: ('DS', '2', "Field of View Origin", ''),
0x00187032: ('DS', '1', "Field of View Rotation", ''),
0x00187034: ('CS', '1', "Field of View Horizontal Flip", ''),
0x00187040: ('LT', '1', "Grid Absorbing Material", ''),
0x00187041: ('LT', '1', "Grid Spacing Material", ''),
0x00187042: ('DS', '1', "Grid Thickness", ''),
0x00187044: ('DS', '1', "Grid Pitch", ''),
0x00187046: ('IS', '2', "Grid Aspect Ratio", ''),
0x00187048: ('DS', '1', "Grid Period", ''),
0x0018704C: ('DS', '1', "Grid Focal Distance", ''),
0x00187050: ('CS', '1-n', "Filter Material", ''),
0x00187052: ('DS', '1-n', "Filter Thickness Minimum", ''),
0x00187054: ('DS', '1-n', "Filter Thickness Maximum", ''),
0x00187060: ('CS', '1', "Exposure Control Mode", ''),
0x00187062: ('LT', '1', "Exposure Control Mode Description", ''),
0x00187064: ('CS', '1', "Exposure Status", ''),
0x00187065: ('DS', '1', "Phototimer Setting", ''),
0x00188150: ('DS', '1', "Exposure Time in ?", ''),
0x00188151: ('DS', '1', "X-Ray Tube Current in ?", ''),
0x00189004: ('CS', '1', "Content Qualification", ''),
0x00189005: ('SH', '1', "Pulse Sequence Name", ''),
0x00189006: ('SQ', '1', "MR Imaging Modifier Sequence", ''),
0x00189008: ('CS', '1', "Echo Pulse Sequence", ''),
0x00189009: ('CS', '1', "Inversion Recovery", ''),
0x00189010: ('CS', '1', "Flow Compensation", ''),
0x00189011: ('CS', '1', "Multiple Spin Echo", ''),
0x00189012: ('CS', '1', "Multi-planar Excitation", ''),
0x00189014: ('CS', '1', "Phase Contrast", ''),
0x00189015: ('CS', '1', "Time of Flight Contrast", ''),
0x00189016: ('CS', '1', "Spoiling", ''),
0x00189017: ('CS', '1', "Steady State Pulse Sequence", ''),
0x00189018: ('CS', '1', "Echo Planar Pulse Sequence", ''),
0x00189019: ('FD', '1', "Tag Angle First Axis", ''),
0x00189020: ('CS', '1', "Magnetization Transfer", ''),
0x00189021: ('CS', '1', "T2 Preparation", ''),
0x00189022: ('CS', '1', "Blood Signal Nulling", ''),
0x00189024: ('CS', '1', "Saturation Recovery", ''),
0x00189025: ('CS', '1', "Spectrally Selected Suppression", ''),
0x00189026: ('CS', '1', "Spectrally Selected Excitation", ''),
0x00189027: ('CS', '1', "Spatial Pre-saturation", ''),
0x00189028: ('CS', '1', "Tagging", ''),
0x00189029: ('CS', '1', "Oversampling Phase", ''),
0x00189030: ('FD', '1', "Tag Spacing First Dimension", ''),
0x00189032: ('CS', '1', "Geometry of k-Space Traversal", ''),
0x00189033: ('CS', '1', "Segmented k-Space Traversal", ''),
0x00189034: ('CS', '1', "Rectilinear Phase Encode Reordering", ''),
0x00189035: ('FD', '1', "Tag Thickness", ''),
0x00189036: ('CS', '1', "Partial Fourier Direction", ''),
0x00189037: ('CS', '1', "Cardiac Synchronization Technique", ''),
0x00189041: ('LO', '1', "Receive Coil Manufacturer Name", ''),
0x00189042: ('SQ', '1', "MR Receive Coil Sequence", ''),
0x00189043: ('CS', '1', "Receive Coil Type ", ''),
0x00189044: ('CS', '1', "Quadrature Receive Coil ", ''),
0x00189045: ('SQ', '1', "Multi-Coil Definition Sequence", ''),
0x00189046: ('LO', '1', "Multi-Coil Configuration ", ''),
0x00189047: ('SH', '1', "Multi-Coil Element Name", ''),
0x00189048: ('CS', '1', "Multi-Coil Element Used", ''),
0x00189049: ('SQ', '1', "MR Transmit Coil Sequence", ''),
0x00189050: ('LO', '1', "Transmit Coil Manufacturer Name", ''),
0x00189051: ('CS', '1', "Transmit Coil Type", ''),
0x00189052: ('FD', '1-2', "Spectral Width", ''),
0x00189053: ('FD', '1-2', "Chemical Shift Reference", ''),
0x00189054: ('CS', '1', "Volume Localization Technique", ''),
0x00189058: ('US', '1', "MR Acquisition Frequency Encoding Steps", ''),
0x00189059: ('CS', '1', "De-coupling", ''),
0x00189060: ('CS', '1-2', "De-coupled Nucleus", ''),
0x00189061: ('FD', '1-2', "De-coupling Frequency", ''),
0x00189062: ('CS', '1', "De-coupling Method", ''),
0x00189063: ('FD', '1-2', "De-coupling Chemical Shift Reference", ''),
0x00189064: ('CS', '1', "k-space Filtering", ''),
0x00189065: ('CS', '1-2', "Time Domain Filtering", ''),
0x00189066: ('US', '1-2', "Number of Zero fills", ''),
0x00189067: ('CS', '1', "Baseline Correction", ''),
0x00189069: ('FD', '1', "Parallel Reduction Factor In-plane", ''),
0x00189070: ('FD', '1', "Cardiac R-R Interval Specified", ''),
0x00189073: ('FD', '1', "Acquisition Duration", ''),
0x00189074: ('DT', '1', "Frame Acquisition DateTime", ''),
0x00189075: ('CS', '1', "Diffusion Directionality", ''),
0x00189076: ('SQ', '1', "Diffusion Gradient Direction Sequence", ''),
0x00189077: ('CS', '1', "Parallel Acquisition", ''),
0x00189078: ('CS', '1', "Parallel Acquisition Technique", ''),
0x00189079: ('FD', '1-n', "Inversion Times", ''),
0x00189080: ('ST', '1', "Metabolite Map Description", ''),
0x00189081: ('CS', '1', "Partial Fourier", ''),
0x00189082: ('FD', '1', "Effective Echo Time", ''),
0x00189083: ('SQ', '1', "Metabolite Map Code Sequence", ''),
0x00189084: ('SQ', '1', "Chemical Shift Sequence", ''),
0x00189085: ('CS', '1', "Cardiac Signal Source", ''),
0x00189087: ('FD', '1', "Diffusion b-value", ''),
0x00189089: ('FD', '3', "Diffusion Gradient Orientation", ''),
0x00189090: ('FD', '3', "Velocity Encoding Direction", ''),
0x00189091: ('FD', '1', "Velocity Encoding Minimum Value", ''),
0x00189093: ('US', '1', "Number of k-Space Trajectories", ''),
0x00189094: ('CS', '1', "Coverage of k-Space", ''),
0x00189095: ('UL', '1', "Spectroscopy Acquisition Phase Rows", ''),
0x00189096: ('FD', '1', "Parallel Reduction Factor In-plane (Retired)", 'Retired'),
0x00189098: ('FD', '1-2', "Transmitter Frequency", ''),
0x00189100: ('CS', '1-2', "Resonant Nucleus", ''),
0x00189101: ('CS', '1', "Frequency Correction", ''),
0x00189103: ('SQ', '1', "MR Spectroscopy FOV/Geometry Sequence", ''),
0x00189104: ('FD', '1', "Slab Thickness", ''),
0x00189105: ('FD', '3', "Slab Orientation", ''),
0x00189106: ('FD', '3', "Mid Slab Position", ''),
0x00189107: ('SQ', '1', "MR Spatial Saturation Sequence", ''),
0x00189112: ('SQ', '1', "MR Timing and Related Parameters Sequence", ''),
0x00189114: ('SQ', '1', "MR Echo Sequence", ''),
0x00189115: ('SQ', '1', "MR Modifier Sequence", ''),
0x00189117: ('SQ', '1', "MR Diffusion Sequence", ''),
0x00189118: ('SQ', '1', "Cardiac Synchronization ", ''),
0x00189119: ('SQ', '1', "MR Averages Sequence", ''),
0x00189125: ('SQ', '1', "MR FOV/Geometry Sequence", ''),
0x00189126: ('SQ', '1', "Volume Localization Sequence", ''),
0x00189127: ('UL', '1', "Spectroscopy Acquisition Data Columns", ''),
0x00189147: ('CS', '1', "Diffusion Anisotropy Type", ''),
0x00189151: ('DT', '1', "Frame Reference DateTime", ''),
0x00189152: ('SQ', '1', "MR Metabolite Map Sequence", ''),
0x00189155: ('FD', '1', "Parallel Reduction Factor out-of-plane", ''),
0x00189159: ('UL', '1', "Spectroscopy Acquisition Out-of-plane Phase Steps", ''),
0x00189166: ('CS', '1', "Bulk Motion Status", 'Retired'),
0x00189168: ('FD', '1', "Parallel Reduction Factor Second In-plane", ''),
0x00189169: ('CS', '1', "Cardiac Beat Rejection Technique", ''),
0x00189170: ('CS', '1', "Respiratory Motion Compensation Technique", ''),
0x00189171: ('CS', '1', "Respiratory Signal Source", ''),
0x00189172: ('CS', '1', "Bulk Motion Compensation Technique", ''),
0x00189173: ('CS', '1', "Bulk Motion Signal Source", ''),
0x00189174: ('CS', '1', "Applicable Safety Standard Agency", ''),
0x00189175: ('LO', '1', "Applicable Safety Standard Description", ''),
0x00189176: ('SQ', '1', "Operating Mode Sequence", ''),
0x00189177: ('CS', '1', "Operating Mode Type", ''),
0x00189178: ('CS', '1', "Operating Mode", ''),
0x00189179: ('CS', '1', "Specific Absorption Rate Definition", ''),
0x00189180: ('CS', '1', "Gradient Output Type", ''),
0x00189181: ('FD', '1', "Specific Absorption Rate Value", ''),
0x00189182: ('FD', '1', "Gradient Output", ''),
0x00189183: ('CS', '1', "Flow Compensation Direction", ''),
0x00189184: ('FD', '1', "Tagging Delay", ''),
0x00189185: ('ST', '1', "Respiratory Motion Compensation Technique Description", ''),
0x00189186: ('SH', '1', "Respiratory Signal Source ID", ''),
0x00189195: ('FD', '1', "Chemical Shifts Minimum Integration Limit in Hz", 'Retired'),
0x00189196: ('FD', '1', "Chemical Shifts Maximum Integration Limit in Hz", 'Retired'),
0x00189197: ('SQ', '1', "MR Velocity Encoding Sequence", ''),
0x00189198: ('CS', '1', "First Order Phase Correction", ''),
0x00189199: ('CS', '1', "Water Referenced Phase Correction", ''),
0x00189200: ('CS', '1', "MR Spectroscopy Acquisition Type", ''),
0x00189214: ('CS', '1', "Respiratory Cycle Position", ''),
0x00189217: ('FD', '1', "Velocity Encoding Maximum Value", ''),
0x00189218: ('FD', '1', "Tag Spacing Second Dimension", ''),
0x00189219: ('SS', '1', "Tag Angle Second Axis", ''),
0x00189220: ('FD', '1', "Frame Acquisition Duration", ''),
0x00189226: ('SQ', '1', "MR Image Frame Type Sequence", ''),
0x00189227: ('SQ', '1', "MR Spectroscopy Frame Type Sequence", ''),
0x00189231: ('US', '1', "MR Acquisition Phase Encoding Steps in-plane", ''),
0x00189232: ('US', '1', "MR Acquisition Phase Encoding Steps out-of-plane", ''),
0x00189234: ('UL', '1', "Spectroscopy Acquisition Phase Columns", ''),
0x00189236: ('CS', '1', "Cardiac Cycle Position", ''),
0x00189239: ('SQ', '1', "Specific Absorption Rate Sequence", ''),
0x00189240: ('US', '1', "RF Echo Train Length", ''),
0x00189241: ('US', '1', "Gradient Echo Train Length", ''),
0x00189295: ('FD', '1', "Chemical Shifts Minimum Integration Limit in ppm", ''),
0x00189296: ('FD', '1', "Chemical Shifts Maximum Integration Limit in ppm", ''),
0x00189301: ('SQ', '1', "CT Acquisition Type Sequence", ''),
0x00189302: ('CS', '1', "Acquisition Type", ''),
0x00189303: ('FD', '1', "Tube Angle", ''),
0x00189304: ('SQ', '1', "CT Acquisition Details Sequence", ''),
0x00189305: ('FD', '1', "Revolution Time", ''),
0x00189306: ('FD', '1', "Single Collimation Width", ''),
0x00189307: ('FD', '1', "Total Collimation Width", ''),
0x00189308: ('SQ', '1', "CT Table Dynamics Sequence", ''),
0x00189309: ('FD', '1', "Table Speed", ''),
0x00189310: ('FD', '1', "Table Feed per Rotation", ''),
0x00189311: ('FD', '1', "Spiral Pitch Factor", ''),
0x00189312: ('SQ', '1', "CT Geometry Sequence", ''),
0x00189313: ('FD', '3', "Data Collection Center (Patient)", ''),
0x00189314: ('SQ', '1', "CT Reconstruction Sequence", ''),
0x00189315: ('CS', '1', "Reconstruction Algorithm", ''),
0x00189316: ('CS', '1', "Convolution Kernel Group", ''),
0x00189317: ('FD', '2', "Reconstruction Field of View", ''),
0x00189318: ('FD', '3', "Reconstruction Target Center (Patient)", ''),
0x00189319: ('FD', '1', "Reconstruction Angle", ''),
0x00189320: ('SH', '1', "Image Filter", ''),
0x00189321: ('SQ', '1', "CT Exposure Sequence", ''),
0x00189322: ('FD', '2', "Reconstruction Pixel Spacing ", ''),
0x00189323: ('CS', '1', "Exposure Modulation Type", ''),
0x00189324: ('FD', '1', "Estimated Dose Saving", ''),
0x00189325: ('SQ', '1', "CT X-Ray Details Sequence", ''),
0x00189326: ('SQ', '1', "CT Position Sequence", ''),
0x00189327: ('FD', '1', "Table Position", ''),
0x00189328: ('FD', '1', "Exposure Time in ms", ''),
0x00189329: ('SQ', '1', "CT Image Frame Type Sequence", ''),
0x00189330: ('FD', '1', "X-Ray Tube Current in mA", ''),
0x00189332: ('FD', '1', "Exposure in mAs", ''),
0x00189333: ('CS', '1', "Constant Volume Flag ", ''),
0x00189334: ('CS', '1', "Fluoroscopy Flag", ''),
0x00189335: ('FD', '1', "Distance Source to Data Collection Center", ''),
0x00189337: ('US', '1', "Contrast/Bolus Agent Number", ''),
0x00189338: ('SQ', '1', "Contrast/Bolus Ingredient Code Sequence", ''),
0x00189340: ('SQ', '1', "Contrast Administration Profile Sequence", ''),
0x00189341: ('SQ', '1', "Contrast/Bolus Usage Sequence", ''),
0x00189342: ('CS', '1', "Contrast/Bolus Agent Administered", ''),
0x00189343: ('CS', '1', "Contrast/Bolus Agent Detected", ''),
0x00189344: ('CS', '1', "Contrast/Bolus Agent Phase", ''),
0x00189345: ('FD', '1', "CTDIvol", ''),
0x00189346: ('SQ', '1', "CTDI Phantom Type Code Sequence", ''),
0x00189351: ('FL', '1', "Calcium Scoring Mass Factor Patient", ''),
0x00189352: ('FL', '3', "Calcium Scoring Mass Factor Device", ''),
0x00189360: ('SQ', '1', "CT Additional X-Ray Source Sequence", ''),
0x00189401: ('SQ', '1', "Projection Pixel Calibration Sequence", ''),
0x00189402: ('FL', '1', "Distance Source to Isocenter", ''),
0x00189403: ('FL', '1', "Distance Object to Table Top", ''),
0x00189404: ('FL', '2', "Object Pixel Spacing in Center of Beam", ''),
0x00189405: ('SQ', '1', "Positioner Position Sequence", ''),
0x00189406: ('SQ', '1', "Table Position Sequence", ''),
0x00189407: ('SQ', '1', "Collimator Shape Sequence", ''),
0x00189412: ('SQ', '1', "XA/XRF Frame Characteristics Sequence", ''),
0x00189417: ('SQ', '1', "Frame Acquisition Sequence", ''),
0x00189420: ('CS', '1', "X-Ray Receptor Type", ''),
0x00189423: ('LO', '1', "Acquisition Protocol Name", ''),
0x00189424: ('LT', '1', "Acquisition Protocol Description", ''),
0x00189425: ('CS', '1', "Contrast/Bolus Ingredient Opaque", ''),
0x00189426: ('FL', '1', "Distance Receptor Plane to Detector Housing", ''),
0x00189427: ('CS', '1', "Intensifier Active Shape", ''),
0x00189428: ('FL', '1-2', "Intensifier Active Dimension(s)", ''),
0x00189429: ('FL', '2', "Physical Detector Size", ''),
0x00189430: ('US', '2', "Position of Isocenter Projection", ''),
0x00189432: ('SQ', '1', "Field of View Sequence", ''),
0x00189433: ('LO', '1', "Field of View Description", ''),
0x00189434: ('SQ', '1', "Exposure Control Sensing Regions Sequence", ''),
0x00189435: ('CS', '1', "Exposure Control Sensing Region Shape", ''),
0x00189436: ('SS', '1', "Exposure Control Sensing Region Left Vertical Edge", ''),
0x00189437: ('SS', '1', "Exposure Control Sensing Region Right Vertical Edge", ''),
0x00189438: ('SS', '1', "Exposure Control Sensing Region Upper Horizontal Edge", ''),
0x00189439: ('SS', '1', "Exposure Control Sensing Region Lower Horizontal Edge", ''),
0x00189440: ('SS', '2', "Center of Circular Exposure Control Sensing Region", ''),
0x00189441: ('US', '1', "Radius of Circular Exposure Control Sensing Region", ''),
0x00189442: ('SS', '2-n', "Vertices of the Polygonal Exposure Control Sensing Region", ''),
0x00189445: ('OB', '1', "Retired-blank", 'Retired'),
0x00189447: ('FL', '1', "Column Angulation (Patient)", ''),
0x00189449: ('FL', '1', "Beam Angle", ''),
0x00189451: ('SQ', '1', "Frame Detector Parameters Sequence", ''),
0x00189452: ('FL', '1', "Calculated Anatomy Thickness", ''),
0x00189455: ('SQ', '1', "Calibration Sequence", ''),
0x00189456: ('SQ', '1', "Object Thickness Sequence", ''),
0x00189457: ('CS', '1', "Plane Identification", ''),
0x00189461: ('FL', '1-2', "Field of View Dimension(s) in Float", ''),
0x00189462: ('SQ', '1', "Isocenter Reference System Sequence", ''),
0x00189463: ('FL', '1', "Positioner Isocenter Primary Angle", ''),
0x00189464: ('FL', '1', "Positioner Isocenter Secondary Angle", ''),
0x00189465: ('FL', '1', "Positioner Isocenter Detector Rotation Angle", ''),
0x00189466: ('FL', '1', "Table X Position to Isocenter", ''),
0x00189467: ('FL', '1', "Table Y Position to Isocenter", ''),
0x00189468: ('FL', '1', "Table Z Position to Isocenter", ''),
0x00189469: ('FL', '1', "Table Horizontal Rotation Angle", ''),
0x00189470: ('FL', '1', "Table Head Tilt Angle", ''),
0x00189471: ('FL', '1', "Table Cradle Tilt Angle", ''),
0x00189472: ('SQ', '1', "Frame Display Shutter Sequence", ''),
0x00189473: ('FL', '1', "Acquired Image Area Dose Product", ''),
0x00189474: ('CS', '1', "C-arm Positioner Tabletop Relationship", ''),
0x00189476: ('SQ', '1', "X-Ray Geometry Sequence", ''),
0x00189477: ('SQ', '1', "Irradiation Event Identification Sequence", ''),
0x00189504: ('SQ', '1', "X-Ray 3D Frame Type Sequence", ''),
0x00189506: ('SQ', '1', "Contributing Sources Sequence", ''),
0x00189507: ('SQ', '1', "X-Ray 3D Acquisition Sequence", ''),
0x00189508: ('FL', '1', "Primary Positioner Scan Arc", ''),
0x00189509: ('FL', '1', "Secondary Positioner Scan Arc", ''),
0x00189510: ('FL ', '1', "Primary Positioner Scan Start Angle", ''),
0x00189511: ('FL', '1', "Secondary Positioner Scan Start Angle", ''),
0x00189514: ('FL', '1', "Primary Positioner Increment", ''),
0x00189515: ('FL', '1', "Secondary Positioner Increment", ''),
0x00189516: ('DT', '1', "Start Acquisition DateTime", ''),
0x00189517: ('DT', '1', "End Acquisition DateTime", ''),
0x00189524: ('LO', '1', "Application Name", ''),
0x00189525: ('LO', '1', "Application Version", ''),
0x00189526: ('LO', '1', "Application Manufacturer", ''),
0x00189527: ('CS', '1', "Algorithm Type", ''),
0x00189528: ('LO', '1', "Algorithm Description", ''),
0x00189530: ('SQ', '1', "X-Ray 3D Reconstruction Sequence", ''),
0x00189531: ('LO', '1', "Reconstruction Description", ''),
0x00189538: ('SQ', '1', "Per Projection Acquisition Sequence", ''),
0x00189601: ('SQ', '1', "Diffusion b-matrix Sequence", ''),
0x00189602: ('FD', '1', "Diffusion b-value XX", ''),
0x00189603: ('FD', '1', "Diffusion b-value XY", ''),
0x00189604: ('FD', '1', "Diffusion b-value XZ", ''),
0x00189605: ('FD', '1', "Diffusion b-value YY", ''),
0x00189606: ('FD', '1', "Diffusion b-value YZ", ''),
0x00189607: ('FD', '1', "Diffusion b-value ZZ", ''),
# From Supp 117
0x00189701: ('DT', '1', "Decay Correction DateTime", ''),
0x00189715: ('FD', '1', "Start Density Threshold", ''),
0x00189716: ('FD', '1', "Start Relative Density Difference Threshold", ''),
0x00189717: ('FD', '1', "Start Cardiac Trigger Count Threshold", ''),
0x00189718: ('FD', '1', "Start Respiratory Trigger Count Threshold", ''),
0x00189719: ('FD', '1', "Termination Counts Threshold", ''),
0x00189720: ('FD', '1', "Termination Density Threshold", ''),
0x00189721: ('FD', '1', "Termination Relative Density Threshold", ''),
0x00189722: ('FD', '1', "Termination Time Threshold", ''),
0x00189723: ('FD', '1', "Termination Cardiac Trigger Count Threshold", ''),
0x00189724: ('FD', '1', "Termination Respiratory Trigger Count Threshold", ''),
0x00189725: ('CS', '1', "Detector Geometry", ''),
0x00189726: ('FD', '1', "Transverse Detector Separation", ''),
0x00189727: ('FD', '1', "Axial Detector Dimension", ''),
0x00189729: ('US', '1', "Radiopharmaceutical Agent Number", ''),
0x00189732: ('SQ', '1', "PET Frame Acquisition Sequence", ''),
0x00189733: ('SQ', '1', "PET Detector Motion Details Sequence", ''),
0x00189734: ('SQ', '1', "PET Table Dynamics Sequence", ''),
0x00189735: ('SQ', '1', "PET Position Sequence", ''),
0x00189736: ('SQ', '1', "PET Frame Correction Factors Sequence", ''),
0x00189737: ('SQ', '1', "Radiopharmaceutical Usage Sequence", ''),
0x00189738: ('CS', '1', "Attenuation Correction Source", ''),
0x00189739: ('US', '1', "Number of Iterations", ''),
0x00189740: ('US', '1', "Number of Subsets", ''),
0x00189749: ('SQ', '1', "PET Reconstruction Sequence", ''),
0x00189751: ('SQ', '1', "PET Frame Type Sequence", ''),
0x00189755: ('CS', '1', "Time of Flight Information Used", ''),
0x00189756: ('CS', '1', "Reconstruction Type", ''),
0x00189758: ('CS', '1', "Decay Corrected", ''),
0x00189759: ('CS', '1', "Attenuation Corrected", ''),
0x00189760: ('CS', '1', "Scatter Corrected", ''),
0x00189761: ('CS', '1', "Dead Time Corrected", ''),
0x00189762: ('CS', '1', "Gantry Motion Corrected", ''),
0x00189763: ('CS', '1', "Patient Motion Corrected", ''),
0x00189764: ('CS', '1', "Count Loss Normalization Corrected", ''),
0x00189765: ('CS', '1', "Randoms Corrected", ''),
0x00189766: ('CS', '1', "Non-uniform Radial Sampling Corrected", ''),
0x00189767: ('CS', '1', "Sensitivity Calibrated", ''),
0x00189768: ('CS', '1', "Detector Normalization Correction", ''),
0x00189769: ('CS', '1', "Iterative Reconstruction Method", ''),
0x00189770: ('CS', '1', "Attenuation Correction Temporal Relationship", ''),
0x00189771: ('SQ', '1', "Patient Physiological State Sequence", ''),
0x00189772: ('SQ', '1', "Patient Physiological State Code Sequence", ''),
# End From Supp 117
# From Supp 43
0x00189801: ('FD', '1-n', "Depth(s) of Focus", ''),
0x00189803: ('SQ', '1', "Excluded Intervals Sequence", ''),
0x00189804: ('DT', '1', "Exclusion Start Datetime", ''),
0x00189805: ('FD', '1', "Exclusion Duration", ''),
0x00189806: ('SQ', '1', "US Image Description Sequence", ''),
0x00189807: ('SQ', '1', "Image Data Type Sequence", ''),
0x00189808: ('CS', '1', "Data Type", ''),
0x00189809: ('SQ', '1', "Transducer Scan Pattern Code Sequence", ''),
0x0018980B: ('CS', '1', "Aliased Data Type", ''),
0x0018980C: ('CS', '1', "Position Measuring Device Used", ''),
0x0018980D: ('SQ', '1', "Transducer Geometry Code Sequence", ''),
0x0018980E: ('SQ', '1', "Transducer Beam Steering Code Sequence", ''),
0x0018980F: ('SQ', '1', "Transducer Application Code Sequence", ''),
# End From Supp 43
0x0018A001: ('SQ', '1', "Contributing Equipment Sequence", ''),
0x0018A002: ('DT', '1', "Contribution Date Time", ''),
0x0018A003: ('ST', '1', "Contribution Description", ''),
0x0020000D: ('UI', '1', "Study Instance UID", ''),
0x0020000E: ('UI', '1', "Series Instance UID", ''),
0x00200010: ('SH', '1', "Study ID", ''),
0x00200011: ('IS', '1', "Series Number", ''),
0x00200012: ('IS', '1', "Acquisition Number", ''),
0x00200013: ('IS', '1', "Instance Number", ''),
0x00200014: ('IS', '1', "Isotope Number", 'Retired'),
0x00200015: ('IS', '1', "Phase Number", 'Retired'),
0x00200016: ('IS', '1', "Interval Number", 'Retired'),
0x00200017: ('IS', '1', "Time Slot Number", 'Retired'),
0x00200018: ('IS', '1', "Angle Number", 'Retired'),
0x00200019: ('IS', '1', "Item Number", ''),
0x00200020: ('CS', '2', "Patient Orientation", ''),
0x00200022: ('IS', '1', "Overlay Number", 'Retired'),
0x00200024: ('IS', '1', "Curve Number", 'Retired'),
0x00200026: ('IS', '1', "Lookup Table Number", 'Retired'),
0x00200030: ('DS', '3', "Image Position", 'Retired'),
0x00200032: ('DS', '3', "Image Position (Patient)", ''),
0x00200035: ('DS', '6', "Image Orientation", 'Retired'),
0x00200037: ('DS', '6', "Image Orientation (Patient)", ''),
0x00200050: ('DS', '1', "Location", 'Retired'),
0x00200052: ('UI', '1', "Frame of Reference UID", ''),
0x00200060: ('CS', '1', "Laterality", ''),
0x00200062: ('CS', '1', "Image Laterality", ''),
0x00200070: ('LO', '1', "Image Geometry Type", 'Retired'),
0x00200080: ('CS', '1-n', "Masking Image", 'Retired'),
0x00200100: ('IS', '1', "Temporal Position Identifier", ''),
0x00200105: ('IS', '1', "Number of Temporal Positions", ''),
0x00200110: ('DS', '1', "Temporal Resolution", ''),
0x00200200: ('UI', '1', "Synchronization Frame of Reference UID", ''),
0x00201000: ('IS', '1', "Series in Study", 'Retired'),
0x00201001: ('IS', '1', "Acquisitions in Series", 'Retired'),
0x00201002: ('IS', '1', "Images in Acquisition", ''),
0x00201003: ('IS', '1', "Images in Series", 'Retired'),
0x00201004: ('IS', '1', "Acquisitions in Study", 'Retired'),
0x00201005: ('IS', '1', "Images in Study", 'Retired'),
0x00201020: ('CS', '1-n', "Reference", 'Retired'),
0x00201040: ('LO', '1', "Position Reference Indicator", ''),
0x00201041: ('DS', '1', "Slice Location", ''),
0x00201070: ('IS', '1-n', "Other Study Numbers", 'Retired'),
0x00201200: ('IS', '1', "Number of Patient Related Studies", ''),
0x00201202: ('IS', '1', "Number of Patient Related Series", ''),
0x00201204: ('IS', '1', "Number of Patient Related Instances", ''),
0x00201206: ('IS', '1', "Number of Study Related Series", ''),
0x00201208: ('IS', '1', "Number of Study Related Instances", ''),
0x00201209: ('IS', '1', "Number of Series Related Instances", ''),
0x00203401: ('CS', '1', "Modifying Device ID", 'Retired'),
0x00203402: ('CS', '1', "Modified Image ID", 'Retired'),
0x00203403: ('DA', '1', "Modified Image Date", 'Retired'),
0x00203404: ('LO', '1', "Modifying Device Manufacturer", 'Retired'),
0x00203405: ('TM', '1', "Modified Image Time", 'Retired'),
0x00203406: ('LO', '1', "Modified Image Description", 'Retired'),
0x00204000: ('LT', '1', "Image Comments", ''),
0x00205000: ('AT', '1-n', "Original Image Identification", 'Retired'),
0x00205002: ('CS', '1-n', "Original Image Identification Nomenclature", 'Retired'),
0x00209056: ('SH', '1', "Stack ID", ''),
0x00209057: ('UL', '1', "In-Stack Position Number", ''),
0x00209071: ('SQ', '1', "Frame Anatomy Sequence", ''),
0x00209072: ('CS', '1', "Frame Laterality", ''),
0x00209111: ('SQ', '1', "Frame Content Sequence", ''),
0x00209113: ('SQ', '1', "Plane Position Sequence", ''),
0x00209116: ('SQ', '1', "Plane Orientation Sequence", ''),
0x00209128: ('UL', '1', "Temporal Position Index", ''),
0x00209153: ('FD', '1', "Nominal Cardiac Trigger Delay Time", ''),
0x00209156: ('US', '1', "Frame Acquisition Number", ''),
0x00209157: ('UL', '1-n', "Dimension Index Values", ''),
0x00209158: ('LT', '1', "Frame Comments", ''),
0x00209161: ('UI', '1', "Concatenation UID", ''),
0x00209162: ('US', '1', "In-concatenation Number", ''),
0x00209163: ('US', '1', "In-concatenation Total Number", ''),
0x00209164: ('UI', '1', "Dimension Organization UID", ''),
0x00209165: ('AT', '1', "Dimension Index Pointer", ''),
0x00209167: ('AT', '1', "Functional Group Pointer", ''),
0x00209213: ('LO', '1', "Dimension Index Private Creator", ''),
0x00209221: ('SQ', '1', "Dimension Organization Sequence", ''),
0x00209222: ('SQ', '1', "Dimension Index Sequence", ''),
0x00209228: ('UL', '1', "Concatenation Frame Offset Number", ''),
0x00209238: ('LO', '1', "Functional Group Private Creator", ''),
0x00209241: ('FL', '1', "Nominal Percentage of Cardiac Phase", ''),
0x00209245: ('FL', '1', "Nominal Percentage of Respiratory Phase", ''),
0x00209246: ('FL', '1', "Starting Respiratory Amplitude", ''),
0x00209247: ('CS', '1', "Starting Respiratory Phase", ''),
0x00209248: ('FL', '1', "Ending Respiratory Amplitude", ''),
0x00209249: ('CS', '1', "Ending Respiratory Phase", ''),
0x00209250: ('CS', '1', "Respiratory Trigger Type", ''),
0x00209251: ('FD', '1', "R - R Interval Time Nominal", ''),
0x00209252: ('FD', '1', "Actual Cardiac Trigger Delay Time", ''),
0x00209253: ('SQ', '1', "Respiratory Synchronization Sequence", ''),
0x00209254: ('FD', '1', "Respiratory Interval Time", ''),
0x00209255: ('FD', '1', "Nominal Respiratory Trigger Delay Time", ''),
0x00209256: ('FD', '1', "Respiratory Trigger Delay Threshold", ''),
0x00209257: ('FD', '1', "Actual Respiratory Trigger Delay Time", ''),
# From Supp 43
0x00209301: ('FD', '3', "Image Position (Volume)", ''),
0x00209302: ('FD', '6', "Image Orientation (Volume)", ''),
0x00209307: ('CS', '1', "Ultrasound Acquisition Geometry", ''),
0x00209308: ('FD', '3', "Apex Position", ''),
0x00209309: ('FD', '16', "Volume to Transducer Mapping Matrix", ''),
0x0020930A: ('FD', '16', "Volume to Table Mapping Matrix", ''),
0x0020930C: ('CS', '1', "Patient Frame of Reference Source", ''),
0x0020930D: ('FD', '1', "Temporal Position Time Offset", ''),
0x0020930E: ('SQ', '1', "Plane Position (Volume) Sequence", ''),
0x0020930F: ('SQ', '1', "Plane Orientation (Volume) Sequence", ''),
0x00209310: ('SQ', '1', "Temporal Position Sequence", ''),
0x00209311: ('CS', '1', "Dimension Organization Type", ''),
0x00209312: ('UI', '1', "Volume Frame of Reference UID", ''),
0x00209313: ('UI', '1', "Table Frame of Reference UID", ''),
# End From Supp 43
0x00209421: ('LO', '1', "Dimension Description Label", ''),
0x00209450: ('SQ', '1', "Patient Orientation in Frame Sequence", ''),
0x00209453: ('LO', '1', "Frame Label", ''),
0x00209518: ('US', '1-n', "Acquisition Index", ''),
0x00209529: ('SQ', '1', "Contributing SOP Instances Reference Sequence", ''),
0x00209536: ('US', '1', "Reconstruction Index", ''),
0x00220001: ('US', '1', "Light Path Filter Pass-Through Wavelength", ''),
0x00220002: ('US', '2', "Light Path Filter Pass Band", ''),
0x00220003: ('US', '1', "Image Path Filter Pass-Through Wavelength", ''),
0x00220004: ('US', '2', "Image Path Filter Pass Band", ''),
0x00220005: ('CS', '1', "Patient Eye Movement Commanded", ''),
0x00220006: ('SQ', '1', "Patient Eye Movement Command Code Sequence", ''),
0x00220007: ('FL', '1', "Spherical Lens Power", ''),
0x00220008: ('FL', '1', "Cylinder Lens Power", ''),
0x00220009: ('FL', '1', "Cylinder Axis", ''),
0x0022000A: ('FL', '1', "Emmetropic Magnification", ''),
0x0022000B: ('FL', '1', "Intra Ocular Pressure", ''),
0x0022000C: ('FL', '1', "Horizontal Field of View", ''),
0x0022000D: ('CS', '1', "Pupil Dilated", ''),
0x0022000E: ('FL', '1', "Degree of Dilation", ''),
0x00220010: ('FL', '1', "Stereo Baseline Angle", ''),
0x00220011: ('FL', '1', "Stereo Baseline Displacement", ''),
0x00220012: ('FL', '1', "Stereo Horizontal Pixel Offset", ''),
0x00220013: ('FL', '1', "Stereo Vertical Pixel Offset", ''),
0x00220014: ('FL', '1', "Stereo Rotation", ''),
0x00220015: ('SQ', '1', "Acquisition Device Type Code Sequence", ''),
0x00220016: ('SQ', '1', "Illumination Type Code Sequence", ''),
0x00220017: ('SQ', '1', "Light Path Filter Type Stack Code Sequence", ''),
0x00220018: ('SQ', '1', "Image Path Filter Type Stack Code Sequence", ''),
0x00220019: ('SQ', '1', "Lenses Code Sequence", ''),
0x0022001A: ('SQ', '1', "Channel Description Code Sequence", ''),
0x0022001B: ('SQ', '1', "Refractive State Sequence", ''),
0x0022001C: ('SQ', '1', "Mydriatic Agent Code Sequence", ''),
0x0022001D: ('SQ', '1', "Relative Image Position Code Sequence", ''),
0x00220020: ('SQ', '1', "Stereo Pairs Sequence", ''),
0x00220021: ('SQ', '1', "Left Image Sequence", ''),
0x00220022: ('SQ', '1', "Right Image Sequence", ''),
0x00220030: ('FL', '1', "Axial Length of the Eye", ''),
0x00220031: ('SQ', '1', "Ophthalmic Frame Location Sequence", ''),
0x00220032: ('FL', '2-2n', "Reference Coordinates", ''),
0x00220035: ('FL', '1', "Depth Spatial Resolution", ''),
0x00220036: ('FL', '1', "Maximum Depth Distortion", ''),
0x00220037: ('FL', '1', "Along-scan Spatial Resolution", ''),
0x00220038: ('FL', '1', "Maximum Along-scan Distortion", ''),
0x00220039: ('CS', '1', "Ophthalmic Image Orientation", ''),
0x00220041: ('FL', '1', "Depth of Transverse Image", ''),
0x00220042: ('SQ', '1', "Mydriatic Agent Concentration Units Sequence", ''),
0x00220048: ('FL', '1', "Across-scan Spatial Resolution", ''),
0x00220049: ('FL', '1', "Maximum Across-scan Distortion", ''),
0x0022004E: ('DS', '1', "Mydriatic Agent Concentration", ''),
0x00220055: ('FL', '1', "Illumination Wave Length", ''),
0x00220056: ('FL', '1', "Illumination Power", ''),
0x00220057: ('FL', '1', "Illumination Bandwidth", ''),
0x00220058: ('SQ', '1', "Mydriatic Agent Sequence", ''),
0x00280002: ('US', '1', "Samples per Pixel", ''),
0x00280003: ('US', '1', "Samples per Pixel Used", ''),
0x00280004: ('CS', '1', "Photometric Interpretation", ''),
0x00280005: ('US', '1', "Image Dimensions", 'Retired'),
0x00280006: ('US', '1', "Planar Configuration", ''),
0x00280008: ('IS', '1', "Number of Frames", ''),
0x00280009: ('AT', '1-n', "Frame Increment Pointer", ''),
0x0028000A: ('AT', '1-n', "Frame Dimension Pointer", ''),
0x00280010: ('US', '1', "Rows", ''),
0x00280011: ('US', '1', "Columns", ''),
0x00280012: ('US', '1', "Planes", 'Retired'),
0x00280014: ('US', '1', "Ultrasound Color Data Present", ''),
0x00280020: ('OB', '1', "Retired-blank", 'Retired'),
0x00280030: ('DS', '2', "Pixel Spacing", ''),
0x00280031: ('DS', '2', "Zoom Factor", ''),
0x00280032: ('DS', '2', "Zoom Center", ''),
0x00280034: ('IS', '2', "Pixel Aspect Ratio", ''),
0x00280040: ('CS', '1', "Image Format", 'Retired'),
0x00280050: ('LO', '1-n', "Manipulated Image", 'Retired'),
0x00280051: ('CS', '1-n', "Corrected Image", ''),
0x0028005F: ('LO', '1', "Compression Recognition Code", 'Retired'),
0x00280060: ('CS', '1', "Compression Code", 'Retired'),
0x00280061: ('SH', '1', "Compression Originator", 'Retired'),
0x00280062: ('LO', '1', "Compression Label", 'Retired'),
0x00280063: ('SH', '1', "Compression Description", 'Retired'),
0x00280065: ('CS', '1-n', "Compression Sequence", 'Retired'),
0x00280066: ('AT', '1-n', "Compression Step Pointers", 'Retired'),
0x00280068: ('US', '1', "Repeat Interval", 'Retired'),
0x00280069: ('US', '1', "Bits Grouped", 'Retired'),
0x00280070: ('US', '1-n', "Perimeter Table", 'Retired'),
0x00280071: ('US or SS', '1', "Perimeter Value", 'Retired'),
0x00280080: ('US', '1', "Predictor Rows", 'Retired'),
0x00280081: ('US', '1', "Predictor Columns", 'Retired'),
0x00280082: ('US', '1-n', "Predictor Constants", 'Retired'),
0x00280090: ('CS', '1', "Blocked Pixels", 'Retired'),
0x00280091: ('US', '1', "Block Rows", 'Retired'),
0x00280092: ('US', '1', "Block Columns", 'Retired'),
0x00280093: ('US', '1', "Row Overlap", 'Retired'),
0x00280094: ('US', '1', "Column Overlap", 'Retired'),
0x00280100: ('US', '1', "Bits Allocated", ''),
0x00280101: ('US', '1', "Bits Stored", ''),
0x00280102: ('US', '1', "High Bit", ''),
0x00280103: ('US', '1', "Pixel Representation", ''),
0x00280104: ('US or SS', '1', "Smallest Valid Pixel Value", 'Retired'),
0x00280105: ('US or SS', '1', "Largest Valid Pixel Value", 'Retired'),
0x00280106: ('US or SS', '1', "Smallest Image Pixel Value", ''),
0x00280107: ('US or SS', '1', "Largest Image Pixel Value", ''),
0x00280108: ('US or SS', '1', "Smallest Pixel Value in Series", ''),
0x00280109: ('US or SS', '1', "Largest Pixel Value in Series", ''),
0x00280110: ('US or SS', '1', "Smallest Image Pixel Value in Plane", 'Retired'),
0x00280111: ('US or SS', '1', "Largest Image Pixel Value in Plane", 'Retired'),
0x00280120: ('US or SS', '1', "Pixel Padding Value", ''),
0x00280121: ('US or SS', '1', "Pixel Padding Range Limit", ''),
0x00280200: ('US', '1', "Image Location", 'Retired'),
0x00280300: ('CS', '1', "Quality Control Image", ''),
0x00280301: ('CS', '1', "Burned In Annotation", ''),
0x00280400: ('LO', '1', "Transform Label", 'Retired'),
0x00280401: ('LO', '1', "Transform Version Number", 'Retired'),
0x00280402: ('US', '1', "Number of Transform Steps", 'Retired'),
0x00280403: ('LO', '1-n', "Sequence of Compressed Data", 'Retired'),
0x00280404: ('AT', '1-n', "Details of Coefficients", 'Retired'),
0x00280700: ('LO', '1', "DCT Label", 'Retired'),
0x00280701: ('CS', '1-n', "Data Block Description", 'Retired'),
0x00280702: ('AT', '1-n', "Data Block", 'Retired'),
0x00280710: ('US', '1', "Normalization Factor Format", 'Retired'),
0x00280720: ('US', '1', "Zonal Map Number Format", 'Retired'),
0x00280721: ('AT', '1-n', "Zonal Map Location", 'Retired'),
0x00280722: ('US', '1', "Zonal Map Format", 'Retired'),
0x00280730: ('US', '1', "Adaptive Map Format", 'Retired'),
0x00280740: ('US', '1', "Code Number Format", 'Retired'),
0x00280A02: ('CS', '1', "Pixel Spacing Calibration Type", ''),
0x00280A04: ('LO', '1', "Pixel Spacing Calibration Description", ''),
0x00281040: ('CS', '1', "Pixel Intensity Relationship", ''),
0x00281041: ('SS', '1', "Pixel Intensity Relationship Sign", ''),
0x00281050: ('DS', '1-n', "Window Center", ''),
0x00281051: ('DS', '1-n', "Window Width", ''),
0x00281052: ('DS', '1', "Rescale Intercept", ''),
0x00281053: ('DS', '1', "Rescale Slope", ''),
0x00281054: ('LO', '1', "Rescale Type", ''),
0x00281055: ('LO', '1-n', "Window Center & Width Explanation", ''),
0x00281056: ('CS', '1', "VOI LUT Function", ''),
0x00281080: ('CS', '1', "Gray Scale", 'Retired'),
0x00281090: ('CS', '1', "Recommended Viewing Mode", ''),
0x00281100: ('US or SS', '3', "Gray Lookup Table Descriptor ", 'Retired'),
0x00281101: ('US or SS', '3', "Red Palette Color Lookup Table Descriptor ", ''),
0x00281102: ('US or SS', '3', "Green Palette Color Lookup Table Descriptor ", ''),
0x00281103: ('US or SS', '3', "Blue Palette Color Lookup Table Descriptor ", ''),
# From Supp 43
0x00281104: ('US', '3', "Alpha Palette Color Lookup Table Descriptor", ''),
# End From Supp 43
0x00281111: ('US or SS', '4', "Large Red Palette Color Lookup Table Descriptor ", 'Retired'),
0x00281112: ('US or SS', '4', "Large Green Palette Color Lookup Table Descriptor ", 'Retired'),
0x00281113: ('US or SS', '4', "Large Blue Palette Color Lookup Table Descriptor ", 'Retired'),
0x00281199: ('UI', '1', "Palette Color Lookup Table UID", ''),
0x00281200: ('US or SS or OW', '1-n 1', "Gray Lookup Table Data", 'Retired'),
0x00281201: ('OW', '1', "Red Palette Color Lookup Table Data", ''),
0x00281202: ('OW', '1', "Green Palette Color Lookup Table Data", ''),
0x00281203: ('OW', '1', "Blue Palette Color Lookup Table Data", ''),
# From Supp 43
0x00281204: ('OW', '1', "Alpha Palette Color Lookup Table Data", ''),
# End From Supp 43
0x00281211: ('OW', '1', "Large Red Palette Color Lookup Table Data", 'Retired'),
0x00281212: ('OW', '1', "Large Green Palette Color Lookup Table Data", 'Retired'),
0x00281213: ('OW', '1', "Large Blue Palette Color Lookup Table Data", 'Retired'),
0x00281214: ('UI', '1', "Large Palette Color Lookup Table UID", 'Retired'),
0x00281221: ('OW', '1', "Segmented Red Palette Color Lookup Table Data", ''),
0x00281222: ('OW', '1', "Segmented Green Palette Color Lookup Table Data", ''),
0x00281223: ('OW', '1', "Segmented Blue Palette Color Lookup Table Data", ''),
0x00281300: ('CS', '1', "Implant Present", ''),
0x00281350: ('CS', '1', "Partial View", ''),
0x00281351: ('ST', '1', "Partial View Description", ''),
0x00281352: ('SQ', '1', "Partial View Code Sequence", ''),
0x0028135A: ('CS', '1', "Spatial Locations Preserved", ''),
# From Supp 43
0x00281401: ('SQ', '1', "Data Frame Assignment Sequence", ''),
0x00281402: ('CS', '1', "Data Path Assignment", ''),
0x00281403: ('US', '1', "Bits Mapped to Color Lookup Table", ''),
0x00281404: ('SQ', '1', "Blending LUT 1 Sequence", ''),
0x00281405: ('CS', '1', "Blending LUT 1 Transfer Function", ''),
0x00281406: ('FD', '1', "Blending Weight Constant", ''),
0x00281407: ('US', '3', "Blending Lookup Table Descriptor", ''),
0x00281408: ('OW', '1', "Blending Lookup Table Data", ''),
0x0028140B: ('SQ', '1', "Enhanced Palette Color Lookup Table Sequence", ''),
0x0028140C: ('SQ', '1', "Blending LUT 2 Sequence", ''),
0x0028140D: ('CS', '1', "Blending LUT 2 Transfer Function", ''),
0x0028140E: ('CS', '1', "Data Path ID", ''),
0x0028140F: ('CS', '1', "RGB LUT Transfer Function", ''),
0x00281410: ('CS', '1', "Alpha LUT Transfer Function", ''),
# End From Supp 43
0x00282000: ('OB', '1', "ICC Profile", ''),
0x00282110: ('CS', '1', "Lossy Image Compression", ''),
0x00282112: ('DS', '1-n', "Lossy Image Compression Ratio", ''),
0x00282114: ('CS', '1-n', "Lossy Image Compression Method", ''),
0x00283000: ('SQ', '1', "Modality LUT Sequence", ''),
0x00283002: ('US or SS', '3', "LUT Descriptor", ''),
0x00283003: ('LO', '1', "LUT Explanation", ''),
0x00283004: ('LO', '1', "Modality LUT Type", ''),
0x00283006: ('US or SS or OW', '1-n 1', "LUT Data", ''),
0x00283010: ('SQ', '1', "VOI LUT Sequence", ''),
0x00283110: ('SQ', '1', "Softcopy VOI LUT Sequence", ''),
0x00284000: ('LT', '1', "Image Presentation Comments", 'Retired'),
0x00285000: ('SQ', '1', "Bi-Plane Acquisition Sequence", 'Retired'),
0x00286010: ('US', '1', "Representative Frame Number", ''),
0x00286020: ('US', '1-n', "Frame Numbers of Interest (FOI) ", ''),
0x00286022: ('LO', '1-n', "Frame(s) of Interest Description", ''),
0x00286023: ('CS', '1-n', "Frame of Interest Type", ''),
0x00286030: ('US', '1-n', "Mask Pointer(s)", 'Retired'),
0x00286040: ('US', '1-n', "R Wave Pointer", ''),
0x00286100: ('SQ', '1', "Mask Subtraction Sequence", ''),
0x00286101: ('CS', '1', "Mask Operation", ''),
0x00286102: ('US', '2-2n', "Applicable Frame Range", ''),
0x00286110: ('US', '1-n', "Mask Frame Numbers", ''),
0x00286112: ('US', '1', "Contrast Frame Averaging", ''),
0x00286114: ('FL', '2', "Mask Sub-pixel Shift", ''),
0x00286120: ('SS', '1', "TID Offset", ''),
0x00286190: ('ST', '1', "Mask Operation Explanation", ''),
0x00287FE0: ('UT', '1', "Pixel Data Provider URL", ''),
0x00289001: ('UL', '1', "Data Point Rows", ''),
0x00289002: ('UL', '1', "Data Point Columns", ''),
0x00289003: ('CS', '1', "Signal Domain Columns", ''),
0x00289099: ('US', '1', "Largest Monochrome Pixel Value", 'Retired'),
0x00289108: ('CS', '1', "Data Representation", ''),
0x00289110: ('SQ', '1', "Pixel Measures Sequence", ''),
0x00289132: ('SQ', '1', "Frame VOI LUT Sequence", ''),
0x00289145: ('SQ', '1', "Pixel Value Transformation Sequence", ''),
0x00289235: ('CS', '1', "Signal Domain Rows", ''),
0x00289411: ('FL', '1', "Display Filter Percentage", ''),
0x00289415: ('SQ', '1', "Frame Pixel Shift Sequence", ''),
0x00289416: ('US', '1', "Subtraction Item ID", ''),
0x00289422: ('SQ', '1', "Pixel Intensity Relationship LUT Sequence", ''),
0x00289443: ('SQ', '1', "Frame Pixel Data Properties Sequence", ''),
0x00289444: ('CS', '1', "Geometrical Properties", ''),
0x00289445: ('FL', '1', "Geometric Maximum Distortion", ''),
0x00289446: ('CS', '1-n', "Image Processing Applied", ''),
0x00289454: ('CS', '1', "Mask Selection Mode", ''),
0x00289474: ('CS', '1', "LUT Function", ''),
0x00289520: ('DS', '16', "Image to Equipment Mapping Matrix", ''),
0x00289537: ('CS', '1', "Equipment Coordinate System Identification", ''),
0x0032000A: ('CS', '1', "Study Status ID", 'Retired'),
0x0032000C: ('CS', '1', "Study Priority ID", 'Retired'),
0x00320012: ('LO', '1', "Study ID Issuer", 'Retired'),
0x00320032: ('DA', '1', "Study Verified Date", 'Retired'),
0x00320033: ('TM', '1', "Study Verified Time", 'Retired'),
0x00320034: ('DA', '1', "Study Read Date", 'Retired'),
0x00320035: ('TM', '1', "Study Read Time", 'Retired'),
0x00321000: ('DA', '1', "Scheduled Study Start Date", 'Retired'),
0x00321001: ('TM', '1', "Scheduled Study Start Time", 'Retired'),
0x00321010: ('DA', '1', "Scheduled Study Stop Date", 'Retired'),
0x00321011: ('TM', '1', "Scheduled Study Stop Time", 'Retired'),
0x00321020: ('LO', '1', "Scheduled Study Location", 'Retired'),
0x00321021: ('AE', '1-n', "Scheduled Study Location AE Title", 'Retired'),
0x00321030: ('LO', '1', "Reason for Study", 'Retired'),
0x00321031: ('SQ', '1', "Requesting Physician Identification Sequence", ''),
0x00321032: ('PN', '1', "Requesting Physician", ''),
0x00321033: ('LO', '1', "Requesting Service", ''),
0x00321040: ('DA', '1', "Study Arrival Date", 'Retired'),
0x00321041: ('TM', '1', "Study Arrival Time", 'Retired'),
0x00321050: ('DA', '1', "Study Completion Date", 'Retired'),
0x00321051: ('TM', '1', "Study Completion Time", 'Retired'),
0x00321055: ('CS', '1', "Study Component Status ID", 'Retired'),
0x00321060: ('LO', '1', "Requested Procedure Description", ''),
0x00321064: ('SQ', '1', "Requested Procedure Code Sequence", ''),
0x00321070: ('LO', '1', "Requested Contrast Agent", ''),
0x00324000: ('LT', '1', "Study Comments", 'Retired'),
0x00380004: ('SQ', '1', "Referenced Patient Alias Sequence", ''),
0x00380008: ('CS', '1', "Visit Status ID", ''),
0x00380010: ('LO', '1', "Admission ID", ''),
0x00380011: ('LO', '1', "Issuer of Admission ID", ''),
0x00380016: ('LO', '1', "Route of Admissions", ''),
0x0038001A: ('DA', '1', "Scheduled Admission Date", 'Retired'),
0x0038001B: ('TM', '1', "Scheduled Admission Time", 'Retired'),
0x0038001C: ('DA', '1', "Scheduled Discharge Date", 'Retired'),
0x0038001D: ('TM', '1', "Scheduled Discharge Time", 'Retired'),
0x0038001E: ('LO', '1', "Scheduled Patient Institution Residence", 'Retired'),
0x00380020: ('DA', '1', "Admitting Date", ''),
0x00380021: ('TM', '1', "Admitting Time", ''),
0x00380030: ('DA', '1', "Discharge Date", 'Retired'),
0x00380032: ('TM', '1', "Discharge Time", 'Retired'),
0x00380040: ('LO', '1', "Discharge Diagnosis Description", 'Retired'),
0x00380044: ('SQ', '1', "Discharge Diagnosis Code Sequence", 'Retired'),
0x00380050: ('LO', '1', "Special Needs", ''),
0x00380060: ('LO', '1', "Service Episode ID", ''),
0x00380061: ('LO', '1', "Issuer of Service Episode ID", ''),
0x00380062: ('LO', '1', "Service Episode Description", ''),
0x00380100: ('SQ', '1', "Pertinent Documents Sequence", ''),
0x00380300: ('LO', '1', "Current Patient Location", ''),
0x00380400: ('LO', '1', "Patient's Institution Residence", ''),
0x00380500: ('LO', '1', "Patient State", ''),
0x00380502: ('SQ', '1', "Patient Clinical Trial Participation Sequence", ''),
0x00384000: ('LT', '1', "Visit Comments", ''),
0x003A0004: ('CS', '1', "Waveform Originality", ''),
0x003A0005: ('US', '1', "Number of Waveform Channels ", ''),
0x003A0010: ('UL', '1', "Number of Waveform Samples ", ''),
0x003A001A: ('DS', '1', "Sampling Frequency ", ''),
0x003A0020: ('SH', '1', "Multiplex Group Label ", ''),
0x003A0200: ('SQ', '1', "Channel Definition Sequence", ''),
0x003A0202: ('IS', '1', "Waveform Channel Number ", ''),
0x003A0203: ('SH', '1', "Channel Label", ''),
0x003A0205: ('CS', '1-n', "Channel Status", ''),
0x003A0208: ('SQ', '1', "Channel Source Sequence", ''),
0x003A0209: ('SQ', '1', "Channel Source Modifiers Sequence", ''),
0x003A020A: ('SQ', '1', "Source Waveform Sequence", ''),
0x003A020C: ('LO', '1', "Channel Derivation Description", ''),
0x003A0210: ('DS', '1', "Channel Sensitivity ", ''),
0x003A0211: ('SQ', '1', "Channel Sensitivity Units Sequence", ''),
0x003A0212: ('DS', '1', "Channel Sensitivity Correction Factor", ''),
0x003A0213: ('DS', '1', "Channel Baseline ", ''),
0x003A0214: ('DS', '1', "Channel Time Skew", ''),
0x003A0215: ('DS', '1', "Channel Sample Skew", ''),
0x003A0218: ('DS', '1', "Channel Offset", ''),
0x003A021A: ('US', '1', "Waveform Bits Stored", ''),
0x003A0220: ('DS', '1', "Filter Low Frequency", ''),
0x003A0221: ('DS', '1', "Filter High Frequency", ''),
0x003A0222: ('DS', '1', "Notch Filter Frequency", ''),
0x003A0223: ('DS', '1', "Notch Filter Bandwidth", ''),
0x003A0230: ('FL', '1', "Waveform Data Display Scale", ''),
0x003A0231: ('US', '3', "Waveform Display Background CIELab Value", ''),
0x003A0240: ('SQ', '1', "Waveform Presentation Group Sequence", ''),
0x003A0241: ('US', '1', "Presentation Group Number", ''),
0x003A0242: ('SQ', '1', "Channel Display Sequence", ''),
0x003A0244: ('US', '3', "Channel Recommended Display CIELab Value", ''),
0x003A0245: ('FL', '1', "Channel Position", ''),
0x003A0246: ('CS', '1', "Display Shading Flag", ''),
0x003A0247: ('FL', '1', "Fractional Channel Display Scale", ''),
0x003A0248: ('FL', '1', "Absolute Channel Display Scale", ''),
0x003A0300: ('SQ', '1', "Multiplexed Audio Channels Description Code Sequence", ''),
0x003A0301: ('IS', '1', "Channel Identification Code", ''),
0x003A0302: ('CS', '1', "Channel Mode", ''),
0x00400001: ('AE', '1-n', "Scheduled Station AE Title", ''),
0x00400002: ('DA', '1', "Scheduled Procedure Step Start Date", ''),
0x00400003: ('TM', '1', "Scheduled Procedure Step Start Time", ''),
0x00400004: ('DA', '1', "Scheduled Procedure Step End Date", ''),
0x00400005: ('TM', '1', "Scheduled Procedure Step End Time", ''),
0x00400006: ('PN', '1', "Scheduled Performing Physician's Name", ''),
0x00400007: ('LO', '1', "Scheduled Procedure Step Description", ''),
0x00400008: ('SQ', '1', "Scheduled Protocol Code Sequence", ''),
0x00400009: ('SH', '1', "Scheduled Procedure Step ID", ''),
0x0040000A: ('SQ', '1', "Stage Code Sequence", ''),
0x0040000B: ('SQ', '1', "Scheduled Performing Physician Identification Sequence", ''),
0x00400010: ('SH', '1-n', "Scheduled Station Name", ''),
0x00400011: ('SH', '1', "Scheduled Procedure Step Location", ''),
0x00400012: ('LO', '1', "Pre-Medication", ''),
0x00400020: ('CS', '1', "Scheduled Procedure Step Status", ''),
0x00400100: ('SQ', '1', "Scheduled Procedure Step Sequence", ''),
0x00400220: ('SQ', '1', "Referenced Non-Image Composite SOP Instance Sequence ", ''),
0x00400241: ('AE', '1', "Performed Station AE Title", ''),
0x00400242: ('SH', '1', "Performed Station Name ", ''),
0x00400243: ('SH', '1', "Performed Location", ''),
0x00400244: ('DA', '1', "Performed Procedure Step Start Date", ''),
0x00400245: ('TM', '1', "Performed Procedure Step Start Time", ''),
0x00400250: ('DA', '1', "Performed Procedure Step End Date", ''),
0x00400251: ('TM', '1', "Performed Procedure Step End Time", ''),
0x00400252: ('CS', '1', "Performed Procedure Step Status", ''),
0x00400253: ('SH', '1', "Performed Procedure Step ID", ''),
0x00400254: ('LO', '1', "Performed Procedure Step Description", ''),
0x00400255: ('LO', '1', "Performed Procedure Type Description", ''),
0x00400260: ('SQ', '1', "Performed Protocol Code Sequence", ''),
# From Supp 43
0x00400261: ('CS', '1', "Performed Protocol Type", ''),
# End From Supp 43
0x00400270: ('SQ', '1', "Scheduled Step Attributes Sequence", ''),
0x00400275: ('SQ', '1', "Request Attributes Sequence", ''),
0x00400280: ('ST', '1', "Comments on the Performed Procedure Step", ''),
0x00400281: ('SQ', '1', "Performed Procedure Step Discontinuation Reason Code Sequence", ''),
0x00400293: ('SQ', '1', "Quantity Sequence", ''),
0x00400294: ('DS', '1', "Quantity", ''),
0x00400295: ('SQ', '1', "Measuring Units Sequence", ''),
0x00400296: ('SQ', '1', "Billing Item Sequence", ''),
0x00400300: ('US', '1', "Total Time of Fluoroscopy", ''),
0x00400301: ('US', '1', "Total Number of Exposures", ''),
0x00400302: ('US', '1', "Entrance Dose", ''),
0x00400303: ('US', '1-2', "Exposed Area", ''),
0x00400306: ('DS', '1', "Distance Source to Entrance", ''),
0x00400307: ('DS', '1', "Distance Source to Support", 'Retired'),
0x0040030E: ('SQ', '1', "Exposure Dose Sequence", ''),
0x00400310: ('ST', '1', "Comments on Radiation Dose", ''),
0x00400312: ('DS', '1', "X-Ray Output", ''),
0x00400314: ('DS', '1', "Half Value Layer", ''),
0x00400316: ('DS', '1', "Organ Dose", ''),
0x00400318: ('CS', '1', "Organ Exposed", ''),
0x00400320: ('SQ', '1', "Billing Procedure Step Sequence", ''),
0x00400321: ('SQ', '1', "Film Consumption Sequence", ''),
0x00400324: ('SQ', '1', "Billing Supplies and Devices Sequence", ''),
0x00400330: ('SQ', '1', "Referenced Procedure Step Sequence", 'Retired'),
0x00400340: ('SQ', '1', "Performed Series Sequence", ''),
0x00400400: ('LT', '1', "Comments on the Scheduled Procedure Step", ''),
0x00400440: ('SQ', '1', "Protocol Context Sequence", ''),
0x00400441: ('SQ', '1', "Content Item Modifier Sequence", ''),
# From Supp 122
0x00400500: ('SQ', '1', "Scheduled Specimen Sequence", ''),
0x0040050A: ('LO', '1', "Specimen Accession Number", 'Retired'),
0x00400512: ('LO', '1', "Container Identifier", ''),
0x00400513: ('SQ', '1', "Issuer of the Container Identifier Sequence", ''),
0x00400515: ('SQ', '1', "Alternate Container Identifier Sequence", ''),
0x00400518: ('SQ', '1', "Container Type Code Sequence", ''),
0x0040051A: ('LO', '1', "Container Description", ''),
0x00400520: ('SQ', '1', "Container Component Sequence", ''),
0x00400550: ('SQ', '1', "Specimen Sequence", 'Retired'),
# End From Supp 122
0x00400551: ('LO', '1', "Specimen Identifier", ''),
0x00400552: ('SQ', '1', "Specimen Description Sequence - Trial", 'Retired'),
0x00400553: ('ST', '1', "Specimen Description - Trial", 'Retired'),
# From Supp 122
0x00400554: ('UI', '1', "Specimen UID", ''),
# End From Supp 122
0x00400555: ('SQ', '1', "Acquisition Context Sequence", ''),
0x00400556: ('ST', '1', "Acquisition Context Description", ''),
0x0040059A: ('SQ', '1', "Specimen Type Code Sequence", ''),
# From Supp 122
0x00400560: ('SQ', '1', "Specimen Description Sequence", ''),
0x00400562: ('SQ', '1', "Issuer of the Specimen Identifier Sequence", ''),
0x00400600: ('LO', '1', "Specimen Short Description", ''),
0x00400602: ('UT', '1', "Specimen Detailed Description", ''),
0x00400610: ('SQ', '1', "Specimen Preparation Sequence", ''),
0x00400612: ('SQ', '1', "Specimen Preparation Step Content Item Sequence", ''),
0x00400620: ('SQ', '1', "Specimen Localization Content Item Sequence", ''),
0x004006FA: ('LO', '1', "Slide Identifier", 'Retired'),
# End From Supp 122
0x0040071A: ('SQ', '1', "Image Center Point Coordinates Sequence", ''),
0x0040072A: ('DS', '1', "X offset in Slide Coordinate System", ''),
0x0040073A: ('DS', '1', "Y offset in Slide Coordinate System", ''),
0x0040074A: ('DS', '1', "Z offset in Slide Coordinate System", ''),
0x004008D8: ('SQ', '1', "Pixel Spacing Sequence", ''),
0x004008DA: ('SQ', '1', "Coordinate System Axis Code Sequence", ''),
0x004008EA: ('SQ', '1', "Measurement Units Code Sequence", ''),
0x004009F8: ('SQ', '1', "Vital Stain Code Sequence - Trial", 'Retired'),
0x00401001: ('SH', '1', "Requested Procedure ID", ''),
0x00401002: ('LO', '1', "Reason for the Requested Procedure", ''),
0x00401003: ('SH', '1', "Requested Procedure Priority ", ''),
0x00401004: ('LO', '1', "Patient Transport Arrangements", ''),
0x00401005: ('LO', '1', "Requested Procedure Location", ''),
0x00401006: ('SH', '1', "Placer Order Number / Procedure", 'Retired'),
0x00401007: ('SH', '1', "Filler Order Number / Procedure", 'Retired'),
0x00401008: ('LO', '1', "Confidentiality Code", ''),
0x00401009: ('SH', '1', "Reporting Priority", ''),
0x0040100A: ('SQ', '1', "Reason for Requested Procedure Code Sequence", ''),
0x00401010: ('PN', '1-n', "Names of Intended Recipients of Results", ''),
0x00401011: ('SQ', '1', "Intended Recipients of Results Identification Sequence", ''),
0x00401101: ('SQ', '1', "Person Identification Code Sequence", ''),
0x00401102: ('ST', '1', "Person's Address", ''),
0x00401103: ('LO', '1-n', "Person's Telephone Numbers", ''),
0x00401400: ('LT', '1', "Requested Procedure Comments", ''),
0x00402001: ('LO', '1', "Reason for the Imaging Service Request", 'Retired'),
0x00402004: ('DA', '1', "Issue Date of Imaging Service Request", ''),
0x00402005: ('TM', '1', "Issue Time of Imaging Service Request", ''),
0x00402006: ('SH', '1', "Placer Order Number / Imaging Service Request (Retired)", 'Retired'),
0x00402007: ('SH', '1', "Filler Order Number / Imaging Service Request (Retired)", 'Retired'),
0x00402008: ('PN', '1', "Order Entered By", ''),
0x00402009: ('SH', '1', "Order Enterer's Location", ''),
0x00402010: ('SH', '1', "Order Callback Phone Number", ''),
0x00402016: ('LO', '1', "Placer Order Number / Imaging Service Request", ''),
0x00402017: ('LO', '1', "Filler Order Number / Imaging Service Request", ''),
0x00402400: ('LT', '1', "Imaging Service Request Comments", ''),
0x00403001: ('LO', '1', "Confidentiality Constraint on Patient Data Description", ''),
0x00404001: ('CS', '1', "General Purpose Scheduled Procedure Step Status", ''),
0x00404002: ('CS', '1', "General Purpose Performed Procedure Step Status", ''),
0x00404003: ('CS', '1', "General Purpose Scheduled Procedure Step Priority", ''),
0x00404004: ('SQ', '1', "Scheduled Processing Applications Code Sequence", ''),
0x00404005: ('DT', '1', "Scheduled Procedure Step Start Date and Time", ''),
0x00404006: ('CS', '1', "Multiple Copies Flag", ''),
0x00404007: ('SQ', '1', "Performed Processing Applications Code Sequence", ''),
0x00404009: ('SQ', '1', "Human Performer Code Sequence", ''),
0x00404010: ('DT', '1', "Scheduled Procedure Step Modification Date and Time", ''),
0x00404011: ('DT', '1', "Expected Completion Date and Time", ''),
0x00404015: ('SQ', '1', "Resulting General Purpose Performed Procedure Steps Sequence", ''),
0x00404016: ('SQ', '1', "Referenced General Purpose Scheduled Procedure Step Sequence", ''),
0x00404018: ('SQ', '1', "Scheduled Workitem Code Sequence", ''),
0x00404019: ('SQ', '1', "Performed Workitem Code Sequence", ''),
0x00404020: ('CS', '1', "Input Availability Flag", ''),
0x00404021: ('SQ', '1', "Input Information Sequence", ''),
0x00404022: ('SQ', '1', "Relevant Information Sequence", ''),
0x00404023: ('UI', '1', "Referenced General Purpose Scheduled Procedure Step Transaction UID", ''),
0x00404025: ('SQ', '1', "Scheduled Station Name Code Sequence", ''),
0x00404026: ('SQ', '1', "Scheduled Station Class Code Sequence", ''),
0x00404027: ('SQ', '1', "Scheduled Station Geographic Location Code Sequence", ''),
0x00404028: ('SQ', '1', "Performed Station Name Code Sequence", ''),
0x00404029: ('SQ', '1', "Performed Station Class Code Sequence", ''),
0x00404030: ('SQ', '1', "Performed Station Geographic Location Code Sequence", ''),
0x00404031: ('SQ', '1', "Requested Subsequent Workitem Code Sequence", ''),
0x00404032: ('SQ', '1', "Non-DICOM Output Code Sequence", ''),
0x00404033: ('SQ', '1', "Output Information Sequence", ''),
0x00404034: ('SQ', '1', "Scheduled Human Performers Sequence", ''),
0x00404035: ('SQ', '1', "Actual Human Performers Sequence", ''),
0x00404036: ('LO', '1', "Human Performer's Organization", ''),
0x00404037: ('PN', '1', "Human Performer's Name", ''),
0x00408302: ('DS', '1', "Entrance Dose in mGy", ''),
0x00409094: ('SQ', '1', "Referenced Image Real World Value Mapping Sequence", ''),
0x00409096: ('SQ', '1', "Real World Value Mapping Sequence ", ''),
0x00409098: ('SQ', '1', "Pixel Value Mapping Code Sequence", ''),
0x00409210: ('SH', '1', "LUT Label", ''),
0x00409211: ('US or SS', '1', "Real World Value Last Value Mapped", ''),
0x00409212: ('FD', '1-n', "Real World Value LUT Data", ''),
0x00409216: ('US or SS', '1', "Real World Value First Value Mapped", ''),
0x00409224: ('FD', '1', "Real World Value Intercept", ''),
0x00409225: ('FD', '1', "Real World Value Slope", ''),
0x0040A010: ('CS', '1', "Relationship Type", ''),
0x0040A027: ('LO', '1', "Verifying Organization", ''),
0x0040A030: ('DT', '1', "Verification Date Time", ''),
0x0040A032: ('DT', '1', "Observation Date Time", ''),
0x0040A040: ('CS', '1', "Value Type", ''),
0x0040A043: ('SQ', '1', "Concept Name Code Sequence", ''),
0x0040A050: ('CS', '1', "Continuity Of Content", ''),
0x0040A073: ('SQ', '1', "Verifying Observer Sequence", ''),
0x0040A075: ('PN', '1', "Verifying Observer Name", ''),
0x0040A078: ('SQ', '1', "Author Observer Sequence", ''),
0x0040A07A: ('SQ', '1', "Participant Sequence", ''),
0x0040A07C: ('SQ', '1', "Custodial Organization Sequence", ''),
0x0040A080: ('CS', '1', "Participation Type", ''),
0x0040A082: ('DT', '1', "Participation DateTime", ''),
0x0040A084: ('CS', '1', "Observer Type", ''),
0x0040A088: ('SQ', '1', "Verifying Observer Identification Code Sequence", ''),
0x0040A090: ('SQ', '1', "Equivalent CDA Document Sequence", 'Retired'),
0x0040A0B0: ('US', '2-2n', "Referenced Waveform Channels", ''),
0x0040A120: ('DT', '1', "DateTime", ''),
0x0040A121: ('DA', '1', "Date", ''),
0x0040A122: ('TM', '1', "Time", ''),
0x0040A123: ('PN', '1', "Person Name", ''),
0x0040A124: ('UI', '1', "UID", ''),
0x0040A130: ('CS', '1', "Temporal Range Type", ''),
0x0040A132: ('UL', '1-n', "Referenced Sample Positions", ''),
0x0040A136: ('US', '1-n', "Referenced Frame Numbers", ''),
0x0040A138: ('DS', '1-n', "Referenced Time Offsets", ''),
0x0040A13A: ('DT', '1-n', "Referenced DateTime ", ''),
0x0040A160: ('UT', '1', "Text Value", ''),
0x0040A168: ('SQ', '1', "Concept Code Sequence", ''),
0x0040A170: ('SQ', '1', "Purpose of Reference Code Sequence", ''),
0x0040A180: ('US', '1', "Annotation Group Number", ''),
0x0040A195: ('SQ', '1', "Modifier Code Sequence ", ''),
0x0040A300: ('SQ', '1', "Measured Value Sequence", ''),
0x0040A301: ('SQ', '1', "Numeric Value Qualifier Code Sequence", ''),
0x0040A30A: ('DS', '1-n', "Numeric Value", ''),
0x0040A353: ('ST', '1', "Address - Trial", 'Retired'),
0x0040A354: ('LO', '1', "Telephone Number - Trial", 'Retired'),
0x0040A360: ('SQ', '1', "Predecessor Documents Sequence", ''),
0x0040A370: ('SQ', '1', "Referenced Request Sequence", ''),
0x0040A372: ('SQ', '1', "Performed Procedure Code Sequence", ''),
0x0040A375: ('SQ', '1', "Current Requested Procedure Evidence Sequence", ''),
0x0040A385: ('SQ', '1', "Pertinent Other Evidence Sequence", ''),
0x0040A390: ('SQ', '1', "HL7 Structured Document Reference Sequence", ''),
0x0040A491: ('CS', '1', "Completion Flag", ''),
0x0040A492: ('LO', '1', "Completion Flag Description", ''),
0x0040A493: ('CS', '1', "Verification Flag", ''),
0x0040A494: ('CS', '1', "Archive Requested", ''),
0x0040A504: ('SQ', '1', "Content Template Sequence", ''),
0x0040A525: ('SQ', '1', "Identical Documents Sequence", ''),
0x0040A730: ('SQ', '1', "Content Sequence", ''),
0x0040B020: ('SQ', '1', "Annotation Sequence", ''),
0x0040DB00: ('CS', '1', "Template Identifier", ''),
0x0040DB06: ('DT', '1', "Template Version", 'Retired'),
0x0040DB07: ('DT', '1', "Template Local Version", 'Retired'),
0x0040DB0B: ('CS', '1', "Template Extension Flag", 'Retired'),
0x0040DB0C: ('UI', '1', "Template Extension Organization UID", 'Retired'),
0x0040DB0D: ('UI', '1', "Template Extension Creator UID", 'Retired'),
0x0040DB73: ('UL', '1-n', "Referenced Content Item Identifier", ''),
0x0040E001: ('ST', '1', "HL7 Instance Identifier ", ''),
0x0040E004: ('DT', '1', "HL7 Document Effective Time", ''),
0x0040E006: ('SQ', '1', "HL7 Document Type Code Sequence", ''),
0x0040E010: ('UT', '1', "Retrieve URI ", ''),
0x00420010: ('ST', '1', "Document Title", ''),
0x00420011: ('OB', '1', "Encapsulated Document", ''),
0x00420012: ('LO', '1', "MIME Type of Encapsulated Document", ''),
0x00420013: ('SQ', '1', "Source Instance Sequence", ''),
0x00420014: ('LO', '1-n', "List of MIME Types", ''),
0x00440001: ('ST', '1', "Product Package Identifier", ''),
0x00440002: ('CS', '1', "Substance Administration Approval", ''),
0x00440003: ('LT', '1', "Approval Status Further Description", ''),
0x00440004: ('DT', '1', "Approval Status DateTime ", ''),
0x00440007: ('SQ', '1', "Product Type Code Sequence", ''),
0x00440008: ('LO', '1-n', "Product Name", ''),
0x00440009: ('LT', '1', "Product Description", ''),
0x0044000A: ('LO', '1', "Product Lot Identifier", ''),
0x0044000B: ('DT', '1', "Product Expiration DateTime", ''),
0x00440010: ('DT', '1', "Substance Administration DateTime", ''),
0x00440011: ('LO', '1', "Substance Administration Notes", ''),
0x00440012: ('LO', '1', "Substance Administration Device ID", ''),
0x00440013: ('SQ', '1', "Product Parameter Sequence", ''),
0x00440019: ('SQ', '1', "Substance Administration Parameter Sequence", ''),
0x00500004: ('CS', '1', "Calibration Image", ''),
0x00500010: ('SQ', '1', "Device Sequence", ''),
# From Supp 122
0x00500012: ('SQ', '1', "Container Component Type Code Sequence", ''),
0x00500013: ('FD', '1', "Container Component Thickness", ''),
# End From Supp 122
0x00500014: ('DS', '1', "Device Length", ''),
# From Supp 122
0x00500015: ('FD', '1', "Container Component Width", ''),
# End From Supp 122
0x00500016: ('DS', '1', "Device Diameter", ''),
0x00500017: ('CS', '1', "Device Diameter Units", ''),
0x00500018: ('DS', '1', "Device Volume", ''),
0x00500019: ('DS', '1', "Intermarker Distance", ''),
# From Supp 122
0x0050001A: ('CS', '1', "Container Component Material", ''),
0x0050001B: ('LO', '1', "Container Component ID", ''),
0x0050001C: ('FD', '1', "Container Component Length", ''),
0x0050001D: ('FD', '1', "Container Component Diameter", ''),
0x0050001E: ('LO', '1', "Container Component Description", ''),
# End From Supp 122
0x00500020: ('LO', '1', "Device Description", ''),
0x00540010: ('US', '1-n', "Energy Window Vector", ''),
0x00540011: ('US', '1', "Number of Energy Windows", ''),
0x00540012: ('SQ', '1', "Energy Window Information Sequence", ''),
0x00540013: ('SQ', '1', "Energy Window Range Sequence", ''),
0x00540014: ('DS', '1', "Energy Window Lower Limit", ''),
0x00540015: ('DS', '1', "Energy Window Upper Limit", ''),
0x00540016: ('SQ', '1', "Radiopharmaceutical Information Sequence", ''),
0x00540017: ('IS', '1', "Residual Syringe Counts", ''),
0x00540018: ('SH', '1', "Energy Window Name", ''),
0x00540020: ('US', '1-n', "Detector Vector", ''),
0x00540021: ('US', '1', "Number of Detectors", ''),
0x00540022: ('SQ', '1', "Detector Information Sequence", ''),
0x00540030: ('US', '1-n', "Phase Vector", ''),
0x00540031: ('US', '1', "Number of Phases", ''),
0x00540032: ('SQ', '1', "Phase Information Sequence", ''),
0x00540033: ('US', '1', "Number of Frames in Phase", ''),
0x00540036: ('IS', '1', "Phase Delay", ''),
0x00540038: ('IS', '1', "Pause Between Frames", ''),
0x00540039: ('CS', '1', "Phase Description", ''),
0x00540050: ('US', '1-n', "Rotation Vector", ''),
0x00540051: ('US', '1', "Number of Rotations", ''),
0x00540052: ('SQ', '1', "Rotation Information Sequence", ''),
0x00540053: ('US', '1', "Number of Frames in Rotation", ''),
0x00540060: ('US', '1-n', "R-R Interval Vector", ''),
0x00540061: ('US', '1', "Number of R-R Intervals", ''),
0x00540062: ('SQ', '1', "Gated Information Sequence", ''),
0x00540063: ('SQ', '1', "Data Information Sequence", ''),
0x00540070: ('US', '1-n', "Time Slot Vector", ''),
0x00540071: ('US', '1', "Number of Time Slots", ''),
0x00540072: ('SQ', '1', "Time Slot Information Sequence", ''),
0x00540073: ('DS', '1', "Time Slot Time", ''),
0x00540080: ('US', '1-n', "Slice Vector", ''),
0x00540081: ('US', '1', "Number of Slices", ''),
0x00540090: ('US', '1-n', "Angular View Vector", ''),
0x00540100: ('US', '1-n', "Time Slice Vector", ''),
0x00540101: ('US', '1', "Number of Time Slices", ''),
0x00540200: ('DS', '1', "Start Angle", ''),
0x00540202: ('CS', '1', "Type of Detector Motion", ''),
0x00540210: ('IS', '1-n', "Trigger Vector", ''),
0x00540211: ('US', '1', "Number of Triggers in Phase", ''),
0x00540220: ('SQ', '1', "View Code Sequence", ''),
0x00540222: ('SQ', '1', "View Modifier Code Sequence", ''),
0x00540300: ('SQ', '1', "Radionuclide Code Sequence", ''),
0x00540302: ('SQ', '1', "Administration Route Code Sequence", ''),
0x00540304: ('SQ', '1', "Radiopharmaceutical Code Sequence", ''),
0x00540306: ('SQ', '1', "Calibration Data Sequence", ''),
0x00540308: ('US', '1', "Energy Window Number", ''),
0x00540400: ('SH', '1', "Image ID", ''),
0x00540410: ('SQ', '1', "Patient Orientation Code Sequence", ''),
0x00540412: ('SQ', '1', "Patient Orientation Modifier Code Sequence", ''),
0x00540414: ('SQ', '1', "Patient Gantry Relationship Code Sequence", ''),
0x00540500: ('CS', '1', "Slice Progression Direction", ''),
0x00541000: ('CS', '2', "Series Type", ''),
0x00541001: ('CS', '1', "Units", ''),
0x00541002: ('CS', '1', "Counts Source", ''),
0x00541004: ('CS', '1', "Reprojection Method", ''),
0x00541100: ('CS', '1', "Randoms Correction Method", ''),
0x00541101: ('LO', '1', "Attenuation Correction Method", ''),
0x00541102: ('CS', '1', "Decay Correction", ''),
0x00541103: ('LO', '1', "Reconstruction Method", ''),
0x00541104: ('LO', '1', "Detector Lines of Response Used", ''),
0x00541105: ('LO', '1', "Scatter Correction Method", ''),
0x00541200: ('DS', '1', "Axial Acceptance", ''),
0x00541201: ('IS', '2', "Axial Mash", ''),
0x00541202: ('IS', '1', "Transverse Mash", ''),
0x00541203: ('DS', '2', "Detector Element Size", ''),
0x00541210: ('DS', '1', "Coincidence Window Width", ''),
0x00541220: ('CS', '1-n', "Secondary Counts Type", ''),
0x00541300: ('DS', '1', "Frame Reference Time", ''),
0x00541310: ('IS', '1', "Primary (Prompts) Counts Accumulated", ''),
0x00541311: ('IS', '1-n', "Secondary Counts Accumulated", ''),
0x00541320: ('DS', '1', "Slice Sensitivity Factor", ''),
0x00541321: ('DS', '1', "Decay Factor", ''),
0x00541322: ('DS', '1', "Dose Calibration Factor", ''),
0x00541323: ('DS', '1', "Scatter Fraction Factor", ''),
0x00541324: ('DS', '1', "Dead Time Factor", ''),
0x00541330: ('US', '1', "Image Index", ''),
0x00541400: ('CS', '1-n', "Counts Included", 'Retired'),
0x00541401: ('CS', '1', "Dead Time Correction Flag", 'Retired'),
0x00603000: ('SQ', '1', "Histogram Sequence", ''),
0x00603002: ('US', '1', "Histogram Number of Bins", ''),
0x00603004: ('US or SS', '1', "Histogram First Bin Value", ''),
0x00603006: ('US or SS', '1', "Histogram Last Bin Value", ''),
0x00603008: ('US', '1', "Histogram Bin Width", ''),
0x00603010: ('LO', '1', "Histogram Explanation", ''),
0x00603020: ('UL', '1-n', "Histogram Data", ''),
0x00620001: ('CS', '1', "Segmentation Type", ''),
0x00620002: ('SQ', '1', "Segment Sequence", ''),
0x00620003: ('SQ', '1', "Segmented Property Category Code Sequence", ''),
0x00620004: ('US', '1', "Segment Number", ''),
0x00620005: ('LO', '1', "Segment Label", ''),
0x00620006: ('ST', '1', "Segment Description", ''),
0x00620008: ('CS', '1', "Segment Algorithm Type", ''),
0x00620009: ('LO', '1', "Segment Algorithm Name", ''),
0x0062000A: ('SQ', '1', "Segment Identification Sequence", ''),
0x0062000B: ('US', '1-n', "Referenced Segment Number", ''),
0x0062000C: ('US', '1', "Recommended Display Grayscale Value", ''),
0x0062000D: ('US', '3', "Recommended Display CIELab Value", ''),
0x0062000E: ('US', '1', "Maximum Fractional Value", ''),
0x0062000F: ('SQ', '1', "Segmented Property Type Code Sequence", ''),
0x00620010: ('CS', '1', "Segmentation Fractional Type", ''),
0x00640002: ('SQ', '1', "Deformable Registration Sequence", ''),
0x00640003: ('UI', '1', "Source Frame of Reference UID", ''),
0x00640005: ('SQ', '1', "Deformable Registration Grid Sequence", ''),
0x00640007: ('UL', '3', "Grid Dimensions", ''),
0x00640008: ('FD', '3', "Grid Resolution", ''),
0x00640009: ('OF', '1', "Vector Grid Data", ''),
0x0064000F: ('SQ', '1', "Pre Deformation Matrix Registration Sequence", ''),
0x00640010: ('SQ', '1', "Post Deformation Matrix Registration Sequence", ''),
0x00700001: ('SQ', '1', "Graphic Annotation Sequence", ''),
0x00700002: ('CS', '1', "Graphic Layer", ''),
0x00700003: ('CS', '1', "Bounding Box Annotation Units", ''),
0x00700004: ('CS', '1', "Anchor Point Annotation Units", ''),
0x00700005: ('CS', '1', "Graphic Annotation Units", ''),
0x00700006: ('ST', '1', "Unformatted Text Value", ''),
0x00700008: ('SQ', '1', "Text Object Sequence", ''),
0x00700009: ('SQ', '1', "Graphic Object Sequence", ''),
0x00700010: ('FL', '2', "Bounding Box Top Left Hand Corner", ''),
0x00700011: ('FL', '2', "Bounding Box Bottom Right Hand Corner", ''),
0x00700012: ('CS', '1', "Bounding Box Text Horizontal Justification", ''),
0x00700014: ('FL', '2', "Anchor Point", ''),
0x00700015: ('CS', '1', "Anchor Point Visibility", ''),
0x00700020: ('US', '1', "Graphic Dimensions ", ''),
0x00700021: ('US', '1', "Number of Graphic Points", ''),
0x00700022: ('FL', '2-n', "Graphic Data", ''),
0x00700023: ('CS', '1', "Graphic Type", ''),
0x00700024: ('CS', '1', "Graphic Filled", ''),
0x00700040: ('IS', '1', "Image Rotation (Retired)", 'Retired'),
0x00700041: ('CS', '1', "Image Horizontal Flip", ''),
0x00700042: ('US', '1', "Image Rotation ", ''),
0x00700050: ('US', '2', "Displayed Area Top Left Hand Corner (Trial)", 'Retired'),
0x00700051: ('US', '2', "Displayed Area Bottom Right Hand Corner (Trial)", 'Retired'),
0x00700052: ('SL', '2', "Displayed Area Top Left Hand Corner", ''),
0x00700053: ('SL', '2', "Displayed Area Bottom Right Hand Corner", ''),
0x0070005A: ('SQ', '1', "Displayed Area Selection Sequence", ''),
0x00700060: ('SQ', '1', "Graphic Layer Sequence", ''),
0x00700062: ('IS', '1', "Graphic Layer Order", ''),
0x00700066: ('US', '1', "Graphic Layer Recommended Display Grayscale Value", ''),
0x00700067: ('US', '3', "Graphic Layer Recommended Display RGB Value", 'Retired'),
0x00700068: ('LO', '1', "Graphic Layer Description", ''),
0x00700080: ('CS', '1', "Content Label", ''),
0x00700081: ('LO', '1', "Content Description", ''),
0x00700082: ('DA', '1', "Presentation Creation Date", ''),
0x00700083: ('TM', '1', "Presentation Creation Time", ''),
0x00700084: ('PN', '1', "Content Creator's Name", ''),
0x00700086: ('SQ', '1', "Content Creator's Identification Code Sequence", ''),
0x00700100: ('CS', '1', "Presentation Size Mode", ''),
0x00700101: ('DS', '2', "Presentation Pixel Spacing", ''),
0x00700102: ('IS', '2', "Presentation Pixel Aspect Ratio", ''),
0x00700103: ('FL', '1', "Presentation Pixel Magnification Ratio", ''),
0x00700306: ('CS', '1', "Shape Type", ''),
0x00700308: ('SQ', '1', "Registration Sequence", ''),
0x00700309: ('SQ', '1', "Matrix Registration Sequence", ''),
0x0070030A: ('SQ', '1', "Matrix Sequence", ''),
0x0070030C: ('CS', '1', "Frame of Reference Transformation Matrix Type", ''),
0x0070030D: ('SQ', '1', "Registration Type Code Sequence", ''),
0x0070030F: ('ST', '1', "Fiducial Description", ''),
0x00700310: ('SH', '1', "Fiducial Identifier", ''),
0x00700311: ('SQ', '1', "Fiducial Identifier Code Sequence", ''),
0x00700312: ('FD', '1', "Contour Uncertainty Radius", ''),
0x00700314: ('SQ', '1', "Used Fiducials Sequence", ''),
0x00700318: ('SQ', '1', "Graphic Coordinates Data Sequence", ''),
0x0070031A: ('UI', '1', "Fiducial UID", ''),
0x0070031C: ('SQ', '1', "Fiducial Set Sequence", ''),
0x0070031E: ('SQ', '1', "Fiducial Sequence", ''),
0x00700401: ('US', '3', "Graphic Layer Recommended Display CIELab Value", ''),
0x00700402: ('SQ', '1', "Blending Sequence", ''),
0x00700403: ('FL', '1', "Relative Opacity", ''),
0x00700404: ('SQ', '1', "Referenced Spatial Registration Sequence", ''),
0x00700405: ('CS', '1', "Blending Position", ''),
0x00720002: ('SH', '1', "Hanging Protocol Name", ''),
0x00720004: ('LO', '1', "Hanging Protocol Description", ''),
0x00720006: ('CS', '1', "Hanging Protocol Level", ''),
0x00720008: ('LO', '1', "Hanging Protocol Creator", ''),
0x0072000A: ('DT', '1', "Hanging Protocol Creation DateTime", ''),
0x0072000C: ('SQ', '1', "Hanging Protocol Definition Sequence", ''),
0x0072000E: ('SQ', '1', "Hanging Protocol User Identification Code Sequence", ''),
0x00720010: ('LO', '1', "Hanging Protocol User Group Name", ''),
0x00720012: ('SQ', '1', "Source Hanging Protocol Sequence", ''),
0x00720014: ('US', '1', "Number of Priors Referenced", ''),
0x00720020: ('SQ', '1', "Image Sets Sequence", ''),
0x00720022: ('SQ', '1', "Image Set Selector Sequence", ''),
0x00720024: ('CS', '1', "Image Set Selector Usage Flag", ''),
0x00720026: ('AT', '1', "Selector Attribute", ''),
0x00720028: ('US', '1', "Selector Value Number", ''),
0x00720030: ('SQ', '1', "Time Based Image Sets Sequence", ''),
0x00720032: ('US', '1', "Image Set Number", ''),
0x00720034: ('CS', '1', "Image Set Selector Category", ''),
0x00720038: ('US', '2', "Relative Time", ''),
0x0072003A: ('CS', '1', "Relative Time Units", ''),
0x0072003C: ('SS', '2', "Abstract Prior Value", ''),
0x0072003E: ('SQ', '1', "Abstract Prior Code Sequence", ''),
0x00720040: ('LO', '1', "Image Set Label", ''),
0x00720050: ('CS', '1', "Selector Attribute VR", ''),
0x00720052: ('AT', '1', "Selector Sequence Pointer", ''),
0x00720054: ('LO', '1', "Selector Sequence Pointer Private Creator", ''),
0x00720056: ('LO', '1', "Selector Attribute Private Creator", ''),
0x00720060: ('AT', '1-n', "Selector AT Value", ''),
0x00720062: ('CS', '1-n', "Selector CS Value", ''),
0x00720064: ('IS', '1-n', "Selector IS Value", ''),
0x00720066: ('LO', '1-n', "Selector LO Value", ''),
0x00720068: ('LT', '1', "Selector LT Value", ''),
0x0072006A: ('PN', '1-n', "Selector PN Value", ''),
0x0072006C: ('SH', '1-n', "Selector SH Value", ''),
0x0072006E: ('ST', '1', "Selector ST Value", ''),
0x00720070: ('UT', '1', "Selector UT Value", ''),
0x00720072: ('DS', '1-n', "Selector DS Value", ''),
0x00720074: ('FD', '1-n', "Selector FD Value", ''),
0x00720076: ('FL', '1-n', "Selector FL Value", ''),
0x00720078: ('UL', '1-n', "Selector UL Value", ''),
0x0072007A: ('US', '1-n', "Selector US Value", ''),
0x0072007C: ('SL', '1-n', "Selector SL Value", ''),
0x0072007E: ('SS', '1-n', "Selector SS Value", ''),
0x00720080: ('SQ', '1', "Selector Code Sequence Value", ''),
0x00720100: ('US', '1', "Number of Screens", ''),
0x00720102: ('SQ', '1', "Nominal Screen Definition Sequence", ''),
0x00720104: ('US', '1', "Number of Vertical Pixels", ''),
0x00720106: ('US', '1', "Number of Horizontal Pixels", ''),
0x00720108: ('FD', '4', "Display Environment Spatial Position", ''),
0x0072010A: ('US', '1', "Screen Minimum Grayscale Bit Depth", ''),
0x0072010C: ('US', '1', "Screen Minimum Color Bit Depth", ''),
0x0072010E: ('US', '1', "Application Maximum Repaint Time", ''),
0x00720200: ('SQ', '1', "Display Sets Sequence", ''),
0x00720202: ('US', '1', "Display Set Number", ''),
0x00720203: ('LO', '1', "Display Set Label", ''),
0x00720204: ('US', '1', "Display Set Presentation Group", ''),
0x00720206: ('LO', '1', "Display Set Presentation Group Description", ''),
0x00720208: ('CS', '1', "Partial Data Display Handling", ''),
0x00720210: ('SQ', '1', "Synchronized Scrolling Sequence", ''),
0x00720212: ('US', '2-n', "Display Set Scrolling Group", ''),
0x00720214: ('SQ', '1', "Navigation Indicator Sequence", ''),
0x00720216: ('US', '1', "Navigation Display Set ", ''),
0x00720218: ('US', '1-n', "Reference Display Sets", ''),
0x00720300: ('SQ', '1', "Image Boxes Sequence", ''),
0x00720302: ('US', '1', "Image Box Number", ''),
0x00720304: ('CS', '1', "Image Box Layout Type", ''),
0x00720306: ('US', '1', "Image Box Tile Horizontal Dimension", ''),
0x00720308: ('US', '1', "Image Box Tile Vertical Dimension", ''),
0x00720310: ('CS', '1', "Image Box Scroll Direction", ''),
0x00720312: ('CS', '1', "Image Box Small Scroll Type", ''),
0x00720314: ('US', '1', "Image Box Small Scroll Amount", ''),
0x00720316: ('CS', '1', "Image Box Large Scroll Type", ''),
0x00720318: ('US', '1', "Image Box Large Scroll Amount", ''),
0x00720320: ('US', '1', "Image Box Overlap Priority", ''),
0x00720330: ('FD', '1', "Cine Relative to Real-Time", ''),
0x00720400: ('SQ', '1', "Filter Operations Sequence", ''),
0x00720402: ('CS', '1', "Filter-by Category", ''),
0x00720404: ('CS', '1', "Filter-by Attribute Presence", ''),
0x00720406: ('CS', '1', "Filter-by Operator", ''),
0x00720500: ('CS', '1', "Blending Operation Type", ''),
0x00720510: ('CS', '1', "Reformatting Operation Type", ''),
0x00720512: ('FD', '1', "Reformatting Thickness", ''),
0x00720514: ('FD', '1', "Reformatting Interval", ''),
0x00720516: ('CS', '1', "Reformatting Operation Initial View Direction", ''),
0x00720520: ('CS', '1-n', "3D Rendering Type", ''),
0x00720600: ('SQ', '1', "Sorting Operations Sequence", ''),
0x00720602: ('CS', '1', "Sort-by Category", ''),
0x00720604: ('CS', '1', "Sorting Direction", ''),
0x00720700: ('CS', '2', "Display Set Patient Orientation", ''),
0x00720702: ('CS', '1', "VOI Type", ''),
0x00720704: ('CS', '1', "Pseudo-color Type", ''),
0x00720706: ('CS', '1', "Show Grayscale Inverted", ''),
0x00720710: ('CS', '1', "Show Image True Size Flag", ''),
0x00720712: ('CS', '1', "Show Graphic Annotation Flag", ''),
0x00720714: ('CS', '1', "Show Patient Demographics Flag", ''),
0x00720716: ('CS', '1', "Show Acquisition Techniques Flag", ''),
0x00720717: ('CS', '1', "Display Set Horizontal Justification ", ''),
0x00720718: ('CS', '1', "Display Set Vertical Justification", ''),
0x00741000: ('CS', '1', "Unified Procedure Step State", ''),
0x00741002: ('SQ', '1', "UPS Progress Information Sequence", ''),
0x00741004: ('DS', '1', "Unified Procedure Step Progress", ''),
0x00741006: ('ST', '1', "Unified Procedure Step Progress Description", ''),
0x00741008: ('SQ', '1', "Unified Procedure Step Communications URI Sequence", ''),
0x0074100a: ('ST', '1', "Contact URI", ''),
0x0074100c: ('LO', '1', "Contact Display Name", ''),
0x0074100e: ('SQ', '1', "Unified Procedure Step Discontinuation Reason Code Sequence", ''),
0x00741020: ('SQ', '1', "Beam Task Sequence", ''),
0x00741022: ('CS', '1', "Beam Task Type", ''),
0x00741024: ('IS', '1', "Beam Order Index", ''),
0x00741030: ('SQ', '1', "Delivery Verification Image Sequence", ''),
0x00741032: ('CS', '1', "Verification Image Timing", ''),
0x00741034: ('CS', '1', "Double Exposure Flag", ''),
0x00741036: ('CS', '1', "Double Exposure Ordering", ''),
0x00741038: ('DS', '1', "Double Exposure Meterset", ''),
0x0074103A: ('DS', '4', "Double Exposure Field Delta", ''),
0x00741040: ('SQ', '1', "Related Reference RT Image Sequence", ''),
0x00741042: ('SQ', '1', "General Machine Verification Sequence", ''),
0x00741044: ('SQ', '1', "Conventional Machine Verification Sequence", ''),
0x00741046: ('SQ', '1', "Ion Machine Verification Sequence", ''),
0x00741048: ('SQ', '1-n', "Failed Attributes Sequence", ''),
0x0074104A: ('SQ', '1-n', "Overridden Attributes Sequence", ''),
0x0074104C: ('SQ', '1', "Conventional Control Point Verification Sequence", ''),
0x0074104E: ('SQ', '1', "Ion Control Point Verification Sequence", ''),
0x00741050: ('SQ', '1-n', "Attribute Occurrence Sequence", ''),
0x00741052: ('AT', '1', "Attribute Occurrence Pointer", ''),
0x00741054: ('UL', '1', "Attribute Item Selector", ''),
0x00741056: ('LO', '1', "Attribute Occurrence Private Creator", ''),
0x00741200: ('CS', '1', "Scheduled Procedure Step Priority", ''),
0x00741202: ('LO', '1', "Worklist Label", ''),
0x00741204: ('LO', '1', "Procedure Step Label", ''),
0x00741210: ('SQ', '1', "Scheduled Processing Parameters Sequence", ''),
0x00741212: ('SQ', '1', "Performed Processing Parameters Sequence", ''),
0x00741216: ('SQ', '1', "UPS Performed Procedure Sequence", ''),
0x00741220: ('SQ', '1', "Related Procedure Step Sequence", ''),
0x00741222: ('LO', '1', "Procedure Step Relationship Type", ''),
0x00741230: ('LO', '1', "Deletion Lock", ''),
0x00741234: ('AE', '1', "Receiving AE", ''),
0x00741236: ('AE', '1', "Requesting AE", ''),
0x00741238: ('LT', '1', "Reason for Cancellation", ''),
0x00741242: ('CS', '1', "SCP Status", ''),
0x00741244: ('CS', '1', "Subscription List Status", ''),
0x00741246: ('CS', '1', "UPS List Status", ''),
0x00880130: ('SH', '1', "Storage Media File-set ID", ''),
0x00880140: ('UI', '1', "Storage Media File-set UID", ''),
0x00880200: ('SQ', '1', "Icon Image Sequence", ''),
0x00880904: ('LO', '1', "Topic Title", 'Retired'),
0x00880906: ('ST', '1', "Topic Subject", 'Retired'),
0x00880910: ('LO', '1', "Topic Author", 'Retired'),
0x00880912: ('LO', '1-32', "Topic Keywords", 'Retired'),
0x01000410: ('CS', '1', "SOP Instance Status", ''),
0x01000420: ('DT', '1', "SOP Authorization Date and Time", ''),
0x01000424: ('LT', '1', "SOP Authorization Comment", ''),
0x01000426: ('LO', '1', "Authorization Equipment Certification Number", ''),
0x04000005: ('US', '1', "MAC ID Number", ''),
0x04000010: ('UI', '1', "MAC Calculation Transfer Syntax UID", ''),
0x04000015: ('CS', '1', "MAC Algorithm", ''),
0x04000020: ('AT', '1-n', "Data Elements Signed", ''),
0x04000100: ('UI', '1', "Digital Signature UID", ''),
0x04000105: ('DT', '1', "Digital Signature DateTime", ''),
0x04000110: ('CS', '1', "Certificate Type", ''),
0x04000115: ('OB', '1', "Certificate of Signer", ''),
0x04000120: ('OB', '1', "Signature", ''),
0x04000305: ('CS', '1', "Certified Timestamp Type", ''),
0x04000310: ('OB', '1', "Certified Timestamp", ''),
0x04000401: ('SQ', '1', "Digital Signature Purpose Code Sequence", ''),
0x04000402: ('SQ', '1', "Referenced Digital Signature Sequence", ''),
0x04000403: ('SQ', '1', "Referenced SOP Instance MAC Sequence", ''),
0x04000404: ('OB', '1', "MAC", ''),
0x04000500: ('SQ', '1', "Encrypted Attributes Sequence", ''),
0x04000510: ('UI', '1', "Encrypted Content Transfer Syntax UID", ''),
0x04000520: ('OB', '1', "Encrypted Content", ''),
0x04000550: ('SQ', '1', "Modified Attributes Sequence", ''),
0x04000561: ('SQ', '1', "Original Attributes Sequence", ''),
0x04000562: ('DT', '1', "Attribute Modification DateTime", ''),
0x04000563: ('LO', '1', "Modifying System", ''),
0x04000564: ('LO', '1', "Source of Previous Values", ''),
0x04000565: ('CS', '1', "Reason for the Attribute Modification", ''),
0x20000010: ('IS', '1', "Number of Copies", ''),
0x2000001E: ('SQ', '1', "Printer Configuration Sequence", ''),
0x20000020: ('CS', '1', "Print Priority", ''),
0x20000030: ('CS', '1', "Medium Type", ''),
0x20000040: ('CS', '1', "Film Destination", ''),
0x20000050: ('LO', '1', "Film Session Label", ''),
0x20000060: ('IS', '1', "Memory Allocation", ''),
0x20000061: ('IS', '1', "Maximum Memory Allocation", ''),
0x20000062: ('CS', '1', "Color Image Printing Flag", 'Retired'),
0x20000063: ('CS', '1', "Collation Flag", 'Retired'),
0x20000065: ('CS', '1', "Annotation Flag", 'Retired'),
0x20000067: ('CS', '1', "Image Overlay Flag", 'Retired'),
0x20000069: ('CS', '1', "Presentation LUT Flag", 'Retired'),
0x2000006A: ('CS', '1', "Image Box Presentation LUT Flag", 'Retired'),
0x200000A0: ('US', '1', "Memory Bit Depth", ''),
0x200000A1: ('US', '1', "Printing Bit Depth", ''),
0x200000A2: ('SQ', '1', "Media Installed Sequence", ''),
0x200000A4: ('SQ', '1', "Other Media Available Sequence", ''),
0x200000A8: ('SQ', '1', "Supported Image Display Formats Sequence", ''),
0x20000500: ('SQ', '1', "Referenced Film Box Sequence", ''),
0x20000510: ('SQ', '1', "Referenced Stored Print  Sequence", 'Retired'),
0x20100010: ('ST', '1', "Image Display Format", ''),
0x20100030: ('CS', '1', "Annotation Display Format ID", ''),
0x20100040: ('CS', '1', "Film Orientation", ''),
0x20100050: ('CS', '1', "Film Size ID", ''),
0x20100052: ('CS', '1', "Printer Resolution ID", ''),
0x20100054: ('CS', '1', "Default Printer Resolution ID", ''),
0x20100060: ('CS', '1', "Magnification Type", ''),
0x20100080: ('CS', '1', "Smoothing Type  ", ''),
0x201000A6: ('CS', '1', "Default Magnification Type", ''),
0x201000A7: ('CS', '1-n', "Other Magnification Types Available", ''),
0x201000A8: ('CS', '1', "Default Smoothing Type", ''),
0x201000A9: ('CS', '1-n', "Other Smoothing Types Available", ''),
0x20100100: ('CS', '1', "Border Density", ''),
0x20100110: ('CS', '1', "Empty Image Density", ''),
0x20100120: ('US', '1', "Min Density", ''),
0x20100130: ('US', '1', "Max Density", ''),
0x20100140: ('CS', '1', "Trim", ''),
0x20100150: ('ST', '1', "Configuration Information", ''),
0x20100152: ('LT', '1', "Configuration Information Description", ''),
0x20100154: ('IS', '1', "Maximum Collated Films", ''),
0x2010015E: ('US', '1', "Illumination", ''),
0x20100160: ('US', '1', "Reflected Ambient Light", ''),
0x20100376: ('DS', '2', "Printer Pixel Spacing", ''),
0x20100500: ('SQ', '1', "Referenced Film Session Sequence", ''),
0x20100510: ('SQ', '1', "Referenced Image Box Sequence", ''),
0x20100520: ('SQ', '1', "Referenced Basic Annotation Box Sequence", ''),
0x20200010: ('US', '1', "Image Box Position", ''),
0x20200020: ('CS', '1', "Polarity", ''),
0x20200030: ('DS', '1', "Requested Image Size", ''),
0x20200040: ('CS', '1', "Requested Decimate/Crop Behavior", ''),
0x20200050: ('CS', '1', "Requested Resolution ID", ''),
0x202000A0: ('CS', '1', "Requested Image Size Flag", ''),
0x202000A2: ('CS', '1', "Decimate/Crop Result", ''),
0x20200110: ('SQ', '1', "Basic Grayscale Image Sequence", ''),
0x20200111: ('SQ', '1', "Basic Color Image Sequence", ''),
0x20200130: ('SQ', '1', "Referenced Image Overlay Box Sequence", 'Retired'),
0x20200140: ('SQ', '1', "Referenced VOI LUT Box Sequence ", 'Retired'),
0x20300010: ('US', '1', "Annotation Position", ''),
0x20300020: ('LO', '1', "Text String", ''),
0x20400010: ('SQ', '1', "Referenced Overlay Plane Sequence", 'Retired'),
0x20400011: ('US', '1-99', "Referenced Overlay Plane Groups", 'Retired'),
0x20400020: ('SQ', '1', "Overlay Pixel Data Sequence", 'Retired'),
0x20400060: ('CS', '1', "Overlay Magnification Type", 'Retired'),
0x20400070: ('CS', '1', "Overlay Smoothing Type", 'Retired'),
0x20400072: ('CS', '1', "Overlay or Image Magnification", 'Retired'),
0x20400074: ('US', '1', "Magnify to Number of Columns", 'Retired'),
0x20400080: ('CS', '1', "Overlay Foreground Density", 'Retired'),
0x20400082: ('CS', '1', "Overlay Background Density", 'Retired'),
0x20400090: ('CS', '1', "Overlay Mode", 'Retired'),
0x20400100: ('CS', '1', "Threshold Density", 'Retired'),
0x20400500: ('SQ', '1', "Referenced Image Box Sequence (Retired)", 'Retired'),
0x20500010: ('SQ', '1', "Presentation LUT Sequence", ''),
0x20500020: ('CS', '1', "Presentation LUT Shape", ''),
0x20500500: ('SQ', '1', "Referenced Presentation  LUT Sequence", ''),
0x21000010: ('SH', '1', "Print Job ID", 'Retired'),
0x21000020: ('CS', '1', "Execution Status", ''),
0x21000030: ('CS', '1', "Execution Status Info", ''),
0x21000040: ('DA', '1', "Creation Date", ''),
0x21000050: ('TM', '1', "Creation Time", ''),
0x21000070: ('AE', '1', "Originator", ''),
0x21000140: ('AE', '1', "Destination AE", 'Retired'),
0x21000160: ('SH', '1', "Owner ID", ''),
0x21000170: ('IS', '1', "Number of Films", ''),
0x21000500: ('SQ', '1', "Referenced Print Job Sequence (Pull Stored Print)", 'Retired'),
0x21100010: ('CS', '1', "Printer Status", ''),
0x21100020: ('CS', '1', "Printer Status Info", ''),
0x21100030: ('LO', '1', "Printer Name", ''),
0x21100099: ('SH', '1', "Print Queue ID", 'Retired'),
0x21200010: ('CS', '1', "Queue Status", 'Retired'),
0x21200050: ('SQ', '1', "Print Job Description Sequence", 'Retired'),
0x21200070: ('SQ', '1', "Referenced Print Job Sequence", 'Retired'),
0x21300010: ('SQ', '1', "Print Management Capabilities Sequence", 'Retired'),
0x21300015: ('SQ', '1', "Printer Characteristics Sequence", 'Retired'),
0x21300030: ('SQ', '1', "Film Box Content Sequence", 'Retired'),
0x21300040: ('SQ', '1', "Image Box Content Sequence", 'Retired'),
0x21300050: ('SQ', '1', "Annotation Content Sequence", 'Retired'),
0x21300060: ('SQ', '1', "Image Overlay Box Content Sequence", 'Retired'),
0x21300080: ('SQ', '1', "Presentation LUT Content Sequence", 'Retired'),
0x213000A0: ('SQ', '1', "Proposed Study Sequence", 'Retired'),
0x213000C0: ('SQ', '1', "Original Image Sequence", 'Retired'),
0x22000001: ('CS', '1', "Label Using Information Extracted From Instances", ''),
0x22000002: ('UT', '1', "Label Text", ''),
0x22000003: ('CS', '1', "Label Style Selection", ''),
0x22000004: ('LT', '1', "Media Disposition", ''),
0x22000005: ('LT', '1', "Barcode Value", ''),
0x22000006: ('CS', '1', "Barcode Symbology", ''),
0x22000007: ('CS', '1', "Allow Media Splitting", ''),
0x22000008: ('CS', '1', "Include Non-DICOM Objects", ''),
0x22000009: ('CS', '1', "Include Display Application", ''),
0x2200000A: ('CS', '1', "Preserve Composite Instances After Media Creation", ''),
0x2200000B: ('US', '1', "Total Number of Pieces of Media Created", ''),
0x2200000C: ('LO', '1', "Requested Media Application Profile", ''),
0x2200000D: ('SQ', '1', "Referenced Storage Media Sequence", ''),
0x2200000E: ('AT', '1-n', "Failure Attributes", ''),
0x2200000F: ('CS', '1', "Allow Lossy Compression", ''),
0x22000020: ('CS', '1', "Request Priority", ''),
0x30020002: ('SH', '1', "RT Image Label", ''),
0x30020003: ('LO', '1', "RT Image Name", ''),
0x30020004: ('ST', '1', "RT Image Description", ''),
0x3002000A: ('CS', '1', "Reported Values Origin", ''),
0x3002000C: ('CS', '1', "RT Image Plane", ''),
0x3002000D: ('DS', '3', "X-Ray Image Receptor Translation", ''),
0x3002000E: ('DS', '1', "X-Ray Image Receptor Angle", ''),
0x30020010: ('DS', '6', "RT Image Orientation", ''),
0x30020011: ('DS', '2', "Image Plane Pixel Spacing", ''),
0x30020012: ('DS', '2', "RT Image Position", ''),
0x30020020: ('SH', '1', "Radiation Machine Name", ''),
0x30020022: ('DS', '1', "Radiation Machine SAD", ''),
0x30020024: ('DS', '1', "Radiation Machine SSD", ''),
0x30020026: ('DS', '1', "RT Image SID", ''),
0x30020028: ('DS', '1', "Source to Reference Object Distance", ''),
0x30020029: ('IS', '1', "Fraction Number", ''),
0x30020030: ('SQ', '1', "Exposure Sequence", ''),
0x30020032: ('DS', '1', "Meterset Exposure", ''),
0x30020034: ('DS', '4', "Diaphragm Position", ''),
0x30020040: ('SQ', '1', "Fluence Map Sequence", ''),
0x30020041: ('CS', '1', "Fluence Data Source", ''),
0x30020042: ('DS', '1', "Fluence Data Scale", ''),
# From CP805/916
0x30020050: ('SQ', '1', "Primary Fluence Mode Sequence", ''),
0x30020051: ('CS', '1', "Fluence Mode", ''),
0x30020052: ('SH', '1', "Fluence Mode ID", ''),
# End from CP805/916
0x30040001: ('CS', '1', "DVH Type", ''),
0x30040002: ('CS', '1', "Dose Units", ''),
0x30040004: ('CS', '1', "Dose Type", ''),
0x30040006: ('LO', '1', "Dose Comment", ''),
0x30040008: ('DS', '3', "Normalization Point", ''),
0x3004000A: ('CS', '1', "Dose Summation Type", ''),
0x3004000C: ('DS', '2-n', "Grid Frame Offset Vector", ''),
0x3004000E: ('DS', '1', "Dose Grid Scaling", ''),
0x30040010: ('SQ', '1', "RT Dose ROI Sequence", ''),
0x30040012: ('DS', '1', "Dose Value", ''),
0x30040014: ('CS', '1-3', "Tissue Heterogeneity Correction", ''),
0x30040040: ('DS', '3', "DVH Normalization Point", ''),
0x30040042: ('DS', '1', "DVH Normalization Dose Value", ''),
0x30040050: ('SQ', '1', "DVH Sequence", ''),
0x30040052: ('DS', '1', "DVH Dose Scaling", ''),
0x30040054: ('CS', '1', "DVH Volume Units", ''),
0x30040056: ('IS', '1', "DVH Number of Bins", ''),
0x30040058: ('DS', '2-2n', "DVH Data", ''),
0x30040060: ('SQ', '1', "DVH Referenced ROI Sequence", ''),
0x30040062: ('CS', '1', "DVH ROI Contribution Type", ''),
0x30040070: ('DS', '1', "DVH Minimum Dose", ''),
0x30040072: ('DS', '1', "DVH Maximum Dose", ''),
0x30040074: ('DS', '1', "DVH Mean Dose", ''),
0x30060002: ('SH', '1', "Structure Set Label", ''),
0x30060004: ('LO', '1', "Structure Set Name", ''),
0x30060006: ('ST', '1', "Structure Set Description", ''),
0x30060008: ('DA', '1', "Structure Set Date", ''),
0x30060009: ('TM', '1', "Structure Set Time", ''),
0x30060010: ('SQ', '1', "Referenced Frame of Reference Sequence", ''),
0x30060012: ('SQ', '1', "RT Referenced Study Sequence", ''),
0x30060014: ('SQ', '1', "RT Referenced Series Sequence", ''),
0x30060016: ('SQ', '1', "Contour Image Sequence", ''),
0x30060020: ('SQ', '1', "Structure Set ROI Sequence", ''),
0x30060022: ('IS', '1', "ROI Number", ''),
0x30060024: ('UI', '1', "Referenced Frame of Reference UID", ''),
0x30060026: ('LO', '1', "ROI Name", ''),
0x30060028: ('ST', '1', "ROI Description", ''),
0x3006002A: ('IS', '3', "ROI Display Color", ''),
0x3006002C: ('DS', '1', "ROI Volume", ''),
0x30060030: ('SQ', '1', "RT Related ROI Sequence", ''),
0x30060033: ('CS', '1', "RT ROI Relationship", ''),
0x30060036: ('CS', '1', "ROI Generation Algorithm", ''),
0x30060038: ('LO', '1', "ROI Generation Description", ''),
0x30060039: ('SQ', '1', "ROI Contour Sequence", ''),
0x30060040: ('SQ', '1', "Contour Sequence", ''),
0x30060042: ('CS', '1', "Contour Geometric Type", ''),
0x30060044: ('DS', '1', "Contour Slab Thickness", ''),
0x30060045: ('DS', '3', "Contour Offset Vector", ''),
0x30060046: ('IS', '1', "Number of Contour Points", ''),
0x30060048: ('IS', '1', "Contour Number", ''),
0x30060049: ('IS', '1-n', "Attached Contours", ''),
0x30060050: ('DS', '3-3n', "Contour Data", ''),
0x30060080: ('SQ', '1', "RT ROI Observations Sequence", ''),
0x30060082: ('IS', '1', "Observation Number", ''),
0x30060084: ('IS', '1', "Referenced ROI Number", ''),
0x30060085: ('SH', '1', "ROI Observation Label", ''),
0x30060086: ('SQ', '1', "RT ROI Identification Code Sequence", ''),
0x30060088: ('ST', '1', "ROI Observation Description", ''),
0x300600A0: ('SQ', '1', "Related RT ROI Observations Sequence", ''),
0x300600A4: ('CS', '1', "RT ROI Interpreted Type", ''),
0x300600A6: ('PN', '1', "ROI Interpreter", ''),
0x300600B0: ('SQ', '1', "ROI Physical Properties Sequence", ''),
0x300600B2: ('CS', '1', "ROI Physical Property", ''),
0x300600B4: ('DS', '1', "ROI Physical Property Value", ''),
0x300600B6: ('SQ', '1', "ROI Elemental Composition Sequence", ''),
0x300600B7: ('US', '1', "ROI Elemental Composition Atomic Number", ''),
0x300600B8: ('FL', '1', "ROI Elemental Composition Atomic Mass Fraction", ''),
0x300600C0: ('SQ', '1', "Frame of Reference Relationship Sequence", ''),
0x300600C2: ('UI', '1', "Related Frame of Reference UID", ''),
0x300600C4: ('CS', '1', "Frame of Reference Transformation Type", ''),
0x300600C6: ('DS', '16', "Frame of Reference Transformation Matrix", ''),
0x300600C8: ('LO', '1', "Frame of Reference Transformation Comment", ''),
0x30080010: ('SQ', '1', "Measured Dose Reference Sequence", ''),
0x30080012: ('ST', '1', "Measured Dose Description", ''),
0x30080014: ('CS', '1', "Measured Dose Type", ''),
0x30080016: ('DS', '1', "Measured Dose Value", ''),
0x30080020: ('SQ', '1', "Treatment Session Beam Sequence", ''),
0x30080021: ('SQ', '1', "Treatment Session Ion Beam Sequence", ''),
0x30080022: ('IS', '1', "Current Fraction Number", ''),
0x30080024: ('DA', '1', "Treatment Control Point Date", ''),
0x30080025: ('TM', '1', "Treatment Control Point Time", ''),
0x3008002A: ('CS', '1', "Treatment Termination Status", ''),
0x3008002B: ('SH', '1', "Treatment Termination Code", ''),
0x3008002C: ('CS', '1', "Treatment Verification Status", ''),
0x30080030: ('SQ', '1', "Referenced Treatment Record Sequence", ''),
0x30080032: ('DS', '1', "Specified Primary Meterset ", ''),
0x30080033: ('DS', '1', "Specified Secondary Meterset ", ''),
0x30080036: ('DS', '1', "Delivered Primary Meterset ", ''),
0x30080037: ('DS', '1', "Delivered Secondary Meterset ", ''),
0x3008003A: ('DS', '1', "Specified Treatment Time", ''),
0x3008003B: ('DS', '1', "Delivered Treatment Time", ''),
0x30080040: ('SQ', '1', "Control Point Delivery Sequence", ''),
0x30080041: ('SQ', '1', "Ion Control Point Delivery Sequence", ''),
0x30080042: ('DS', '1', "Specified Meterset", ''),
0x30080044: ('DS', '1', "Delivered Meterset", ''),
0x30080045: ('FL', '1', "Meterset Rate Set", ''),
0x30080046: ('FL', '1', "Meterset Rate Delivered", ''),
0x30080047: ('FL', '1-n', "Scan Spot Metersets Delivered", ''),
0x30080048: ('DS', '1', "Dose Rate Delivered", ''),
0x30080050: ('SQ', '1', "Treatment Summary Calculated Dose Reference Sequence", ''),
0x30080052: ('DS', '1', "Cumulative Dose to Dose Reference", ''),
0x30080054: ('DA', '1', "First Treatment Date", ''),
0x30080056: ('DA', '1', "Most Recent Treatment Date", ''),
0x3008005A: ('IS', '1', "Number of Fractions Delivered", ''),
0x30080060: ('SQ', '1', "Override Sequence", ''),
0x30080061: ('AT', '1', "Parameter Sequence Pointer", ''),
0x30080062: ('AT', '1', "Override Parameter Pointer", ''),
0x30080063: ('IS', '1', "Parameter Item Index", ''),
0x30080064: ('IS', '1', "Measured Dose Reference Number", ''),
0x30080065: ('AT', '1', "Parameter Pointer", ''),
0x30080066: ('ST', '1', "Override Reason", ''),
0x30080068: ('SQ', '1', "Corrected Parameter Sequence", ''),
0x3008006A: ('FL', '1', "Correction Value", ''),
0x30080070: ('SQ', '1', "Calculated Dose Reference Sequence", ''),
0x30080072: ('IS', '1', "Calculated Dose Reference Number", ''),
0x30080074: ('ST', '1', "Calculated Dose Reference Description", ''),
0x30080076: ('DS', '1', "Calculated Dose Reference Dose Value", ''),
0x30080078: ('DS', '1', "Start Meterset", ''),
0x3008007A: ('DS', '1', "End Meterset", ''),
0x30080080: ('SQ', '1', "Referenced Measured Dose Reference Sequence", ''),
0x30080082: ('IS', '1', "Referenced Measured Dose Reference Number", ''),
0x30080090: ('SQ', '1', "Referenced Calculated Dose Reference Sequence", ''),
0x30080092: ('IS', '1', "Referenced Calculated Dose Reference Number", ''),
0x300800A0: ('SQ', '1', "Beam Limiting Device Leaf Pairs Sequence", ''),
0x300800B0: ('SQ', '1', "Recorded Wedge Sequence", ''),
0x300800C0: ('SQ', '1', "Recorded Compensator Sequence", ''),
0x300800D0: ('SQ', '1', "Recorded Block Sequence", ''),
0x300800E0: ('SQ', '1', "Treatment Summary Measured Dose Reference Sequence", ''),
0x300800F0: ('SQ', '1', "Recorded Snout Sequence", ''),
0x300800F2: ('SQ', '1', "Recorded Range Shifter Sequence", ''),
0x300800F4: ('SQ', '1', "Recorded Lateral Spreading Device Sequence", ''),
0x300800F6: ('SQ', '1', "Recorded Range Modulator Sequence", ''),
0x30080100: ('SQ', '1', "Recorded Source Sequence", ''),
0x30080105: ('LO', '1', "Source Serial Number", ''),
0x30080110: ('SQ', '1', "Treatment Session Application Setup Sequence", ''),
0x30080116: ('CS', '1', "Application Setup Check", ''),
0x30080120: ('SQ', '1', "Recorded Brachy Accessory Device Sequence", ''),
0x30080122: ('IS', '1', "Referenced Brachy Accessory Device Number", ''),
0x30080130: ('SQ', '1', "Recorded Channel Sequence", ''),
0x30080132: ('DS', '1', "Specified Channel Total Time", ''),
0x30080134: ('DS', '1', "Delivered Channel Total Time", ''),
0x30080136: ('IS', '1', "Specified Number of Pulses", ''),
0x30080138: ('IS', '1', "Delivered Number of Pulses", ''),
0x3008013A: ('DS', '1', "Specified Pulse Repetition Interval", ''),
0x3008013C: ('DS', '1', "Delivered Pulse Repetition Interval", ''),
0x30080140: ('SQ', '1', "Recorded Source Applicator Sequence", ''),
0x30080142: ('IS', '1', "Referenced Source Applicator Number", ''),
0x30080150: ('SQ', '1', "Recorded Channel Shield Sequence", ''),
0x30080152: ('IS', '1', "Referenced Channel Shield Number", ''),
0x30080160: ('SQ', '1', "Brachy Control Point Delivered Sequence", ''),
0x30080162: ('DA', '1', "Safe Position Exit Date", ''),
0x30080164: ('TM', '1', "Safe Position Exit Time", ''),
0x30080166: ('DA', '1', "Safe Position Return Date", ''),
0x30080168: ('TM', '1', "Safe Position Return Time", ''),
0x30080200: ('CS', '1', "Current Treatment Status", ''),
0x30080202: ('ST', '1', "Treatment Status Comment", ''),
0x30080220: ('SQ', '1', "Fraction Group Summary Sequence", ''),
0x30080223: ('IS', '1', "Referenced Fraction Number", ''),
0x30080224: ('CS', '1', "Fraction Group Type", ''),
0x30080230: ('CS', '1', "Beam Stopper Position", ''),
0x30080240: ('SQ', '1', "Fraction Status Summary Sequence", ''),
0x30080250: ('DA', '1', "Treatment Date", ''),
0x30080251: ('TM', '1', "Treatment Time", ''),
0x300A0002: ('SH', '1', "RT Plan Label", ''),
0x300A0003: ('LO', '1', "RT Plan Name", ''),
0x300A0004: ('ST', '1', "RT Plan Description", ''),
0x300A0006: ('DA', '1', "RT Plan Date", ''),
0x300A0007: ('TM', '1', "RT Plan Time", ''),
0x300A0009: ('LO', '1-n', "Treatment Protocols", ''),
0x300A000A: ('CS', '1', "Plan Intent", ''),
0x300A000B: ('LO', '1-n', "Treatment Sites", ''),
0x300A000C: ('CS', '1', "RT Plan Geometry", ''),
0x300A000E: ('ST', '1', "Prescription Description", ''),
0x300A0010: ('SQ', '1', "Dose Reference Sequence", ''),
0x300A0012: ('IS', '1', "Dose Reference Number", ''),
0x300A0013: ('UI', '1', "Dose Reference UID", ''),
0x300A0014: ('CS', '1', "Dose Reference Structure Type", ''),
0x300A0015: ('CS', '1', "Nominal Beam Energy Unit", ''),
0x300A0016: ('LO', '1', "Dose Reference Description", ''),
0x300A0018: ('DS', '3', "Dose Reference Point Coordinates", ''),
0x300A001A: ('DS', '1', "Nominal Prior Dose", ''),
0x300A0020: ('CS', '1', "Dose Reference Type", ''),
0x300A0021: ('DS', '1', "Constraint Weight", ''),
0x300A0022: ('DS', '1', "Delivery Warning Dose", ''),
0x300A0023: ('DS', '1', "Delivery Maximum Dose", ''),
0x300A0025: ('DS', '1', "Target Minimum Dose", ''),
0x300A0026: ('DS', '1', "Target Prescription Dose", ''),
0x300A0027: ('DS', '1', "Target Maximum Dose", ''),
0x300A0028: ('DS', '1', "Target Underdose Volume Fraction", ''),
0x300A002A: ('DS', '1', "Organ at Risk Full-volume Dose", ''),
0x300A002B: ('DS', '1', "Organ at Risk Limit Dose", ''),
0x300A002C: ('DS', '1', "Organ at Risk Maximum Dose", ''),
0x300A002D: ('DS', '1', "Organ at Risk Overdose Volume Fraction", ''),
0x300A0040: ('SQ', '1', "Tolerance Table Sequence", ''),
0x300A0042: ('IS', '1', "Tolerance Table Number", ''),
0x300A0043: ('SH', '1', "Tolerance Table Label", ''),
0x300A0044: ('DS', '1', "Gantry Angle Tolerance", ''),
0x300A0046: ('DS', '1', "Beam Limiting Device Angle Tolerance", ''),
0x300A0048: ('SQ', '1', "Beam Limiting Device Tolerance Sequence", ''),
0x300A004A: ('DS', '1', "Beam Limiting Device Position Tolerance", ''),
0x300A004B: ('FL', '1', "Snout Position Tolerance", ''),
0x300A004C: ('DS', '1', "Patient Support Angle Tolerance", ''),
0x300A004E: ('DS', '1', "Table Top Eccentric Angle Tolerance", ''),
0x300A004F: ('FL', '1', "Table Top Pitch Angle Tolerance", ''),
0x300A0050: ('FL', '1', "Table Top Roll Angle Tolerance", ''),
0x300A0051: ('DS', '1', "Table Top Vertical Position Tolerance", ''),
0x300A0052: ('DS', '1', "Table Top Longitudinal Position Tolerance", ''),
0x300A0053: ('DS', '1', "Table Top Lateral Position Tolerance", ''),
0x300A0055: ('CS', '1', "RT Plan Relationship", ''),
0x300A0070: ('SQ', '1', "Fraction Group Sequence", ''),
0x300A0071: ('IS', '1', "Fraction Group Number", ''),
0x300A0072: ('LO', '1', "Fraction Group Description", ''),
0x300A0078: ('IS', '1', "Number of Fractions Planned", ''),
0x300A0079: ('IS', '1', "Number of Fraction Pattern Digits Per Day", ''),
0x300A007A: ('IS', '1', "Repeat Fraction Cycle Length", ''),
0x300A007B: ('LT', '1', "Fraction Pattern", ''),
0x300A0080: ('IS', '1', "Number of Beams", ''),
0x300A0082: ('DS', '3', "Beam Dose Specification Point", ''),
0x300A0084: ('DS', '1', "Beam Dose", ''),
0x300A0086: ('DS', '1', "Beam Meterset", ''),
0x300A0088: ('FL', '1', "Beam Dose Point Depth", ''),
0x300A0089: ('FL', '1', "Beam Dose Point Equivalent Depth", ''),
0x300A008A: ('FL', '1', "Beam Dose Point SSD", ''),
0x300A00A0: ('IS', '1', "Number of Brachy Application Setups", ''),
0x300A00A2: ('DS', '3', "Brachy Application Setup Dose Specification Point", ''),
0x300A00A4: ('DS', '1', "Brachy Application Setup Dose", ''),
0x300A00B0: ('SQ', '1', "Beam Sequence", ''),
0x300A00B2: ('SH', '1', "Treatment Machine Name ", ''),
0x300A00B3: ('CS', '1', "Primary Dosimeter Unit", ''),
0x300A00B4: ('DS', '1', "Source-Axis Distance", ''),
0x300A00B6: ('SQ', '1', "Beam Limiting Device Sequence", ''),
0x300A00B8: ('CS', '1', "RT Beam Limiting Device Type", ''),
0x300A00BA: ('DS', '1', "Source to Beam Limiting Device Distance", ''),
0x300A00BB: ('FL', '1', "Isocenter to Beam Limiting Device Distance", ''),
0x300A00BC: ('IS', '1', "Number of Leaf/Jaw Pairs", ''),
0x300A00BE: ('DS', '3-n', "Leaf Position Boundaries", ''),
0x300A00C0: ('IS', '1', "Beam Number", ''),
0x300A00C2: ('LO', '1', "Beam Name", ''),
0x300A00C3: ('ST', '1', "Beam Description", ''),
0x300A00C4: ('CS', '1', "Beam Type", ''),
0x300A00C6: ('CS', '1', "Radiation Type", ''),
0x300A00C7: ('CS', '1', "High-Dose Technique Type", ''),
0x300A00C8: ('IS', '1', "Reference Image Number", ''),
0x300A00CA: ('SQ', '1', "Planned Verification Image Sequence", ''),
0x300A00CC: ('LO', '1-n', "Imaging Device-Specific Acquisition Parameters", ''),
0x300A00CE: ('CS', '1', "Treatment Delivery Type", ''),
0x300A00D0: ('IS', '1', "Number of Wedges", ''),
0x300A00D1: ('SQ', '1', "Wedge Sequence", ''),
0x300A00D2: ('IS', '1', "Wedge Number", ''),
0x300A00D3: ('CS', '1', "Wedge Type", ''),
0x300A00D4: ('SH', '1', "Wedge ID", ''),
0x300A00D5: ('IS', '1', "Wedge Angle", ''),
0x300A00D6: ('DS', '1', "Wedge Factor", ''),
0x300A00D7: ('FL', '1', "Total Wedge Tray Water-Equivalent Thickness", ''),
0x300A00D8: ('DS', '1', "Wedge Orientation", ''),
0x300A00D9: ('FL', '1', "Isocenter to Wedge Tray Distance", ''),
0x300A00DA: ('DS', '1', "Source to Wedge Tray Distance", ''),
0x300A00DB: ('FL', '1', "Wedge Thin Edge Position", ''),
0x300A00DC: ('SH', '1', "Bolus ID", ''),
0x300A00DD: ('ST', '1', "Bolus Description", ''),
0x300A00E0: ('IS', '1', "Number of Compensators", ''),
0x300A00E1: ('SH', '1', "Material ID", ''),
0x300A00E2: ('DS', '1', "Total Compensator Tray Factor", ''),
0x300A00E3: ('SQ', '1', "Compensator Sequence", ''),
0x300A00E4: ('IS', '1', "Compensator Number", ''),
0x300A00E5: ('SH', '1', "Compensator ID", ''),
0x300A00E6: ('DS', '1', "Source to Compensator Tray Distance", ''),
0x300A00E7: ('IS', '1', "Compensator Rows", ''),
0x300A00E8: ('IS', '1', "Compensator Columns", ''),
0x300A00E9: ('DS', '2', "Compensator Pixel Spacing", ''),
0x300A00EA: ('DS', '2', "Compensator Position", ''),
0x300A00EB: ('DS', '1-n', "Compensator Transmission Data", ''),
0x300A00EC: ('DS', '1-n', "Compensator Thickness Data", ''),
0x300A00ED: ('IS', '1', "Number of Boli", ''),
0x300A00EE: ('CS', '1', "Compensator Type", ''),
0x300A00F0: ('IS', '1', "Number of Blocks", ''),
0x300A00F2: ('DS', '1', "Total Block Tray Factor", ''),
0x300A00F3: ('FL', '1', "Total Block Tray Water-Equivalent Thickness", ''),
0x300A00F4: ('SQ', '1', "Block Sequence", ''),
0x300A00F5: ('SH', '1', "Block Tray ID", ''),
0x300A00F6: ('DS', '1', "Source to Block Tray Distance", ''),
0x300A00F7: ('FL', '1', "Isocenter to Block Tray Distance", ''),
0x300A00F8: ('CS', '1', "Block Type", ''),
0x300A00F9: ('LO', '1', "Accessory Code", ''),
0x300A00FA: ('CS', '1', "Block Divergence", ''),
0x300A00FB: ('CS', '1', "Block Mounting Position", ''),
0x300A00FC: ('IS', '1', "Block Number", ''),
0x300A00FE: ('LO', '1', "Block Name", ''),
0x300A0100: ('DS', '1', "Block Thickness", ''),
0x300A0102: ('DS', '1', "Block Transmission", ''),
0x300A0104: ('IS', '1', "Block Number of Points", ''),
0x300A0106: ('DS', '2-2n', "Block Data", ''),
0x300A0107: ('SQ', '1', "Applicator Sequence", ''),
0x300A0108: ('SH', '1', "Applicator ID", ''),
0x300A0109: ('CS', '1', "Applicator Type", ''),
0x300A010A: ('LO', '1', "Applicator Description", ''),
0x300A010C: ('DS', '1', "Cumulative Dose Reference Coefficient", ''),
0x300A010E: ('DS', '1', "Final Cumulative Meterset Weight", ''),
0x300A0110: ('IS', '1', "Number of Control Points", ''),
0x300A0111: ('SQ', '1', "Control Point Sequence", ''),
0x300A0112: ('IS', '1', "Control Point Index", ''),
0x300A0114: ('DS', '1', "Nominal Beam Energy", ''),
0x300A0115: ('DS', '1', "Dose Rate Set", ''),
0x300A0116: ('SQ', '1', "Wedge Position Sequence", ''),
0x300A0118: ('CS', '1', "Wedge Position", ''),
0x300A011A: ('SQ', '1', "Beam Limiting Device Position Sequence", ''),
0x300A011C: ('DS', '2-2n', "Leaf/Jaw Positions", ''),
0x300A011E: ('DS', '1', "Gantry Angle", ''),
0x300A011F: ('CS', '1', "Gantry Rotation Direction", ''),
0x300A0120: ('DS', '1', "Beam Limiting Device Angle", ''),
0x300A0121: ('CS', '1', "Beam Limiting Device Rotation Direction", ''),
0x300A0122: ('DS', '1', "Patient Support Angle", ''),
0x300A0123: ('CS', '1', "Patient Support Rotation Direction", ''),
0x300A0124: ('DS', '1', "Table Top Eccentric Axis Distance", ''),
0x300A0125: ('DS', '1', "Table Top Eccentric Angle", ''),
0x300A0126: ('CS', '1', "Table Top Eccentric Rotation Direction", ''),
0x300A0128: ('DS', '1', "Table Top Vertical Position", ''),
0x300A0129: ('DS', '1', "Table Top Longitudinal Position", ''),
0x300A012A: ('DS', '1', "Table Top Lateral Position", ''),
0x300A012C: ('DS', '3', "Isocenter Position", ''),
0x300A012E: ('DS', '3', "Surface Entry Point", ''),
0x300A0130: ('DS', '1', "Source to Surface Distance", ''),
0x300A0134: ('DS', '1', "Cumulative Meterset Weight", ''),
0x300A0140: ('FL', '1', "Table Top Pitch Angle", ''),
0x300A0142: ('CS', '1', "Table Top Pitch Rotation Direction", ''),
0x300A0144: ('FL', '1', "Table Top Roll Angle", ''),
0x300A0146: ('CS', '1', "Table Top Roll Rotation Direction", ''),
0x300A0148: ('FL', '1', "Head Fixation Angle", ''),
0x300A014A: ('FL', '1', "Gantry Pitch Angle", ''),
0x300A014C: ('CS', '1', "Gantry Pitch Rotation Direction", ''),
0x300A014E: ('FL', '1', "Gantry Pitch Angle Tolerance", ''),
0x300A0180: ('SQ', '1', "Patient Setup Sequence", ''),
0x300A0182: ('IS', '1', "Patient Setup Number", ''),
0x300A0183: ('LO', '1', "Patient Setup Label", ''),
0x300A0184: ('LO', '1', "Patient Additional Position", ''),
0x300A0190: ('SQ', '1', "Fixation Device Sequence", ''),
0x300A0192: ('CS', '1', "Fixation Device Type", ''),
0x300A0194: ('SH', '1', "Fixation Device Label", ''),
0x300A0196: ('ST', '1', "Fixation Device Description", ''),
0x300A0198: ('SH', '1', "Fixation Device Position", ''),
0x300A0199: ('FL', '1', "Fixation Device Pitch Angle", ''),
0x300A019A: ('FL', '1', "Fixation Device Roll Angle", ''),
0x300A01A0: ('SQ', '1', "Shielding Device Sequence", ''),
0x300A01A2: ('CS', '1', "Shielding Device Type", ''),
0x300A01A4: ('SH', '1', "Shielding Device Label", ''),
0x300A01A6: ('ST', '1', "Shielding Device Description", ''),
0x300A01A8: ('SH', '1', "Shielding Device Position", ''),
0x300A01B0: ('CS', '1', "Setup Technique", ''),
0x300A01B2: ('ST', '1', "Setup Technique Description", ''),
0x300A01B4: ('SQ', '1', "Setup Device Sequence", ''),
0x300A01B6: ('CS', '1', "Setup Device Type", ''),
0x300A01B8: ('SH', '1', "Setup Device Label", ''),
0x300A01BA: ('ST', '1', "Setup Device Description", ''),
0x300A01BC: ('DS', '1', "Setup Device Parameter", ''),
0x300A01D0: ('ST', '1', "Setup Reference Description", ''),
0x300A01D2: ('DS', '1', "Table Top Vertical Setup Displacement", ''),
0x300A01D4: ('DS', '1', "Table Top Longitudinal Setup Displacement", ''),
0x300A01D6: ('DS', '1', "Table Top Lateral Setup Displacement", ''),
0x300A0200: ('CS', '1', "Brachy Treatment Technique", ''),
0x300A0202: ('CS', '1', "Brachy Treatment Type", ''),
0x300A0206: ('SQ', '1', "Treatment Machine Sequence", ''),
0x300A0210: ('SQ', '1', "Source Sequence", ''),
0x300A0212: ('IS', '1', "Source Number", ''),
0x300A0214: ('CS', '1', "Source Type", ''),
0x300A0216: ('LO', '1', "Source Manufacturer", ''),
0x300A0218: ('DS', '1', "Active Source Diameter", ''),
0x300A021A: ('DS', '1', "Active Source Length", ''),
0x300A0222: ('DS', '1', "Source Encapsulation Nominal Thickness", ''),
0x300A0224: ('DS', '1', "Source Encapsulation Nominal Transmission", ''),
0x300A0226: ('LO', '1', "Source Isotope Name", ''),
0x300A0228: ('DS', '1', "Source Isotope Half Life", ''),
0x300A0229: ('CS', '1', "Source Strength Units", ''),
0x300A022A: ('DS', '1', "Reference Air Kerma Rate", ''),
0x300A022B: ('DS', '1', "Source Strength", ''),
0x300A022C: ('DA', '1', "Source Strength Reference Date", ''),
0x300A022E: ('TM', '1', "Source Strength Reference Time", ''),
0x300A0230: ('SQ', '1', "Application Setup Sequence", ''),
0x300A0232: ('CS', '1', "Application Setup Type", ''),
0x300A0234: ('IS', '1', "Application Setup Number", ''),
0x300A0236: ('LO', '1', "Application Setup Name", ''),
0x300A0238: ('LO', '1', "Application Setup Manufacturer", ''),
0x300A0240: ('IS', '1', "Template Number", ''),
0x300A0242: ('SH', '1', "Template Type", ''),
0x300A0244: ('LO', '1', "Template Name", ''),
0x300A0250: ('DS', '1', "Total Reference Air Kerma", ''),
0x300A0260: ('SQ', '1', "Brachy Accessory Device Sequence", ''),
0x300A0262: ('IS', '1', "Brachy Accessory Device Number", ''),
0x300A0263: ('SH', '1', "Brachy Accessory Device ID", ''),
0x300A0264: ('CS', '1', "Brachy Accessory Device Type", ''),
0x300A0266: ('LO', '1', "Brachy Accessory Device Name", ''),
0x300A026A: ('DS', '1', "Brachy Accessory Device Nominal Thickness", ''),
0x300A026C: ('DS', '1', "Brachy Accessory Device Nominal Transmission", ''),
0x300A0280: ('SQ', '1', "Channel Sequence", ''),
0x300A0282: ('IS', '1', "Channel Number", ''),
0x300A0284: ('DS', '1', "Channel Length", ''),
0x300A0286: ('DS', '1', "Channel Total Time", ''),
0x300A0288: ('CS', '1', "Source Movement Type", ''),
0x300A028A: ('IS', '1', "Number of Pulses", ''),
0x300A028C: ('DS', '1', "Pulse Repetition Interval", ''),
0x300A0290: ('IS', '1', "Source Applicator Number", ''),
0x300A0291: ('SH', '1', "Source Applicator ID", ''),
0x300A0292: ('CS', '1', "Source Applicator Type", ''),
0x300A0294: ('LO', '1', "Source Applicator Name", ''),
0x300A0296: ('DS', '1', "Source Applicator Length", ''),
0x300A0298: ('LO', '1', "Source Applicator Manufacturer", ''),
0x300A029C: ('DS', '1', "Source Applicator Wall Nominal Thickness", ''),
0x300A029E: ('DS', '1', "Source Applicator Wall Nominal Transmission", ''),
0x300A02A0: ('DS', '1', "Source Applicator Step Size", ''),
0x300A02A2: ('IS', '1', "Transfer Tube Number", ''),
0x300A02A4: ('DS', '1', "Transfer Tube Length", ''),
0x300A02B0: ('SQ', '1', "Channel Shield Sequence", ''),
0x300A02B2: ('IS', '1', "Channel Shield Number", ''),
0x300A02B3: ('SH', '1', "Channel Shield ID", ''),
0x300A02B4: ('LO', '1', "Channel Shield Name", ''),
0x300A02B8: ('DS', '1', "Channel Shield Nominal Thickness", ''),
0x300A02BA: ('DS', '1', "Channel Shield Nominal Transmission", ''),
0x300A02C8: ('DS', '1', "Final Cumulative Time Weight", ''),
0x300A02D0: ('SQ', '1', "Brachy Control Point Sequence", ''),
0x300A02D2: ('DS', '1', "Control Point Relative Position", ''),
0x300A02D4: ('DS', '3', "Control Point 3D Position", ''),
0x300A02D6: ('DS', '1', "Cumulative Time Weight", ''),
0x300A02E0: ('CS', '1', "Compensator Divergence", ''),
0x300A02E1: ('CS', '1', "Compensator Mounting Position", ''),
0x300A02E2: ('DS', '1-n', "Source to Compensator Distance", ''),
0x300A02E3: ('FL', '1', "Total Compensator Tray Water-Equivalent Thickness", ''),
0x300A02E4: ('FL', '1', "Isocenter to Compensator Tray Distance", ''),
0x300A02E5: ('FL', '1', "Compensator Column Offset", ''),
0x300A02E6: ('FL', '1-n', "Isocenter to Compensator Distances", ''),
0x300A02E7: ('FL', '1', "Compensator Relative Stopping Power Ratio", ''),
0x300A02E8: ('FL', '1', "Compensator Milling Tool Diameter", ''),
0x300A02EA: ('SQ', '1', "Ion Range Compensator Sequence", ''),
0x300A02EB: ('LT', '1', "Compensator Description", ''),
0x300A0302: ('IS', '1', "Radiation Mass Number", ''),
0x300A0304: ('IS', '1', "Radiation Atomic Number", ''),
0x300A0306: ('SS', '1', "Radiation Charge State", ''),
0x300A0308: ('CS', '1', "Scan Mode", ''),
0x300A030A: ('FL', '2', "Virtual Source-Axis Distances", ''),
0x300A030C: ('SQ', '1', "Snout Sequence", ''),
0x300A030D: ('FL', '1', "Snout Position", ''),
0x300A030F: ('SH', '1', "Snout ID", ''),
0x300A0312: ('IS', '1', "Number of Range Shifters", ''),
0x300A0314: ('SQ', '1', "Range Shifter Sequence", ''),
0x300A0316: ('IS', '1', "Range Shifter Number", ''),
0x300A0318: ('SH', '1', "Range Shifter ID", ''),
0x300A0320: ('CS', '1', "Range Shifter Type", ''),
0x300A0322: ('LO', '1', "Range Shifter Description", ''),
0x300A0330: ('IS', '1', "Number of Lateral Spreading Devices", ''),
0x300A0332: ('SQ', '1', "Lateral Spreading Device Sequence", ''),
0x300A0334: ('IS', '1', "Lateral Spreading Device Number", ''),
0x300A0336: ('SH', '1', "Lateral Spreading Device ID", ''),
0x300A0338: ('CS', '1', "Lateral Spreading Device Type", ''),
0x300A033A: ('LO', '1', "Lateral Spreading Device Description", ''),
0x300A033C: ('FL', '1', "Lateral Spreading Device Water Equivalent Thickness", ''),
0x300A0340: ('IS', '1', "Number of Range Modulators", ''),
0x300A0342: ('SQ', '1', "Range Modulator Sequence", ''),
0x300A0344: ('IS', '1', "Range Modulator Number", ''),
0x300A0346: ('SH', '1', "Range Modulator ID", ''),
0x300A0348: ('CS', '1', "Range Modulator Type", ''),
0x300A034A: ('LO', '1', "Range Modulator Description", ''),
0x300A034C: ('SH', '1', "Beam Current Modulation ID", ''),
0x300A0350: ('CS', '1', "Patient Support Type", ''),
0x300A0352: ('SH', '1', "Patient Support ID", ''),
0x300A0354: ('LO', '1', "Patient Support Accessory Code", ''),
0x300A0356: ('FL', '1', "Fixation Light Azimuthal Angle", ''),
0x300A0358: ('FL', '1', "Fixation Light Polar Angle", ''),
0x300A035A: ('FL', '1', "Meterset Rate", ''),
0x300A0360: ('SQ', '1', "Range Shifter Settings Sequence", ''),
0x300A0362: ('LO', '1', "Range Shifter Setting", ''),
0x300A0364: ('FL', '1', "Isocenter to Range Shifter Distance", ''),
0x300A0366: ('FL', '1', "Range Shifter Water Equivalent Thickness", ''),
0x300A0370: ('SQ', '1', "Lateral Spreading Device Settings Sequence", ''),
0x300A0372: ('LO', '1', "Lateral Spreading Device Setting", ''),
0x300A0374: ('FL', '1', "Isocenter to Lateral Spreading Device Distance", ''),
0x300A0380: ('SQ', '1', "Range Modulator Settings Sequence", ''),
0x300A0382: ('FL', '1', "Range Modulator Gating Start Value", ''),
0x300A0384: ('FL', '1', "Range Modulator Gating Stop Value", ''),
0x300A0386: ('FL', '1', "Range Modulator Gating Start Water Equivalent Thickness", ''),
0x300A0388: ('FL', '1', "Range Modulator Gating Stop Water Equivalent Thickness", ''),
0x300A038A: ('FL', '1', "Isocenter to Range Modulator Distance", ''),
0x300A0390: ('SH', '1', "Scan Spot Tune ID", ''),
0x300A0392: ('IS', '1', "Number of Scan Spot Positions", ''),
0x300A0394: ('FL', '1-n', "Scan Spot Position Map", ''),
0x300A0396: ('FL', '1-n', "Scan Spot Meterset Weights", ''),
0x300A0398: ('FL', '2', "Scanning Spot Size", ''),
0x300A039A: ('IS', '1', "Number of Paintings", ''),
0x300A03A0: ('SQ', '1', "Ion Tolerance Table Sequence", ''),
0x300A03A2: ('SQ', '1', "Ion Beam Sequence", ''),
0x300A03A4: ('SQ', '1', "Ion Beam Limiting Device Sequence", ''),
0x300A03A6: ('SQ', '1', "Ion Block Sequence", ''),
0x300A03A8: ('SQ', '1', "Ion Control Point Sequence", ''),
0x300A03AA: ('SQ', '1', "Ion Wedge Sequence", ''),
0x300A03AC: ('SQ', '1', "Ion Wedge Position Sequence", ''),
0x300A0401: ('SQ', '1', "Referenced Setup Image Sequence", ''),
0x300A0402: ('ST', '1', "Setup Image Comment", ''),
0x300A0410: ('SQ', '1', "Motion Synchronization Sequence", ''),
0x300A0412: ('FL', '3', "Control Point Orientation", ''),
0x300A0420: ('SQ', '1', "General Accessory Sequence", ''),
0x300A0421: ('CS', '1', "General Accessory ID", ''),
0x300A0422: ('ST', '1', "General Accessory Description", ''),
0x300A0423: ('SH', '1', "General Accessory Type", ''),
0x300A0424: ('IS', '1', "General Accessory Number", ''),
0x300C0002: ('SQ', '1', "Referenced RT Plan Sequence", ''),
0x300C0004: ('SQ', '1', "Referenced Beam Sequence", ''),
0x300C0006: ('IS', '1', "Referenced Beam Number", ''),
0x300C0007: ('IS', '1', "Referenced Reference Image Number", ''),
0x300C0008: ('DS', '1', "Start Cumulative Meterset Weight", ''),
0x300C0009: ('DS', '1', "End Cumulative Meterset Weight", ''),
0x300C000A: ('SQ', '1', "Referenced Brachy Application Setup Sequence", ''),
0x300C000C: ('IS', '1', "Referenced Brachy Application Setup Number", ''),
0x300C000E: ('IS', '1', "Referenced Source Number", ''),
0x300C0020: ('SQ', '1', "Referenced Fraction Group Sequence", ''),
0x300C0022: ('IS', '1', "Referenced Fraction Group Number", ''),
0x300C0040: ('SQ', '1', "Referenced Verification Image Sequence", ''),
0x300C0042: ('SQ', '1', "Referenced Reference Image Sequence", ''),
0x300C0050: ('SQ', '1', "Referenced Dose Reference Sequence", ''),
0x300C0051: ('IS', '1', "Referenced Dose Reference Number", ''),
0x300C0055: ('SQ', '1', "Brachy Referenced Dose Reference Sequence", ''),
0x300C0060: ('SQ', '1', "Referenced Structure Set Sequence", ''),
0x300C006A: ('IS', '1', "Referenced Patient Setup Number", ''),
0x300C0080: ('SQ', '1', "Referenced Dose Sequence", ''),
0x300C00A0: ('IS', '1', "Referenced Tolerance Table Number", ''),
0x300C00B0: ('SQ', '1', "Referenced Bolus Sequence", ''),
0x300C00C0: ('IS', '1', "Referenced Wedge Number", ''),
0x300C00D0: ('IS', '1', "Referenced Compensator Number", ''),
0x300C00E0: ('IS', '1', "Referenced Block Number", ''),
0x300C00F0: ('IS', '1', "Referenced Control Point Index", ''),
0x300C00F2: ('SQ', '1', "Referenced Control Point Sequence", ''),
0x300C00F4: ('IS', '1', "Referenced Start Control Point Index", ''),
0x300C00F6: ('IS', '1', "Referenced Stop Control Point Index", ''),
0x300C0100: ('IS', '1', "Referenced Range Shifter Number", ''),
0x300C0102: ('IS', '1', "Referenced Lateral Spreading Device Number", ''),
0x300C0104: ('IS', '1', "Referenced Range Modulator Number", ''),
0x300E0002: ('CS', '1', "Approval Status", ''),
0x300E0004: ('DA', '1', "Review Date", ''),
0x300E0005: ('TM', '1', "Review Time", ''),
0x300E0008: ('PN', '1', "Reviewer Name", ''),
0x40000010: ('LT', '1', "Arbitrary", 'Retired'),
0x40004000: ('LT', '1', "Text Comments", 'Retired'),
0x40080040: ('SH', '1', "Results ID", 'Retired'),
0x40080042: ('LO', '1', "Results ID Issuer", 'Retired'),
0x40080050: ('SQ', '1', "Referenced Interpretation Sequence", 'Retired'),
0x40080100: ('DA', '1', "Interpretation Recorded Date", 'Retired'),
0x40080101: ('TM', '1', "Interpretation Recorded Time", 'Retired'),
0x40080102: ('PN', '1', "Interpretation Recorder", 'Retired'),
0x40080103: ('LO', '1', "Reference to Recorded Sound", 'Retired'),
0x40080108: ('DA', '1', "Interpretation Transcription Date", 'Retired'),
0x40080109: ('TM', '1', "Interpretation Transcription Time", 'Retired'),
0x4008010A: ('PN', '1', "Interpretation Transcriber", 'Retired'),
0x4008010B: ('ST', '1', "Interpretation Text", 'Retired'),
0x4008010C: ('PN', '1', "Interpretation Author", 'Retired'),
0x40080111: ('SQ', '1', "Interpretation Approver Sequence", 'Retired'),
0x40080112: ('DA', '1', "Interpretation Approval Date", 'Retired'),
0x40080113: ('TM', '1', "Interpretation Approval Time", 'Retired'),
0x40080114: ('PN', '1', "Physician Approving Interpretation", 'Retired'),
0x40080115: ('LT', '1', "Interpretation Diagnosis Description", 'Retired'),
0x40080117: ('SQ', '1', "Interpretation Diagnosis Code Sequence", 'Retired'),
0x40080118: ('SQ', '1', "Results Distribution List Sequence", 'Retired'),
0x40080119: ('PN', '1', "Distribution Name", 'Retired'),
0x4008011A: ('LO', '1', "Distribution Address", 'Retired'),
0x40080200: ('SH', '1', "Interpretation ID", 'Retired'),
0x40080202: ('LO', '1', "Interpretation ID Issuer", 'Retired'),
0x40080210: ('CS', '1', "Interpretation Type ID", 'Retired'),
0x40080212: ('CS', '1', "Interpretation Status ID", 'Retired'),
0x40080300: ('ST', '1', "Impressions", 'Retired'),
0x40084000: ('ST', '1', "Results Comments", 'Retired'),
0x4FFE0001: ('SQ', '1', "MAC Parameters Sequence", ''),
0x52009229: ('SQ', '1', "Shared Functional Groups Sequence", ''),
0x52009230: ('SQ', '1', "Per-frame Functional Groups Sequence", ''),
0x54000100: ('SQ', '1', "Waveform Sequence ", ''),
0x54000110: ('OB/OW', '1', "Channel Minimum Value ", ''),
0x54000112: ('OB/OW', '1', "Channel Maximum Value ", ''),
0x54001004: ('US', '1', "Waveform Bits Allocated", ''),
0x54001006: ('CS', '1', "Waveform Sample Interpretation", ''),
0x5400100A: ('OB/OW', '1', "Waveform Padding Value", ''),
0x54001010: ('OB/OW', '1', "Waveform Data ", ''),
0x56000010: ('OF', '1', "First Order Phase Correction Angle", ''),
0x56000020: ('OF', '1', "Spectroscopy Data", ''),
0x7FE00010: ('OW/OB', '1', "Pixel Data", ''),
0x7FE00020: ('OW', '1', "Coefficients SDVN", 'Retired'),
0x7FE00030: ('OW', '1', "Coefficients SDHN", 'Retired'),
0x7FE00040: ('OW', '1', "Coefficients SDDN", 'Retired'),
0xFFFAFFFA: ('SQ', '1', "Digital Signatures Sequence", ''),
0xFFFCFFFC: ('OB', '1', "Data Set Trailing Padding", ''),
0xFFFEE000: ('NONE', '1', "Item", ''),
0xFFFEE00D: ('NONE', '1', "Item Delimitation Item", ''),
0xFFFEE0DD: ('NONE', '1', "Sequence Delimitation Item ", '')}

RepeatersDictionary = {
'002031xx': ('CS', '1-n', "Source Image IDs", 'Retired'),
'002804x0': ('US', '1', "Rows For Nth Order Coefficients", 'Retired'),
'002804x1': ('US', '1', "Columns For Nth Order Coefficients", 'Retired'),
'002804x2': ('LO', '1-n', "Coefficient Coding", 'Retired'),
'002804x3': ('AT', '1-n', "Coefficient Coding Pointers", 'Retired'),
'002808x0': ('CS', '1-n', "Code Label", 'Retired'),
'002808x2': ('US', '1', "Number of Table", 'Retired'),
'002808x3': ('AT', '1-n', "Code Table Location", 'Retired'),
'002808x4': ('US', '1', "Bits For Code Word", 'Retired'),
'002808x8': ('AT', '1-n', "Image Data Location", 'Retired'),
'1000xxx0': ('US', '3', "Escape Triplet", 'Retired'),
'1000xxx1': ('US', '3', "Run Length Triplet", 'Retired'),
'1000xxx2': ('US', '1', "Huffman Table Size", 'Retired'),
'1000xxx3': ('US', '3', "Huffman Table Triplet", 'Retired'),
'1000xxx4': ('US', '1', "Shift Table Size", 'Retired'),
'1000xxx5': ('US', '3', "Shift Table Triplet", 'Retired'),
'1010xxxx': ('US', '1-n', "Zonal Map", 'Retired'),
'50xx0005': ('US', '1', "Curve Dimensions ", 'Retired'),
'50xx0010': ('US', '1', "Number of Points ", 'Retired'),
'50xx0020': ('CS', '1', "Type of Data", 'Retired'),
'50xx0022': ('LO', '1', "Curve Description", 'Retired'),
'50xx0030': ('SH', '1-n', "Axis Units ", 'Retired'),
'50xx0040': ('SH', '1-n', "Axis Labels ", 'Retired'),
'50xx0103': ('US', '1', "Data Value Representation ", 'Retired'),
'50xx0104': ('US', '1-n', "Minimum Coordinate Value ", 'Retired'),
'50xx0105': ('US', '1-n', "Maximum Coordinate Value ", 'Retired'),
'50xx0106': ('SH', '1-n', "Curve Range", 'Retired'),
'50xx0110': ('US', '1-n', "Curve Data Descriptor", 'Retired'),
'50xx0112': ('US', '1-n', "Coordinate Start Value", 'Retired'),
'50xx0114': ('US', '1-n', "Coordinate Step Value", 'Retired'),
'50xx1001': ('CS', '1', "Curve Activation Layer ", 'Retired'),
'50xx2000': ('US', '1', "Audio Type", 'Retired'),
'50xx2002': ('US', '1', "Audio Sample Format", 'Retired'),
'50xx2004': ('US', '1', "Number of Channels", 'Retired'),
'50xx2006': ('UL', '1', "Number of Samples", 'Retired'),
'50xx2008': ('UL', '1', "Sample Rate", 'Retired'),
'50xx200A': ('UL', '1', "Total Time", 'Retired'),
'50xx200C': ('OW/OB', '1', "Audio Sample Data", 'Retired'),
'50xx200E': ('LT', '1', "Audio Comments", 'Retired'),
'50xx2500': ('LO', '1', "Curve Label", 'Retired'),
'50xx2600': ('SQ', '1', "Curve Referenced Overlay Sequence ", 'Retired'),
'50xx2610': ('US', '1', "Curve Referenced Overlay Group", 'Retired'),
'50xx3000': ('OW/OB', '1', "Curve Data", 'Retired'),
'60xx0010': ('US', '1', "Overlay Rows", ''),
'60xx0011': ('US', '1', "Overlay Columns", ''),
'60xx0012': ('US', '1', "Overlay Planes", 'Retired'),
'60xx0015': ('IS', '1', "Number of Frames in Overlay", ''),
'60xx0022': ('LO', '1', "Overlay Description", ''),
'60xx0040': ('CS', '1', "Overlay Type", ''),
'60xx0045': ('LO', '1', "Overlay Subtype", ''),
'60xx0050': ('SS', '2', "Overlay Origin", ''),
'60xx0051': ('US', '1', "Image Frame Origin", ''),
'60xx0052': ('US', '1', "Overlay Plane Origin", 'Retired'),
'60xx0060': ('CS', '1', "Overlay Compression Code", 'Retired'),
'60xx0061': ('SH', '1', "Overlay Compression Originator", 'Retired'),
'60xx0062': ('SH', '1', "Overlay Compression Label", 'Retired'),
'60xx0063': ('CS', '1', "Overlay Compression Description", 'Retired'),
'60xx0066': ('AT', '1-n', "Overlay Compression Step Pointers", 'Retired'),
'60xx0068': ('US', '1', "Overlay Repeat Interval", 'Retired'),
'60xx0069': ('US', '1', "Overlay Bits Grouped", 'Retired'),
'60xx0100': ('US', '1', "Overlay Bits Allocated", ''),
'60xx0102': ('US', '1', "Overlay Bit Position", ''),
'60xx0110': ('CS', '1', "Overlay Format", 'Retired'),
'60xx0200': ('US', '1', "Overlay Location", 'Retired'),
'60xx0800': ('CS', '1-n', "Overlay Code Label", 'Retired'),
'60xx0802': ('US', '1', "Overlay Number of Tables", 'Retired'),
'60xx0803': ('AT', '1-n', "Overlay Code Table Location", 'Retired'),
'60xx0804': ('US', '1', "Overlay Bits For Code Word", 'Retired'),
'60xx1001': ('CS', '1', "Overlay Activation Layer ", ''),
'60xx1100': ('US', '1', "Overlay Descriptor - Gray", 'Retired'),
'60xx1101': ('US', '1', "Overlay Descriptor - Red", 'Retired'),
'60xx1102': ('US', '1', "Overlay Descriptor - Green", 'Retired'),
'60xx1103': ('US', '1', "Overlay Descriptor - Blue", 'Retired'),
'60xx1200': ('US', '1-n', "Overlays- Gray", 'Retired'),
'60xx1201': ('US', '1-n', "Overlays - Red", 'Retired'),
'60xx1202': ('US', '1-n', "Overlays - Green", 'Retired'),
'60xx1203': ('US', '1-n', "Overlays- Blue", 'Retired'),
'60xx1301': ('IS', '1', "ROI Area", ''),
'60xx1302': ('DS', '1', "ROI Mean", ''),
'60xx1303': ('DS', '1', "ROI Standard Deviation", ''),
'60xx1500': ('LO', '1', "Overlay Label", ''),
'60xx3000': ('OB/OW', '1', "Overlay Data", ''),
'60xx4000': ('LT', '1', "Overlay Comments", 'Retired'),
'7Fxx0010': ('OW/OB', '1', "Variable Pixel Data", 'Retired'),
'7Fxx0011': ('US', '1', "Variable Next Data Group", 'Retired'),
'7Fxx0020': ('OW', '1', "Variable Coefficients SDVN", 'Retired'),
'7Fxx0030': ('OW', '1', "Variable Coefficients SDHN", 'Retired'),
'7Fxx0040': ('OW', '1', "Variable Coefficients SDDN", 'Retired')}
