import os
import sys
import gtk
import gtk.glade
import gobject
import gnome
import gettext

gtdomain = "pybackpack"
localedir = "/usr/share/locale"
gettext.install(gtdomain, localedir, unicode=True)
gtk.glade.bindtextdomain(gtdomain, localedir)
gtk.glade.textdomain(gtdomain)

import version
import rdiff_interface
from gui import GuiHandlers

class BackupTool:
    def __init__(self):
        gnome.program_init(version.APPNAME, version.VERSION)
        try:
            self.widgets = gtk.glade.XML("%s/gui.glade" % os.path.dirname(__file__))
        except RuntimeError, e:
            dlg = gtk.MessageDialog( \
                None, \
                gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE, \
                _("Unable to start %(progname)s:\n%(error)s") % {'progname':version.APPNAME, 'error':e})
            dlg.connect("response", lambda w: gtk.main_quit())
            sys.exit(1)

        # connect signals to handler functions
        self.guihandlers = GuiHandlers(self.widgets)
        self.widgets.signal_autoconnect(self.guihandlers)
        
        # create a backup set called 'home' that
        # contains the user's entire home directory
        rdiff_interface.FindSets()
        exists = False
        for s in rdiff_interface.backupsets:
            if s['name'] == 'home':
                exists = True
                break
        if exists == False:
            rdiff_interface.WriteSet(
                "home", _("A complete backup of your home directory."),
                [(os.environ['HOME'], True)], True, {'default_dest': 'cdrw://'})
        
        # populate the backup set list on the main window
        self.widgets.get_widget('treeview_backup_sets').set_model(
                gtk.ListStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING))
        self.guihandlers.refresh_set_list(self)
        column = gtk.TreeViewColumn()
        column.set_title(_('Backup Sets'))
        column.set_spacing(3)
        renderer = gtk.CellRendererPixbuf()
        column.pack_start(renderer, expand=False)
        column.add_attribute(renderer, 'pixbuf', 0)
        renderer = gtk.CellRendererText()
        column.pack_start(renderer, expand=True)
        column.add_attribute(renderer, 'text', 1)
        self.widgets.get_widget('treeview_backup_sets').append_column(column)
        
        if len(self.widgets.get_widget('treeview_backup_sets').get_model()) == 0:
            self.widgets.get_widget('label_backup_set_info').set_text(
                _("To begin, you need to create a new backup set. Click the 'New' button to get started."))

        # other widget initialisation
        self.widgets.get_widget('window_main').set_title(version.TITLE)
        self.widgets.get_widget('lbl_restore_help').set_text(
            self.widgets.get_widget('lbl_restore_help').get_text().
            replace(r'%s', version.APPPATH))
        self.widgets.get_widget('lbl_homebackup').set_text(
            self.widgets.get_widget('lbl_homebackup').get_text().replace(
            r'%s', os.environ['HOME']))
        self.widgets.get_widget('cmb_backup_type').set_active(0)
        self.widgets.get_widget('notebook3').set_current_page(0)

        # populate the list of recently used backup/restore locations
        self.widgets.get_widget('set_destination').set_model(
            gtk.ListStore(gobject.TYPE_STRING))
        self.widgets.get_widget('restore_src').set_model(gtk.ListStore(gobject.TYPE_STRING))
        for file, store in [("backup_mru", 
                            self.widgets.get_widget('set_destination').get_model()),
                            ("restore_mru", self.widgets.get_widget('restore_src').get_model())]:
            try:
                for line in open(os.path.join(os.environ['HOME'], ".%s" % version.\
                    APPPATH, file)).readlines():
                    store.append((line.strip(),))
            except IOError, e:
                    pass #if the file doesn't exist, don't panic!
        
        # detect what CD burners are available
        self.guihandlers.find_cd_burners()
        
def StartUp():
    pbp = BackupTool()
    gtk.main()

