/*
 * this file is a part of pxfw
 * Copyright (C) 2006, Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// const unsigned char op_blacklist[]={ 0xAC, 0xDE, 0xDF , 0xF8 };

const unsigned char op_blacklist[]={ 0xDE, 0xDF };  // used in TEST mode
const int           op_blacklist_sz=sizeof(op_blacklist);

int op_blacklisted(unsigned char opcode){
    if (op_blacklist_sz) for (int i=0; i<op_blacklist_sz; i++) {
	if (op_blacklist[i] == opcode) return 1;	
    }
    return 0;
}

const char* VERSION="0.2.1";

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>

//#include <libqpx/qpx_mmc.h>

#include <math.h>

//#include "pxfw.h"
#include "transport.h"

const int WR_PLEXTOR	= 0x0001;
const int PX_OLD	= 0x0001;
const int PX_PREMIUM	= 0x0002;
const int PX_708	= 0x0004;
const int PX_708A2	= 0x0008;
const int PX_712	= 0x0010;
const int PX_714	= 0x0020;
const int PX_716	= 0x0040;
const int PX_755	= 0x0080;
const int PX_760	= 0x0100;

int swap4(char* c) {
	char d[4];
	d[0]=c[3];
	d[1]=c[2];
	d[2]=c[1];
	d[3]=c[0];
	return *(int*)d;
}

int swap4(int c_) {
	char* c = (char*)&c_;
	char d[4];
	d[0]=c[3];
	d[1]=c[2];
	d[2]=c[1];
	d[3]=c[0];
	return *(int*)d;
}

short int swap2(char* c) {
	char d[2];
	d[0]=c[1];
	d[1]=c[0];
	return *(short int*)d;
}

unsigned short int swap2u(char* c) {
	char d[2];
	d[0]=c[1];
	d[1]=c[0];
	return *(unsigned short int*)d;
}

int min(int a, int b){
  if (a<=b)
	return a;
  return b;}

int max(int a, int b){
  if (a>b)
	return a;
  return b;}

long fsize(FILE* f){
	struct stat st;
	fstat(fileno(f),&st);
	return st.st_size;
}

int custom_command (char* drive, unsigned char opcode) {
	Scsi_Command cmd;
	int	err;
    	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		exit (3);
	}
	cmd[0]=opcode;
	if ((err=cmd.transport(NONE,NULL,0))) {
	  return err;
	}
	return 0;
}

int TestUnitReady (char* drive) {
	Scsi_Command cmd;
	int	err;
    	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		exit (3);
	}
//	int j = ExecSCSICmd(0,drive,&srbExec, NULL,0,6,0);
	cmd[0]=0;
	if ((err=cmd.transport(NONE,NULL,0))) {
//	  sperror ("TEST_UNIT_READY",err);
	  return 0;
	}
	return 1;
}

int get_feature(char* drive, int feature_number, char* pDest, int pDest_len, int* current = NULL) {
	Scsi_Command	cmd;
	int		err;
	if (current) *current = 0;
	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		exit (3);
	}
//ExecSCSICmd(SRB_DIR_IN,drive,&srbExec,
//pDest,32,10,0x46,0x02,(feature_number >> 8) & 0xFF,feature_number & 0xFF,0,0,0,32);
	cmd[0] = 0x46;
	cmd[1] = 0x02;
	cmd[2] = (feature_number >> 8) & 0xFF;
	cmd[3] = feature_number & 0xFF;
	cmd[7] = 32;
	if ((err=cmd.transport(READ,pDest,32))) {
		sperror ("GET_FEATURE",err);
		return 0;
	}
	char* data_length = (char*)&pDest[0];
	char* current_profile = (char*)&pDest[6];
	if (current) *current = pDest[10] & 0x01;
	if (swap4(data_length) < 8) return 0;
	return 1;
}

/* This read_capacity code is inspired from
Antony Polyakov dvd+rw-mediainfo.cpp
*/


int inquiry(char* drive, char* ven, char* dev, char* fw) {
	Scsi_Command	cmd;
	int		err;
	char		data[128];
	if (!cmd.associate(drive)){
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		exit (3);
	}
	cmd[0] = 0x12;
	cmd[4] = 36;
	cmd[5] = 0;
	if (err=cmd.transport(READ,data,36)){
		sperror("INQUIRY",err);
		exit (1);
	}
	if ((data[0]&0x1F) != 5){
		fprintf (stderr,"Not a MCC unit!\n");
		exit (0);
	}
	memcpy(ven,data+8,8);
	ven[8] = 0;
	memcpy(dev,data+16,16);
	dev[16] = 0;
	memcpy(fw,data+32,4);
	fw[4] = 0;
}

int FW_convert_to_ID (int* dev_ID, char* buf) {
//	if (!strncmp(buf,"PLEXTOR CD-R   PREMIUM",22)) *dev_ID=PX_PREMIUM;
//	else
//	if (!strncmp(buf,"PLEXTOR DVDR   PX-708",21)) *dev_ID=PX_708;
//	else
//	if (!strncmp(buf,"PLEXTOR DVDR   PX-712",21)) *dev_ID=PX_712 | PX_708A2;
//	else
	if (!strncmp(buf,"PLEXTOR DVDR   PX-716",21)) *dev_ID=PX_716 | PX_714;
	else
	if (!strncmp(buf,"PLEXTOR DVDR   PX-760",21)) *dev_ID=PX_760 | PX_755;
	else
		*dev_ID = 0;
}

int convert_to_ID (char* ven, char* dev,int* ven_ID, int* dev_ID, long int* FWSZ) {
	*FWSZ=0;
	if (!strncmp(ven,"PLEXTOR ",8)) {
		*ven_ID=WR_PLEXTOR;
		if(!strncmp(dev,"CD-R   PREMIUM",14)) {
			*dev_ID=PX_PREMIUM;
			*FWSZ=524288;
		} else
		if(!strncmp(dev,"DVDR   PX-708A2",15)) {
			*dev_ID=PX_708A2;
			*FWSZ=1028096;
		} else
		if(!strncmp(dev,"DVDR   PX-708",13)) {
			*dev_ID=PX_708;
			*FWSZ=983040;
		} else
		if(!strncmp(dev,"DVDR   PX-712",13)) {
			*dev_ID=PX_712;
			*FWSZ=1028096;
		} else
		if(!strncmp(dev,"DVDR   PX-714",13)) {
			*dev_ID=PX_714;
			*FWSZ=983040;
		} else
		if(!strncmp(dev,"DVDR   PX-716",13)) {
			*dev_ID=PX_716;
			*FWSZ=983040;
		} else
		if(!strncmp(dev,"DVDR   PX-755",13)) {
			*dev_ID=PX_755;
			*FWSZ=2031616;
		} else
		if(!strncmp(dev,"DVDR   PX-760",13)) {
			*dev_ID=PX_760;
			*FWSZ=2031616;
		} else
			*dev_ID=PX_OLD;
	}
}

int plextor_get_TLA(char* drive , char* cTLA) {
	char*		data;
	int		j;
	int		err;
	int		i,ii;
	Scsi_Command	cmd;
	data=(char*)calloc(sizeof(char),0x100);
	if (!cmd.associate(drive)){
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		exit (3);
	}
	cmd[0] = 0xF1;
	cmd[9] = 0x80;
	// The Plextor PX-716 does not understand this command....
	if ((err=cmd.transport(READ,data,0x100)))
	{
		//printf("Possible PX-716...\n");
		cmd[0] = 0xF1;
		cmd[1] = 0x01;
		cmd[9] = 0x80;
		if ((err=cmd.transport(READ,data,0x100) ))
		{
//      		sperror ("READ_ccTLA",err);
			strcpy(cTLA,"N/A\0");
        		return (0);	
		}
	}
	memcpy(cTLA,data+0x29,4);
	cTLA[4] = 0;
/*	for(i=0;i<0x10;i++){
		for(ii=0;ii<0x10;ii++){
			j=data[i*0x10+ii];
			printf("%4d ",j);
		}
		printf("\n");
	};*/
	return 1;
}

int plextor_read_eeprom(char* drive, unsigned char* buf, unsigned char offs) {
	unsigned int	sz=256;
	char*		data;
	int		i,j;
	int		err;
	Scsi_Command	cmd;

	if (!cmd.associate(drive))
		{ fprintf (stderr,"%s: unable to open: ",drive); perror (NULL); exit (3); }

	cmd[0] = 0xF1;
	cmd[1] = 0x01;
	cmd[7] = offs;
	cmd[8] = (sz >> 8) & 0xFF;
	cmd[9] = sz & 0xFF;
	if ((err=cmd.transport(READ,buf,sz) ))
		{ sperror ("read EEPROM",err); 	return (0); }

	printf("EEPROM block #%d:\n",offs);
	for(i=0;i<(sz/0x10);i++) {
	    printf("| %X0 | ", i);
	    for(j=0;j<0x10;j++) printf("%02X ",buf[i*0x10+j]);
	    printf("|");
	    for(j=0;j<0x10;j++) {
		if (buf[i*0x10+j] > 0x20) printf("%c",buf[i*0x10+j]);
		else printf(" ");
	    }
	    printf("|\n");
	};
	return 1;
}

int plextor_reboot(char* drive) {
	int		err;
	Scsi_Command	cmd;
	if (!cmd.associate(drive))
		{ fprintf (stderr,"%s: unable to open: ",drive); perror (NULL); exit (3); }
	cmd[0] = 0xEE;
	if ((err=cmd.transport(NONE,NULL,0) ))
		{ sperror ("reboot",err); return (0); }
}

int determine_disc_type(char* drive, int* disc_type) {
	Scsi_Command	cmd;
	int		err;
	char 		data[40]; memset(data, 0, 40);
	int current = 0;
//	*disc_type = 0;
	get_feature(drive, 0x1E, data, 32, &current);
	*disc_type = data[7];
	return 1;
}

int mode_sense(char* drive, int page, int page_control, void* pDest, int dest_len) {
	Scsi_Command	cmd;
	int		err;
   	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		return 0xFFFF;
//		exit (3);
	}
	cmd[0]=0x5A;
	cmd[2]=page_control << 6 | page;
	cmd[7]=dest_len >> 8;
	cmd[8]=dest_len & 0xFF;
	if ((err=cmd.transport(READ,pDest,dest_len) )){
        	sperror ("MODE_SENCE",err);
        	return 0;
	}
	return 1;
}

int get_drive_serial_number(char* drive, char* dest) {
	char data[2048]; memset(data, 0, sizeof(data));
	get_feature(drive, 0x108, data, sizeof(data), NULL);
	char length = data[11]; data[12+length]=0;
	strcpy(dest, data+12);
	return 1;
}

int fwup_init(char* drive) {
	Scsi_Command	cmd;
	int		err;
	char		buff[0x100];
	printf("Plex FW update init...\n");
   	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		return 0xFFFF;
//		exit (3);
	}
	for (int j=0; j<3; j++) {
	    for (int i=0; i<12; i++) cmd[i]=0x00;	
	    err=cmd.transport(READ,buff,0x12);
//	    if (err) {
//		sperror ("",err);
//        	return 1;
//	    }
	}
	printf("UNIT READY:)\n");
	return 0;
}

int load_eject(char* drive, bool load){
	Scsi_Command	cmd;
	int		err;
   	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		return 0xFFFF;
//		exit (3);
	}

	cmd[0]=0x1B; //MMC_START_STOP_UNIT;
	cmd[4]=0x02 | load;
	if ((err=cmd.transport(WRITE,NULL,0)))
		{ sperror ("LOAD_EJECT",err); return (err); }
	return 0;
}

int fwblk_send(char* drive, int offs, int blksz, unsigned char* data_wr, bool last) {
	Scsi_Command	cmd;
	int		err;
//	char		*data_wr;
//	char		data_rd[4096];
	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		return 0xFFFF;
//		exit (3);
	}

	cmd[0] = 0x3B;
	cmd[1] = last ? 0x05:0x04;
	cmd[2] = 0x00;
	cmd[3] = (offs >> 16) & 0xFF;
	cmd[4] = (offs >> 8) & 0xFF;
	cmd[5] = offs & 0xFF;
	cmd[6] = (blksz >> 16) & 0xFF;
	cmd[7] = (blksz >> 8) & 0xFF;
	cmd[8] = blksz & 0xFF;
	cmd[9] = 0x00;
	cmd[10]= 0x00;
	cmd[11]= 0x00;

	if ((err=cmd.transport(WRITE,data_wr,blksz) )){
		sperror ("SEND_FWBLK",err);
		if (!last) return 1;
	}
	return 0;
}

int fwblk_read(char* drive, int offs, int blksz, unsigned char* buf, unsigned char x) {
	Scsi_Command	cmd;
	int		err;
//	char		*data_wr;
	char		data_rd[4096];
	if (!cmd.associate(drive)) {
		fprintf (stderr,"%s: unable to open: ",drive);
		perror (NULL);
		return 0xFFFF;
//		exit (3);
	}

        printf("data read...\n");

	cmd[0] = 0x3B;
//	cmd[1] = last ? 0x05:0x04;
	cmd[1] = x;

	cmd[2] = 0x00;
	cmd[3] = (offs >> 16) & 0xFF;
	cmd[4] = (offs >> 8) & 0xFF;
	cmd[5] = offs & 0xFF;
	cmd[6] = (blksz >> 16) & 0xFF;
	cmd[7] = (blksz >> 8) & 0xFF;
	cmd[8] = blksz & 0xFF;
	cmd[9] = 0x00;
	cmd[10]= 0x00;
	cmd[11]= 0x00;

	if ((err=cmd.transport(READ,data_rd,blksz) )){
		sperror ("READ_FWBLK",err);
		return 1;
	}

//	printf("data check...\n");
//
//	for (int i=0; i<blksz; i++)
//		if (data_wr[i] != data_rd[i]) {
//			printf("i: %4d, W: %02X, R: %02X\n",i,data_wr[i] & 0xFF,data_rd[i] & 0xFF);
//		        return 1;
//		}
//	printf("Block write success\n");
//
	return 0;
}

void crc16_init(unsigned short int *crc16){
    *crc16 = 0;
}

void crc16_update(unsigned short int *crc16, unsigned char* buf, int len) {
	unsigned int i,ad,c;
	for (i=0; i<len; i++) {
		ad = buf[i];
//		ad = ((unsigned short int*)buf)[i];
//		ad = ((((unsigned char*)buf)[i+1]) << 8) | ((unsigned char*)buf)[i];
		*crc16 += ad;
//		c = ((*crc16+ad)>0xFFFF); *crc16 += ad + c;
	}
}

void usage(char* bin) {
	fprintf (stderr,"\nusage: %s /dev/dvd <FW_file> -h -d -u\n",bin);
	printf("\t-h\t show help\n");
	printf("\t-d\t debug\n");
	printf("\t-u\t write FW\n");
	printf("\t-f\t force flashing, even if drive not recognized or checksum error\n");
	printf("\t-e\t read EEPROM\n");
	printf("\t-r\t reboot drive\n");
	printf("\t-t\t test opcodes supported by drive (EXPERIMENTAL),\n");
	printf("\t\t use it only if you know what are you doing!\n");
}

int main(int argc,char *argv[]) {
//int qcheck(int argc,char *argv[]) {

	int i,j;
//    char 	wrinfo[0x3F];
	int	disc_type;
	int	book_type;
	int	layers;
	char	*fwfname;
	char	*drive;
	int	vendor_ID=0;
	char	vendor[9];
	int	device_ID=0;
	char	device[17];
	char	firmware[5];
	char	TLA[5]="";
	char	drv_serial[16];
	int	FW_dev_ID=0;
	int	cap;
const	int	fwblk = 4096;
	int	blen;
	int	fwblocks;
	long	fwsz;
	long	fwfsz;
	int	err;

	int 	last;
	int	flags=0;
	unsigned short int fCRC;
	unsigned short int CRC16;
	unsigned short int CRC16_diff;
	
	const int FL_HELP	= 0x00000001;
	const int FL_UPDATE	= 0x00000002;
	const int FL_BACKUP	= 0x00000004;
	const int FL_DEBUG	= 0x00000008;
	const int FL_TEST	= 0x00000010;
	const int FL_EEPROM	= 0x00000020;
	const int FL_REBOOT	= 0x00000040;
	const int FL_FORCE	= 0x00000080;

	unsigned char FWBUF[fwblk];
	FILE * fwfile;

	if (argc<2) {
		usage(argv[0]);
		exit (2);
	}
	drive = argv[1];
	fwfname = argv[2];
	printf(" ________________________________________\n");
	printf("|\n");
	printf("|** Plextor FW updater v%s (c) ShultZ **\n",VERSION);
	printf("|________________________________________\n");

//	flags = FL_UPDATE;
	if (argc>3) {
//		printf("Parsing additional options...\n");
		for (i=3; i<argc; i++) {
//			printf("arg[%d]: %s\n",i,argv[i]);
			if(!strcmp(argv[i],"-h")) flags |= FL_HELP;
			if(!strcmp(argv[i],"-u")) flags |= FL_UPDATE;
//			if(!strcmp(argv[i],"-b")) flags |= FL_BACKUP;
			if(!strcmp(argv[i],"-d")) flags |= FL_DEBUG;
			if(!strcmp(argv[i],"-t")) flags |= FL_TEST;
			if(!strcmp(argv[i],"-e")) flags |= FL_EEPROM;
			if(!strcmp(argv[i],"-r")) flags |= FL_REBOOT;
			if(!strcmp(argv[i],"-f")) flags |= FL_FORCE;
		}
	}
	printf("Flags: ");
	if (flags & FL_HELP)   printf(" HELP");
	if (flags & FL_UPDATE) printf(" UPDATE");
	if (flags & FL_BACKUP) printf(" BACKUP");
	if (flags & FL_DEBUG)  printf(" DEBUG");
	if (flags & FL_TEST)   printf(" TEST");
	if (flags & FL_EEPROM)   printf(" EEPROM");
	if (flags & FL_REBOOT)   printf(" REBOOT");

	printf("\nDevice : %s\n",drive);
	inquiry(drive,vendor,device,firmware);
	convert_to_ID(vendor,device,&vendor_ID,&device_ID,&fwsz);
	printf("Vendor : '%s'\n",vendor); 
	printf("Model  : '%s'",device);
	if ((vendor_ID == WR_PLEXTOR)) {
		plextor_get_TLA(drive,TLA);
		printf(" (TLA#%s)",TLA);
	}
	printf("\nF/W    : '%s'\n",firmware);
	if (get_drive_serial_number(drive,drv_serial)) {
		printf("Serial#: %s\n",drv_serial);
	}

	if ((vendor_ID != WR_PLEXTOR) && (!(flags & FL_FORCE))){
		printf("%s: Only PLEXTOR drives supported!\n",argv[0]);
		return 1;
	} else {
		if ((device_ID == PX_OLD)){
			printf("%s: Not supported PLEXTOR drive!\n",argv[0]);
			return 1;
		}
	}

	if (flags & FL_HELP) {
		usage(argv[0]);
		exit (0);
	}

	if (flags & FL_REBOOT) {
		plextor_reboot (drive);
		exit (0);
	}

	if (flags & FL_EEPROM) {
		unsigned char buf[1024];
		for (unsigned char idx=0; idx<4; idx++) plextor_read_eeprom(drive, buf+idx*256, idx);
		exit (0);
	}
	
	if (flags & FL_TEST) {
		for (unsigned int opcode=0x0000; opcode<0x0100; opcode++) {
			printf("Trying OpCode: ");
		        print_opcode((unsigned char)opcode);			
			if (!op_blacklisted((unsigned char)opcode)) {			
			        int err = custom_command(drive, (opcode & 0x00FF));
				if (!err) printf ("OK");
				else if (err==-1) printf ("command didn't passed to drive");
				else if (err==0x52000) printf ("*** command not supported ***");
				else print_sense(err);
			} else {
				printf("!!! BLACK LIST !!!");
			}
			printf("\n");
		}
		exit(0);
	}

	if (argc<3) exit(3);

	fwfile = fopen(fwfname, "r");
	if (!fwfile) {
		printf("%s: Can't open file: %s\n",argv[0],fwfname);
		return 1;
	}

//	fwblk=4096;
	fread(FWBUF, fwblk, 1, fwfile);
	const int FB=64;
	const int HH=16;

	fwfsz=fsize(fwfile);

	fwblocks=fwfsz/fwblk;
	printf("FW size:      %d\n",fwsz);
	printf("FW file size: %d\n",fwfsz);
	printf("First %d bytes of FW:\n", FB);
	for (i=0; i<(FB/HH); i++){
		printf("| ");
		for (j=0; j<HH; j++) printf("%02X ",FWBUF[i*HH+j] & 0xFF);
		printf(" | ");
		for (j=0; j<HH; j++)
			if ((FWBUF[i*HH+j] & 0xFF) > 0x20)
				printf("%c",FWBUF[i*HH+j] & 0xFF);
			else
				printf(" ");
		printf(" |\n");
	}
	FW_convert_to_ID(&FW_dev_ID,(char*) FWBUF);
	if ( device_ID & FW_dev_ID)
		printf("");
	else {
		printf("FW is not for selected drive!\n");
		exit(4);
	}
	if (flags & FL_BACKUP) {
		printf("BackUp feature not implemented yet...\n");
		for (i=0; i<fwblk; i++) FWBUF[i]=0;
		i=0;
		if (err = fwblk_read(drive, i*fwblk, fwblk, FWBUF, 2)) {
			printf("** error reading data\n");
		};

		printf("First %d bytes of FW:\n", FB);
		for (i=0; i<(FB/HH); i++){
			printf("| ");
			for (j=0; j<HH; j++) printf("%02X ",FWBUF[i*HH+j] & 0xFF);
			printf(" | ");
			for (j=0; j<HH; j++)
				if ((FWBUF[i*HH+j] & 0xFF) > 0x20)
					printf("%c",FWBUF[i*HH+j] & 0xFF);
				else
					printf(" ");
			printf(" |\n");
		}
	}


	fseek(fwfile,0,SEEK_SET);
	last=0;
	crc16_init(&CRC16);
//	printf("fwblocks = %d\n",fwblocks);
	for (i=0;!last;i++) {
//		fseek(fwfile,i*fwblk,SEEK_SET);

		fread(FWBUF, fwblk, 1, fwfile);
		if (i == (fwblocks-1)) last=1;
		if (last) blen = fwblk-2; else blen = fwblk;
//		printf("Offset %04X, block # %X\n",i*fwblk,i);
		crc16_update(&CRC16, FWBUF, blen);
//		printf ("%02X:  %4dB CRC=%04X\n",i,blen,CRC16blk);
	}
	fCRC = (FWBUF[fwblk-2] << 8) | FWBUF[fwblk-1];
	CRC16_diff = (CRC16  - fCRC) & 0xFFFF;
	printf("CheckSum:\n");
	printf("Last bytes : %04X\n",fCRC);
	printf("Calculated : %04X\n",CRC16);
	printf("diff       : %04X\n",CRC16_diff);


	if (flags & FL_UPDATE) {
		if (fwfsz!=fwsz) {
			printf("*** File size does not match FW size! ***\n");
	        	exit(3);
		}
		if (CRC16_diff) {
			if (!(flags & FL_FORCE)) {
			    printf("*** CheckSum incorrect! ***\n");
			    exit(3);
			} else {
			    printf("*** CheckSum incorrect, but -f option found. Force flashing...\n");
			}
		}
		determine_disc_type(drive, &disc_type);
//		printf("Disc type: %02X\n",disc_type);
		if (disc_type) {
			printf("Disc found, doing eject...\n");
			if (load_eject(drive, 0)) {
				printf("Can't eject disc:( remove disc manualy and try again\n");
				return 1;
			}
	        }

		printf("Sending FirmWare to drive \n");
		fseek(fwfile,0,SEEK_SET);
		last=0;
//		for (i=0;i<(fwblocks);i++) {
		err = fwup_init(drive);
		if (err) last=1;
		for (i=0;!last;i++) {
			fread(FWBUF, fwblk, 1, fwfile);
//			printf("Block #%d:\n",i);
			if (feof(fwfile) || (i == (fwblocks-1) )) {
				last=1;
				printf("\nData transfer complete: %d bytes (%X blocks). Updating...\n", (i+1)*fwblk, i+1);
			}
			err = fwblk_send(drive, i*fwblk, fwblk, FWBUF, last);
			if (err) {
			    printf("FW UPDATE ERROR!\n");
			    last=1;
			}
		}
		inquiry(drive,vendor,device,firmware);
		printf("FW update complete! New INQUIRY data:\n");
		printf("Vendor : '%s'\n",vendor); 
		printf("Model  : '%s'\n",device);
		printf("F/W    : '%s'\n",firmware);
	}
	printf("\n");
	fclose(fwfile);
	return 0;
}
