/* Table to ease conversion from binary to decimal formats

   Copyright (C) 2006 IBM Corporation.
   Copyright (C) 2007-2015 Free Software Foundation, Inc.

   This file is part of the Decimal Floating Point C Library.

   Author(s): Steve Munroe <sjmunroe@us.ibm.com>

   The Decimal Floating Point C Library is free software; you can
   redistribute it and/or modify it under the terms of the GNU Lesser
   General Public License version 2.1.

   The Decimal Floating Point C Library is distributed in the hope that
   it will be useful, but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
   the GNU Lesser General Public License version 2.1 for more details.

   You should have received a copy of the GNU Lesser General Public
   License version 2.1 along with the Decimal Floating Point C Library;
   if not, write to the Free Software Foundation, Inc., 59 Temple Place,
   Suite 330, Boston, MA 02111-1307 USA.

   Please see dfp/COPYING.txt for more information.  */

/*  Table of decimal powers of 2 from 0 to 1076. Only positive powers of
 *  2 are needed as negative exponents are handled via divide. Entries
 *  1023-1076 are required to handle denormal doubles (-1022 - 54)
*/
const _Decimal128 decpowof2 [] = {
	1.0E+0DL,	/* 2**0 */
	2.0E+0DL,	/* 2**1 */
	4.0E+0DL,	/* 2**2 */
	8.0E+0DL,	/* 2**3 */
	1.6E+1DL,	/* 2**4 */
	3.2E+1DL,	/* 2**5 */
	6.4E+1DL,	/* 2**6 */
	1.28E+2DL,	/* 2**7 */
	2.56E+2DL,	/* 2**8 */
	5.12E+2DL,	/* 2**9 */
	1.024E+3DL,	/* 2**10 */
	2.048E+3DL,	/* 2**11 */
	4.096E+3DL,	/* 2**12 */
	8.192E+3DL,	/* 2**13 */
	1.6384E+4DL,	/* 2**14 */
	3.2768E+4DL,	/* 2**15 */
	6.5536E+4DL,	/* 2**16 */
	1.31072E+5DL,	/* 2**17 */
	2.62144E+5DL,	/* 2**18 */
	5.24288E+5DL,	/* 2**19 */
	1.048576E+6DL,	/* 2**20 */
	2.097152E+6DL,	/* 2**21 */
	4.194304E+6DL,	/* 2**22 */
	8.388608E+6DL,	/* 2**23 */
	1.6777216E+7DL,	/* 2**24 */
	3.3554432E+7DL,	/* 2**25 */
	6.7108864E+7DL,	/* 2**26 */
	1.34217728E+8DL,	/* 2**27 */
	2.68435456E+8DL,	/* 2**28 */
	5.36870912E+8DL,	/* 2**29 */
	1.073741824E+9DL,	/* 2**30 */
	2.147483648E+9DL,	/* 2**31 */
	4.294967296E+9DL,	/* 2**32 */
	8.589934592E+9DL,	/* 2**33 */
	1.7179869184E+10DL,	/* 2**34 */
	3.4359738368E+10DL,	/* 2**35 */
	6.8719476736E+10DL,	/* 2**36 */
	1.37438953472E+11DL,	/* 2**37 */
	2.74877906944E+11DL,	/* 2**38 */
	5.49755813888E+11DL,	/* 2**39 */
	1.099511627776E+12DL,	/* 2**40 */
	2.199023255552E+12DL,	/* 2**41 */
	4.398046511104E+12DL,	/* 2**42 */
	8.796093022208E+12DL,	/* 2**43 */
	1.7592186044416E+13DL,	/* 2**44 */
	3.5184372088832E+13DL,	/* 2**45 */
	7.0368744177664E+13DL,	/* 2**46 */
	1.40737488355328E+14DL,	/* 2**47 */
	2.81474976710656E+14DL,	/* 2**48 */
	5.62949953421312E+14DL,	/* 2**49 */
	1.125899906842624E+15DL,	/* 2**50 */
	2.251799813685248E+15DL,	/* 2**51 */
	4.503599627370496E+15DL,	/* 2**52 */
	9.007199254740992E+15DL,	/* 2**53 */
	1.8014398509481984E+16DL,	/* 2**54 */
	3.6028797018963968E+16DL,	/* 2**55 */
	7.2057594037927936E+16DL,	/* 2**56 */
	1.44115188075855872E+17DL,	/* 2**57 */
	2.88230376151711744E+17DL,	/* 2**58 */
	5.76460752303423488E+17DL,	/* 2**59 */
	1.152921504606846976E+18DL,	/* 2**60 */
	2.305843009213693952E+18DL,	/* 2**61 */
	4.611686018427387904E+18DL,	/* 2**62 */
	9.223372036854775808E+18DL,	/* 2**63 */
	1.8446744073709551616E+19DL,	/* 2**64 */
	3.6893488147419103232E+19DL,	/* 2**65 */
	7.3786976294838206464E+19DL,	/* 2**66 */
	1.47573952589676412928E+20DL,	/* 2**67 */
	2.95147905179352825856E+20DL,	/* 2**68 */
	5.90295810358705651712E+20DL,	/* 2**69 */
	1.180591620717411303424E+21DL,	/* 2**70 */
	2.361183241434822606848E+21DL,	/* 2**71 */
	4.722366482869645213696E+21DL,	/* 2**72 */
	9.444732965739290427392E+21DL,	/* 2**73 */
	1.8889465931478580854784E+22DL,	/* 2**74 */
	3.7778931862957161709568E+22DL,	/* 2**75 */
	7.5557863725914323419136E+22DL,	/* 2**76 */
	1.51115727451828646838272E+23DL,	/* 2**77 */
	3.02231454903657293676544E+23DL,	/* 2**78 */
	6.04462909807314587353088E+23DL,	/* 2**79 */
	1.208925819614629174706176E+24DL,	/* 2**80 */
	2.417851639229258349412352E+24DL,	/* 2**81 */
	4.835703278458516698824704E+24DL,	/* 2**82 */
	9.671406556917033397649408E+24DL,	/* 2**83 */
	1.9342813113834066795298816E+25DL,	/* 2**84 */
	3.8685626227668133590597632E+25DL,	/* 2**85 */
	7.7371252455336267181195264E+25DL,	/* 2**86 */
	1.54742504910672534362390528E+26DL,	/* 2**87 */
	3.09485009821345068724781056E+26DL,	/* 2**88 */
	6.18970019642690137449562112E+26DL,	/* 2**89 */
	1.237940039285380274899124224E+27DL,	/* 2**90 */
	2.475880078570760549798248448E+27DL,	/* 2**91 */
	4.951760157141521099596496896E+27DL,	/* 2**92 */
	9.903520314283042199192993792E+27DL,	/* 2**93 */
	1.9807040628566084398385987584E+28DL,	/* 2**94 */
	3.9614081257132168796771975168E+28DL,	/* 2**95 */
	7.9228162514264337593543950336E+28DL,	/* 2**96 */
	1.58456325028528675187087900672E+29DL,	/* 2**97 */
	3.16912650057057350374175801344E+29DL,	/* 2**98 */
	6.33825300114114700748351602688E+29DL,	/* 2**99 */
	1.267650600228229401496703205376E+30DL,	/* 2**100 */
	2.535301200456458802993406410752E+30DL,	/* 2**101 */
	5.070602400912917605986812821504E+30DL,	/* 2**102 */
	1.0141204801825835211973625643008E+31DL,	/* 2**103 */
	2.0282409603651670423947251286016E+31DL,	/* 2**104 */
	4.0564819207303340847894502572032E+31DL,	/* 2**105 */
	8.1129638414606681695789005144064E+31DL,	/* 2**106 */
	1.62259276829213363391578010288128E+32DL,	/* 2**107 */
	3.24518553658426726783156020576256E+32DL,	/* 2**108 */
	6.49037107316853453566312041152512E+32DL,	/* 2**109 */
	1.298074214633706907132624082305024E+33DL,	/* 2**110 */
	2.596148429267413814265248164610048E+33DL,	/* 2**111 */
	5.192296858534827628530496329220096E+33DL,	/* 2**112 */
	1.038459371706965525706099265844019E+34DL,	/* 2**113 */
	2.076918743413931051412198531688038E+34DL,	/* 2**114 */
	4.153837486827862102824397063376077E+34DL,	/* 2**115 */
	8.307674973655724205648794126752154E+34DL,	/* 2**116 */
	1.661534994731144841129758825350431E+35DL,	/* 2**117 */
	3.323069989462289682259517650700861E+35DL,	/* 2**118 */
	6.646139978924579364519035301401723E+35DL,	/* 2**119 */
	1.329227995784915872903807060280345E+36DL,	/* 2**120 */
	2.658455991569831745807614120560689E+36DL,	/* 2**121 */
	5.316911983139663491615228241121378E+36DL,	/* 2**122 */
	1.063382396627932698323045648224276E+37DL,	/* 2**123 */
	2.126764793255865396646091296448551E+37DL,	/* 2**124 */
	4.253529586511730793292182592897103E+37DL,	/* 2**125 */
	8.507059173023461586584365185794205E+37DL,	/* 2**126 */
	1.701411834604692317316873037158841E+38DL,	/* 2**127 */
	3.402823669209384634633746074317682E+38DL,	/* 2**128 */
	6.805647338418769269267492148635364E+38DL,	/* 2**129 */
	1.361129467683753853853498429727073E+39DL,	/* 2**130 */
	2.722258935367507707706996859454146E+39DL,	/* 2**131 */
	5.444517870735015415413993718908291E+39DL,	/* 2**132 */
	1.088903574147003083082798743781658E+40DL,	/* 2**133 */
	2.177807148294006166165597487563317E+40DL,	/* 2**134 */
	4.355614296588012332331194975126633E+40DL,	/* 2**135 */
	8.711228593176024664662389950253266E+40DL,	/* 2**136 */
	1.742245718635204932932477990050653E+41DL,	/* 2**137 */
	3.484491437270409865864955980101306E+41DL,	/* 2**138 */
	6.968982874540819731729911960202613E+41DL,	/* 2**139 */
	1.393796574908163946345982392040523E+42DL,	/* 2**140 */
	2.787593149816327892691964784081045E+42DL,	/* 2**141 */
	5.575186299632655785383929568162090E+42DL,	/* 2**142 */
	1.115037259926531157076785913632418E+43DL,	/* 2**143 */
	2.230074519853062314153571827264836E+43DL,	/* 2**144 */
	4.460149039706124628307143654529672E+43DL,	/* 2**145 */
	8.920298079412249256614287309059345E+43DL,	/* 2**146 */
	1.784059615882449851322857461811869E+44DL,	/* 2**147 */
	3.568119231764899702645714923623738E+44DL,	/* 2**148 */
	7.136238463529799405291429847247476E+44DL,	/* 2**149 */
	1.427247692705959881058285969449495E+45DL,	/* 2**150 */
	2.854495385411919762116571938898990E+45DL,	/* 2**151 */
	5.708990770823839524233143877797981E+45DL,	/* 2**152 */
	1.141798154164767904846628775559596E+46DL,	/* 2**153 */
	2.283596308329535809693257551119192E+46DL,	/* 2**154 */
	4.567192616659071619386515102238384E+46DL,	/* 2**155 */
	9.134385233318143238773030204476769E+46DL,	/* 2**156 */
	1.826877046663628647754606040895354E+47DL,	/* 2**157 */
	3.653754093327257295509212081790708E+47DL,	/* 2**158 */
	7.307508186654514591018424163581415E+47DL,	/* 2**159 */
	1.461501637330902918203684832716283E+48DL,	/* 2**160 */
	2.923003274661805836407369665432566E+48DL,	/* 2**161 */
	5.846006549323611672814739330865132E+48DL,	/* 2**162 */
	1.169201309864722334562947866173026E+49DL,	/* 2**163 */
	2.338402619729444669125895732346053E+49DL,	/* 2**164 */
	4.676805239458889338251791464692106E+49DL,	/* 2**165 */
	9.353610478917778676503582929384211E+49DL,	/* 2**166 */
	1.870722095783555735300716585876842E+50DL,	/* 2**167 */
	3.741444191567111470601433171753685E+50DL,	/* 2**168 */
	7.482888383134222941202866343507369E+50DL,	/* 2**169 */
	1.496577676626844588240573268701474E+51DL,	/* 2**170 */
	2.993155353253689176481146537402948E+51DL,	/* 2**171 */
	5.986310706507378352962293074805895E+51DL,	/* 2**172 */
	1.197262141301475670592458614961179E+52DL,	/* 2**173 */
	2.394524282602951341184917229922358E+52DL,	/* 2**174 */
	4.789048565205902682369834459844716E+52DL,	/* 2**175 */
	9.578097130411805364739668919689432E+52DL,	/* 2**176 */
	1.915619426082361072947933783937886E+53DL,	/* 2**177 */
	3.831238852164722145895867567875773E+53DL,	/* 2**178 */
	7.662477704329444291791735135751546E+53DL,	/* 2**179 */
	1.532495540865888858358347027150309E+54DL,	/* 2**180 */
	3.064991081731777716716694054300618E+54DL,	/* 2**181 */
	6.129982163463555433433388108601237E+54DL,	/* 2**182 */
	1.225996432692711086686677621720247E+55DL,	/* 2**183 */
	2.451992865385422173373355243440495E+55DL,	/* 2**184 */
	4.903985730770844346746710486880989E+55DL,	/* 2**185 */
	9.807971461541688693493420973761979E+55DL,	/* 2**186 */
	1.961594292308337738698684194752396E+56DL,	/* 2**187 */
	3.923188584616675477397368389504792E+56DL,	/* 2**188 */
	7.846377169233350954794736779009583E+56DL,	/* 2**189 */
	1.569275433846670190958947355801917E+57DL,	/* 2**190 */
	3.138550867693340381917894711603833E+57DL,	/* 2**191 */
	6.277101735386680763835789423207666E+57DL,	/* 2**192 */
	1.255420347077336152767157884641533E+58DL,	/* 2**193 */
	2.510840694154672305534315769283067E+58DL,	/* 2**194 */
	5.021681388309344611068631538566133E+58DL,	/* 2**195 */
	1.004336277661868922213726307713227E+59DL,	/* 2**196 */
	2.008672555323737844427452615426453E+59DL,	/* 2**197 */
	4.017345110647475688854905230852907E+59DL,	/* 2**198 */
	8.034690221294951377709810461705813E+59DL,	/* 2**199 */
	1.606938044258990275541962092341163E+60DL,	/* 2**200 */
	3.213876088517980551083924184682325E+60DL,	/* 2**201 */
	6.427752177035961102167848369364650E+60DL,	/* 2**202 */
	1.285550435407192220433569673872930E+61DL,	/* 2**203 */
	2.571100870814384440867139347745860E+61DL,	/* 2**204 */
	5.142201741628768881734278695491720E+61DL,	/* 2**205 */
	1.028440348325753776346855739098344E+62DL,	/* 2**206 */
	2.056880696651507552693711478196688E+62DL,	/* 2**207 */
	4.113761393303015105387422956393376E+62DL,	/* 2**208 */
	8.227522786606030210774845912786753E+62DL,	/* 2**209 */
	1.645504557321206042154969182557351E+63DL,	/* 2**210 */
	3.291009114642412084309938365114701E+63DL,	/* 2**211 */
	6.582018229284824168619876730229402E+63DL,	/* 2**212 */
	1.316403645856964833723975346045880E+64DL,	/* 2**213 */
	2.632807291713929667447950692091761E+64DL,	/* 2**214 */
	5.265614583427859334895901384183522E+64DL,	/* 2**215 */
	1.053122916685571866979180276836704E+65DL,	/* 2**216 */
	2.106245833371143733958360553673409E+65DL,	/* 2**217 */
	4.212491666742287467916721107346817E+65DL,	/* 2**218 */
	8.424983333484574935833442214693635E+65DL,	/* 2**219 */
	1.684996666696914987166688442938727E+66DL,	/* 2**220 */
	3.369993333393829974333376885877454E+66DL,	/* 2**221 */
	6.739986666787659948666753771754908E+66DL,	/* 2**222 */
	1.347997333357531989733350754350982E+67DL,	/* 2**223 */
	2.695994666715063979466701508701963E+67DL,	/* 2**224 */
	5.391989333430127958933403017403926E+67DL,	/* 2**225 */
	1.078397866686025591786680603480785E+68DL,	/* 2**226 */
	2.156795733372051183573361206961570E+68DL,	/* 2**227 */
	4.313591466744102367146722413923141E+68DL,	/* 2**228 */
	8.627182933488204734293444827846282E+68DL,	/* 2**229 */
	1.725436586697640946858688965569256E+69DL,	/* 2**230 */
	3.450873173395281893717377931138513E+69DL,	/* 2**231 */
	6.901746346790563787434755862277025E+69DL,	/* 2**232 */
	1.380349269358112757486951172455405E+70DL,	/* 2**233 */
	2.760698538716225514973902344910810E+70DL,	/* 2**234 */
	5.521397077432451029947804689821620E+70DL,	/* 2**235 */
	1.104279415486490205989560937964324E+71DL,	/* 2**236 */
	2.208558830972980411979121875928648E+71DL,	/* 2**237 */
	4.417117661945960823958243751857296E+71DL,	/* 2**238 */
	8.834235323891921647916487503714593E+71DL,	/* 2**239 */
	1.766847064778384329583297500742919E+72DL,	/* 2**240 */
	3.533694129556768659166595001485837E+72DL,	/* 2**241 */
	7.067388259113537318333190002971674E+72DL,	/* 2**242 */
	1.413477651822707463666638000594335E+73DL,	/* 2**243 */
	2.826955303645414927333276001188670E+73DL,	/* 2**244 */
	5.653910607290829854666552002377339E+73DL,	/* 2**245 */
	1.130782121458165970933310400475468E+74DL,	/* 2**246 */
	2.261564242916331941866620800950936E+74DL,	/* 2**247 */
	4.523128485832663883733241601901871E+74DL,	/* 2**248 */
	9.046256971665327767466483203803743E+74DL,	/* 2**249 */
	1.809251394333065553493296640760749E+75DL,	/* 2**250 */
	3.618502788666131106986593281521497E+75DL,	/* 2**251 */
	7.237005577332262213973186563042994E+75DL,	/* 2**252 */
	1.447401115466452442794637312608599E+76DL,	/* 2**253 */
	2.894802230932904885589274625217198E+76DL,	/* 2**254 */
	5.789604461865809771178549250434395E+76DL,	/* 2**255 */
	1.157920892373161954235709850086879E+77DL,	/* 2**256 */
	2.315841784746323908471419700173758E+77DL,	/* 2**257 */
	4.631683569492647816942839400347516E+77DL,	/* 2**258 */
	9.263367138985295633885678800695033E+77DL,	/* 2**259 */
	1.852673427797059126777135760139007E+78DL,	/* 2**260 */
	3.705346855594118253554271520278013E+78DL,	/* 2**261 */
	7.410693711188236507108543040556026E+78DL,	/* 2**262 */
	1.482138742237647301421708608111205E+79DL,	/* 2**263 */
	2.964277484475294602843417216222410E+79DL,	/* 2**264 */
	5.928554968950589205686834432444821E+79DL,	/* 2**265 */
	1.185710993790117841137366886488964E+80DL,	/* 2**266 */
	2.371421987580235682274733772977928E+80DL,	/* 2**267 */
	4.742843975160471364549467545955857E+80DL,	/* 2**268 */
	9.485687950320942729098935091911713E+80DL,	/* 2**269 */
	1.897137590064188545819787018382343E+81DL,	/* 2**270 */
	3.794275180128377091639574036764685E+81DL,	/* 2**271 */
	7.588550360256754183279148073529371E+81DL,	/* 2**272 */
	1.517710072051350836655829614705874E+82DL,	/* 2**273 */
	3.035420144102701673311659229411748E+82DL,	/* 2**274 */
	6.070840288205403346623318458823497E+82DL,	/* 2**275 */
	1.214168057641080669324663691764699E+83DL,	/* 2**276 */
	2.428336115282161338649327383529399E+83DL,	/* 2**277 */
	4.856672230564322677298654767058797E+83DL,	/* 2**278 */
	9.713344461128645354597309534117595E+83DL,	/* 2**279 */
	1.942668892225729070919461906823519E+84DL,	/* 2**280 */
	3.885337784451458141838923813647038E+84DL,	/* 2**281 */
	7.770675568902916283677847627294076E+84DL,	/* 2**282 */
	1.554135113780583256735569525458815E+85DL,	/* 2**283 */
	3.108270227561166513471139050917630E+85DL,	/* 2**284 */
	6.216540455122333026942278101835261E+85DL,	/* 2**285 */
	1.243308091024466605388455620367052E+86DL,	/* 2**286 */
	2.486616182048933210776911240734104E+86DL,	/* 2**287 */
	4.973232364097866421553822481468208E+86DL,	/* 2**288 */
	9.946464728195732843107644962936417E+86DL,	/* 2**289 */
	1.989292945639146568621528992587283E+87DL,	/* 2**290 */
	3.978585891278293137243057985174567E+87DL,	/* 2**291 */
	7.957171782556586274486115970349133E+87DL,	/* 2**292 */
	1.591434356511317254897223194069827E+88DL,	/* 2**293 */
	3.182868713022634509794446388139653E+88DL,	/* 2**294 */
	6.365737426045269019588892776279307E+88DL,	/* 2**295 */
	1.273147485209053803917778555255861E+89DL,	/* 2**296 */
	2.546294970418107607835557110511723E+89DL,	/* 2**297 */
	5.092589940836215215671114221023445E+89DL,	/* 2**298 */
	1.018517988167243043134222844204689E+90DL,	/* 2**299 */
	2.037035976334486086268445688409378E+90DL,	/* 2**300 */
	4.074071952668972172536891376818756E+90DL,	/* 2**301 */
	8.148143905337944345073782753637513E+90DL,	/* 2**302 */
	1.629628781067588869014756550727503E+91DL,	/* 2**303 */
	3.259257562135177738029513101455005E+91DL,	/* 2**304 */
	6.518515124270355476059026202910010E+91DL,	/* 2**305 */
	1.303703024854071095211805240582002E+92DL,	/* 2**306 */
	2.607406049708142190423610481164004E+92DL,	/* 2**307 */
	5.214812099416284380847220962328008E+92DL,	/* 2**308 */
	1.042962419883256876169444192465602E+93DL,	/* 2**309 */
	2.085924839766513752338888384931203E+93DL,	/* 2**310 */
	4.171849679533027504677776769862406E+93DL,	/* 2**311 */
	8.343699359066055009355553539724813E+93DL,	/* 2**312 */
	1.668739871813211001871110707944963E+94DL,	/* 2**313 */
	3.337479743626422003742221415889925E+94DL,	/* 2**314 */
	6.674959487252844007484442831779850E+94DL,	/* 2**315 */
	1.334991897450568801496888566355970E+95DL,	/* 2**316 */
	2.669983794901137602993777132711940E+95DL,	/* 2**317 */
	5.339967589802275205987554265423880E+95DL,	/* 2**318 */
	1.067993517960455041197510853084776E+96DL,	/* 2**319 */
	2.135987035920910082395021706169552E+96DL,	/* 2**320 */
	4.271974071841820164790043412339104E+96DL,	/* 2**321 */
	8.543948143683640329580086824678208E+96DL,	/* 2**322 */
	1.708789628736728065916017364935642E+97DL,	/* 2**323 */
	3.417579257473456131832034729871283E+97DL,	/* 2**324 */
	6.835158514946912263664069459742567E+97DL,	/* 2**325 */
	1.367031702989382452732813891948513E+98DL,	/* 2**326 */
	2.734063405978764905465627783897027E+98DL,	/* 2**327 */
	5.468126811957529810931255567794053E+98DL,	/* 2**328 */
	1.093625362391505962186251113558811E+99DL,	/* 2**329 */
	2.187250724783011924372502227117621E+99DL,	/* 2**330 */
	4.374501449566023848745004454235243E+99DL,	/* 2**331 */
	8.749002899132047697490008908470485E+99DL,	/* 2**332 */
	1.749800579826409539498001781694097E+100DL,	/* 2**333 */
	3.499601159652819078996003563388194E+100DL,	/* 2**334 */
	6.999202319305638157992007126776388E+100DL,	/* 2**335 */
	1.399840463861127631598401425355278E+101DL,	/* 2**336 */
	2.799680927722255263196802850710555E+101DL,	/* 2**337 */
	5.599361855444510526393605701421111E+101DL,	/* 2**338 */
	1.119872371088902105278721140284222E+102DL,	/* 2**339 */
	2.239744742177804210557442280568444E+102DL,	/* 2**340 */
	4.479489484355608421114884561136889E+102DL,	/* 2**341 */
	8.958978968711216842229769122273777E+102DL,	/* 2**342 */
	1.791795793742243368445953824454755E+103DL,	/* 2**343 */
	3.583591587484486736891907648909511E+103DL,	/* 2**344 */
	7.167183174968973473783815297819022E+103DL,	/* 2**345 */
	1.433436634993794694756763059563804E+104DL,	/* 2**346 */
	2.866873269987589389513526119127609E+104DL,	/* 2**347 */
	5.733746539975178779027052238255217E+104DL,	/* 2**348 */
	1.146749307995035755805410447651043E+105DL,	/* 2**349 */
	2.293498615990071511610820895302087E+105DL,	/* 2**350 */
	4.586997231980143023221641790604174E+105DL,	/* 2**351 */
	9.173994463960286046443283581208348E+105DL,	/* 2**352 */
	1.834798892792057209288656716241670E+106DL,	/* 2**353 */
	3.669597785584114418577313432483339E+106DL,	/* 2**354 */
	7.339195571168228837154626864966678E+106DL,	/* 2**355 */
	1.467839114233645767430925372993336E+107DL,	/* 2**356 */
	2.935678228467291534861850745986671E+107DL,	/* 2**357 */
	5.871356456934583069723701491973343E+107DL,	/* 2**358 */
	1.174271291386916613944740298394669E+108DL,	/* 2**359 */
	2.348542582773833227889480596789337E+108DL,	/* 2**360 */
	4.697085165547666455778961193578674E+108DL,	/* 2**361 */
	9.394170331095332911557922387157348E+108DL,	/* 2**362 */
	1.878834066219066582311584477431470E+109DL,	/* 2**363 */
	3.757668132438133164623168954862939E+109DL,	/* 2**364 */
	7.515336264876266329246337909725878E+109DL,	/* 2**365 */
	1.503067252975253265849267581945176E+110DL,	/* 2**366 */
	3.006134505950506531698535163890351E+110DL,	/* 2**367 */
	6.012269011901013063397070327780703E+110DL,	/* 2**368 */
	1.202453802380202612679414065556141E+111DL,	/* 2**369 */
	2.404907604760405225358828131112281E+111DL,	/* 2**370 */
	4.809815209520810450717656262224562E+111DL,	/* 2**371 */
	9.619630419041620901435312524449124E+111DL,	/* 2**372 */
	1.923926083808324180287062504889825E+112DL,	/* 2**373 */
	3.847852167616648360574125009779650E+112DL,	/* 2**374 */
	7.695704335233296721148250019559300E+112DL,	/* 2**375 */
	1.539140867046659344229650003911860E+113DL,	/* 2**376 */
	3.078281734093318688459300007823720E+113DL,	/* 2**377 */
	6.156563468186637376918600015647440E+113DL,	/* 2**378 */
	1.231312693637327475383720003129488E+114DL,	/* 2**379 */
	2.462625387274654950767440006258976E+114DL,	/* 2**380 */
	4.925250774549309901534880012517952E+114DL,	/* 2**381 */
	9.850501549098619803069760025035903E+114DL,	/* 2**382 */
	1.970100309819723960613952005007181E+115DL,	/* 2**383 */
	3.940200619639447921227904010014361E+115DL,	/* 2**384 */
	7.880401239278895842455808020028723E+115DL,	/* 2**385 */
	1.576080247855779168491161604005745E+116DL,	/* 2**386 */
	3.152160495711558336982323208011489E+116DL,	/* 2**387 */
	6.304320991423116673964646416022978E+116DL,	/* 2**388 */
	1.260864198284623334792929283204596E+117DL,	/* 2**389 */
	2.521728396569246669585858566409191E+117DL,	/* 2**390 */
	5.043456793138493339171717132818383E+117DL,	/* 2**391 */
	1.008691358627698667834343426563677E+118DL,	/* 2**392 */
	2.017382717255397335668686853127353E+118DL,	/* 2**393 */
	4.034765434510794671337373706254706E+118DL,	/* 2**394 */
	8.069530869021589342674747412509412E+118DL,	/* 2**395 */
	1.613906173804317868534949482501882E+119DL,	/* 2**396 */
	3.227812347608635737069898965003765E+119DL,	/* 2**397 */
	6.455624695217271474139797930007530E+119DL,	/* 2**398 */
	1.291124939043454294827959586001506E+120DL,	/* 2**399 */
	2.582249878086908589655919172003012E+120DL,	/* 2**400 */
	5.164499756173817179311838344006024E+120DL,	/* 2**401 */
	1.032899951234763435862367668801205E+121DL,	/* 2**402 */
	2.065799902469526871724735337602409E+121DL,	/* 2**403 */
	4.131599804939053743449470675204819E+121DL,	/* 2**404 */
	8.263199609878107486898941350409638E+121DL,	/* 2**405 */
	1.652639921975621497379788270081928E+122DL,	/* 2**406 */
	3.305279843951242994759576540163855E+122DL,	/* 2**407 */
	6.610559687902485989519153080327710E+122DL,	/* 2**408 */
	1.322111937580497197903830616065542E+123DL,	/* 2**409 */
	2.644223875160994395807661232131084E+123DL,	/* 2**410 */
	5.288447750321988791615322464262168E+123DL,	/* 2**411 */
	1.057689550064397758323064492852434E+124DL,	/* 2**412 */
	2.115379100128795516646128985704867E+124DL,	/* 2**413 */
	4.230758200257591033292257971409735E+124DL,	/* 2**414 */
	8.461516400515182066584515942819469E+124DL,	/* 2**415 */
	1.692303280103036413316903188563894E+125DL,	/* 2**416 */
	3.384606560206072826633806377127788E+125DL,	/* 2**417 */
	6.769213120412145653267612754255575E+125DL,	/* 2**418 */
	1.353842624082429130653522550851115E+126DL,	/* 2**419 */
	2.707685248164858261307045101702230E+126DL,	/* 2**420 */
	5.415370496329716522614090203404460E+126DL,	/* 2**421 */
	1.083074099265943304522818040680892E+127DL,	/* 2**422 */
	2.166148198531886609045636081361784E+127DL,	/* 2**423 */
	4.332296397063773218091272162723568E+127DL,	/* 2**424 */
	8.664592794127546436182544325447137E+127DL,	/* 2**425 */
	1.732918558825509287236508865089427E+128DL,	/* 2**426 */
	3.465837117651018574473017730178855E+128DL,	/* 2**427 */
	6.931674235302037148946035460357709E+128DL,	/* 2**428 */
	1.386334847060407429789207092071542E+129DL,	/* 2**429 */
	2.772669694120814859578414184143084E+129DL,	/* 2**430 */
	5.545339388241629719156828368286167E+129DL,	/* 2**431 */
	1.109067877648325943831365673657233E+130DL,	/* 2**432 */
	2.218135755296651887662731347314467E+130DL,	/* 2**433 */
	4.436271510593303775325462694628934E+130DL,	/* 2**434 */
	8.872543021186607550650925389257868E+130DL,	/* 2**435 */
	1.774508604237321510130185077851574E+131DL,	/* 2**436 */
	3.549017208474643020260370155703147E+131DL,	/* 2**437 */
	7.098034416949286040520740311406294E+131DL,	/* 2**438 */
	1.419606883389857208104148062281259E+132DL,	/* 2**439 */
	2.839213766779714416208296124562518E+132DL,	/* 2**440 */
	5.678427533559428832416592249125035E+132DL,	/* 2**441 */
	1.135685506711885766483318449825007E+133DL,	/* 2**442 */
	2.271371013423771532966636899650014E+133DL,	/* 2**443 */
	4.542742026847543065933273799300028E+133DL,	/* 2**444 */
	9.085484053695086131866547598600057E+133DL,	/* 2**445 */
	1.817096810739017226373309519720011E+134DL,	/* 2**446 */
	3.634193621478034452746619039440023E+134DL,	/* 2**447 */
	7.268387242956068905493238078880045E+134DL,	/* 2**448 */
	1.453677448591213781098647615776009E+135DL,	/* 2**449 */
	2.907354897182427562197295231552018E+135DL,	/* 2**450 */
	5.814709794364855124394590463104036E+135DL,	/* 2**451 */
	1.162941958872971024878918092620807E+136DL,	/* 2**452 */
	2.325883917745942049757836185241615E+136DL,	/* 2**453 */
	4.651767835491884099515672370483229E+136DL,	/* 2**454 */
	9.303535670983768199031344740966458E+136DL,	/* 2**455 */
	1.860707134196753639806268948193292E+137DL,	/* 2**456 */
	3.721414268393507279612537896386583E+137DL,	/* 2**457 */
	7.442828536787014559225075792773166E+137DL,	/* 2**458 */
	1.488565707357402911845015158554633E+138DL,	/* 2**459 */
	2.977131414714805823690030317109267E+138DL,	/* 2**460 */
	5.954262829429611647380060634218533E+138DL,	/* 2**461 */
	1.190852565885922329476012126843707E+139DL,	/* 2**462 */
	2.381705131771844658952024253687413E+139DL,	/* 2**463 */
	4.763410263543689317904048507374827E+139DL,	/* 2**464 */
	9.526820527087378635808097014749653E+139DL,	/* 2**465 */
	1.905364105417475727161619402949931E+140DL,	/* 2**466 */
	3.810728210834951454323238805899861E+140DL,	/* 2**467 */
	7.621456421669902908646477611799722E+140DL,	/* 2**468 */
	1.524291284333980581729295522359944E+141DL,	/* 2**469 */
	3.048582568667961163458591044719889E+141DL,	/* 2**470 */
	6.097165137335922326917182089439778E+141DL,	/* 2**471 */
	1.219433027467184465383436417887956E+142DL,	/* 2**472 */
	2.438866054934368930766872835775911E+142DL,	/* 2**473 */
	4.877732109868737861533745671551822E+142DL,	/* 2**474 */
	9.755464219737475723067491343103645E+142DL,	/* 2**475 */
	1.951092843947495144613498268620729E+143DL,	/* 2**476 */
	3.902185687894990289226996537241458E+143DL,	/* 2**477 */
	7.804371375789980578453993074482916E+143DL,	/* 2**478 */
	1.560874275157996115690798614896583E+144DL,	/* 2**479 */
	3.121748550315992231381597229793166E+144DL,	/* 2**480 */
	6.243497100631984462763194459586333E+144DL,	/* 2**481 */
	1.248699420126396892552638891917267E+145DL,	/* 2**482 */
	2.497398840252793785105277783834533E+145DL,	/* 2**483 */
	4.994797680505587570210555567669066E+145DL,	/* 2**484 */
	9.989595361011175140421111135338132E+145DL,	/* 2**485 */
	1.997919072202235028084222227067626E+146DL,	/* 2**486 */
	3.995838144404470056168444454135253E+146DL,	/* 2**487 */
	7.991676288808940112336888908270506E+146DL,	/* 2**488 */
	1.598335257761788022467377781654101E+147DL,	/* 2**489 */
	3.196670515523576044934755563308202E+147DL,	/* 2**490 */
	6.393341031047152089869511126616405E+147DL,	/* 2**491 */
	1.278668206209430417973902225323281E+148DL,	/* 2**492 */
	2.557336412418860835947804450646562E+148DL,	/* 2**493 */
	5.114672824837721671895608901293124E+148DL,	/* 2**494 */
	1.022934564967544334379121780258625E+149DL,	/* 2**495 */
	2.045869129935088668758243560517249E+149DL,	/* 2**496 */
	4.091738259870177337516487121034499E+149DL,	/* 2**497 */
	8.183476519740354675032974242068998E+149DL,	/* 2**498 */
	1.636695303948070935006594848413800E+150DL,	/* 2**499 */
	3.273390607896141870013189696827599E+150DL,	/* 2**500 */
	6.546781215792283740026379393655198E+150DL,	/* 2**501 */
	1.309356243158456748005275878731040E+151DL,	/* 2**502 */
	2.618712486316913496010551757462079E+151DL,	/* 2**503 */
	5.237424972633826992021103514924159E+151DL,	/* 2**504 */
	1.047484994526765398404220702984832E+152DL,	/* 2**505 */
	2.094969989053530796808441405969663E+152DL,	/* 2**506 */
	4.189939978107061593616882811939327E+152DL,	/* 2**507 */
	8.379879956214123187233765623878654E+152DL,	/* 2**508 */
	1.675975991242824637446753124775731E+153DL,	/* 2**509 */
	3.351951982485649274893506249551462E+153DL,	/* 2**510 */
	6.703903964971298549787012499102923E+153DL,	/* 2**511 */
	1.340780792994259709957402499820585E+154DL,	/* 2**512 */
	2.681561585988519419914804999641169E+154DL,	/* 2**513 */
	5.363123171977038839829609999282338E+154DL,	/* 2**514 */
	1.072624634395407767965921999856468E+155DL,	/* 2**515 */
	2.145249268790815535931843999712935E+155DL,	/* 2**516 */
	4.290498537581631071863687999425871E+155DL,	/* 2**517 */
	8.580997075163262143727375998851742E+155DL,	/* 2**518 */
	1.716199415032652428745475199770348E+156DL,	/* 2**519 */
	3.432398830065304857490950399540697E+156DL,	/* 2**520 */
	6.864797660130609714981900799081393E+156DL,	/* 2**521 */
	1.372959532026121942996380159816279E+157DL,	/* 2**522 */
	2.745919064052243885992760319632557E+157DL,	/* 2**523 */
	5.491838128104487771985520639265115E+157DL,	/* 2**524 */
	1.098367625620897554397104127853023E+158DL,	/* 2**525 */
	2.196735251241795108794208255706046E+158DL,	/* 2**526 */
	4.393470502483590217588416511412092E+158DL,	/* 2**527 */
	8.786941004967180435176833022824183E+158DL,	/* 2**528 */
	1.757388200993436087035366604564837E+159DL,	/* 2**529 */
	3.514776401986872174070733209129673E+159DL,	/* 2**530 */
	7.029552803973744348141466418259347E+159DL,	/* 2**531 */
	1.405910560794748869628293283651869E+160DL,	/* 2**532 */
	2.811821121589497739256586567303739E+160DL,	/* 2**533 */
	5.623642243178995478513173134607477E+160DL,	/* 2**534 */
	1.124728448635799095702634626921495E+161DL,	/* 2**535 */
	2.249456897271598191405269253842991E+161DL,	/* 2**536 */
	4.498913794543196382810538507685982E+161DL,	/* 2**537 */
	8.997827589086392765621077015371964E+161DL,	/* 2**538 */
	1.799565517817278553124215403074393E+162DL,	/* 2**539 */
	3.599131035634557106248430806148785E+162DL,	/* 2**540 */
	7.198262071269114212496861612297571E+162DL,	/* 2**541 */
	1.439652414253822842499372322459514E+163DL,	/* 2**542 */
	2.879304828507645684998744644919028E+163DL,	/* 2**543 */
	5.758609657015291369997489289838057E+163DL,	/* 2**544 */
	1.151721931403058273999497857967611E+164DL,	/* 2**545 */
	2.303443862806116547998995715935223E+164DL,	/* 2**546 */
	4.606887725612233095997991431870445E+164DL,	/* 2**547 */
	9.213775451224466191995982863740891E+164DL,	/* 2**548 */
	1.842755090244893238399196572748178E+165DL,	/* 2**549 */
	3.685510180489786476798393145496356E+165DL,	/* 2**550 */
	7.371020360979572953596786290992713E+165DL,	/* 2**551 */
	1.474204072195914590719357258198543E+166DL,	/* 2**552 */
	2.948408144391829181438714516397085E+166DL,	/* 2**553 */
	5.896816288783658362877429032794170E+166DL,	/* 2**554 */
	1.179363257756731672575485806558834E+167DL,	/* 2**555 */
	2.358726515513463345150971613117668E+167DL,	/* 2**556 */
	4.717453031026926690301943226235336E+167DL,	/* 2**557 */
	9.434906062053853380603886452470672E+167DL,	/* 2**558 */
	1.886981212410770676120777290494134E+168DL,	/* 2**559 */
	3.773962424821541352241554580988269E+168DL,	/* 2**560 */
	7.547924849643082704483109161976538E+168DL,	/* 2**561 */
	1.509584969928616540896621832395308E+169DL,	/* 2**562 */
	3.019169939857233081793243664790615E+169DL,	/* 2**563 */
	6.038339879714466163586487329581230E+169DL,	/* 2**564 */
	1.207667975942893232717297465916246E+170DL,	/* 2**565 */
	2.415335951885786465434594931832492E+170DL,	/* 2**566 */
	4.830671903771572930869189863664984E+170DL,	/* 2**567 */
	9.661343807543145861738379727329968E+170DL,	/* 2**568 */
	1.932268761508629172347675945465994E+171DL,	/* 2**569 */
	3.864537523017258344695351890931987E+171DL,	/* 2**570 */
	7.729075046034516689390703781863975E+171DL,	/* 2**571 */
	1.545815009206903337878140756372795E+172DL,	/* 2**572 */
	3.091630018413806675756281512745590E+172DL,	/* 2**573 */
	6.183260036827613351512563025491180E+172DL,	/* 2**574 */
	1.236652007365522670302512605098236E+173DL,	/* 2**575 */
	2.473304014731045340605025210196472E+173DL,	/* 2**576 */
	4.946608029462090681210050420392944E+173DL,	/* 2**577 */
	9.893216058924181362420100840785888E+173DL,	/* 2**578 */
	1.978643211784836272484020168157178E+174DL,	/* 2**579 */
	3.957286423569672544968040336314355E+174DL,	/* 2**580 */
	7.914572847139345089936080672628710E+174DL,	/* 2**581 */
	1.582914569427869017987216134525742E+175DL,	/* 2**582 */
	3.165829138855738035974432269051484E+175DL,	/* 2**583 */
	6.331658277711476071948864538102968E+175DL,	/* 2**584 */
	1.266331655542295214389772907620594E+176DL,	/* 2**585 */
	2.532663311084590428779545815241187E+176DL,	/* 2**586 */
	5.065326622169180857559091630482374E+176DL,	/* 2**587 */
	1.013065324433836171511818326096475E+177DL,	/* 2**588 */
	2.026130648867672343023636652192950E+177DL,	/* 2**589 */
	4.052261297735344686047273304385900E+177DL,	/* 2**590 */
	8.104522595470689372094546608771799E+177DL,	/* 2**591 */
	1.620904519094137874418909321754360E+178DL,	/* 2**592 */
	3.241809038188275748837818643508720E+178DL,	/* 2**593 */
	6.483618076376551497675637287017439E+178DL,	/* 2**594 */
	1.296723615275310299535127457403488E+179DL,	/* 2**595 */
	2.593447230550620599070254914806976E+179DL,	/* 2**596 */
	5.186894461101241198140509829613951E+179DL,	/* 2**597 */
	1.037378892220248239628101965922790E+180DL,	/* 2**598 */
	2.074757784440496479256203931845581E+180DL,	/* 2**599 */
	4.149515568880992958512407863691161E+180DL,	/* 2**600 */
	8.299031137761985917024815727382322E+180DL,	/* 2**601 */
	1.659806227552397183404963145476464E+181DL,	/* 2**602 */
	3.319612455104794366809926290952929E+181DL,	/* 2**603 */
	6.639224910209588733619852581905858E+181DL,	/* 2**604 */
	1.327844982041917746723970516381172E+182DL,	/* 2**605 */
	2.655689964083835493447941032762343E+182DL,	/* 2**606 */
	5.311379928167670986895882065524686E+182DL,	/* 2**607 */
	1.062275985633534197379176413104937E+183DL,	/* 2**608 */
	2.124551971267068394758352826209875E+183DL,	/* 2**609 */
	4.249103942534136789516705652419749E+183DL,	/* 2**610 */
	8.498207885068273579033411304839498E+183DL,	/* 2**611 */
	1.699641577013654715806682260967900E+184DL,	/* 2**612 */
	3.399283154027309431613364521935799E+184DL,	/* 2**613 */
	6.798566308054618863226729043871598E+184DL,	/* 2**614 */
	1.359713261610923772645345808774320E+185DL,	/* 2**615 */
	2.719426523221847545290691617548639E+185DL,	/* 2**616 */
	5.438853046443695090581383235097279E+185DL,	/* 2**617 */
	1.087770609288739018116276647019456E+186DL,	/* 2**618 */
	2.175541218577478036232553294038911E+186DL,	/* 2**619 */
	4.351082437154956072465106588077823E+186DL,	/* 2**620 */
	8.702164874309912144930213176155646E+186DL,	/* 2**621 */
	1.740432974861982428986042635231129E+187DL,	/* 2**622 */
	3.480865949723964857972085270462258E+187DL,	/* 2**623 */
	6.961731899447929715944170540924517E+187DL,	/* 2**624 */
	1.392346379889585943188834108184903E+188DL,	/* 2**625 */
	2.784692759779171886377668216369807E+188DL,	/* 2**626 */
	5.569385519558343772755336432739613E+188DL,	/* 2**627 */
	1.113877103911668754551067286547923E+189DL,	/* 2**628 */
	2.227754207823337509102134573095845E+189DL,	/* 2**629 */
	4.455508415646675018204269146191691E+189DL,	/* 2**630 */
	8.911016831293350036408538292383381E+189DL,	/* 2**631 */
	1.782203366258670007281707658476676E+190DL,	/* 2**632 */
	3.564406732517340014563415316953353E+190DL,	/* 2**633 */
	7.128813465034680029126830633906705E+190DL,	/* 2**634 */
	1.425762693006936005825366126781341E+191DL,	/* 2**635 */
	2.851525386013872011650732253562682E+191DL,	/* 2**636 */
	5.703050772027744023301464507125364E+191DL,	/* 2**637 */
	1.140610154405548804660292901425073E+192DL,	/* 2**638 */
	2.281220308811097609320585802850146E+192DL,	/* 2**639 */
	4.562440617622195218641171605700291E+192DL,	/* 2**640 */
	9.124881235244390437282343211400583E+192DL,	/* 2**641 */
	1.824976247048878087456468642280117E+193DL,	/* 2**642 */
	3.649952494097756174912937284560233E+193DL,	/* 2**643 */
	7.299904988195512349825874569120466E+193DL,	/* 2**644 */
	1.459980997639102469965174913824093E+194DL,	/* 2**645 */
	2.919961995278204939930349827648186E+194DL,	/* 2**646 */
	5.839923990556409879860699655296373E+194DL,	/* 2**647 */
	1.167984798111281975972139931059275E+195DL,	/* 2**648 */
	2.335969596222563951944279862118549E+195DL,	/* 2**649 */
	4.671939192445127903888559724237098E+195DL,	/* 2**650 */
	9.343878384890255807777119448474197E+195DL,	/* 2**651 */
	1.868775676978051161555423889694839E+196DL,	/* 2**652 */
	3.737551353956102323110847779389679E+196DL,	/* 2**653 */
	7.475102707912204646221695558779357E+196DL,	/* 2**654 */
	1.495020541582440929244339111755871E+197DL,	/* 2**655 */
	2.990041083164881858488678223511743E+197DL,	/* 2**656 */
	5.980082166329763716977356447023486E+197DL,	/* 2**657 */
	1.196016433265952743395471289404697E+198DL,	/* 2**658 */
	2.392032866531905486790942578809394E+198DL,	/* 2**659 */
	4.784065733063810973581885157618789E+198DL,	/* 2**660 */
	9.568131466127621947163770315237577E+198DL,	/* 2**661 */
	1.913626293225524389432754063047515E+199DL,	/* 2**662 */
	3.827252586451048778865508126095031E+199DL,	/* 2**663 */
	7.654505172902097557731016252190062E+199DL,	/* 2**664 */
	1.530901034580419511546203250438012E+200DL,	/* 2**665 */
	3.061802069160839023092406500876025E+200DL,	/* 2**666 */
	6.123604138321678046184813001752050E+200DL,	/* 2**667 */
	1.224720827664335609236962600350410E+201DL,	/* 2**668 */
	2.449441655328671218473925200700820E+201DL,	/* 2**669 */
	4.898883310657342436947850401401640E+201DL,	/* 2**670 */
	9.797766621314684873895700802803279E+201DL,	/* 2**671 */
	1.959553324262936974779140160560656E+202DL,	/* 2**672 */
	3.919106648525873949558280321121312E+202DL,	/* 2**673 */
	7.838213297051747899116560642242623E+202DL,	/* 2**674 */
	1.567642659410349579823312128448525E+203DL,	/* 2**675 */
	3.135285318820699159646624256897049E+203DL,	/* 2**676 */
	6.270570637641398319293248513794099E+203DL,	/* 2**677 */
	1.254114127528279663858649702758820E+204DL,	/* 2**678 */
	2.508228255056559327717299405517639E+204DL,	/* 2**679 */
	5.016456510113118655434598811035279E+204DL,	/* 2**680 */
	1.003291302022623731086919762207056E+205DL,	/* 2**681 */
	2.006582604045247462173839524414112E+205DL,	/* 2**682 */
	4.013165208090494924347679048828223E+205DL,	/* 2**683 */
	8.026330416180989848695358097656446E+205DL,	/* 2**684 */
	1.605266083236197969739071619531289E+206DL,	/* 2**685 */
	3.210532166472395939478143239062579E+206DL,	/* 2**686 */
	6.421064332944791878956286478125157E+206DL,	/* 2**687 */
	1.284212866588958375791257295625031E+207DL,	/* 2**688 */
	2.568425733177916751582514591250063E+207DL,	/* 2**689 */
	5.136851466355833503165029182500126E+207DL,	/* 2**690 */
	1.027370293271166700633005836500025E+208DL,	/* 2**691 */
	2.054740586542333401266011673000050E+208DL,	/* 2**692 */
	4.109481173084666802532023346000101E+208DL,	/* 2**693 */
	8.218962346169333605064046692000201E+208DL,	/* 2**694 */
	1.643792469233866721012809338400040E+209DL,	/* 2**695 */
	3.287584938467733442025618676800080E+209DL,	/* 2**696 */
	6.575169876935466884051237353600161E+209DL,	/* 2**697 */
	1.315033975387093376810247470720032E+210DL,	/* 2**698 */
	2.630067950774186753620494941440064E+210DL,	/* 2**699 */
	5.260135901548373507240989882880129E+210DL,	/* 2**700 */
	1.052027180309674701448197976576026E+211DL,	/* 2**701 */
	2.104054360619349402896395953152051E+211DL,	/* 2**702 */
	4.208108721238698805792791906304103E+211DL,	/* 2**703 */
	8.416217442477397611585583812608206E+211DL,	/* 2**704 */
	1.683243488495479522317116762521641E+212DL,	/* 2**705 */
	3.366486976990959044634233525043282E+212DL,	/* 2**706 */
	6.732973953981918089268467050086565E+212DL,	/* 2**707 */
	1.346594790796383617853693410017313E+213DL,	/* 2**708 */
	2.693189581592767235707386820034626E+213DL,	/* 2**709 */
	5.386379163185534471414773640069252E+213DL,	/* 2**710 */
	1.077275832637106894282954728013850E+214DL,	/* 2**711 */
	2.154551665274213788565909456027701E+214DL,	/* 2**712 */
	4.309103330548427577131818912055401E+214DL,	/* 2**713 */
	8.618206661096855154263637824110803E+214DL,	/* 2**714 */
	1.723641332219371030852727564822161E+215DL,	/* 2**715 */
	3.447282664438742061705455129644321E+215DL,	/* 2**716 */
	6.894565328877484123410910259288642E+215DL,	/* 2**717 */
	1.378913065775496824682182051857728E+216DL,	/* 2**718 */
	2.757826131550993649364364103715457E+216DL,	/* 2**719 */
	5.515652263101987298728728207430914E+216DL,	/* 2**720 */
	1.103130452620397459745745641486183E+217DL,	/* 2**721 */
	2.206260905240794919491491282972366E+217DL,	/* 2**722 */
	4.412521810481589838982982565944731E+217DL,	/* 2**723 */
	8.825043620963179677965965131889462E+217DL,	/* 2**724 */
	1.765008724192635935593193026377892E+218DL,	/* 2**725 */
	3.530017448385271871186386052755785E+218DL,	/* 2**726 */
	7.060034896770543742372772105511570E+218DL,	/* 2**727 */
	1.412006979354108748474554421102314E+219DL,	/* 2**728 */
	2.824013958708217496949108842204628E+219DL,	/* 2**729 */
	5.648027917416434993898217684409256E+219DL,	/* 2**730 */
	1.129605583483286998779643536881851E+220DL,	/* 2**731 */
	2.259211166966573997559287073763702E+220DL,	/* 2**732 */
	4.518422333933147995118574147527405E+220DL,	/* 2**733 */
	9.036844667866295990237148295054809E+220DL,	/* 2**734 */
	1.807368933573259198047429659010962E+221DL,	/* 2**735 */
	3.614737867146518396094859318021924E+221DL,	/* 2**736 */
	7.229475734293036792189718636043847E+221DL,	/* 2**737 */
	1.445895146858607358437943727208769E+222DL,	/* 2**738 */
	2.891790293717214716875887454417539E+222DL,	/* 2**739 */
	5.783580587434429433751774908835078E+222DL,	/* 2**740 */
	1.156716117486885886750354981767016E+223DL,	/* 2**741 */
	2.313432234973771773500709963534031E+223DL,	/* 2**742 */
	4.626864469947543547001419927068062E+223DL,	/* 2**743 */
	9.253728939895087094002839854136125E+223DL,	/* 2**744 */
	1.850745787979017418800567970827225E+224DL,	/* 2**745 */
	3.701491575958034837601135941654450E+224DL,	/* 2**746 */
	7.402983151916069675202271883308900E+224DL,	/* 2**747 */
	1.480596630383213935040454376661780E+225DL,	/* 2**748 */
	2.961193260766427870080908753323560E+225DL,	/* 2**749 */
	5.922386521532855740161817506647120E+225DL,	/* 2**750 */
	1.184477304306571148032363501329424E+226DL,	/* 2**751 */
	2.368954608613142296064727002658848E+226DL,	/* 2**752 */
	4.737909217226284592129454005317696E+226DL,	/* 2**753 */
	9.475818434452569184258908010635392E+226DL,	/* 2**754 */
	1.895163686890513836851781602127078E+227DL,	/* 2**755 */
	3.790327373781027673703563204254157E+227DL,	/* 2**756 */
	7.580654747562055347407126408508313E+227DL,	/* 2**757 */
	1.516130949512411069481425281701663E+228DL,	/* 2**758 */
	3.032261899024822138962850563403325E+228DL,	/* 2**759 */
	6.064523798049644277925701126806651E+228DL,	/* 2**760 */
	1.212904759609928855585140225361330E+229DL,	/* 2**761 */
	2.425809519219857711170280450722660E+229DL,	/* 2**762 */
	4.851619038439715422340560901445320E+229DL,	/* 2**763 */
	9.703238076879430844681121802890641E+229DL,	/* 2**764 */
	1.940647615375886168936224360578128E+230DL,	/* 2**765 */
	3.881295230751772337872448721156256E+230DL,	/* 2**766 */
	7.762590461503544675744897442312513E+230DL,	/* 2**767 */
	1.552518092300708935148979488462503E+231DL,	/* 2**768 */
	3.105036184601417870297958976925005E+231DL,	/* 2**769 */
	6.210072369202835740595917953850010E+231DL,	/* 2**770 */
	1.242014473840567148119183590770002E+232DL,	/* 2**771 */
	2.484028947681134296238367181540004E+232DL,	/* 2**772 */
	4.968057895362268592476734363080008E+232DL,	/* 2**773 */
	9.936115790724537184953468726160016E+232DL,	/* 2**774 */
	1.987223158144907436990693745232003E+233DL,	/* 2**775 */
	3.974446316289814873981387490464007E+233DL,	/* 2**776 */
	7.948892632579629747962774980928013E+233DL,	/* 2**777 */
	1.589778526515925949592554996185603E+234DL,	/* 2**778 */
	3.179557053031851899185109992371205E+234DL,	/* 2**779 */
	6.359114106063703798370219984742410E+234DL,	/* 2**780 */
	1.271822821212740759674043996948482E+235DL,	/* 2**781 */
	2.543645642425481519348087993896964E+235DL,	/* 2**782 */
	5.087291284850963038696175987793928E+235DL,	/* 2**783 */
	1.017458256970192607739235197558786E+236DL,	/* 2**784 */
	2.034916513940385215478470395117571E+236DL,	/* 2**785 */
	4.069833027880770430956940790235143E+236DL,	/* 2**786 */
	8.139666055761540861913881580470285E+236DL,	/* 2**787 */
	1.627933211152308172382776316094057E+237DL,	/* 2**788 */
	3.255866422304616344765552632188114E+237DL,	/* 2**789 */
	6.511732844609232689531105264376228E+237DL,	/* 2**790 */
	1.302346568921846537906221052875246E+238DL,	/* 2**791 */
	2.604693137843693075812442105750491E+238DL,	/* 2**792 */
	5.209386275687386151624884211500983E+238DL,	/* 2**793 */
	1.041877255137477230324976842300197E+239DL,	/* 2**794 */
	2.083754510274954460649953684600393E+239DL,	/* 2**795 */
	4.167509020549908921299907369200786E+239DL,	/* 2**796 */
	8.335018041099817842599814738401572E+239DL,	/* 2**797 */
	1.667003608219963568519962947680314E+240DL,	/* 2**798 */
	3.334007216439927137039925895360629E+240DL,	/* 2**799 */
	6.668014432879854274079851790721258E+240DL,	/* 2**800 */
	1.333602886575970854815970358144252E+241DL,	/* 2**801 */
	2.667205773151941709631940716288503E+241DL,	/* 2**802 */
	5.334411546303883419263881432577006E+241DL,	/* 2**803 */
	1.066882309260776683852776286515401E+242DL,	/* 2**804 */
	2.133764618521553367705552573030802E+242DL,	/* 2**805 */
	4.267529237043106735411105146061605E+242DL,	/* 2**806 */
	8.535058474086213470822210292123210E+242DL,	/* 2**807 */
	1.707011694817242694164442058424642E+243DL,	/* 2**808 */
	3.414023389634485388328884116849284E+243DL,	/* 2**809 */
	6.828046779268970776657768233698568E+243DL,	/* 2**810 */
	1.365609355853794155331553646739714E+244DL,	/* 2**811 */
	2.731218711707588310663107293479427E+244DL,	/* 2**812 */
	5.462437423415176621326214586958854E+244DL,	/* 2**813 */
	1.092487484683035324265242917391771E+245DL,	/* 2**814 */
	2.184974969366070648530485834783542E+245DL,	/* 2**815 */
	4.369949938732141297060971669567084E+245DL,	/* 2**816 */
	8.739899877464282594121943339134167E+245DL,	/* 2**817 */
	1.747979975492856518824388667826833E+246DL,	/* 2**818 */
	3.495959950985713037648777335653667E+246DL,	/* 2**819 */
	6.991919901971426075297554671307334E+246DL,	/* 2**820 */
	1.398383980394285215059510934261467E+247DL,	/* 2**821 */
	2.796767960788570430119021868522933E+247DL,	/* 2**822 */
	5.593535921577140860238043737045867E+247DL,	/* 2**823 */
	1.118707184315428172047608747409173E+248DL,	/* 2**824 */
	2.237414368630856344095217494818347E+248DL,	/* 2**825 */
	4.474828737261712688190434989636694E+248DL,	/* 2**826 */
	8.949657474523425376380869979273387E+248DL,	/* 2**827 */
	1.789931494904685075276173995854677E+249DL,	/* 2**828 */
	3.579862989809370150552347991709355E+249DL,	/* 2**829 */
	7.159725979618740301104695983418710E+249DL,	/* 2**830 */
	1.431945195923748060220939196683742E+250DL,	/* 2**831 */
	2.863890391847496120441878393367484E+250DL,	/* 2**832 */
	5.727780783694992240883756786734968E+250DL,	/* 2**833 */
	1.145556156738998448176751357346994E+251DL,	/* 2**834 */
	2.291112313477996896353502714693987E+251DL,	/* 2**835 */
	4.582224626955993792707005429387974E+251DL,	/* 2**836 */
	9.164449253911987585414010858775948E+251DL,	/* 2**837 */
	1.832889850782397517082802171755190E+252DL,	/* 2**838 */
	3.665779701564795034165604343510379E+252DL,	/* 2**839 */
	7.331559403129590068331208687020759E+252DL,	/* 2**840 */
	1.466311880625918013666241737404152E+253DL,	/* 2**841 */
	2.932623761251836027332483474808303E+253DL,	/* 2**842 */
	5.865247522503672054664966949616607E+253DL,	/* 2**843 */
	1.173049504500734410932993389923321E+254DL,	/* 2**844 */
	2.346099009001468821865986779846643E+254DL,	/* 2**845 */
	4.692198018002937643731973559693286E+254DL,	/* 2**846 */
	9.384396036005875287463947119386571E+254DL,	/* 2**847 */
	1.876879207201175057492789423877314E+255DL,	/* 2**848 */
	3.753758414402350114985578847754628E+255DL,	/* 2**849 */
	7.507516828804700229971157695509257E+255DL,	/* 2**850 */
	1.501503365760940045994231539101851E+256DL,	/* 2**851 */
	3.003006731521880091988463078203703E+256DL,	/* 2**852 */
	6.006013463043760183976926156407405E+256DL,	/* 2**853 */
	1.201202692608752036795385231281481E+257DL,	/* 2**854 */
	2.402405385217504073590770462562962E+257DL,	/* 2**855 */
	4.804810770435008147181540925125924E+257DL,	/* 2**856 */
	9.609621540870016294363081850251849E+257DL,	/* 2**857 */
	1.921924308174003258872616370050370E+258DL,	/* 2**858 */
	3.843848616348006517745232740100740E+258DL,	/* 2**859 */
	7.687697232696013035490465480201479E+258DL,	/* 2**860 */
	1.537539446539202607098093096040296E+259DL,	/* 2**861 */
	3.075078893078405214196186192080592E+259DL,	/* 2**862 */
	6.150157786156810428392372384161183E+259DL,	/* 2**863 */
	1.230031557231362085678474476832237E+260DL,	/* 2**864 */
	2.460063114462724171356948953664473E+260DL,	/* 2**865 */
	4.920126228925448342713897907328947E+260DL,	/* 2**866 */
	9.840252457850896685427795814657893E+260DL,	/* 2**867 */
	1.968050491570179337085559162931579E+261DL,	/* 2**868 */
	3.936100983140358674171118325863157E+261DL,	/* 2**869 */
	7.872201966280717348342236651726315E+261DL,	/* 2**870 */
	1.574440393256143469668447330345263E+262DL,	/* 2**871 */
	3.148880786512286939336894660690526E+262DL,	/* 2**872 */
	6.297761573024573878673789321381052E+262DL,	/* 2**873 */
	1.259552314604914775734757864276210E+263DL,	/* 2**874 */
	2.519104629209829551469515728552421E+263DL,	/* 2**875 */
	5.038209258419659102939031457104841E+263DL,	/* 2**876 */
	1.007641851683931820587806291420968E+264DL,	/* 2**877 */
	2.015283703367863641175612582841937E+264DL,	/* 2**878 */
	4.030567406735727282351225165683873E+264DL,	/* 2**879 */
	8.061134813471454564702450331367746E+264DL,	/* 2**880 */
	1.612226962694290912940490066273549E+265DL,	/* 2**881 */
	3.224453925388581825880980132547098E+265DL,	/* 2**882 */
	6.448907850777163651761960265094197E+265DL,	/* 2**883 */
	1.289781570155432730352392053018839E+266DL,	/* 2**884 */
	2.579563140310865460704784106037679E+266DL,	/* 2**885 */
	5.159126280621730921409568212075357E+266DL,	/* 2**886 */
	1.031825256124346184281913642415071E+267DL,	/* 2**887 */
	2.063650512248692368563827284830143E+267DL,	/* 2**888 */
	4.127301024497384737127654569660286E+267DL,	/* 2**889 */
	8.254602048994769474255309139320572E+267DL,	/* 2**890 */
	1.650920409798953894851061827864114E+268DL,	/* 2**891 */
	3.301840819597907789702123655728229E+268DL,	/* 2**892 */
	6.603681639195815579404247311456458E+268DL,	/* 2**893 */
	1.320736327839163115880849462291292E+269DL,	/* 2**894 */
	2.641472655678326231761698924582583E+269DL,	/* 2**895 */
	5.282945311356652463523397849165166E+269DL,	/* 2**896 */
	1.056589062271330492704679569833033E+270DL,	/* 2**897 */
	2.113178124542660985409359139666066E+270DL,	/* 2**898 */
	4.226356249085321970818718279332133E+270DL,	/* 2**899 */
	8.452712498170643941637436558664266E+270DL,	/* 2**900 */
	1.690542499634128788327487311732853E+271DL,	/* 2**901 */
	3.381084999268257576654974623465706E+271DL,	/* 2**902 */
	6.762169998536515153309949246931413E+271DL,	/* 2**903 */
	1.352433999707303030661989849386283E+272DL,	/* 2**904 */
	2.704867999414606061323979698772565E+272DL,	/* 2**905 */
	5.409735998829212122647959397545130E+272DL,	/* 2**906 */
	1.081947199765842424529591879509026E+273DL,	/* 2**907 */
	2.163894399531684849059183759018052E+273DL,	/* 2**908 */
	4.327788799063369698118367518036104E+273DL,	/* 2**909 */
	8.655577598126739396236735036072208E+273DL,	/* 2**910 */
	1.731115519625347879247347007214442E+274DL,	/* 2**911 */
	3.462231039250695758494694014428883E+274DL,	/* 2**912 */
	6.924462078501391516989388028857766E+274DL,	/* 2**913 */
	1.384892415700278303397877605771553E+275DL,	/* 2**914 */
	2.769784831400556606795755211543107E+275DL,	/* 2**915 */
	5.539569662801113213591510423086213E+275DL,	/* 2**916 */
	1.107913932560222642718302084617243E+276DL,	/* 2**917 */
	2.215827865120445285436604169234485E+276DL,	/* 2**918 */
	4.431655730240890570873208338468971E+276DL,	/* 2**919 */
	8.863311460481781141746416676937941E+276DL,	/* 2**920 */
	1.772662292096356228349283335387588E+277DL,	/* 2**921 */
	3.545324584192712456698566670775176E+277DL,	/* 2**922 */
	7.090649168385424913397133341550353E+277DL,	/* 2**923 */
	1.418129833677084982679426668310071E+278DL,	/* 2**924 */
	2.836259667354169965358853336620141E+278DL,	/* 2**925 */
	5.672519334708339930717706673240282E+278DL,	/* 2**926 */
	1.134503866941667986143541334648056E+279DL,	/* 2**927 */
	2.269007733883335972287082669296113E+279DL,	/* 2**928 */
	4.538015467766671944574165338592226E+279DL,	/* 2**929 */
	9.076030935533343889148330677184452E+279DL,	/* 2**930 */
	1.815206187106668777829666135436890E+280DL,	/* 2**931 */
	3.630412374213337555659332270873781E+280DL,	/* 2**932 */
	7.260824748426675111318664541747561E+280DL,	/* 2**933 */
	1.452164949685335022263732908349512E+281DL,	/* 2**934 */
	2.904329899370670044527465816699025E+281DL,	/* 2**935 */
	5.808659798741340089054931633398049E+281DL,	/* 2**936 */
	1.161731959748268017810986326679610E+282DL,	/* 2**937 */
	2.323463919496536035621972653359220E+282DL,	/* 2**938 */
	4.646927838993072071243945306718439E+282DL,	/* 2**939 */
	9.293855677986144142487890613436879E+282DL,	/* 2**940 */
	1.858771135597228828497578122687376E+283DL,	/* 2**941 */
	3.717542271194457656995156245374751E+283DL,	/* 2**942 */
	7.435084542388915313990312490749503E+283DL,	/* 2**943 */
	1.487016908477783062798062498149901E+284DL,	/* 2**944 */
	2.974033816955566125596124996299801E+284DL,	/* 2**945 */
	5.948067633911132251192249992599602E+284DL,	/* 2**946 */
	1.189613526782226450238449998519920E+285DL,	/* 2**947 */
	2.379227053564452900476899997039841E+285DL,	/* 2**948 */
	4.758454107128905800953799994079682E+285DL,	/* 2**949 */
	9.516908214257811601907599988159364E+285DL,	/* 2**950 */
	1.903381642851562320381519997631873E+286DL,	/* 2**951 */
	3.806763285703124640763039995263745E+286DL,	/* 2**952 */
	7.613526571406249281526079990527491E+286DL,	/* 2**953 */
	1.522705314281249856305215998105498E+287DL,	/* 2**954 */
	3.045410628562499712610431996210996E+287DL,	/* 2**955 */
	6.090821257124999425220863992421993E+287DL,	/* 2**956 */
	1.218164251424999885044172798484399E+288DL,	/* 2**957 */
	2.436328502849999770088345596968797E+288DL,	/* 2**958 */
	4.872657005699999540176691193937594E+288DL,	/* 2**959 */
	9.745314011399999080353382387875188E+288DL,	/* 2**960 */
	1.949062802279999816070676477575038E+289DL,	/* 2**961 */
	3.898125604559999632141352955150075E+289DL,	/* 2**962 */
	7.796251209119999264282705910300151E+289DL,	/* 2**963 */
	1.559250241823999852856541182060030E+290DL,	/* 2**964 */
	3.118500483647999705713082364120060E+290DL,	/* 2**965 */
	6.237000967295999411426164728240121E+290DL,	/* 2**966 */
	1.247400193459199882285232945648024E+291DL,	/* 2**967 */
	2.494800386918399764570465891296048E+291DL,	/* 2**968 */
	4.989600773836799529140931782592096E+291DL,	/* 2**969 */
	9.979201547673599058281863565184193E+291DL,	/* 2**970 */
	1.995840309534719811656372713036839E+292DL,	/* 2**971 */
	3.991680619069439623312745426073677E+292DL,	/* 2**972 */
	7.983361238138879246625490852147354E+292DL,	/* 2**973 */
	1.596672247627775849325098170429471E+293DL,	/* 2**974 */
	3.193344495255551698650196340858942E+293DL,	/* 2**975 */
	6.386688990511103397300392681717883E+293DL,	/* 2**976 */
	1.277337798102220679460078536343577E+294DL,	/* 2**977 */
	2.554675596204441358920157072687153E+294DL,	/* 2**978 */
	5.109351192408882717840314145374307E+294DL,	/* 2**979 */
	1.021870238481776543568062829074861E+295DL,	/* 2**980 */
	2.043740476963553087136125658149723E+295DL,	/* 2**981 */
	4.087480953927106174272251316299445E+295DL,	/* 2**982 */
	8.174961907854212348544502632598891E+295DL,	/* 2**983 */
	1.634992381570842469708900526519778E+296DL,	/* 2**984 */
	3.269984763141684939417801053039556E+296DL,	/* 2**985 */
	6.539969526283369878835602106079113E+296DL,	/* 2**986 */
	1.307993905256673975767120421215823E+297DL,	/* 2**987 */
	2.615987810513347951534240842431645E+297DL,	/* 2**988 */
	5.231975621026695903068481684863290E+297DL,	/* 2**989 */
	1.046395124205339180613696336972658E+298DL,	/* 2**990 */
	2.092790248410678361227392673945316E+298DL,	/* 2**991 */
	4.185580496821356722454785347890632E+298DL,	/* 2**992 */
	8.371160993642713444909570695781264E+298DL,	/* 2**993 */
	1.674232198728542688981914139156253E+299DL,	/* 2**994 */
	3.348464397457085377963828278312506E+299DL,	/* 2**995 */
	6.696928794914170755927656556625011E+299DL,	/* 2**996 */
	1.339385758982834151185531311325002E+300DL,	/* 2**997 */
	2.678771517965668302371062622650005E+300DL,	/* 2**998 */
	5.357543035931336604742125245300009E+300DL,	/* 2**999 */
	1.071508607186267320948425049060002E+301DL,	/* 2**1000 */
	2.143017214372534641896850098120004E+301DL,	/* 2**1001 */
	4.286034428745069283793700196240007E+301DL,	/* 2**1002 */
	8.572068857490138567587400392480014E+301DL,	/* 2**1003 */
	1.714413771498027713517480078496003E+302DL,	/* 2**1004 */
	3.428827542996055427034960156992006E+302DL,	/* 2**1005 */
	6.857655085992110854069920313984012E+302DL,	/* 2**1006 */
	1.371531017198422170813984062796802E+303DL,	/* 2**1007 */
	2.743062034396844341627968125593605E+303DL,	/* 2**1008 */
	5.486124068793688683255936251187209E+303DL,	/* 2**1009 */
	1.097224813758737736651187250237442E+304DL,	/* 2**1010 */
	2.194449627517475473302374500474884E+304DL,	/* 2**1011 */
	4.388899255034950946604749000949767E+304DL,	/* 2**1012 */
	8.777798510069901893209498001899535E+304DL,	/* 2**1013 */
	1.755559702013980378641899600379907E+305DL,	/* 2**1014 */
	3.511119404027960757283799200759814E+305DL,	/* 2**1015 */
	7.022238808055921514567598401519628E+305DL,	/* 2**1016 */
	1.404447761611184302913519680303926E+306DL,	/* 2**1017 */
	2.808895523222368605827039360607851E+306DL,	/* 2**1018 */
	5.617791046444737211654078721215702E+306DL,	/* 2**1019 */
	1.123558209288947442330815744243140E+307DL,	/* 2**1020 */
	2.247116418577894884661631488486281E+307DL,	/* 2**1021 */
	4.494232837155789769323262976972562E+307DL,	/* 2**1022 */
	8.988465674311579538646525953945124E+307DL,	/* 2**1023 */
	1.797693134862315907729305190789025E+308DL,	/* 2**1024 */
	3.595386269724631815458610381578049E+308DL,	/* 2**1025 */
	7.190772539449263630917220763156099E+308DL,	/* 2**1026 */
	1.438154507889852726183444152631220E+309DL,	/* 2**1027 */
	2.876309015779705452366888305262440E+309DL,	/* 2**1028 */
	5.752618031559410904733776610524879E+309DL,	/* 2**1029 */
	1.150523606311882180946755322104976E+310DL,	/* 2**1030 */
	2.301047212623764361893510644209952E+310DL,	/* 2**1031 */
	4.602094425247528723787021288419903E+310DL,	/* 2**1032 */
	9.204188850495057447574042576839807E+310DL,	/* 2**1033 */
	1.840837770099011489514808515367961E+311DL,	/* 2**1034 */
	3.681675540198022979029617030735923E+311DL,	/* 2**1035 */
	7.363351080396045958059234061471845E+311DL,	/* 2**1036 */
	1.472670216079209191611846812294369E+312DL,	/* 2**1037 */
	2.945340432158418383223693624588738E+312DL,	/* 2**1038 */
	5.890680864316836766447387249177476E+312DL,	/* 2**1039 */
	1.178136172863367353289477449835495E+313DL,	/* 2**1040 */
	2.356272345726734706578954899670990E+313DL,	/* 2**1041 */
	4.712544691453469413157909799341981E+313DL,	/* 2**1042 */
	9.425089382906938826315819598683962E+313DL,	/* 2**1043 */
	1.885017876581387765263163919736792E+314DL,	/* 2**1044 */
	3.770035753162775530526327839473585E+314DL,	/* 2**1045 */
	7.540071506325551061052655678947170E+314DL,	/* 2**1046 */
	1.508014301265110212210531135789434E+315DL,	/* 2**1047 */
	3.016028602530220424421062271578868E+315DL,	/* 2**1048 */
	6.032057205060440848842124543157736E+315DL,	/* 2**1049 */
	1.206411441012088169768424908631547E+316DL,	/* 2**1050 */
	2.412822882024176339536849817263094E+316DL,	/* 2**1051 */
	4.825645764048352679073699634526189E+316DL,	/* 2**1052 */
	9.651291528096705358147399269052377E+316DL,	/* 2**1053 */
	1.930258305619341071629479853810475E+317DL,	/* 2**1054 */
	3.860516611238682143258959707620951E+317DL,	/* 2**1055 */
	7.721033222477364286517919415241902E+317DL,	/* 2**1056 */
	1.544206644495472857303583883048380E+318DL,	/* 2**1057 */
	3.088413288990945714607167766096761E+318DL,	/* 2**1058 */
	6.176826577981891429214335532193521E+318DL,	/* 2**1059 */
	1.235365315596378285842867106438704E+319DL,	/* 2**1060 */
	2.470730631192756571685734212877409E+319DL,	/* 2**1061 */
	4.941461262385513143371468425754817E+319DL,	/* 2**1062 */
	9.882922524771026286742936851509634E+319DL,	/* 2**1063 */
	1.976584504954205257348587370301927E+320DL,	/* 2**1064 */
	3.953169009908410514697174740603854E+320DL,	/* 2**1065 */
	7.906338019816821029394349481207707E+320DL,	/* 2**1066 */
	1.581267603963364205878869896241541E+321DL,	/* 2**1067 */
	3.162535207926728411757739792483083E+321DL,	/* 2**1068 */
	6.325070415853456823515479584966166E+321DL,	/* 2**1069 */
	1.265014083170691364703095916993233E+322DL,	/* 2**1070 */
	2.530028166341382729406191833986466E+322DL,	/* 2**1071 */
	5.060056332682765458812383667972933E+322DL,	/* 2**1072 */
	1.012011266536553091762476733594587E+323DL,	/* 2**1073 */
	2.024022533073106183524953467189173E+323DL,	/* 2**1074 */
	4.048045066146212367049906934378346E+323DL,	/* 2**1075 */
	8.096090132292424734099813868756692E+323DL,	/* 2**1076 */
	1.619218026458484946819962773751338E+324DL	/* 2**1077 */
};

//weak_alias(decpowof2, __decpowof2)
