#!/usr/bin/env python
"""Using multiple screens and windows with PsychoPy
"""

from psychopy import visual, event, core
from numpy import sin, pi#numeric python for doing some maths

if True: #use two positions on one screen
    winL = visual.Window(size=[400,300], pos=[100,200], screen=0, allowGUI=False)#, fullscr=True)
    winR = visual.Window(size=[400,300], pos=[400,200], screen=0, allowGUI=False)#, fullscr=True)#same screen diff place
else:
    winL = visual.Window(size=[400,300], pos=[100,200], screen=0, allowGUI=False, fullscr=False)
    winR = visual.Window(size=[400,300], pos=[100,200], screen=1, allowGUI=False, fullscr=False)#same place diff screen
    
#create some stimuli    
#NB. if the windows have the same characteristics then 
    #left screen
contextPatchL = visual.PatchStim(winL, tex='sin',mask='circle',size=1.0,sf=3.0, texRes=512)
targetStimL= visual.PatchStim(winL, ori=20,tex='sin',mask='circle',size=0.4,sf=3.0, texRes=512)
    #right screen
contextPatchR = visual.PatchStim(winR, tex='sin',mask='circle',size=1.0,sf=3.0, texRes=512)
targetStimR= visual.PatchStim(winR, ori=20,tex='sin',mask='circle',size=0.4,sf=3.0, texRes=512)

t=0.0
while t<10:
    t=t+0.01
    newX = sin(t*pi*2)*0.05+0.05#don't let it go behind the context (looks weird if it switches)
        
    contextPatchR.draw()
    targetStimR.setPos([newX,0])#make this patch move the opposite way
    targetStimR.draw()
        
    contextPatchL.draw()
    targetStimL.setPos([-newX,0])
    targetStimL.draw()
    
    winL.flip()
    winR.flip()
    
winR.close()
winL.close()