#!/usr/bin/perl

use strict;
use warnings;
use File::Path qw(remove_tree);

my $DriverPath = "";
if ($#ARGV == 0) { $DriverPath = $ARGV[0] . "/"; }

#
# First, grab the license
#

my $LicenseFile = $DriverPath . "../../share/python/source.template";
my $license = read_file($LicenseFile);

sub read_file {
    my ($filename) = @_;
 
    open my $in, '<:encoding(UTF-8)', $filename or die "Could not open '$filename' for reading $!";
    local $/ = undef;
    my $all = <$in>;
    close $in;
 
    return $all;
}

#
# Now, grab the physical constants
#
my $PhysconstFile = $DriverPath . "../../include/physconst.h";
my $PyPhysconstFile = $DriverPath . "../../share/python/p4const/physconst.py";
open(PHYSCONST, "<$PhysconstFile") or die "I can't open $PhysconstFile\n";
open(TEXOUT, ">physconst.tex") or die "I can't write to physconst.tex\n";
open(PYOUT, ">$PyPhysconstFile") or die "I can't write to $PyPhysconstFile\n";
open(RSTOUT, ">source/autodoc_physconst.rst") or die "I can't write to physconst.rst\n";
print PYOUT "$license";
print PYOUT "# Do not modify this file! It is auto-generated by the document_options_and_tests\n".
            "# script, from psi4topdir/include/physconst.h\n";
printf RSTOUT ".. index:: physconst\n";
printf RSTOUT ".. _`apdx:physconst`:\n\n";
printf RSTOUT "Physical Constants\n";
printf RSTOUT "==================\n\n";
printf RSTOUT ".. table:: Physical constants in |PSIfour|\n\n";
printf RSTOUT "   +-%-23s-+-%-20s-+-%-100s-+\n", ('-' x 23), ('-' x 20), ('-' x 100);
printf RSTOUT "   | %-23s | %-20s | %-100s |\n", "Label", "Value", "Description";
printf RSTOUT "   +=%23s=+=%20s=+=%100s=+\n", ('=' x 23), ('=' x 20), ('=' x 100);
while(<PHYSCONST>){
    next unless /\s*#define\s+pc(\w+)\s+([-Ee0-9.]+)\s+\/\*-(.*)-\*\//;
    my $Var     = $1;
    my $Val     = $2;
    my $Comment = $3;
    printf PYOUT "psi%-25s = %-20s #%-40s\n", $Var, $Val, $Comment;
    printf RSTOUT "   | %23s | %-20s | %-100s |\n", "psi" . $Var, $Val, $Comment;
    printf RSTOUT "   +-%-23s-+-%-20s-+-%-100s-+\n", ('-' x 23), ('-' x 20), ('-' x 100);
    $Var =~ s/_/\\_/g; # Make things TeX-friendly
    $Comment =~ s/_/\\_/g; # Make things TeX-friendly
    $Comment =~ s/@@/_/g;  # process @@ as math mode subscript in tex
    printf TEXOUT "psi%-25s & %-20s & %-40s\\\\\n", $Var, $Val, $Comment;
}
print "Auto-documenting constants file physconst.h\n";
close PHYSCONST;
close PYOUT;
close TEXOUT;
unlink("physconst.tex");
printf RSTOUT "\n";
close RSTOUT;


