#include "opt_advanced.h"
#include "common.h"
#include "iconwidget.h"

#include <qwhatsthis.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#include "opt_advanced-ui.h"

//----------------------------------------------------------------------------
// OptionsTabAdvanced
//----------------------------------------------------------------------------

OptionsTabAdvanced::OptionsTabAdvanced(QObject *parent)
: OptionsTab(parent, "advanced", "", tr("Advanced"), tr("Options for advanced users"))
{
	w = 0;
}

OptionsTabAdvanced::~OptionsTabAdvanced()
{
}

QWidget *OptionsTabAdvanced::widget()
{
	if ( w )
		return 0;

	w = new OptAdvancedUI();
	OptAdvancedUI *d = (OptAdvancedUI *)w;

	QWhatsThis::add(d->ck_singleclick,
		tr("Normally, a double-click on a contact will invoke the default action."
		"  Check this option if you'd rather invoke with a single-click."));
	QWhatsThis::add(d->ck_showself,
		tr("If checked, always show the self-contact in roster, "
		   "otherwise it is shown only when multiple resources are connected to your account."));
	QWhatsThis::add(d->ck_jidComplete,
		tr("Enables as-you-type JID autocompletion in message dialog."));
	QWhatsThis::add(d->ck_grabUrls,
		tr("Automatically attaches URLs from clipboard to the messages when enabled"));
	QWhatsThis::add(d->cb_incomingAs,
		tr("<P>Specifies how to treat incoming events:</P>"
		"<P><B>Normal</B> - messages come as messages, chats come as chats.</P>"
		"<P><B>Messages</B> - All messages/chats come as messages, no matter what their original form was.</P>"
		"<P><B>Chats</B> - All messages/chats come as chats, no matter what their original form was.</P>"));
	QWhatsThis::add(d->ck_showSubjects,
		tr("Makes Psi show separate subject line in messages. Uncheck this if you want to save some screen space."));
	QWhatsThis::add(d->ck_showCounter,
		tr("Makes Psi show message length counter. Check this if you want to know how long is your message. Can be useful when you're using SMS transport."));
	QWhatsThis::add(d->ck_autoVersion,
		tr("Automatically sends iq:version query to contact when he becomes online. This allows you to determine what client he is using to get online. Note: results in increased traffic."));
	QWhatsThis::add(d->ck_autoVCardOnLogin,
		tr("By default, Psi always checks your vCard on login. If you want to save some traffic, you can uncheck this option."));
	QWhatsThis::add(d->ck_rosterAnim,
		tr("Makes Psi animate contact names in the main window when they come online."));
	QWhatsThis::add(d->ck_scrollTo,
		tr("Makes Psi scroll the main window automatically so you can see new incoming events."));
	QWhatsThis::add(d->ck_ignoreHeadline,
		tr("Makes Psi ignore all incoming \"headline\" events,"
		" like system-wide news on MSN, announcements, etc."));

	return w;
}

void OptionsTabAdvanced::applyOptions(Options *opt)
{
	if ( !w )
		return;

	OptAdvancedUI *d = (OptAdvancedUI *)w;

	opt->singleclick = d->ck_singleclick->isChecked();
	opt->alwaysShowSelf = d->ck_showself->isChecked();
	opt->jidComplete = d->ck_jidComplete->isChecked();
	opt->grabUrls    = d->ck_grabUrls->isChecked();
	opt->incomingAs = d->cb_incomingAs->currentItem();
	opt->showSubjects = d->ck_showSubjects->isChecked();
	opt->showCounter = d->ck_showCounter->isChecked();
	opt->autoVersion = d->ck_autoVersion->isChecked();
	opt->autoVCardOnLogin = d->ck_autoVCardOnLogin->isChecked();
	opt->rosterAnim = d->ck_rosterAnim->isChecked();
	opt->scrollTo = d->ck_scrollTo->isChecked();
	opt->ignoreHeadline = d->ck_ignoreHeadline->isChecked();
}

void OptionsTabAdvanced::restoreOptions(const Options *opt)
{
	if ( !w )
		return;

	OptAdvancedUI *d = (OptAdvancedUI *)w;

	d->ck_singleclick->setChecked( opt->singleclick );
	d->ck_showself->setChecked( opt->alwaysShowSelf );
	d->ck_jidComplete->setChecked( opt->jidComplete );
	d->ck_grabUrls->setChecked( opt->grabUrls );
	d->cb_incomingAs->setCurrentItem( opt->incomingAs );
	d->ck_showSubjects->setChecked( opt->showSubjects );
	d->ck_showCounter->setChecked( opt->showCounter );
	d->ck_autoVersion->setChecked( opt->autoVersion );
	d->ck_autoVCardOnLogin->setChecked( opt->autoVCardOnLogin );
	d->ck_rosterAnim->setChecked( opt->rosterAnim );
	d->ck_scrollTo->setChecked( opt->scrollTo );
	d->ck_ignoreHeadline->setChecked( opt->ignoreHeadline );
}
