#
# Psi qmake profile
#

# Configuration
CONFIG    += qt thread

# Executable name
TARGET    = psi

# Header files
HEADERS   = \
	kmp/ndns.h \
	kmp/xmlfilter.h \
	kmp/stream.h \
	kmp/sha1.h \
	kmp/jid.h \
	kmp/types.h \
	kmp/xmlcommon.h \
	kmp/vcard.h \
	kmp/message.h \
	kmp/tasks.h \
	kmp/jidlink.h \
	kmp/dtcp.h \
	kmp/ibb.h \
	kmp/client.h \
	varlist.h \
	profiles.h \
	profiledlg.h \
	main.h \
	idle.h \
	psiaccount.h \
	psicon.h \
	psievent.h \
	xmlconsole.h \
	contactview.h \
	zip.h \
	iconset.h \
	userlist.h \
	showtextdlg.h \
	mainwin.h \
	trayicon.h \
	rtparse.h \
	common.h \
	busywidget.h \
	accountdlg.h \
	changepwdlg.h \
	msgmle.h \
	statusdlg.h \
	optionsdlg.h \
	eventdlg.h \
	chatdlg.h \
	adduserdlg.h \
	groupchatdlg.h \
	infodlg.h \
	eventdb.h \
	historydlg.h \
	servicesdlg.h \
	jltest.h

# Source files
SOURCES   = \
	kmp/ndns.cpp \
	kmp/xmlfilter.cpp \
	kmp/stream.cpp \
	kmp/sha1.cpp \
	kmp/jid.cpp \
	kmp/types.cpp \
	kmp/xmlcommon.cpp \
	kmp/vcard.cpp \
	kmp/message.cpp \
	kmp/tasks.cpp \
	kmp/jidlink.cpp \
	kmp/dtcp.cpp \
	kmp/ibb.cpp \
	kmp/client.cpp \
	varlist.cpp \
	profiles.cpp \
	profiledlg.cpp \
	main.cpp \
	idle.cpp \
	psiaccount.cpp \
	psicon.cpp \
	psievent.cpp \
	xmlconsole.cpp \
	contactview.cpp \
	zip.cpp \
	iconset.cpp \
	userlist.cpp \
	showtextdlg.cpp \
	mainwin.cpp \
	trayicon.cpp \
	rtparse.cpp \
	common.cpp \
	busywidget.cpp \
	accountdlg.cpp \
	changepwdlg.cpp \
	msgmle.cpp \
	statusdlg.cpp \
	optionsdlg.cpp \
	eventdlg.cpp \
	chatdlg.cpp \
	adduserdlg.cpp \
	groupchatdlg.cpp \
	infodlg.cpp \
	eventdb.cpp \
	historydlg.cpp \
	servicesdlg.cpp \
	jltest.cpp

# Mini-unzip
SOURCES += minizip/unzip.c

# Qt Designer interfaces
INTERFACES = \
	ui_profileopen.ui \
	ui_profilemanage.ui \
	ui_profilenew.ui \
	ui_accountmanage.ui \
	ui_accountadd.ui \
	ui_accountreg.ui \
	ui_accountremove.ui \
	ui_accountmodify.ui \
	ui_changepw.ui \
	ui_options.ui \
	ui_addurl.ui \
	ui_adduser.ui \
	ui_gcjoin.ui \
	ui_info.ui \
	ui_services.ui \
	ui_search.ui

# Translations
TRANSLATIONS = \
	psi_jp.ts \
	psi_de.ts \
	psi_zh.ts \
	psi_pl.ts \
	psi_se.ts \
	psi_cz.ts \
	psi_fr.ts \
	psi_es.ts \
	psi_ru.ts \
	psi_da.ts \
	psi_pt.ts \
	psi_nl.ts \
	psi_ar.ts \
	psi_ptbr.ts \
	psi_it.ts \
	psi_sr.ts \
	psi_mk.ts

INCLUDEPATH += kmp

# System-specific build settings
unix:!mac {
	INCLUDEPATH  += /usr/include /usr/X11R6/include
	LIBS         += -lz -lXss
	SOURCES      += trayicon_x11.cpp

	QMAKE_STRIP = "/bin/true"
	include( configure.pri )
}

win32: {
	INCLUDEPATH  += win32/zlib
	LIBS         += win32/idleui.lib win32/zlib/libz.a
	SOURCES      += trayicon_win.cpp
	RC_FILE      =  win32/psi_win32.rc
}

mac: {
	SOURCES      += trayicon_mac.cpp
	QMAKE_LFLAGS += -framework Carbon -lz
}

QMAKE_ABSOLUTE_SOURCE_PATH = 1

