#include "pixmapcache.h"
#include "prokyon.h"
#include "gui.h"

#include <qpixmapcache.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qimage.h>


// *** constructor ***
PixmapCache::PixmapCache() {
    QDir dir (PROKYON_HOME + "/images", "*.png");
    const QFileInfoList *filist = dir.entryInfoList();
    QFileInfoListIterator it( *filist );
    QFileInfo *fi;
    uint size = 0;

    while((fi = it.current()) != 0) {
        ++it;
        size += fi->size(); // byte
    }

    // The default size of the global QPixmapCache is 1024 kb
    // We add two times the size of all prokyon3 images in order
    // to handle them and a faded version of them without
    // reducing the cache for qt's internal pixmap handling.
    size = size / 1024 * 2 + 1024;
    //Warning(QString::number(size).latin1());

    QPixmapCache::setCacheLimit(size); // kilobyte
}

const QPixmap PixmapCache::get
    (const QString file) {
    QPixmap pm;
    if(!QPixmapCache::find(file, pm)) {
        pm.load(PROKYON_HOME + "/images/" + file);
        QPixmapCache::insert(file, pm);
    }
    return pm;
}

const QPixmap PixmapCache::getFaded(const QString file) {
    QPixmap pm;
    if(!QPixmapCache::find(file + "_faded", pm)) {
        pm = fadeOutIcon(PROKYON_HOME + "/images/" + file);
        QPixmapCache::insert(file + "_faded", pm);
    }
    return pm;
}

const QIconSet PixmapCache::getFadeIconSet(const QString file) {
    QIconSet iconset = QIconSet(get
                                (file));
    iconset.setPixmap(getFaded(file),QIconSet::Automatic, QIconSet::Disabled);
    return iconset;
}

QPixmap PixmapCache::fadeOutIcon(const QString file) {
    QImage img(file);
    img.setAlphaBuffer(true);
    img = img.convertDepth(32);
    int h = img.height();
    int w = img.width();
    for(int y=0; y<h; y++) {
        uint* line = (uint*)img.scanLine(y);
        for(int x=0; x<w; x++) {
            uint pixel = line[x];
            int r = qRed(pixel);
            int g = qGreen(pixel);
            int b = qBlue(pixel);
            int a = int(qAlpha(pixel)*0.3);
            line[x] = qRgba(r,g,b,a);
        }
    }
    return QPixmap(img);
}

