/***************************************************************************
                          job_modifyplaylists.h  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 
    Contributed by Tim Lee ;-)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JOB_MODIFYPLAYLISTS_H
#define JOB_MODIFYPLAYLISTS_H

#include "prokyon.h"

#include "jobbase.h"

#include "lvi_playlist.h"

#define APPEND_PLAYLIST  1
#define RENAME_PLAYLIST  2
#define DELETE_PLAYLIST  3

class Job_ModifyPlaylists : public JobBase  {
public:
    Job_ModifyPlaylists(int _mode, QString _listname);
    Job_ModifyPlaylists(int _mode, LVI_Playlist *_playlist);
    Job_ModifyPlaylists(int _mode, LVI_Playlist *_playlist, QString _newname);

    int type() {
        return JOB_MODIFY_PLAYLISTS;
    }

    void run();

    ~Job_ModifyPlaylists();

private:
    int mode;
    QString listname;
    LVI_Playlist *playlist;
    QString newname;
    int playlistID;
};

#endif
