/***************************************************************************
                          jobmanager.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "jobmanager.h"

#include "gui.h"

#include "job_synchronizewithdatabase.h"

JobManager::JobManager()
{
  job_connect_isRunning = false;
  job_disconnect_isRunning = false;
  job_connectMixxx_isRunning = false;
  job_disconnectMixxx_isRunning = false;
  job_query_isRunning = false;
  job_modify_isRunning = false;
  job_generate_isRunning = false;
  job_extradata_isRunning = false;
  job_mextras_Running = 0;
  job_playalbum_isRunning = false;
  job_importplaylist_isRunning = false;
  
  jobCounter = 0;
#ifdef HAVE_MEXTRAS
  job_mextras_max = config->mextras_count();  // max number of simultaneous musicextras instances
#endif /* HAVE_MEXTRAS */
}

JobManager::~JobManager()
{
  deleteFinishedJobs();
}

void JobManager::addJob(JobBase *job, bool dequeuedMusicextrasJob)
{
  Job_SynchronizeWithDatabase *syncjob;
  deleteFinishedJobs();
  bool success = false;

  int buf_type;
  JobBase* buf_job;
  if ( verbose== 8) {
    buf_type = job->type();
    buf_job = job;
    qWarning(" adding a job:%p type:%s ", buf_job, JOB_CODE[buf_type]);
  }

  switch(job->type()) {
  case JOB_CONNECT_TO_DATABASE:
    if(job_connect_isRunning) delete job;
    else {
      success = true;
      job_connect_isRunning = true;
    }
    break;
  case JOB_DISCONNECT_FROM_DATABASE:
    if(job_disconnect_isRunning) delete job;
    else {
      success = true;
      job_disconnect_isRunning = true;
    }
    break;
  case JOB_CONNECT_TO_MIXXX:
    if(job_connectMixxx_isRunning) delete job;
    else {
      success = true;
      job_connectMixxx_isRunning = true;
    }
    break;
  case JOB_DISCONNECT_FROM_MIXXX:
    if(job_disconnectMixxx_isRunning) delete job;
    else {
      success = true;
      job_disconnectMixxx_isRunning = true;
    }
    break;
  case JOB_SYNCHRONIZE_WITH_DATABASE:
    syncjob = static_cast<Job_SynchronizeWithDatabase*>(job);
    if(job_synchronize_isRunning.contains(syncjob->getMediumID()) && job_synchronize_isRunning[syncjob->getMediumID()]) delete job;
    else {
      success = true;
      job_synchronize_isRunning[syncjob->getMediumID()] = true;
    }
    break;
  case JOB_QUERY_DATABASE:
    if(job_query_isRunning) delete job;
    else {
      success = true;
      job_query_isRunning = true;
    }
    break;
  case JOB_MODIFY_TRACKS_IN_DATABASE:
  case JOB_MODIFY_PLAYLISTS:
  case JOB_MODIFY_PLAYLIST_TRACKS:
    if(job_modify_isRunning) delete job;
    else {
      success = true;
      job_modify_isRunning = true;
    }
    break;
  case JOB_GENERATE_PLAYLIST:
    if(job_generate_isRunning) delete job;
    else {
      success = true;
      job_generate_isRunning = true;
    }
    break;
  case JOB_IMPORT_PLAYLIST:
    if(job_importplaylist_isRunning) delete job;
    else {
      success = true;
      job_importplaylist_isRunning = true;
    }
    break;
  case JOB_GET_EXTRA_DATA:
    if(job_extradata_isRunning) delete job;
    else {
      success = true;
      job_extradata_isRunning = true;
    }
    break;
  case JOB_CALL_MUSICEXTRAS:
    {
        if(!dequeuedMusicextrasJob) {
            NewMusicExtrasJobEvent* ne1 = new NewMusicExtrasJobEvent();
            QApplication::postEvent( gui, ne1 );
        }
        NewMusicExtrasJobEvent* ne2 = new NewMusicExtrasJobEvent();
        QApplication::postEvent( gui->getPlaylisting(), ne2 ); 
    }
    if(job_mextras_Running < job_mextras_max) {
      success = true;          // start job
      job_mextras_Running++;
    } else  
      job_mextras_queue.enqueue(job);  
    break;
  case JOB_PLAYALBUM:
    if(job_playalbum_isRunning) delete job;
    else {
      success = true;
      job_playalbum_isRunning = true;
    }
    break;
  case JOB_MODIFY_FAVOURITE:
  case JOB_QUERY_PLAYLIST_TRACKS:
  case JOB_COMPUTE_CDROM_ID:
  case JOB_APPEND_CDROM_TO_DATABASE:
  case JOB_DELETE_MEDIUM_FROM_DATABASE:
  case JOB_RENAME_MEDIUM:
  case JOB_APPEND_SMB_TO_DATABASE:
  case JOB_APPEND_NFS_TO_DATABASE:
  case JOB_DELETE_TRACK_PHYSICALLY:
  case JOB_COUNT_DATA:
  case JOB_STORE_CUSTOM_QUERY:
  case JOB_REMOVE_CUSTOM_QUERY:
    success = true;
    break;
  default:
    qWarning( "jobtype '%s' not handled", JOB_CODE[job->type()]);
  }
  
  if(success) {
    jobList.append(job);
    incrJobCounter();
    job->start();
  } else {
    if (verbose==8) 
      if ( buf_type == JOB_CALL_MUSICEXTRAS )
        qWarning( "Queing job:%p type:%s", buf_job, JOB_CODE[buf_type]);
      else
        qWarning( "Deleting job:%p type:%s !!!without running it!!!", buf_job, JOB_CODE[buf_type]);
  }
}

void JobManager::jobDone(JobBase *job)
{
  Job_SynchronizeWithDatabase *syncjob;
  switch(job->type()) {
  case JOB_CONNECT_TO_DATABASE:
    job_connect_isRunning = false;
    break;
  case JOB_DISCONNECT_FROM_DATABASE:
    job_disconnect_isRunning = false;
    break;
  case JOB_CONNECT_TO_MIXXX:
    job_connectMixxx_isRunning = false;
    break;
  case JOB_DISCONNECT_FROM_MIXXX:
    job_disconnectMixxx_isRunning = false;
    break;
  case JOB_SYNCHRONIZE_WITH_DATABASE:
    syncjob = static_cast<Job_SynchronizeWithDatabase*>(job);
    job_synchronize_isRunning[syncjob->getMediumID()] = false;
    break;
  case JOB_QUERY_DATABASE:
    job_query_isRunning = false;
    break;
  case JOB_MODIFY_TRACKS_IN_DATABASE:
  case JOB_MODIFY_PLAYLISTS:
  case JOB_MODIFY_PLAYLIST_TRACKS:
    job_modify_isRunning = false;
    break;
  case JOB_GENERATE_PLAYLIST:
    job_generate_isRunning = false;
    break;
  case JOB_IMPORT_PLAYLIST:
    job_importplaylist_isRunning = false;
    break;
  case JOB_GET_EXTRA_DATA:
    job_extradata_isRunning = false;
    break;
  case JOB_CALL_MUSICEXTRAS:
    job_mextras_Running--;
    if (job_mextras_Running < job_mextras_max) 
      if (!job_mextras_queue.isEmpty()) 
	    addJob(job_mextras_queue.dequeue(), true);
    // post a time tag message to log window
    if (job_mextras_Running==0 && job_mextras_queue.isEmpty()) {
      LogEvent* le = new LogEvent( QDateTime::currentDateTime().toString() );
      QApplication::postEvent( gui->getPlaylisting(), le ); 
      AllMusicExtrasJobsDoneEvent* ae = new AllMusicExtrasJobsDoneEvent();
      QApplication::postEvent( gui->getPlaylisting(), ae ); 
    }
    {
        MusicExtrasJobDoneEvent* me = new MusicExtrasJobDoneEvent();
        QApplication::postEvent( gui, me );
    } 
    break;
  case JOB_PLAYALBUM:
    job_playalbum_isRunning = false;
    break;
  }
  decrJobCounter();
}

void JobManager::incrJobCounter()
{
	QString statustext;
	jobCounter++;
	statustext.sprintf(_(" Jobs: %d"), jobCounter);
	StatusEvent* se = new StatusEvent( new STATUSDATA( statustext, 1) );
	QApplication::postEvent( gui->getPlaylisting(), se ); 
}

void JobManager::decrJobCounter()
{
	QString statustext;
	jobCounter--;
	statustext.sprintf(_(" Jobs: %d"), jobCounter);
	StatusEvent* se = new StatusEvent( new STATUSDATA( statustext, 1) );
	QApplication::postEvent( gui->getPlaylisting(), se ); 
}

int JobManager::getNumberOfJobsRunning()
{
    return jobCounter;
}

void JobManager::deleteFinishedJobs()
{
  for(JobBase *curr = jobList.first(); curr != 0; curr = jobList.next()) {
    if(curr->finished()) {
      jobList.remove(curr);
      if (verbose==8) 
	qWarning( " deleting job:%p type:%s....", curr, JOB_CODE[curr->type()]);
      delete curr;
    }
  }
}

bool JobManager::terminateJob(JobBase *job)
  /**************************************************
   Carefull. 
   forcing terminate on some prokyon3 thread is not completely safe. 
   As an example it can freezes GUI if thread is killed while locking main GUI lock
   It is always safer to implement a safeTerminate() member in a thread.
   This is only implemented with JOB_CALL_MUSICEXTRAS at the moment.
  ****************************************************/
{
  if (job) {
    for(JobBase *curr = jobList.first(); curr != 0; curr = jobList.next()) {
      if(curr==job) {
	if (!curr->finished()) {
	  jobman->lock();  // safer to lock access against running  threads
#ifdef HAVE_MEXTRAS
	  if(curr->type() == JOB_CALL_MUSICEXTRAS) {
	    static_cast<Job_CallMusicextras*>(curr)->safeTerminate();
	  } else {
#endif /* HAVE_MEXTRAS */
	    if (verbose==8) 
	      qWarning( " terminating job:%p type:%s....", curr, JOB_CODE[curr->type()]);
	    curr->terminate();
	    jobDone(curr);  
	    jobList.remove(curr);
	    delete curr;
#ifdef HAVE_MEXTRAS
	  }
#endif /* HAVE_MEXTRAS */
	  jobman->unlock();
	}
	return true;
      }
    }
  }
  return false;
}

#ifdef HAVE_MEXTRAS
void JobManager::terminateMusicextrasJob()
{
  jobman->lock(); 
  for(JobBase *curr = jobList.first(); curr != 0; curr = jobList.next()) 
    if(curr->type() == JOB_CALL_MUSICEXTRAS && !curr->finished()) 
	static_cast<Job_CallMusicextras*>(curr)->safeTerminate();
  if (verbose==7) qWarning( " Clearing Musicextras queue list....");
  job_mextras_queue.clear();
  // we need to post an event because the jobs removed from the queue don't report jobDone()
  AllMusicExtrasJobsDoneEvent* ae = new AllMusicExtrasJobsDoneEvent();
  QApplication::postEvent( gui, ae ); 
  jobman->unlock();
}
#endif /* HAVE_MEXTRAS */
