/***************************************************************************
                          gui.cpp  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#if HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "prokyon.h"
#include "gui.h"

#include "dirwatcher.h"
#include "jobmanager.h"
#include "configuration.h"
#include "job_connecttodatabase.h"
#include "job_disconnectfromdatabase.h"

#include "database_create_dialog.h"
#include "helpviewer.h"

#include <qaction.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qiconset.h>
#include <qimage.h>
#include <qfont.h>
#include <qtooltip.h>
#include <qvaluelist.h> 
#include <qpixmap.h>
#include <qlayout.h>
#include <qvbox.h>

#include <qwindowsstyle.h>
#include <qevent.h>


QPixmap GUI::fadeOutIcon(QString file) {
	QImage img(file);
	img.setAlphaBuffer(true);
	img = img.convertDepth(32);
	int h = img.height();
	int w = img.width();
	for(int y=0; y<h; y++) {
	    uint* line = (uint*)img.scanLine(y);
	    for(int x=0; x<w; x++) {
		uint pixel = line[x];
		int r = qRed(pixel);
		int g = qGreen(pixel);
		int b = qBlue(pixel);
		int a = int(qAlpha(pixel)*0.3);
		line[x] = qRgba(r,g,b,a);
	    }
	}
	return QPixmap(img);
}

GUI::GUI(QWidget *parent, const char *name): QMainWindow(parent, name)
{
  //-  QStdAction::quit(this, SLOT(close()), actionCollection());
  
  //	QFont myFont("Arial", 11, QFont::Normal);
  //	if (verbose) qWarning("Font exact match: %s", myFont.exactMatch() ? "yes" : "no" );

  //	app->setFont(myFont);
  //	setFont(myFont);
  //	app->setStyle(new QWindowsStyle());
  //	setStyle(new QWindowsStyle());

  QIconSet connectIcons;
  connectIcons.setPixmap(PROKYON_HOME + "/images/action_connect.png", QIconSet::Automatic, QIconSet::Normal);
  connectIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_connect.png"), QIconSet::Automatic, QIconSet::Disabled);
	
  QIconSet disconnectIcons;
  disconnectIcons.setPixmap(PROKYON_HOME + "/images/action_disconnect.png", QIconSet::Automatic, QIconSet::Normal);
  disconnectIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_disconnect.png"), QIconSet::Automatic, QIconSet::Disabled);
	
  QIconSet createdbIcons;
  createdbIcons.setPixmap(PROKYON_HOME + "/images/action_createdb.png", QIconSet::Automatic, QIconSet::Normal);
  createdbIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_createdb.png"), QIconSet::Automatic, QIconSet::Disabled);
		
  QIconSet settingsIcons;
  settingsIcons.setPixmap(PROKYON_HOME + "/images/action_settings.png", QIconSet::Automatic, QIconSet::Normal);
  settingsIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_settings.png"), QIconSet::Automatic, QIconSet::Disabled);
	
  QIconSet quitIcons;
  quitIcons.setPixmap(PROKYON_HOME + "/images/action_quit.png", QIconSet::Automatic, QIconSet::Normal);
  quitIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_quit.png"), QIconSet::Automatic, QIconSet::Disabled);

  QIconSet documentationIcons;
  documentationIcons.setPixmap(PROKYON_HOME + "/images/action_documentation.png", QIconSet::Automatic, QIconSet::Normal);
  documentationIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_documentation.png"), QIconSet::Automatic, QIconSet::Disabled);
		
  action_connect = new QAction(_("Connect"), connectIcons, _("&Connect"), CTRL+Key_C, this, "connect");
  connect(action_connect, SIGNAL(activated()),this, SLOT(slot_connectToDB()));
  action_disconnect = new QAction(_("Disconnect"), disconnectIcons, _("&Disconnect"), CTRL+Key_D, this, "disconnect");
  connect(action_disconnect, SIGNAL(activated()), this, SLOT(slot_disconnectFromDB()));
  QAction *action_quit = new QAction(_("Quit"), quitIcons, _("&Quit"), CTRL+Key_Q, this, "quit");
  connect(action_quit, SIGNAL(activated()), this, SLOT(slot_QUIT()));
  QAction *action_pref = new QAction(_("Settings..."), settingsIcons, _("&Settings..."), CTRL+Key_S, this, "settings");
  connect(action_pref, SIGNAL(activated()), this, SLOT(slot_PREF()));
  action_createdb = new QAction(_("Create new database..."), createdbIcons, _("Create &New database..."), CTRL+Key_N, this, "create");
  connect(action_createdb, SIGNAL(activated()), this, SLOT(slot_CREATEDB()));
  
  action_about = new QAction(_("About..."), createdbIcons, _("&About..."), CTRL+Key_A, this, "about");
  connect(action_about, SIGNAL(activated()), this, SLOT(slot_ABOUT()));

  action_welcome = new QAction(_("Welcome screen..."), _("&Welcome..."), CTRL+Key_W, this, "welcome");
  connect(action_welcome, SIGNAL(activated()), this, SLOT(slot_WELCOME()));

  action_documentation = new QAction(_("Documentation..."), documentationIcons,_("d&Ocumentation..."), CTRL+Key_O, this, "documentation");
  connect(action_documentation, SIGNAL(activated()), this, SLOT(slot_DOCUMENTATION()));

  connect(app, SIGNAL(lastWindowClosed()), this, SLOT(slot_QUIT()));
	
  QToolBar *toolbar = new QToolBar(this, "prokyon toolbar");
	
  action_connect->addTo(toolbar);
  action_disconnect->addTo(toolbar);
  action_pref->addTo(toolbar);
  action_documentation->addTo(toolbar);
  action_quit->addTo(toolbar);
	
  QIconSet toggleleftIcons;
  toggleleftIcons.setPixmap(PROKYON_HOME + "/images/action_switchleft.png", QIconSet::Automatic, QIconSet::Normal);
  toggleleftIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_switchleft.png"), QIconSet::Automatic, QIconSet::Disabled);

  QIconSet togglerightIcons;
  togglerightIcons.setPixmap(PROKYON_HOME + "/images/action_switchright.png", QIconSet::Automatic, QIconSet::Normal);
  togglerightIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_switchright.png"), QIconSet::Automatic, QIconSet::Disabled);

  QIconSet togglebottomIcons;
  togglebottomIcons.setPixmap(PROKYON_HOME + "/images/action_switchbottom.png", QIconSet::Automatic, QIconSet::Normal);
  togglebottomIcons.setPixmap(fadeOutIcon(PROKYON_HOME + "/images/action_switchbottom.png"), QIconSet::Automatic, QIconSet::Disabled);


  action_toggleleft = new QAction(_("Toggle SelectionFrame"), toggleleftIcons, _("Toggle &Left Frame"), CTRL+Key_L, this, "toggleleft");
  action_toggleleft->setToggleAction(true);
  action_toggleleft->setOn(true);
  connect(action_toggleleft, SIGNAL(toggled(bool)), this, SLOT(slot_toggleleft(bool)));

  action_togglebottom = new QAction(_("Toggle InfoFrame"), togglebottomIcons, _("Toggle &Info Frame"), CTRL+Key_I, this, "toggleinfo");
  action_togglebottom->setToggleAction(true);
  action_togglebottom->setOn(true);
  connect(action_togglebottom, SIGNAL(toggled(bool)), this, SLOT(slot_togglebottom(bool)));

  action_toggleright = new QAction(_("Toggle PlaylistFrame"), togglerightIcons, _("Toggle Right Frame"), CTRL+Key_R, this, "toggleright");
  action_toggleright->setToggleAction(true);
  action_toggleright->setOn(true);
  connect(action_toggleright, SIGNAL(toggled(bool)), this, SLOT(slot_toggleright(bool)));

  switchbar = new QToolBar(this, "prokyon switchbar");
  action_toggleleft->addTo(switchbar);
  action_togglebottom->addTo(switchbar);
  action_toggleright->addTo(switchbar);
	

  QPopupMenu *filepopup = new QPopupMenu(this);
  action_createdb->addTo(filepopup);
  filepopup->insertSeparator();
  action_connect->addTo(filepopup);
  action_disconnect->addTo(filepopup);
  filepopup->insertSeparator();
  action_pref->addTo(filepopup);
  filepopup->insertSeparator();
  action_quit->addTo(filepopup);
  menuBar()->insertItem(_("&File"), filepopup);
	
  QPopupMenu *helppopup = new QPopupMenu(this);
  action_about->addTo(helppopup);
  action_welcome->addTo(helppopup);
  action_documentation->addTo(helppopup);
  menuBar()->insertItem(_("&Help"), helppopup); 	

  hsplit = new QSplitter(QSplitter::Horizontal, this);
  
  vsplitr = new QSplitter(QSplitter::Vertical, hsplit);
  vsplitr->setOpaqueResize( true );

  selector = new GUI_Selector(vsplitr);
  sourcer = new GUI_Sourcer(vsplitr);
  char* temps1 = _( "Right click to mount disks, \nRead files info into database, \nOr synchronize." );
  QToolTip::add( sourcer, temps1 );
  QToolTip::add( sourcer->viewport(), temps1 );
  
  vsplitm = new QSplitter(QSplitter::Vertical, hsplit);
  listing = new GUI_Listing(vsplitm);
  taglisting = new GUI_TagListing(vsplitm, listing->list()); 
  // MK begin
  // Do not set a fixed height in constructor of taglisting!
  //===================================================
  //  taglisting->adjustSize();
  //  taglisting->setFixedHeight(taglisting->height());
  //---------------------------------------------------
  // ^^^ -> moved into polish method() !! [HoSa]
  //===================================================
  // MK end

  char* temps2 = _( "View  files and tags details" );
  QToolTip::add( taglisting, temps2 );

  vsplitl = new QSplitter(QSplitter::Vertical, hsplit);

  playlisting = new GUI_Playlist(vsplitl);
  
  status1 = new QLabel(statusBar());
  statusBar()->addWidget(status1, 1, true);

  QFrame* frame1 = new QFrame( statusBar());
  QHBoxLayout* layout1 = new QHBoxLayout( frame1 ); 
  status2 = new QLabel( frame1 );
  labelpix = new QLabel( frame1 );
  layout1->addWidget( labelpix );
  layout1->addWidget( status2, 1 );
  statusBar()->addWidget( frame1, 1, true );

  status3 = new QLabel(statusBar());
  statusBar()->addWidget(status3, 1, true);
  status4 = new QLabel(statusBar());
  statusBar()->addWidget(status4, 1, true);
  status5 = new QLabel(statusBar());
  statusBar()->addWidget(status5, 1, true);
   
  setStatusInfo(_(" Jobs: 0 "), 1);
  setStatusInfo(_(" Status: NOT connected "), 2);
  setStatusInfo(_(" Artists: 0 "), 3);
  setStatusInfo(_(" Tracks: 0 "), 4);
  setStatusInfo(_(" Mode: offline"), 5);
  
  setCentralWidget(hsplit);
  
  connectionState = false;
}

void GUI::polish()
{
  QMainWindow::polish();
  if (config->getAllowGuiRestore() ) {
    action_toggleleft->setOn( config->gettoggleleft() );
    slot_toggleleft( config->gettoggleleft() );

    action_toggleright->setOn( config->gettoggleright() );
    slot_toggleright( config->gettoggleright() );

    action_togglebottom->setOn( config->gettogglebottom() );
    slot_togglebottom( config->gettogglebottom() );

    hsplit->setSizes( config->getinfo_guisize() );
    vsplitr->setSizes( config->getinfo_guisizer() );
    vsplitm->setSizes( config->getinfo_guisizem() );
    gui->getPlaylisting()->getVsplit()->setSizes( config->getinfo_guisizel() );

    //    taglisting->setFixedHeight(taglisting->minimumSizeHint().height());
  }
}

void GUI::setStatusInfo(QString message, int i) {
	switch(i) {
	case 1: status1->setText(message); break;
	case 2: { 
	  status2->setText(message);
	  if (message.find( _("NOT connected") ) != -1 ) 
	    labelpix->setPixmap( QPixmap( PROKYON_HOME + "/images/madsmiley.png") );
	  else 
	    labelpix->setPixmap( QPixmap( PROKYON_HOME + "/images/smiley.png") );
	} break;
	case 3: status3->setText(message); break;
	case 4: status4->setText(message); break;
	case 5: status5->setText(message); break;
	}
}

void GUI::slot_connectToDB()
{
  jobman->lock();
  jobman->addJob(new Job_ConnectToDatabase(config->getHOST(), config->getDATABASE(), config->getUSER(), config->getPASS()));
  jobman->unlock();
}

void GUI::slot_disconnectFromDB()
{
  jobman->lock();
  jobman->addJob(new Job_DisconnectFromDatabase());
  jobman->unlock();
}

void GUI::notifyEstablishedConnection() {
  setStatusInfo(_(" Status: connected "), 2);
  setStatusInfo(_(" Mode: normal "), 5);
  setConnectionState(true);
}

void GUI::notifyLostConnection()        {
	setStatusInfo(_(" Status: NOT connected "), 2);
	setStatusInfo(_(" Artists: 0 "), 3);
	setStatusInfo(_(" Tracks: 0 "), 4);
	setStatusInfo(_(" Mode: offline "), 5);
	setConnectionState(false);
} 

void GUI::setConnectionState(bool state)
{
  if(state == false) {
    action_connect->setEnabled(true);
    action_createdb->setEnabled(true);
    action_disconnect->setEnabled(false);
    taglisting->setConnectionState(false);
    selector->setConnectionState(false);
    sourcer->setConnectionState(false);
    listing->setConnectionState(false);
    playlisting->setConnectionState(false);
  } else {
    action_connect->setEnabled(false);
    action_createdb->setEnabled(false);
    action_disconnect->setEnabled(true);
    taglisting->setConnectionState(true);
    selector->setConnectionState(true);
    sourcer->setConnectionState(true);
    listing->setConnectionState(true);
    playlisting->setConnectionState(true);
  }
    connectionState = state;
}

void GUI::slot_PREF() {
    config->showConfigurationDialog();
}

void GUI::slot_QUIT() {
    app->quit();
}

void GUI::slot_CREATEDB() {
    Database_Create_Dialog *dlg = new Database_Create_Dialog(this);
    dlg->show();
}

void GUI::slot_INITDB() {
}

void GUI::slot_toggleleft(bool b) {
    if(!b) {
	gui->getSelector()->hide();
	gui->getSourcer()->hide();
    } else {
	gui->getSelector()->show();
	gui->getSourcer()->show();
    }
}

void GUI::slot_togglebottom(bool b) {
    if(!b) {
	gui->getTagListing()->hide();
    } else {
	gui->getTagListing()->show();
    }
}

void GUI::slot_toggleright(bool b) {
    if(!b) {
	gui->getPlaylisting()->hide();
    } else {
	gui->getPlaylisting()->show();
    }
}

#include <qmessagebox.h>
void GUI::slot_ABOUT() {
  
  QMessageBox aboutbox(this, "About");
  aboutbox.setPaletteBackgroundPixmap( QPixmap(PROKYON_HOME + "/images/pink_marble.png"));
  aboutbox.setText( ("<center><b><u>Prokyon3 v" VERSION ) + QString(_("</u></b><br>MP3/Ogg Manager/Database<br>http://prokyon3.sourceforge.net<br><br><b><u>Developer:</u></b><br>Markus Kalkbrenner &lt;mkalkbrenner@users.sourceforge.net&gt;<br>Paul-henri Ferme &lt;paul-henri@users.sourceforge.net&gt;<br><br><b><u>Thanks to:</u></b><br>Tim Lee<br>Lars Volkhardt<br>Christophe Vandeplas<br><br>(c) 2002 by Holger Sattel &lt;hsattel@users.sourceforge.net&gt;<br></center>")));
  aboutbox.exec();
}

void GUI::slot_WELCOME() {
    QMessageBox welcomebox(gui, _("Welcome"));
    welcomebox.setPaletteBackgroundPixmap( QPixmap(PROKYON_HOME + "/images/pink_marble.png"));
    welcomebox.setText( _( "<b><center><u>WELCOME TO PROKYON3</u></center><br><br>"
"Thank you for running Prokyon3 for the first time!!!<br><br>"
"Prokyon3 is a multithreaded MP3/Ogg manager and tag editor for Linux. It was "
"written in C++ using the Qt3 widget set and the MySQL database. Prokyon3 "
"can access MP3 files on harddisk, CDROM, SMB and NFS. Files can be played "
"using XMMS, and can even be played when the files are on CD as prokyon3 "
"identifies CDs by content. The files view is customizable and sampler "
"soundtracks are supported. Prokyon3 also offers an editor for ID3 tags and "
"has been designed to support tagging for multiple files en masse.<br><br>"
"Prokyon3 will now automatically create an SQL database for you "
"and connect right to it.<br> You should first go to "
"\"File/Settings/Directory\" "
"and type paths to your music files. Then go to the \"Sourcer\" frame, "
"right click on your main media icon and select "
"\" synchronize (prefer Sources)\" command. You are now ready to enjoy Prokyon3.<br>"
"Prokyon3 is simple and straightforward to use. Anyway, "
"additional help will be  provided via pop-ups window when appropriate.<br><br>"
"<b>NEW with 0.9.2</b>: An on-line manual is also available.... <br><br>"
"The Prokyon3 development team....<br><br><br>"
) );
    welcomebox.exec();
}

void GUI::slot_DOCUMENTATION() {

  if ( QFile::exists( PROKYON_HOME + "/html/manual_one_file/index.html" ) ) {

    HelpWindow *help = new HelpWindow(PROKYON_HOME + "/html/manual_one_file/index.html", PROKYON_HOME + "/html/manual_one_file/", 0, "help viewer");
    help->setCaption("Helpviewer");

    QRect qRect(QApplication::desktop()->screenGeometry());
    int iXpos=qRect.width()/2 - help->width()/2;
    int iYpos=qRect.height()/2 - help->height()/2;
    help->move(iXpos,iYpos);

    if ( QApplication::desktop()->width() > 400
	 && QApplication::desktop()->height() > 500 )
      help->show();
    else
      help->showMaximized();
  } else 
    QMessageBox::information( this, "Prokyon3",
			      _("Unable to find html documentation files.\n" 
			      "See INSTALL for instructions") );
}

void GUI::closeEvent( QCloseEvent* e ) {

  config->setposx( x() );
  config->setposy( y() );
  config->setheight( height() );
  config->setwidth( width() );

  config->settoggleleft( gui->getSelector()->isVisible() );
  config->settogglebottom( gui->getTagListing()->isVisible() );
  config->settoggleright(  gui->getPlaylisting()->isVisible() );

  config->setinfo_guisize( hsplit->sizes() );
  config->setinfo_guisizer( vsplitr->sizes() );
  config->setinfo_guisizem( vsplitm->sizes() );
  config->setinfo_guisizel( gui->getPlaylisting()->getVsplit()->sizes() );

  dirwatcher->stop();
  QMainWindow::closeEvent( e );
}

GUI::~GUI() {
}
