/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfUsersDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfUsersDAOSQLiteEntity::CPfUsersDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfUsersDAOSQLiteEntity::~CPfUsersDAOSQLiteEntity()
{
}

void CPfUsersDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfUsersDAOSQLiteEntity::deleteReg(CPfUsers *reg)
{
    std::string sql("DELETE FROM PF_USERS WHERE X_USER=");
    sql += "'"+reg->getXUser_str()+"'";
    return exec(sql);
}

bool CPfUsersDAOSQLiteEntity::insertReg(CPfUsers *reg)
{
    std::string sql("INSERT INTO PF_USERS (S_USER) VALUES (");
    sql += (reg->getSUser_str()=="")?"NULL":"'"+reg->getSUser_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXUser(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfUsersDAOSQLiteEntity::updateReg(CPfUsers *reg)
{
    std::string sql("UPDATE PF_USERS SET ");
    sql += (reg->getXUser_str()=="")?" X_USER=NULL":" X_USER='"+reg->getXUser_str()+"'";
    sql += (reg->getSUser_str()=="")?",S_USER=NULL":",S_USER='"+reg->getSUser_str()+"'";
    sql += " WHERE X_USER='"+reg->getXUser_str()+"'";
    return exec(sql);
}

void CPfUsersDAOSQLiteEntity::freeVector(std::vector<CPfUsers*>* vector )
{
    std::vector<CPfUsers*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfUsers* CPfUsersDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfUsers *destiny = new CPfUsers();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfUsers*> * CPfUsersDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfUsers*> *container = new std::vector<CPfUsers*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfUsersDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfUsersDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfUsers *destiny = (CPfUsers*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_USER")==0 ){
                destiny->setXUser_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_USER")==0 ){
                destiny->setSUser_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfUsersDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfUsers*> *container = (std::vector<CPfUsers*> *)object;
        CPfUsers *destiny = new CPfUsers();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_USER")==0 ){
                destiny->setXUser_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "S_USER")==0 ){
                destiny->setSUser_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

