PACKAGE = prismstumbler
VERSION = 0.7.1
NATIVE = yes
DEBUG = no
INSTALL = install
PREFIX = /usr/
DESTDIR = /
CONTROL = control1
CONTROL-FE = control1fe
WLAN_NG = no
SUBDIRS = wlanctl gpsd

bin_PROGRAMS = prismstumbler miniclient psfront

prismstumbler_LDADD = gpsd/libgpsd.a -lpcap -lm
psfront_LDADD = -lsqlite -lz

psfront_OBJECTS = psgui.o main-fe.o helper.o interface.o support.o ps_resolv.o ps_database.o cards.o preferences.o setupdlg.o helpwindow.o
miniclient_OBJECTS = miniclient.o
prismstumbler_OBJECTS =  main.o prismstumbler.o iface-wlan-14.o fxgps.o analyzer.o iface-scan.o iwlib.o

PIXMAPS = prism-icon4.png wlan-net.png stock_record.png stock_record_on.png stock_jump_on.png


ifeq ($(DEBUG),yes)
CFLAGS += -DDEBUG -g
else
CFLAGS += -O2 -Os -fomit-frame-pointer
endif

CFLAGS += -DVERSION=\"$(VERSION)\" -DPREFIX=\"$(PREFIX)\" -D_GNU_SOURCE -DPACKAGE=\"$(PACKAGE)\" 
CFLAGS += -DPACKAGE_LOCALE_DIR=\"$(PREFIX)/share/locale\" -I../include

CPPFLAGS += -I.

GTKCFLAGS = `pkg-config --cflags gtk+-2.0 gdk-pixbuf-2.0` 
GTKLDFLAGS += `pkg-config --libs gtk+-2.0 gdk-2.0` `pkg-config --libs gthread-2.0`

# setup how to compile
ifeq ($(NATIVE),yes)

STRIP=strip
CC=gcc

CFLAGS +=  -Wall

else # we do cross-compile...

CC=arm-linux-gcc
STRIP=arm-linux-strip

# CFLAGS +=  -Wall -I/skiff/local/arm-linux/include
LDFLAGS += -L/skiff/local/arm-linux/lib -L/skiff/local/arm-linux/lib/X11  
GTKLDFLAGS += -lgmodule-2.0 -ldl -lXinerama
GTKLDFLAGS += -lX11 -lXext -lXrender -lgdk-x11-2.0
LDFLAGS += -lm

endif #native or cross-compile

ifeq ($(WLAN_NG),yes)
prismstumbler_LDADD += wlanctl/wlanctl.a
CFLAGS += -DWLAN_NG 
endif

MEMBERS  = main 

OBJS = $(patsubst %,%.o,$(MEMBERS))
DEPS = $(patsubst %,%.d,$(MEMBERS))
SOURCES = $(patsubst %,%.c,$(MEMBERS))


${SUBDIR}:
	cd $@; make ${CFLAGS} PREFIX=${PREFIX} DESTDIR=${DESTDIR}

all: ${SUBDIR} ${bin_PROGRAMS}

prismstumbler: $(prismstumbler_OBJECTS) $(prismstumbler_DEPENDENCIES)
	@rm -f prismstumbler
	$(CC) -g -o $@ $(LDFLAGS) $(prismstumbler_OBJECTS) $(prismstumbler_LDADD) 

miniclient: $(miniclient_OBJECTS)
	@rm -f miniclient
	$(CC) -g -o $@ $(LDFLAGS) $(miniclient_OBJECTS) $(miniclient_LDADD) 

CFLAGS += $(GTKCFLAGS)
	
psfront: $(psfront_OBJECTS)
	@rm -f psfront
	$(CC) -g -o $@ $(LDFLAGS) $(psfront_LDADD) $(GTKLDFLAGS) $(psfront_OBJECTS)

CFLAGS += $(MIMECFLAGS)

#installs all
install-program: $(bin_PROGRAMS)
	mkdir -p $(DESTDIR)/$(PREFIX)/bin
	$(INSTALL) $(bin_PROGRAMS) $(DESTDIR)$(PREFIX)/bin/
	for i in $(bin_PROGRAMS); do $(STRIP) $(DESTDIR)$(PREFIX)/bin/$$i; done	
	mkdir -p $(DESTDIR)$(PREFIX)/share/pixmaps
	for i in $(PIXMAPS); do install -m 644 -D pixmaps/$$i $(DESTDIR)$(PREFIX)/share/pixmaps/$$i; done
	mkdir -p $(DESTDIR)$(PREFIX)/share/applications
	$(INSTALL) -m 644 familiar/*.desktop $(DESTDIR)$(PREFIX)/share/applications
	$(INSTALL) -m 644 ../doc/help.txt  $(DESTDIR)$(PREFIX)/share/doc/prismstumbler

install-backend: prismstumbler
	mkdir -p $(DESTDIR)/$(PREFIX)/bin
	$(INSTALL) prismstumbler $(DESTDIR)$(PREFIX)/bin/
	$(STRIP) $(DESTDIR)$(PREFIX)/bin/prismstumbler	
	
install-frontend: psfront
	mkdir -p $(DESTDIR)/etc
	$(INSTALL) -m 644 manufacturers.dat.gz $(DESTDIR)/etc
	mkdir -p $(DESTDIR)/$(PREFIX)/bin
	$(INSTALL) psfront $(DESTDIR)$(PREFIX)/bin/
	$(INSTALL) familiar/pst $(DESTDIR)$(PREFIX)/bin/
	$(STRIP) $(DESTDIR)$(PREFIX)/bin/psfront
	mkdir -p $(DESTDIR)$(PREFIX)/share/pixmaps
	for i in $(PIXMAPS); do install -m 644 -D pixmaps/$$i $(DESTDIR)$(PREFIX)/share/pixmaps/$$i; done
	mkdir -p $(DESTDIR)$(PREFIX)/share/applications
	$(INSTALL) -m 644 familiar/*.desktop $(DESTDIR)$(PREFIX)/share/applications
	mkdir -p  $(DESTDIR)$(PREFIX)/share/doc/prismstumbler
	$(INSTALL) -m 644 ../doc/help.txt $(DESTDIR)$(PREFIX)/share/doc/prismstumbler/
	
clean:
	rm -f $(bin_PROGRAMS) $(OBJS) *~ */*~ *.ipk *.o

install: install-program
 
ipkg: ipkg-frontend ipkg-backend

ipkg-backend: clean
	rm -rf familiar/dist
	mkdir -p familiar/dist/CONTROL
	sed 's:VERSION:$(VERSION):' < familiar/$(CONTROL) > familiar/dist/CONTROL/control
	if test -e familiar/conffiles; then install -m 644 familiar/conffiles familiar/dist/CONTROL; fi
	if test -e familiar/preinst;   then install familiar/preinst   familiar/dist/CONTROL; fi
	if test -e familiar/postinst;  then install familiar/postinst  familiar/dist/CONTROL; fi
	if test -e familiar/prerm;     then install familiar/prerm     familiar/dist/CONTROL; fi
	if test -e familiar/postrm;    then install familiar/postrm    familiar/dist/CONTROL; fi
	$(MAKE) DESTDIR=`pwd`/familiar/dist PREFIX=/usr prefix=/usr DEBUG=no install-backend
	ipkg-build familiar/dist
	mv *.ipk ..

ipkg-frontend: clean
	rm -rf familiar/dist
	mkdir -p familiar/dist/CONTROL
	sed 's:VERSION:$(VERSION):' < familiar/$(CONTROL-FE) > familiar/dist/CONTROL/control
	if test -e familiar/conffiles-fe; then install -m 644 familiar/conffiles familiar/dist/CONTROL; fi
	if test -e familiar/preinst;   then install familiar/preinst   familiar/dist/CONTROL; fi
	if test -e familiar/postinst-fe;  then install familiar/postinst  familiar/dist/CONTROL; fi
	if test -e familiar/prerm;     then install familiar/prerm     familiar/dist/CONTROL; fi
	if test -e familiar/postrm;    then install familiar/postrm    familiar/dist/CONTROL; fi
	$(MAKE) DESTDIR=`pwd`/familiar/dist PREFIX=/usr prefix=/usr DEBUG=no install-frontend
	ipkg-build familiar/dist
	mv *.ipk ..
