//
//  MyDocument.h
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2003 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import <AppKit/AppKit.h>
#import "PRWindowController.h"
#import "PRGrayscaleFilter.h"
#import "PRConvolve55.h"
#import "PRTransforms.h"
#import "PRFourier.h"
#import "PRDFTLowPass.h"
#import "PRDFTHighPass.h"
#import "PREqualize.h"
#import "PRTraceEdges.h"
#import "PRCustTraceEdges.h"
#import "PRMedian.h"

@interface MyDocument : NSDocument
{
    PRWindowController *windowController;
    NSImage *activeImage;
}

- (NSImage *) activeImage;
- (void)makeGrayscale :(id)sender;
- (void)makeDFT :(id)sender;
- (void)makeDFTLowPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq;
- (void)makeDFTHighPass :(BOOL)autoRange :(float) bandPassFreq :(float) bandStopFreq;
- (void)makeConvolve55 :(int[5][5])mat :(int)offset :(float)scale :(BOOL)autoScale;
- (void)makeTransposed :(id)sender;
- (void)makeRotated90 :(id)sender;
- (void)makeRotated180 :(id)sender;
- (void)makeRotated270 :(id)sender;
- (void)makeFlippedVert :(id)sender;
- (void)makeFlippedHoriz :(id)sender;
- (void)makeEqualization :(id)sender;
- (void)makeTraceEdges :(int)filterType :(BOOL)useTh :(float)thLev :(BOOL)doZeroC;
- (void)makeCustTraceEdges;
- (void)makeMedian :(enum medianForms)form :(int)size :(BOOL)sep;

@end
