//
//  PRCCrop.m
//  PRICE
//
//  Created by Riccardo Mottola on Fri Jan 28 2005.
//  Copyright (c) 2005 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRCCrop.h"
#import "MyDocument.h"

@implementation PRCCrop

- (IBAction)showCrop:(id)sender
{
    if (!cropWindow)
        [NSBundle loadNibNamed:@"Crop" owner:self];
    [cropWindow makeKeyAndOrderFront:nil];
    origWidth = [[[[NSDocumentController sharedDocumentController] currentDocument] activeImage] width];
    origHeight = [[[[NSDocumentController sharedDocumentController] currentDocument] activeImage] height];
    [self updateSize];
}

- (IBAction)cropOK:(id)sender
{
    [[[NSDocumentController sharedDocumentController] currentDocument]
        makeCrop :[topField intValue]
                 :[bottomField intValue]
                 :[leftField intValue]
                 :[rightField intValue]
        ];
    
    if ([[NSApp delegate] prefClosePanels])
        [cropWindow performClose:nil];
}

- (IBAction)cropCancel:(id)sender
{
    [cropWindow performClose:nil];
}

- (IBAction)changeTop:(id)sender
{
    [self updateSize];
}

- (IBAction)changeBottom:(id)sender
{
    [self updateSize];
}

- (IBAction)changeLeft:(id)sender
{
    [self updateSize];
}

- (IBAction)changeRight:(id)sender
{
    [self updateSize];
}

- (IBAction)resetValues:(id)sender
{
    [topField setIntValue:0];
	[bottomField setIntValue:0];
	[leftField setIntValue:0];
	[rightField setIntValue:0];
    [self updateSize];
}

- (void)updateSize
{
    [widthField setIntValue:(origWidth - [rightField intValue] - [leftField intValue])];
    [heightField setIntValue:(origHeight - [topField intValue] - [bottomField intValue])];
}

@end
