/* $Cambridge: hermes/src/prayer/lib/template.h,v 1.4 2008/09/16 09:59:57 dpc22 Exp $ */

/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

typedef enum {
    TEMPLATE_ITEM_LINES,
    TEMPLATE_ITEM_IFDEF,
    TEMPLATE_ITEM_IFEQ,
    TEMPLATE_ITEM_FOREACH,
    TEMPLATE_ITEM_LOOP,
    TEMPLATE_ITEM_CALL,
} TEMPLATE_ITEM_TYPE;

/* Any changes to the following must be mirrored in template_compile */

struct template_map_index {
    char *name;
    struct template_map *template_map;
    unsigned long *count;
};

struct template_map {
    char *name;
    struct template *template;
};

struct template {
    char *name;
    struct template_item *head;
    struct template_item *tail;
    unsigned long count;
    struct template_item *tree;
    struct str *error;
};

struct template_item {
    unsigned long number;
    struct template_item *list_next;
    struct template_item *tree_next;
    TEMPLATE_ITEM_TYPE type;
    /* ... */
};

struct template_lines {
    unsigned long number;
    struct template_item *list_next;
    struct template_item *tree_next;
    TEMPLATE_ITEM_TYPE type;
    char **first;
    int count;
};

struct template_ifdef {
    unsigned long number;
    struct template_item *list_next;
    struct template_item *tree_next;
    TEMPLATE_ITEM_TYPE type;
    BOOL positive;
    char *expr;
    struct template_item *true_block;
    struct template_item *false_block;
};

struct template_ifeq {
    unsigned long number;
    struct template_item *list_next;
    struct template_item *tree_next;
    TEMPLATE_ITEM_TYPE type;
    BOOL positive;
    char *name;
    char *value;
    struct template_item *true_block;
    struct template_item *false_block;
};

struct template_foreach {
    unsigned long number;
    struct template_item *list_next;
    struct template_item *tree_next;
    TEMPLATE_ITEM_TYPE type;
    char *name;
    char *array;
    struct template_item *block;
};

struct template_loop {
    unsigned long number;
    struct template_item *list_next;
    struct template_item *tree_next;
    TEMPLATE_ITEM_TYPE type;
    char *var;
    struct template_item *block;
};

struct template_call {
    unsigned long number;
    struct template_item *list_next;
    struct template_item *tree_next;
    TEMPLATE_ITEM_TYPE type;
    char *name;
    char *params;
};

char *
template_gettoken(char **sp, struct pool *pool);

char *
template_getvar(char **sp, char *quotep, struct pool *pool);

char *
template_getlist(char **sp, struct pool *pool);

char *
template_getexpr(char **sp, struct pool *pool);

/* Temporary public, eventually static */
char *
template_parse_read_file(char *filename, struct pool *pool);

/* Temporary public, eventually static */
char **
template_parse_split_lines(char *s, struct pool *pool);

struct template *template_parse(char *dir, char *set,
                                char *name, struct pool *pool);

BOOL
template_expand(char *name,struct template_vals *tvals, struct buffer *b);

BOOL
template_compile(char *prefix, struct template *template, FILE *file);

struct template *
template_find(char *set, char *name, struct pool *pool);

