/* $Cambridge: hermes/src/prayer/cmd/cmd_add_address.c,v 1.3 2008/09/16 09:59:55 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

/* Used by abook search */

void cmd_add_address(struct session *session)
{
    struct request *request = session->request;
    struct draft *draft = session->draft;
    char *back, *field, *name, *email;
    char *tmp;

    if (!draft->have_draft)     /* Impossible? */
        draft_init(draft);

    if (request->argc < 5) {
        session_redirect(session, request, "error");
        return;
    }

    back = request->argv[1];
    field = request->argv[2];
    name = request->argv[3];
    email = request->argv[4];

    string_canon_decode(name);
    string_canon_decode(email);

    tmp = abook_text_to_string(request->pool, name, email);
    tmp = string_trim_whitespace(tmp);

    if (!strcmp(field, "To")) {
        draft_add_to(draft, tmp);
        session_message(session, "Added to To header: %s", tmp);
    } else if (!strcmp(field, "Cc")) {
        draft_add_cc(draft, tmp);
        session_message(session, "Added to Cc header: %s", tmp);
    } else if (!strcmp(field, "Bcc")) {
        draft_add_bcc(draft, tmp);
        session_message(session, "Added to Bcc header: %s", tmp);
    }

    session_redirect(session, request, back);
}
