/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *      Parts copyright 2003 John Knottenbelt, taken from dvbd-0.7.7       *
 *                      2005 Stefan Seyfried                               *
 *                                                                         *
 *               Author(s): John Knottenbelt                               *
 *                          Stefan Seyfried                                *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#include "config.h"
#include "stringutil.h"
#include <cctype>
#include <sstream>
#include <cstdio>

using namespace std;

string lowercase(const string & s)
{
	string l(s.size(), 0);
	for (unsigned i = 0; i < s.size(); i++)
		l[i] = tolower(s[i]);
	return l;
}

string toString(bool b)
{
	if (b)
		return "true";
	else
		return "false";
}

string toString(int n)
{
	char text[64];
	sprintf(text, "%d", n);
	return text;
}

string toString(unsigned n)
{
	char text[64];
	sprintf(text, "%u", n);
	return text;
}

string toString(double n)
{
	ostringstream output;
	output << n;
	return output.str();
}

double toDouble(const string & s)
{
	istringstream input(s);
	double n;

	if (input >> n)
		return n;
	else
		return 0.0;
}

bool toBool(const std::string & s)
{
	if (s == "true")
		return true;
	else
		return false;
}

unsigned long toUnsignedLong(const std::string & s)
{
	istringstream input(s);
	unsigned long n;

	if (input >> n)
		return n;
	else
		return 0;
}

int toPosInt(const std::string & s)
{
	istringstream input(s);
	int n;

	if (input >> n)
		return n;
	else
		return -1;
}

unsigned toUnsigned(const std::string & s)
{
	istringstream input(s);
	unsigned n;

	if (input >> n)
		return n;
	else
		return 0;
}

void splitString(const std::string & s, char delim, std::vector < std::string > &v)
{
	std::string::size_type pos = 0;
	while (true) {
		std::string::size_type next = s.find(delim, pos);
		v.push_back(s.substr(pos, next - pos));
		if (next == std::string::npos)
			break;
		pos = next + 1;
	}
}

std::string stripTrailingWS(const std::string & s)
{
	if (s.size() == 0)
		return "";

	int last = s.size() - 1;
	while (last >= 0 && isspace(s[last]))
		last--;

	return s.substr(0, last + 1);
}

std::string stripLeadingWS(const std::string & s)
{
	std::string::size_type leadingWS = s.find_first_not_of(" \t");
	if (leadingWS != std::string::npos)
		return s.substr(leadingWS, std::string::npos);
	else
		return s;
}

std::string stripLineComment(const std::string & s, char delim)
{
	std::string::size_type commentPos = s.find(delim);
	return s.substr(0, commentPos);
}

std::string stripApostrophe(const std::string & s)
{
	std::string::size_type apo = s.find_first_not_of("'\"");
	int last = s.size() - 1;
	if ((s[last] == '\'') || (s[last] == '\"'))
		last--;
	if (apo != std::string::npos)
		return s.substr(apo, last);
	else
		return s.substr(0, last);
}
