#! /bin/sh

# Copyright (C) 2001-2007 Peter Selinger.
# This file is part of Potrace. It is free software and it is covered
# by the GNU General Public License. See the file COPYING for details.

# If ghostscript is present, we attempt to render the postscript
# output and check it for accuracy.

if test -z "$srcdir"; then
    srcdir=.
fi

. "$srcdir/missing.sh"

GS=`my_which ghostscript`
if test -z "$GS"; then
    GS=`my_which gs`
fi
if test -z "$GS"; then
    echo "Don't have ghostscript, ignoring postscript test." >& 2
    exit 77
fi

NAME=`basename "$0"`

POTRACE="../src/potrace --progress"
PGMDIFF=./pgmdiff
TMPDIR="${TEMPDIR:-/tmp}"
TMP1=`mktemp "$TMPDIR/$NAME-1.XXXXXX"`
TMP2=`mktemp "$TMPDIR/$NAME-2.XXXXXX"`
DATA="$srcdir/data1.pbm"
REFDATA="$srcdir/data1.pbm.gs"
REFDATAROT="$srcdir/data1.pbm.rot"

# run the command, expecting return value 0
action () {
    "$@"
    if test $? -ne 0; then
	echo "$NAME: test failed" >& 2
	echo "Failed command: $LINE: $@" >& 2
	exit 1
    fi
}

actiondiff () {
    D=`action "$PGMDIFF" "$1" "$2"`
    # check return value because subshell can't exit
    if test $? -ne 0; then 
	exit 1; 
    fi
    echo "Difference: $D" >& 2
    if test "$D" -gt "$3"; then
	echo "$NAME: test failed" >& 2
	echo "Failed command: $LINE: $PGMDIFF $1 $2" >& 2
	exit 1;
    fi
}

# keep track of line numbers
alias action="LINE=\$LINENO; action"
alias actiondiff="LINE=\$LINENO; actiondiff"

action $POTRACE -r50 -p -L 0 -B 0 -o "$TMP1" "$DATA"
"$GS" -q -dNOPAUSE -sDEVICE=pbmraw -g460x394 -r100x100 -sOutputFile="$TMP2" -- "$TMP1"
if test $? -ne 0; then
    echo "Something is wrong with $GS; skipping this test" >& 2
    exit 77
fi 
actiondiff "$TMP2" "$REFDATA" 1000

action $POTRACE -r50 -p -L 0 -B 0 --opaque -o "$TMP1" "$DATA"
action "$GS" -q -dNOPAUSE -sDEVICE=pbmraw -g460x394 -r100x100 -sOutputFile="$TMP2" -- "$TMP1"
actiondiff "$TMP2" "$REFDATA" 1200

action $POTRACE -r50 -p -L 0 -B 0 -A 160 -o "$TMP1" "$DATA"
action "$GS" -q -dNOPAUSE -sDEVICE=pbmraw -g568x528 -r100x100 -sOutputFile="$TMP2" -- "$TMP1"
actiondiff "$TMP2" "$REFDATAROT" 1200

action rm -f "$TMP1"
action rm -f "$TMP2"

echo "$NAME: test succeeded" >& 2
exit 0
