/*                              
Service_Calendar.cc
*/

#include "Service_Calendar.h"
#include "DateTimeUtils.h"
#include "ClientDB.h"

extern Language *L;
extern Configuration *Conf;
extern CCLIENT *cclient;
extern Skin *skin;
extern TBuffer BasePath;

#define CLENGTH_TITLE_DISPLAY 80

#define CMODE_MODIFY 0
#define CMODE_CREATE 1

bool Service_Calendar_Initialized = false;
int workingYear, workingMonth, workingDay, workingWeek, workingHour, initweek;
bool BeginWeekOnSunday = false;

TBuffer dbcalfilename;
ClientDB *CDBCal = NULL;

class HTMLPages: public HTMLBasic
  {
  private:
    void PrintStatusLine_Calendar (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname);
    void BotoneraComun_Calendar (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo);
    void LowerBar (TProgData *pd, int lastcmd);
  public:
    void PrintCalendarYearShow (TProgData *pd);    
    void PrintCalendarMonthShow (TProgData *pd);    
    void PrintCalendarWeekShow (TProgData *pd);
    void PrintCalendarDayShow (TProgData *pd);    
    void PrintCalendarEventsModify (TProgData *pd, int mode);        
    };

void HTMLPages::PrintStatusLine_Calendar (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname)
  {
  WRITE ("<TABLE width=\"100%%\">\n<TR>\n");
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    TBuffer amsg;
    GetBufferFromFile (FILE_FOR_NO_ACCEPT_NEW_CONNS, amsg, CMAXBUFFER);
    WRITE ("<TD align=left><B><FONT color=\"#FF0000\"><BLINK>%s</BLINK></FONT></B></TD>\n<TD align=right><B><FONT size=2 color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
              amsg, skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
              L->get(L_USER), user, uo->getImapServer(), 
              mailboxname);
    }
  else
    {
    if (cclient->getError () == false)
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             uo->getStatusLine(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }
    else
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             cclient->getErrorString(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }  
    }
  
  //Only is seen in IE4+/N6+
  if ((displayClock == true) && (uo->get_use_javascript() == true) && (uo->getShowClock() == true))
    {        
    WRITE ("<TD width=\"1%%\" align=right>");  
    JavaScript (DEF_JavaScriptIDClock);    
    JavaScript (DEF_JavaScriptClock);
    WRITE ("</TD>"); 
    }

  WRITE ("\n</TR></TABLE>\n");
  }

void HTMLPages::BotoneraComun_Calendar (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));
    
      //BUTTON BACK  
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");        
      WRITE ("%s", uo->getLastStringCmd(cmdactual, lang, connid, true));                   
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize()); 
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();

      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_CALENDAR_MONTH_SHOW: 
        case CMD_CALENDAR_WEEK_SHOW:         
        case CMD_CALENDAR_DAY_SHOW:         
             {       
             WRITE ("<A HREF=\"%s/%s/help/calendar_show/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CALENDAR, lang, user, connid, validator, pageid, cmdactual); break; 
             }
        }
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());  
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      
      //SPACE 
      EmptyCellx2();     
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD(); 
    EndTR();
  EndTable ();  
  PrintStatusLine_Calendar (user, uo, true, cclient->getMailboxName());
  }

//retrieve the url for the Service icon
const char *GetService_Calendar_ICO_URL (void)
  {
  return skin->getI(L_CALENDAR);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Calendar_ICO_ALT (void)
  {
  return L->get(L_CALENDAR);
  }

//Retrieve the Service name
const char *GetService_Calendar_NAME (void)
  {
  return L->get(L_CALENDAR);
  }

//Retrieve the Service Description
const char *GetService_Calendar_DESCRIPTION (void)
  {
  return L->get(L_CALENDAR_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Calendar_BEGIN (TProgData *pd)
  {
  TBuffer file2show, dbtmpcalfilename, dbtemplateuser;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  
  if (Service_Calendar_Initialized == true) {return true;}
  Service_Calendar_Initialized = false;
  LOG ("Initializating Service Calendar for user=%s", pd->username);      

  BeginWeekOnSunday = false;
  workingYear  = CurrentYear ();
  workingMonth = CurrentMonth ();
  workingDay   = CurrentDay ();
  workingWeek  = CurrentWeek ();
    
  Service_Calendar_Initialized = true; 
  
  xstrncpy (dbcalfilename, CMAXBUFFER, USERCALENDAR);      
  ReturnFileCalendarTemplateUser(dbtemplateuser);
  xsnprintf (dbtmpcalfilename, CMAXBUFFER, "%s/%s", pd->uo->getUserDir(), USERCALENDAR);   
  if (FileExists (dbtmpcalfilename) == false) {CopyFile (dbtemplateuser, dbtmpcalfilename);} 
  if (CDBCal != NULL)
    {
    CDBCal->DBclose();
    delete CDBCal; 
    CDBCal = NULL;         
    }
  CDBCal = new ClientDB (dbcalfilename, pd->uo->getUserDir(), false, false);
  if (CDBCal->DBopen () == false) 
    {
    pd->html->ErrorPage(CDBCal->getErrorMsg());
    }
   
  return true;
  }

//Entry point to service end
bool DoService_Calendar_END (TProgData *pd)
  {
  if (Service_Calendar_Initialized == false) {return true;}  
  Service_Calendar_Initialized = false;
  CDBCal->DBclose();
  delete CDBCal;        
  return true;
  }

//Entry point to execute a service command
bool DoService_Calendar_CMD (TProgData *pd)
  {
  HTMLPages *html;
  int cmd;
  TBuffer buffnum;

  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  cmd = pd->cmd;

  cgienv_GetSimpleVarDef (pd->envfile, "year", buffnum, ""); workingYear = xatoidef (buffnum, CurrentYear ());
                
  switch (pd->cmd)
    {
    case (CMD_CALENDAR_YEAR_SHOW):   
      {
      if (!IsEmpty (pd->parm1)) 
        {
        workingYear = xatoidef (pd->parm1, CurrentYear ());
        if (workingYear == 1) {workingYear  = CurrentYear ();}
        } 
      pd->uo->InitStatusLine (); 
      html->PrintCalendarYearShow (pd); 
      break;
      }       
    case (CMD_CALENDAR_MONTH_SHOW):  
      {
      workingYear  = xatoidef (pd->parm1, CurrentYear ());
      workingMonth = xatoidef (pd->parm2, CurrentMonth ());
      pd->uo->InitStatusLine (); 
      html->PrintCalendarMonthShow (pd); 
      break;
      }      
    case (CMD_CALENDAR_WEEK_SHOW):   
      {
      workingYear  = xatoidef (pd->parm1, CurrentYear ());
      workingMonth = xatoidef (pd->parm2, CurrentMonth ());
      workingWeek  = xatoidef (pd->parm3, CurrentWeek ());
      initweek     = xatoidef (pd->parm4, 1);        
      pd->uo->InitStatusLine (); 
      html->PrintCalendarWeekShow (pd); 
      break;
      }      
    case (CMD_CALENDAR_TODAY):    
      {
      workingYear  = CurrentYear ();
      workingMonth = CurrentMonth ();
      workingDay   = CurrentDay ();
      pd->uo->InitStatusLine (); 
      html->PrintCalendarDayShow (pd); 
      break;
      }             
    case (CMD_CALENDAR_TOMORROW):    
      {
      workingYear  = CurrentYear ();
      workingMonth = CurrentMonth ();
      workingDay   = CurrentDay ();
      NextDay (&workingDay, &workingMonth, &workingYear);
      pd->uo->InitStatusLine (); 
      html->PrintCalendarDayShow (pd); 
      break;
      }                         
    case (CMD_CALENDAR_YESTERDAY):    
      {
      workingYear  = CurrentYear ();
      workingMonth = CurrentMonth ();
      workingDay   = CurrentDay ();
      PrevDay (&workingDay, &workingMonth, &workingYear);
      pd->uo->InitStatusLine (); 
      html->PrintCalendarDayShow (pd); 
      break;
      }                               
    case (CMD_CALENDAR_DAY_SHOW):    
      {
      if (IsEmpty (pd->parm1)) {cgienv_GetSimpleVarDef (pd->envfile, "year", buffnum, "");  workingYear = xatoidef (buffnum, CurrentYear ());}
      else {workingYear  = xatoidef (pd->parm1, CurrentYear ());}
      if (IsEmpty (pd->parm2)) {cgienv_GetSimpleVarDef (pd->envfile, "month", buffnum, "");  workingMonth = xatoidef (buffnum, CurrentMonth ());}
      else {workingMonth = xatoidef (pd->parm2, CurrentMonth ());}
      if (IsEmpty (pd->parm3)) {cgienv_GetSimpleVarDef (pd->envfile, "day", buffnum, "");  workingDay = xatoidef (buffnum, CurrentDay ());}
      else {workingDay   = xatoidef (pd->parm3, CurrentDay ());}      
      pd->uo->InitStatusLine (); 
      html->PrintCalendarDayShow (pd); 
      break;
      }  
    case (CMD_CALENDAR_EVENTS_MODIFY):
      {
      workingYear   = xatoidef (pd->parm1, CurrentYear ());
      workingMonth  = xatoidef (pd->parm2, CurrentMonth ());
      workingDay    = xatoidef (pd->parm3, CurrentDay ());      
      workingHour   = xatoidef (pd->parm4, 7);            
      pd->uo->InitStatusLine (); 
      html->PrintCalendarEventsModify (pd, CMODE_MODIFY); 
      break;
      }                        
    case (CMD_CALENDAR_EVENTS_CREATE): 
      {
      workingYear   = xatoidef (pd->parm1, CurrentYear ());
      workingMonth  = xatoidef (pd->parm2, CurrentMonth ());
      workingDay    = xatoidef (pd->parm3, CurrentDay ());      
      workingHour   = xatoidef (pd->parm4, 7);            
      pd->uo->InitStatusLine (); 
      html->PrintCalendarEventsModify (pd, CMODE_CREATE); 
      break;
      }        
    case (CMD_CALENDAR_EVENTS_ADD):  
      {
      TUniqId uniqid;
      bool b, festivos;
      int horasdesde, beginday, beginmonth, beginyear, endday, endmonth, endyear, hour;
            
      cgienv_GetSimpleVarDef (pd->envfile, "beginday", buffnum, "");   beginday = xatoidef (buffnum, CurrentDay ());
      cgienv_GetSimpleVarDef (pd->envfile, "beginmonth", buffnum, ""); beginmonth = xatoidef (buffnum, CurrentMonth ());
      cgienv_GetSimpleVarDef (pd->envfile, "beginyear", buffnum, "");  beginyear = xatoidef (buffnum, CurrentYear ());
      cgienv_GetSimpleVarDef (pd->envfile, "endday", buffnum, "");     endday = xatoidef (buffnum, CurrentDay ());
      cgienv_GetSimpleVarDef (pd->envfile, "endmonth", buffnum, "");   endmonth = xatoidef (buffnum, CurrentMonth ());
      cgienv_GetSimpleVarDef (pd->envfile, "endyear", buffnum, "");    endyear = xatoidef (buffnum, CurrentYear ());
      cgienv_GetSimpleVarDef (pd->envfile, "hour", buffnum, "");       hour = xatoidef (buffnum, 7);      
      festivos = cgienv_GetEntryBool (pd->envfile, "festivos");

      pd->uo->InitStatusLine ();                                                                            
      horasdesde = (long)(makeUnixDate (beginday, beginmonth, beginyear) / 3600);  
      horasdesde += hour;
      CDBCal->generaIDFromPos (horasdesde, uniqid);
      b = CDBCal->SaveRecordFixedIdFromCGI (pd->envfile, uniqid);
      if (b == false)
        {
        pd->html->ErrorPage(CDBCal->getErrorMsg());
        }
      else
        {   
        if (pd->uo->getLastCmd() == CMD_CALENDAR_DAY_SHOW)
          {
          html->PrintCalendarDayShow (pd); 
          }
        else if (pd->uo->getLastCmd() == CMD_CALENDAR_WEEK_SHOW)
          {
          html->PrintCalendarWeekShow (pd); 
          }          
        else
          {
          html->PrintCalendarDayShow (pd);
          }
        }
      break;      
      }      
    case (CMD_CALENDAR_EVENTS_DELETE):    
      {
      StringList *SL;
      int contborr;
      TBuffer abuf;
      
      SL = new StringList();
      SL->Add (pd->parm1);
      contborr = CDBCal->deleteRecordsByID (SL);
      if (contborr == 0)      {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSPURGED_0), contborr);}
      else if (contborr == 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSPURGED), contborr);}
      else                    {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_RECORDSPURGED_S), contborr);}
      pd->uo->setStatusLine (abuf, BLUE);
      html->PrintCalendarDayShow (pd);
      delete SL; 
      break;
      }               
    default: 
      {    
      //pd->html->dumpFile (pd->envfile, "TEXT/PLAIN");      
      LOG ("ERROR: Service_Calendar: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }         
    }
  return false;  
  }  

void HTMLPages::LowerBar (TProgData *pd, int lastcmd)
  {
  int year, month, day;
  TNumber anum;
  StringList SLItems;                         

  Linea();

  WRITE ("<TABLE WIDTH=100%%>\n"); 
  WRITE ("<TR>\n"); 

  WRITE ("<TD WIDTH=1%%>\n");  
  BeginFormPost ("PrintCalendarToday", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "today");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", lastcmd);  
  FormButton ("today", L->get(L_TODAY)); 
  EndForm ();
  WRITE ("</TD>\n");                   
  WRITE ("<TD WIDTH=1%%>\n");  
  BeginFormPost ("PrintCalendarTomorrow", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "tomorrow");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_YEAR_SHOW);  
  FormButton ("today", L->get(L_TOMORROW)); 
  EndForm ();  
  WRITE ("</TD>\n");                   
  WRITE ("<TD WIDTH=1%%>\n");  
  BeginFormPost ("PrintCalendarYesterday", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "yesterday");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_YEAR_SHOW);  
  FormButton ("today", L->get(L_YESTERDAY)); 
  EndForm ();  
  WRITE ("</TD>\n"); 
  WRITE ("<TD>&nbsp;</TD>\n");                   
  WRITE ("<TD>\n");  
  BeginFormPost ("PrintCalendarChangeDay", PATH_CGI);
  FormButton ("year_show", L->get(L_DAY));
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "day_show");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_YEAR_SHOW);  
  FormBeginSelect ("PrintCalendarDayShow1", "day", NULL, pd->uo->get_use_javascript()); 
  SLItems.Clear();
  for (int i = 0; i <= 30; ++i) {SLItems.Add (xitoa(i+1, anum));}
  for (int i = 0; i < SLItems.Count(); ++i)
    {
    day = i;
    if (day + 1 == workingDay) FormAddOptionSelect (true,  SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
    else FormAddOptionSelect (false, SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
    } 
  FormEndSelect();  
  FormBeginSelect ("PrintCalendarMonthShow1", "month", NULL, pd->uo->get_use_javascript()); 
  SLItems.Clear();
  for (int i = 0; i < NUMBER_MONTHS; ++i) {SLItems.Add (getLongMonth(i));}
  for (int i = 0; i < SLItems.Count(); ++i)
    {
    month = i;
    if (month == workingMonth) FormAddOptionSelect (true,  xitoa (i, anum), SLItems.getString(i).cstr());
    else FormAddOptionSelect (false, xitoa (i, anum), SLItems.getString(i).cstr());
    } 
  FormEndSelect();    
  FormBeginSelect ("PrintCalendarYearShow1", "year", NULL, pd->uo->get_use_javascript()); 
  SLItems.Clear();
  for (int i = workingYear - 10; i < workingYear + 10; ++i) {SLItems.Add (xitoa(i, anum));}
  for (int i = 0; i < SLItems.Count(); ++i)
    {
    year = xatoidef (SLItems.getString(i).cstr(), 0);
    if (year == workingYear) FormAddOptionSelect (true,  SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
    else FormAddOptionSelect (false, SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
    } 
  FormEndSelect();  
  EndForm ();
  WRITE ("</TD>\n");                      
  WRITE ("<TD>&nbsp;</TD>\n");                   
  WRITE ("<TD>\n");  
  BeginFormPost ("PrintCalendarChangeYear", PATH_CGI);
  FormButton ("year_show", L->get(L_YEAR));
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "year_show");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_YEAR_SHOW);  
  FormBeginSelect ("PrintCalendarYearShow1", "year", NULL, pd->uo->get_use_javascript()); 
  SLItems.Clear();
  for (int i = workingYear - 10; i < workingYear + 10; ++i) {SLItems.Add (xitoa(i, anum));}
  for (int i = 0; i < SLItems.Count(); ++i)
    {
    year = xatoidef (SLItems.getString(i).cstr(), 0);
    if (year == workingYear) FormAddOptionSelect (true,  SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
    else FormAddOptionSelect (false, SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
    } 
  FormEndSelect();  
  EndForm ();
  WRITE ("</TD>\n");  
  
  WRITE ("</TR>\n"); 
  WRITE ("</TABLE>\n"); 
  }

void HTMLPages::PrintCalendarYearShow (TProgData *pd)
  {
  TBuffer tmpbuf;
  long jul;
  int dow, begday, colpos, aYear;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CALENDAR_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Calendar (CMD_CALENDAR_YEAR_SHOW, pd->stlang, pd->username, pd->connid, pd->uo);  

  WRITE ("<TABLE WIDTH=100%%><TR>");
  aYear = workingYear; PrevYear (&aYear);
  sprintf (tmpbuf, "%s/%s/year_show/noop/%s/%s/%s/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                      aYear);                                                                                     
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_LEFT_ARROW), L->get(ALT_PREV));
  WRITE ("<TD ALIGN=center><FONT COLOR=\"#0000FF\">%s %d</FONT></TD>", L->get(L_YEAR), workingYear);
  aYear = workingYear; NextYear (&aYear);
  sprintf (tmpbuf, "%s/%s/year_show/noop/%s/%s/%s/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                      aYear); 
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_RIGHT_ARROW), L->get(ALT_NEXT));  
  WRITE ("</TR></TABLE>\n");


  BeginFormPost ("PrintCalendarYearShow", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "year_show");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_YEAR_SHOW);    
  BR();

  if (BeginWeekOnSunday == false) begday = 1; else begday = 0;
  WRITE ("<SMALL>\n");
  WRITE ("<TABLE WIDTH=100%%>\n");
  for (int i = 0; i < NUMBER_MONTHS; ++i)
    {
    if ((i == 0) || (i == 4) || (i == 8)) WRITE ("<TR>\n");
    WRITE ("<TD>\n");    
    sprintf (tmpbuf, "%s/%s/month_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                       workingYear, i);
    WRITE ("<CENTER><B><A HREF=\"%s\">%s</A></B></CENTER></BR>\n", tmpbuf, getLongMonth(i));
    WRITE ("<CENTER>\n");
    WRITE ("<TABLE>\n");  
    WRITE ("<TR>"); for (int j = 0; j < NUMBER_DAYSFORWEEK; ++j) {WRITE ("<TD><B>%s</B></TD>", getShortDay2(j + begday));} WRITE ("</TR>\n");    
    WRITE ("<TR>\n");
    jul = GregorianToJulian (1, i + 1, workingYear);
    dow = DayOfWeek (jul);
    colpos = 0;    
    for (int j = 0; j < DaysOfMonth(i, workingYear) + dow; ++j) 
      {
      ++colpos; 
      if (j < dow) 
        {
        WRITE("<TD>&nbsp;</TD>\n");
        } 
      else
        {
        sprintf (tmpbuf, "%s/%s/day_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd, workingYear, i, j - dow + 1);        
        if (IsMultiplo(j + begday, 7))
          {
          if (DateIsToday (j - dow + 1, i, workingYear) == true)
            {
            WRITE ("<TD align=right><SPAN class=\"classCalToday\"><A HREF=\"%s\">%d</A></SPAN></TD></TR><TR>", tmpbuf, j - dow + 1);
            }
          else
            {
            WRITE ("<TD align=right><SPAN class=\"classCalHoliday\"><A HREF=\"%s\">%d</A></SPAN></TD></TR><TR>", tmpbuf, j - dow + 1);
            }
          colpos = 0;                                                          
          }
        else
          {
          if (DateIsToday (j - dow + 1, i, workingYear) == true)
            {
            WRITE ("<TD align=right><SPAN class=\"classCalToday\"><A HREF=\"%s\">%d</A></SPAN></TD>", tmpbuf, j - dow + 1);
            }
          else
            {
            if (colpos == 6)
              {
              WRITE ("<TD align=right><SPAN class=\"classCalHoliday\"><A HREF=\"%s\">%d</A></SPAN></TD>", tmpbuf, j - dow + 1); 
              }
            else
              {     
              WRITE ("<TD align=right><SPAN class=\"classCalCurrent\"><A HREF=\"%s\">%d</A></SPAN></TD>", tmpbuf, j - dow + 1); 
              }
            }  
          }
        }
      }
    WRITE ("</TR>\n");      
    WRITE ("</TABLE>\n");                          
    WRITE ("</CENTER>\n");    
    if ((i == 3) || (i == 7) || (i == 11)) WRITE ("</TR>\n");
    }
  EndTable();
  WRITE ("</SMALL>\n");
  EndForm ();
  
  LowerBar(pd, CMD_CALENDAR_YEAR_SHOW);
  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
                                                         
void HTMLPages::PrintCalendarMonthShow (TProgData *pd)
  {
  long jul;
  int dow, begday, colpos, NW, aYear, aMonth;
  StringList SLYears;
  TBuffer tmpbuf;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CALENDAR_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Calendar (CMD_CALENDAR_MONTH_SHOW, pd->stlang, pd->username, pd->connid, pd->uo);  

  WRITE ("<TABLE WIDTH=100%%><TR>");
  aYear = workingYear; aMonth = workingMonth; PrevMonth (&aMonth, &aYear);
  sprintf (tmpbuf, "%s/%s/month_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                      aYear, aMonth);                                                                                     
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_LEFT_ARROW), L->get(ALT_PREV));
  WRITE ("<TD ALIGN=center><FONT COLOR=\"#0000FF\">%s %d</FONT></TD>", getLongMonth(workingMonth), workingYear);
  aYear = workingYear; aMonth = workingMonth; NextMonth (&aMonth, &aYear);
  sprintf (tmpbuf, "%s/%s/month_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                      aYear, aMonth); 
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_RIGHT_ARROW), L->get(ALT_NEXT));  
  WRITE ("</TR></TABLE>\n");

  BeginFormPost ("PrintCalendarMonthShow", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "year_show");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_MONTH_SHOW);    
  BR();

  if (BeginWeekOnSunday == false) begday = 1; else begday = 0;
  WRITE ("<CENTER>\n");
  WRITE ("<TABLE WIDTH=100%%>\n");  
    WRITE ("<TR>"); 
      WRITE ("<TD align=center><B>%s</B></TD>\n", L->get(L_WEEK));
      for (int j = 0; j < NUMBER_DAYSFORWEEK; ++j) {WRITE ("<TD align=center><B>%s</B></TD>", getShortDay2(j + begday));} 
    WRITE ("</TR>\n");    
  WRITE ("<TR>\n");
  jul = GregorianToJulian (1, workingMonth + 1, workingYear);
  dow = DayOfWeek (jul);
  colpos = 0;
  for (int j = 0; j < DaysOfMonth(workingMonth, workingYear) + dow; ++j) 
    {    
    ++colpos; 
    if (colpos == 1)
      {
      NW = NumberOfWeek(jul + j);
      sprintf (tmpbuf, "%s/%s/week_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                     workingYear, workingMonth, NW, j - dow + 1);
      WRITE("<TD align=center><FONT COLOR=\"#0000FF\"><A HREF=\"%s\">%d</A></FONT></TD>\n", tmpbuf, NW);
      }
    if (j < dow) 
      {
      WRITE("<TD>&nbsp;</TD>\n");
      } 
    else
      {
      sprintf (tmpbuf, "%s/%s/day_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                     workingYear, workingMonth, j - dow + 1);        
      if (IsMultiplo(j + begday, 7))
        {
        if (DateIsToday (j - dow + 1, workingMonth, workingYear) == true)
          {
          WRITE ("<TD align=center><SPAN class=\"classCalToday\"><A HREF=\"%s\">%d</A></SPAN></TD></TR><TR>", tmpbuf, j - dow + 1);
          }
        else
          {
          WRITE ("<TD align=center><SPAN class=\"classCalHoliday\"><A HREF=\"%s\">%d</A></SPAN></TD></TR><TR>", tmpbuf, j - dow + 1);
          }  
        colpos = 0;
        }
      else
        {
        if (DateIsToday (j - dow + 1, workingMonth, workingYear) == true)
          {
          WRITE ("<TD align=center><SPAN class=\"classCalToday\"><A HREF=\"%s\">%d</A></SPAN></TD>", tmpbuf, j - dow + 1);
          }
        else
          {
          if (colpos == 6)
            {
            WRITE ("<TD align=center><SPAN class=\"classCalHoliday\"><A HREF=\"%s\">%d</A></SPAN></TD>", tmpbuf, j - dow + 1); 
            }
          else
            {     
            WRITE ("<TD align=center><SPAN class=\"classCalCurrent\"><A HREF=\"%s\">%d</A></SPAN></TD>", tmpbuf, j - dow + 1); 
            }
          }  
        }
      }
    }
  WRITE ("</TR>\n");    
  WRITE ("</TABLE>\n");                              
  WRITE ("</CENTER>\n");
  EndForm ();
  
  LowerBar(pd, CMD_CALENDAR_MONTH_SHOW);
  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }  

void HTMLPages::PrintCalendarWeekShow (TProgData *pd)
  {
  long jul;
  int dow, begday, colpos, aDay, aYear, aMonth, aWeek, hora, horasdesde, len;
  StringList SLYears;
  TMatWeek MatWeek;
  TBuffer tmpbuf;
  TUniqId uniqid;
  char *pc = NULL;
  TFieldName fieldname;
  bool ExisteEvent;
  char letra[2];
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CALENDAR_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Calendar (CMD_CALENDAR_WEEK_SHOW, pd->stlang, pd->username, pd->connid, pd->uo);  

  if (BeginWeekOnSunday == false) begday = 1; else begday = 0;
  jul = GregorianToJulian (1, workingMonth + 1, workingYear);
  dow = DayOfWeek (jul);
  colpos = 0;
  DaysOfWeek (initweek, workingWeek, workingMonth, workingYear, MatWeek);  

  WRITE ("<TABLE WIDTH=100%%><TR>");
  aWeek = workingWeek; aDay = initweek; aYear = workingYear; aMonth = workingMonth; PrevWeek (&aDay, &aWeek, &aMonth, &aYear);
  sprintf (tmpbuf, "%s/%s/week_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                    aYear, aMonth, aWeek, aDay);
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_LEFT_ARROW), L->get(ALT_PREV));
  WRITE ("<TD ALIGN=center><FONT COLOR=\"#0000FF\">%s %d, %s %d</FONT></TD>", L->get(L_WEEK), workingWeek, getLongMonth(workingMonth), workingYear);
  aWeek = workingWeek; aDay = initweek; aYear = workingYear; aMonth = workingMonth; NextWeek (&aDay, &aWeek, &aMonth, &aYear);
  sprintf (tmpbuf, "%s/%s/week_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                    aYear, aMonth, aWeek, aDay); 
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_RIGHT_ARROW), L->get(ALT_NEXT));  
  WRITE ("</TR></TABLE>\n");

  BeginFormPost ("PrintCalendarWeekShow", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "year_show");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_WEEK_SHOW);    
  BR();

  letra[1] = '\0';
  WRITE ("<CENTER>\n");
  WRITE ("<FONT SIZE=-1>\n");
  WRITE ("<TABLE WIDTH=100%%>\n");  
  WRITE ("<TR>"); 
    WRITE ("<TD align=center><B>%s</B></TD>\n", L->get(L_HOUR));
    for (int j = 0; j < NUMBER_DAYSFORWEEK; ++j) 
      {
      sprintf (tmpbuf, "%s/%s/day_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                     MatWeek[j].year, MatWeek[j].month, MatWeek[j].day);        
      WRITE ("<TD align=center><SPAN class=\"classCalCurrent\"><A HREF=\"%s\">%s, %d</A></SPAN></TD>", tmpbuf, getShortDay2(j + begday), MatWeek[j].day);
      } 
  WRITE ("</TR>\n");    
  for (int k=0; k < HOURS_INTERVALS; ++k)
    {
    sprintf (tmpbuf, "%02d:00", k + BEGIN_HOUR_PLAN);
    hora = k + BEGIN_HOUR_PLAN;    
    WRITE ("<TR>\n"); 
      WRITE ("<TD width=\"1%%\" align=center>\n"); WRITE (tmpbuf); WRITE ("</TD>\n");  
      for (int i=0; i < NUMBER_DAYSFORWEEK; ++i) 
        {
        horasdesde = (long)(makeUnixDate (MatWeek[i].day, MatWeek[i].month, MatWeek[i].year) / 3600);  
        ExisteEvent = CDBCal->generaIDFromPos (horasdesde + hora, uniqid);
        sprintf (tmpbuf, "%s/%s/events_create/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                     MatWeek[i].year, MatWeek[i].month, MatWeek[i].day, hora);        
        if (ExisteEvent == true)
          {
          strcpy (fieldname, "title");
          pc = CDBCal->getField_Text_ByID (uniqid, fieldname, pc, &len);
          WRITE ("<TD align=center><FONT SIZE=1>");   
          sprintf (tmpbuf, "%s/%s/events_delete/noop/%s/%s/%s/%d/%d/%d/%s/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                       uniqid);        
          WRITE ("<A HREF=\"%s\" onClick=\"return confirm('%s')\"><FONT COLOR=#FF0000>-</FONT></A>&nbsp;&nbsp;&nbsp;", tmpbuf, L->get(MSG_CONFDELETEEVENT));           
          sprintf (tmpbuf, "%s/%s/events_modify/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                     MatWeek[i].year, MatWeek[i].month, MatWeek[i].day, hora); 
          WRITE ("<A HREF=\"%s\">", tmpbuf); 
          if (len > CLENGTH_TITLE_DISPLAY) {pc[CLENGTH_TITLE_DISPLAY] = '\0';}                 
          for (int l=0; l < (signed)strlen(pc); ++l)
            {
            letra[0] = pc[l];
            switch (l)
              {
              case 10: case 20: case 30: case 40: case 50: case 60: case 70: 
                WRITE ("%s<BR>", letra); 
                break;
              default: WRITE (letra); break;
              }       
            }
          WRITE ("</A>");  
          WRITE ("</FONT></TD>\n");
          free (pc);      
          }
        else
          {  
          WRITE ("<TD align=center>\n"); 
            WRITE ("<A HREF=\"%s\"><FONT COLOR=#0000FF>+</FONT></A>", tmpbuf); 
          WRITE ("</TD>\n");
          }
        }
    WRITE ("<TR>\n");    
    if (k < HOURS_INTERVALS - 1) {WRITE ("<TR><TD colspan=8><HR></TD></TR>\n");}
    }
  
  WRITE ("</TABLE>\n");                              
  WRITE ("</FONT>\n");
  WRITE ("</CENTER>\n");
  EndForm ();
  
  LowerBar(pd, CMD_CALENDAR_WEEK_SHOW);
  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));              
  }
  
void HTMLPages::PrintCalendarDayShow (TProgData *pd)    
  {
  long jul, horasdesde;
  int dow, hora, len, aDay, aMonth, aYear;
  StringList SLYears;
  TBuffer tmpbuf;
  TUniqId uniqid;
  char *pc = NULL;
  TFieldName fieldname;
  bool ExisteEvent;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CALENDAR_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  
  BotoneraComun_Calendar (CMD_CALENDAR_DAY_SHOW, pd->stlang, pd->username, pd->connid, pd->uo);  

  jul = GregorianToJulian (workingDay, workingMonth + 1, workingYear);
  dow = DayOfWeek (jul);

  WRITE ("<TABLE WIDTH=100%%><TR>");
  aYear = workingYear; aMonth = workingMonth; aDay = workingDay; PrevDay (&aDay, &aMonth, &aYear);
  sprintf (tmpbuf, "%s/%s/day_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                      aYear, aMonth, aDay);                                                                                     
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_LEFT_ARROW), L->get(ALT_PREV));
  WRITE ("<TD ALIGN=center><FONT COLOR=\"#0000FF\">%s, %d %s %d</FONT></TD>", getLongDay(dow + 1), workingDay, getLongMonth(workingMonth), workingYear);
  aYear = workingYear; aMonth = workingMonth; aDay = workingDay; NextDay (&aDay, &aMonth, &aYear);
  sprintf (tmpbuf, "%s/%s/day_show/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                      aYear, aMonth, aDay); 
  WRITE ("<TD WIDTH=1%% ALIGN=left><A HREF=\"%s\"><IMG SRC=\"%s\" BORDER=\"0\" ALT=\"%s\"></A></TD>", tmpbuf, skin->getI(IMG_RIGHT_ARROW), L->get(ALT_NEXT));  
  WRITE ("</TR></TABLE>\n");

  BeginFormPost ("PrintCalendarDayShow", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "year_show");      
  FormHidden ("subcmd", "noop");        
  FormHidden ("lastcmd", CMD_CALENDAR_DAY_SHOW);    
  BR();  
  WRITE ("<FONT SIZE=-1>\n");
  WRITE ("<TABLE WIDTH=100%%>\n");  
  horasdesde = (long)(makeUnixDate (workingDay, workingMonth, workingYear) / 3600);
  for (int k=0; k < HOURS_INTERVALS; ++k)
    {
    hora = k + BEGIN_HOUR_PLAN;    
    ExisteEvent = CDBCal->generaIDFromPos (horasdesde + hora, uniqid);
    WRITE ("<TR>\n"); 
      sprintf (tmpbuf, "%02d:00", hora);
      WRITE ("<TD width=\"1%%\">\n"); WRITE (tmpbuf); WRITE ("</TD>\n");  
      WRITE ("<TD width=\"1%%\" align=left>\n"); 
        sprintf (tmpbuf, "%s/%s/events_create/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                     workingYear, workingMonth, workingDay, hora);        
        if (ExisteEvent == false)
          {
          WRITE ("<A HREF=\"%s\"><FONT COLOR=#0000FF>+</FONT></A>", tmpbuf);         
          }
        else
          {
          sprintf (tmpbuf, "%s/%s/events_delete/noop/%s/%s/%s/%d/%d/%d/%s/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                       uniqid);        
          WRITE ("<A HREF=\"%s\" onClick=\"return confirm('%s')\"><FONT COLOR=#FF0000>-</FONT></A>", tmpbuf, L->get(MSG_CONFDELETEEVENT));           
          }
      WRITE ("</TD>\n");        
      if (ExisteEvent == true)
        {
        sprintf (tmpbuf, "%s/%s/events_modify/noop/%s/%s/%s/%d/%d/%d/%d/%d/%d/%d/", PATH_CGI, SERVICE_CALENDAR, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), pd->cmd,
                                                                     workingYear, workingMonth, workingDay, hora);
        strcpy (fieldname, "title");
        pc = CDBCal->getField_Text_ByID (uniqid, fieldname, pc, &len);
        if (len > CLENGTH_TITLE_DISPLAY) {pc[CLENGTH_TITLE_DISPLAY] = '\0';}
        WRITE ("<TD align=left><A HREF=\"%s\">\n", tmpbuf); 
        WRITE (pc);        
        WRITE ("</A></TD>\n");
        free (pc);      
        }
      else
        {
        WRITE ("<TD>&nbsp;</TD>\n"); 
        }  
    WRITE ("</TR>\n");    
    if (k < HOURS_INTERVALS - 1) {WRITE ("<TR><TD colspan=3><HR></TD></TR>\n");}
    }
  WRITE ("</TABLE>\n");
  WRITE ("</FONT>\n");
  EndForm ();  

  LowerBar(pd, CMD_CALENDAR_DAY_SHOW);
  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
                                  
void HTMLPages::PrintCalendarEventsModify (TProgData *pd, int mode)            
  {
  TUniqId uniqid;
  long jul;
  int dow, day, month, year, horasdesde, numevent, lentitle, lendescription, lenpc, len;
  StringList SLItems;
  TBuffer tmpbuf, status, priority, ttype;
  TNumber anum;
  char *pctitle = NULL, *pcdescription = NULL, *pc = NULL;    
  bool ExisteEvent, iscurrent;
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_CALENDAR_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), pd->uo->get_use_javascript(), 0, NULL);  
  

  jul = GregorianToJulian (workingDay, workingMonth + 1, workingYear);
  dow = DayOfWeek (jul);
  sprintf (tmpbuf, "%02d:00", workingHour);

  if (mode == CMODE_MODIFY)
    {    
    BotoneraComun_Calendar (CMD_CALENDAR_EVENTS_MODIFY, pd->stlang, pd->username, pd->connid, pd->uo);  
    horasdesde = (long)(makeUnixDate (workingDay, workingMonth, workingYear) / 3600);  
    horasdesde += workingHour;
    ExisteEvent = CDBCal->generaIDFromPos (horasdesde, uniqid);
    numevent      = xatoidef (CDBCal->getField_Text_ByID (uniqid, "numevent", pc, &lenpc), 1);
    pctitle       = CDBCal->getField_Text_ByID (uniqid, "title", pctitle, &lentitle);
    pcdescription = CDBCal->getField_Text_ByID (uniqid, "description", pcdescription, &lendescription);    
    pc = CDBCal->getField_Text_ByID (uniqid, "status", pc, &len); xstrncpy (status, CMAXBUFFER, pc); free (pc);
    pc = CDBCal->getField_Text_ByID (uniqid, "priority", priority, &len); xstrncpy (priority, CMAXBUFFER, pc); free (pc);
    pc = CDBCal->getField_Text_ByID (uniqid, "type", ttype, &len); xstrncpy (ttype, CMAXBUFFER, pc); free (pc);
    //DEBUG (" status=%s, priority=%s, ttype=%s", status, priority, ttype);
    }                                     
  else
    {
    BotoneraComun_Calendar (CMD_CALENDAR_EVENTS_ADD, pd->stlang, pd->username, pd->connid, pd->uo);  
    numevent      = 1;
    pctitle       = NULL;
    pcdescription = NULL;
    xstrncpy (status, CMAXBUFFER, "open");
    xstrncpy (priority, CMAXBUFFER, "current");
    xstrncpy (ttype, CMAXBUFFER, "other");
    }
  
  BeginFormPost ("PrintCalendarDayShow", PATH_CGI);
  FormHidden ("service", SERVICE_CALENDAR);
  FormHidden ("lang", pd->stlang);
  FormHidden ("user", pd->username);        
  FormHidden ("connid", pd->connid);
  FormHidden ("validator", pd->uo->getValidator());
  FormHidden ("pageid", pd->uo->getPageId());
  FormHidden ("cmd", "events_add");      
  FormHidden ("subcmd", "noop");          
  FormHidden ("lastcmd", pd->uo->getLastCmd());  
  FormHidden ("numevent",  numevent); //For future use   
  FormHidden ("year",  workingYear);  
  FormHidden ("month", workingMonth);    
  FormHidden ("day",   workingDay);    
  FormHidden ("hour",  workingHour);    

  BR();      
  WRITE ("<CENTER>\n");
  WRITE ("<TABLE>\n");  

  WRITE ("<TR>"); 
    WRITE ("<TD>"); 
      WRITE ("&nbsp;");
    WRITE ("</TD>"); 
    WRITE ("<TD align=center>\n");  
      FormButton ("add", L->get(L_SAVE)); 
    WRITE ("</TD>");     
  WRITE ("</TR>"); 

  WRITE ("<TR>"); 
    WRITE ("<TD align=right>"); 
      Label (L->get(L_HOUR));
    WRITE ("</TD>"); 
    WRITE ("<TD align=center>\n");  
      sprintf (tmpbuf, "%02d:00", workingHour);
      WRITE ("<B><FONT SIZE=4 COLOR=#0000FF>%s</FONT></B>", tmpbuf);
    WRITE ("</TD>"); 
  WRITE ("</TR>"); 
  WRITE ("<TR>");   
    WRITE ("<TD align=right>"); 
      Label (L->get(L_LEX_SINCE));
    WRITE ("</TD>"); 
    WRITE ("<TD>\n");  
      FormBeginSelect ("PrintCalendarEventsModifyDayBegin1", "beginday", NULL, pd->uo->get_use_javascript()); 
      SLItems.Clear();
      for (int i = 0; i <= 30; ++i) {SLItems.Add (xitoa(i+1, anum));}
      for (int i = 0; i < SLItems.Count(); ++i)
        {
        day = i;
        if (day + 1 == workingDay) FormAddOptionSelect (true,  SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        else FormAddOptionSelect (false, SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        } 
      FormEndSelect();  
      FormBeginSelect ("PrintCalendarEventsModifyMonthBegin1", "beginmonth", NULL, pd->uo->get_use_javascript()); 
      SLItems.Clear();
      for (int i = 0; i < NUMBER_MONTHS; ++i) {SLItems.Add (getLongMonth(i));}
      for (int i = 0; i < SLItems.Count(); ++i)
        {
        month = i;
        if (month == workingMonth) FormAddOptionSelect (true,  xitoa (i, anum), SLItems.getString(i).cstr());
        else FormAddOptionSelect (false, xitoa (i, anum), SLItems.getString(i).cstr());
        } 
      FormEndSelect();    
      FormBeginSelect ("PrintCalendarEventsModifyYearBegin1", "beginyear", NULL, pd->uo->get_use_javascript()); 
      SLItems.Clear();
      for (int i = workingYear - 10; i < workingYear + 10; ++i) {SLItems.Add (xitoa(i, anum));}
      for (int i = 0; i < SLItems.Count(); ++i)
        {
        year = xatoidef (SLItems.getString(i).cstr(), 0);
        if (year == workingYear) FormAddOptionSelect (true,  SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        else FormAddOptionSelect (false, SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        } 
      FormEndSelect();  
      WRITE ("&nbsp;&nbsp;<B>%s</B>&nbsp;&nbsp;", L->get(L_LEX_TO));
      FormBeginSelect ("PrintCalendarEventsModifyDayEnd1", "endday", NULL, pd->uo->get_use_javascript()); 
      SLItems.Clear();
      for (int i = 0; i <= 30; ++i) {SLItems.Add (xitoa(i+1, anum));}
      for (int i = 0; i < SLItems.Count(); ++i)
        {
        day = i; 
        if (day + 1 == workingDay) FormAddOptionSelect (true,  SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        else FormAddOptionSelect (false, SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        } 
      FormEndSelect();  
      FormBeginSelect ("PrintCalendarEventsModifyMonthEnd1", "endmonth", NULL, pd->uo->get_use_javascript()); 
      SLItems.Clear();
      for (int i = 0; i < NUMBER_MONTHS; ++i) {SLItems.Add (getLongMonth(i));}
      for (int i = 0; i < SLItems.Count(); ++i)
        {
        month = i;
        if (month == workingMonth) FormAddOptionSelect (true,  xitoa (i, anum), SLItems.getString(i).cstr());
        else FormAddOptionSelect (false, xitoa (i, anum), SLItems.getString(i).cstr());
        } 
      FormEndSelect();    
      FormBeginSelect ("PrintCalendarEventsModifyYearEnd1", "endyear", NULL, pd->uo->get_use_javascript()); 
      SLItems.Clear();
      for (int i = workingYear - 10; i < workingYear + 10; ++i) {SLItems.Add (xitoa(i, anum));}
      for (int i = 0; i < SLItems.Count(); ++i)
        {
        year = xatoidef (SLItems.getString(i).cstr(), 0);
        if (year == workingYear) FormAddOptionSelect (true,  SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        else FormAddOptionSelect (false, SLItems.getString(i).cstr(), SLItems.getString(i).cstr());
        } 
      FormEndSelect();  
    WRITE ("</TD>\n");                              
  WRITE ("</TR>"); 
  WRITE ("<TR>"); 
    WRITE ("<TD>"); 
      WRITE ("&nbsp;");
    WRITE ("</TD>"); 
    WRITE ("<TD>\n");  
      FormCheckbox ("festivos", "0", false); WRITE ("Incluir Festivos");
    WRITE ("</TD>\n");                              
  WRITE ("</TR>");   
  
  WRITE ("<TR>"); 
    WRITE ("<TD align=right>"); 
      Label (L->get(L_TITLE)); 
    WRITE ("</TD>"); 
    WRITE ("<TD>");   
      if (pctitle == NULL)
        {        
        FormEdit (100, 50, "title", ""); 
        }
      else
        {
        FormEdit (100, 50, "title", pctitle); 
        }
    WRITE ("</TD>"); 
  WRITE ("</TR>"); 
  WRITE ("<TR>"); 
    WRITE ("<TD align=right>"); 
      Label (L->get(L_DESCRIPTION)); 
    WRITE ("</TD>"); 
    WRITE ("<TD>");           
      if (pcdescription == NULL)
        {            
        FormTextArea (5, 60, "description", "", false); 
        }
      else
        {
        FormTextArea (5, 60, "description", pcdescription, false);         
        }
    WRITE ("</TD>"); 
  WRITE ("</TR>");    
  
  WRITE ("<TR>"); 
    WRITE ("<TD align=right>"); 
      Label (L->get(L_STATUS)); 
    WRITE ("</TD>"); 
    WRITE ("<TD colspan=3>");   

      //STATUS 
      FormBeginSelect ("PrintCalendarEventsModifyStatus1", "status", NULL, pd->uo->get_use_javascript());     
      if (strcmp (status, "finished") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "finished", L->get(L_STATUS_FINISHED));
      if (strcmp (status, "open") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent,  "open", L->get(L_STATUS_OPEN));
      if (strcmp (status, "delayed") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "delayed", L->get(L_STATUS_DELAYED));            
      FormEndSelect ();

      //PRIORITY         
      Label (L->get(L_PRIORITY)); 
      FormBeginSelect ("PrintCalendarEventsModifyPriority1", "priority", NULL, pd->uo->get_use_javascript());     
      if (strcmp (priority, "low") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "low", L->get(L_PRIORITY_LOW));
      if (strcmp (priority, "current") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent,  "current", L->get(L_PRIORITY_CURRENT));
      if (strcmp (priority, "important") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "important", L->get(L_PRIORITY_IMPORTANT));
      if (strcmp (priority, "veryimportant") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "veryimportant", L->get(L_PRIORITY_VERYIMPORTANT));            
      FormEndSelect ();
      
      //TYPE
      Label (L->get(L_TYPE)); 
      FormBeginSelect ("PrintCalendarEventsModifyType1", "type", NULL, pd->uo->get_use_javascript());     
      if (strcmp (ttype, "celebration") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "celebration", L->get(L_TYPE_CELEBRATION));
      if (strcmp (ttype, "meeting") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "meeting", L->get(L_TYPE_MEETING));
      if (strcmp (ttype, "launch") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent, "launch", L->get(L_TYPE_LAUNCH));
      if (strcmp (ttype, "other") == 0) {iscurrent = true;} else {iscurrent = false;} 
          FormAddOptionSelect (iscurrent,  "other", L->get(L_TYPE_OTHER));            
      FormEndSelect ();
    WRITE ("</TD>"); 
  WRITE ("</TR>");        
  WRITE ("</TABLE>\n");  
  WRITE ("</CENTER>\n");

  EndForm ();  
  
  free (pctitle);
  free (pcdescription);
  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }

int getWarningToday (TBuffer warning)
  {
  TUniqId uniqid;
  int horasdesde, hora, len, numev;
  bool ExisteEvent;
  TBuffer tmpbuf;
  char *pc = NULL;      

  initStr (warning);
  numev = 0;
  horasdesde = (long)(makeUnixDate (workingDay, workingMonth, workingYear) / 3600);
  for (int k=0; k < HOURS_INTERVALS; ++k)
    {
    hora = k + BEGIN_HOUR_PLAN;    
    ExisteEvent = CDBCal->generaIDFromPos (horasdesde + hora, uniqid);
        
    if (ExisteEvent == true)
      {
      ++numev;            
      if (k == 0)                      
        sprintf (tmpbuf, "%02d:00 ", hora);
      else
        sprintf (tmpbuf, "<BR>%02d:00 ", hora);
      xstrncat (warning, CMAXBUFFER, tmpbuf);      
      pc = CDBCal->getField_Text_ByID (uniqid, "title", pc, &len);
      if (len > CLENGTH_TITLE_DISPLAY) {pc[CLENGTH_TITLE_DISPLAY] = '\0';}
      xstrncat (warning, CMAXBUFFER, pc);        
      free (pc);      
      }
    }
  xstrncat (warning, CMAXBUFFER, "</UL>");
  return numev;  
  }

  
