/*
Services.h
*/

#ifndef __SERVICES_H
#define __SERVICES_H

//For Postman Services
#define iSERVICE_NOTALLOWED     -2
#define iSERVICE_INVALID        -1
#define iSERVICE_MAIN            0
#define iSERVICE_CCLIENT         1
#define iSERVICE_POPPASS         2
#define iSERVICE_FINGER          3
#define iSERVICE_FILEBROWSER     4
#define iSERVICE_FORWARDMAIL     5
#define iSERVICE_SECVIRTUAL      6
#define iSERVICE_DATABASES       7
#define iSERVICE_PERSONALDATA    8
#define iSERVICE_USERACCOUNTS    9
#define iSERVICE_CONFIG         10
#define iSERVICE_SIEVE          11
#define iSERVICE_CALENDAR       12

//Name for several services
#define SERVICE_MAIN           "main"
#define SERVICE_CCLIENT        "cclient"
#define SERVICE_POPPASS        "poppass"
#define SERVICE_FINGER         "finger"
#define SERVICE_FILEBROWSER    "filebrowser"
#define SERVICE_FORWARDMAIL    "forwardmail"
#define SERVICE_SECVIRTUAL     "secvirtual"
#define SERVICE_DATABASES      "databases"
#define SERVICE_PERSONALDATA   "personaldata"
#define SERVICE_USERACCOUNTS   "useraccounts"
#define SERVICE_CONFIG         "config"
#define SERVICE_SIEVE          "sieve"
#define SERVICE_CALENDAR       "calendar" 
 
//SPECIAL COMMAND
#define CMD_SPECIAL_INVALIDPAGE          -1
#define CMD_SPECIAL_INVALID              -2
#define CMD_SPECIAL_CHECK_COOKIE         -3
#define CMD_SPECIAL_NOOP                 -4
#define CMD_SPECIAL_DEBUG                -5 
 
//COMMANDS FOR MAIN SERVICE
#define CMD_MAIN_HOME                     0
#define CMD_MAIN_LOGIN                    1
#define CMD_MAIN_LOGOUT                   2
#define CMD_MAIN_HELP                     3
#define CMD_MAIN_ROOT                     4
#define CMD_MAIN_CONF_ACT                 5
#define CMD_MAIN_RECONNECT                6
#define CMD_MAIN_ABOUT                    7

//COMMAND FOR CCLIENT SERVICE
#define CMD_CCLIENT_MG_DUMPFULLMSG      100 //MESSAGE
#define CMD_CCLIENT_MG_DISPLAY          101
#define CMD_CCLIENT_MG_COPY             102
#define CMD_CCLIENT_MG_MOVE             103                           
#define CMD_CCLIENT_MG_DELDISPLAY       104
#define CMD_CCLIENT_MG_UNDELDISPLAY     105
#define CMD_CCLIENT_MG_FG_DELETE        106   
#define CMD_CCLIENT_MG_FG_UNDELETE      107   
#define CMD_CCLIENT_MG_FG_ANSWERED      108   
#define CMD_CCLIENT_MG_FG_UNANSWERED    109  
#define CMD_CCLIENT_MG_FG_FLAGGED       110                             
#define CMD_CCLIENT_MG_FG_UNFLAGGED     111  
#define CMD_CCLIENT_MG_FG_SEEN          112  
#define CMD_CCLIENT_MG_FG_UNSEEN        113  
#define CMD_CCLIENT_MG_FG_SEARCHED      114  
#define CMD_CCLIENT_MG_FG_UNSEARCHED    115  
#define CMD_CCLIENT_MG_DUMPFULLHEADER   116
#define CMD_CCLIENT_MB_INDEX            117 //MAILBOX
#define CMD_CCLIENT_MB_SHOW             118
#define CMD_CCLIENT_MB_CHANGE           119
#define CMD_CCLIENT_MB_CREATE           120
#define CMD_CCLIENT_MB_DELETE           121
#define CMD_CCLIENT_MB_RENAME           122
#define CMD_CCLIENT_MB_EXPUNGE          123
#define CMD_CCLIENT_MB_DUMP             124
#define CMD_CCLIENT_MB_SEARCH           125
#define CMD_CCLIENT_MB_SORT             126
#define CMD_CCLIENT_FG_DELETE           127 //FLAGS
#define CMD_CCLIENT_FG_UNDELETE         128
#define CMD_CCLIENT_FG_ANSWERED         129
#define CMD_CCLIENT_FG_UNANSWERED       130
#define CMD_CCLIENT_FG_FLAGGED          131                           
#define CMD_CCLIENT_FG_UNFLAGGED        132
#define CMD_CCLIENT_FG_SEEN             133
#define CMD_CCLIENT_FG_UNSEEN           134
#define CMD_CCLIENT_FG_RECENT           135
#define CMD_CCLIENT_FG_UNRECENT         136    
#define CMD_CCLIENT_CM                  137 //COMPOSE MESSAGE   
#define CMD_CCLIENT_CMNNTP              138
#define CMD_CCLIENT_CM_SEND             139
#define CMD_CCLIENT_CM_SENDNNTP         140
#define CMD_CCLIENT_CM_CANCEL           141
#define CMD_CCLIENT_CM_REPLY            142
#define CMD_CCLIENT_CM_REPLYALL         143
#define CMD_CCLIENT_CM_REPLYGROUP       144
#define CMD_CCLIENT_CM_FORWARD          145
#define CMD_CCLIENT_CM_CLEANALL         146
#define CMD_CCLIENT_CM_SAVE             147
#define CMD_CCLIENT_AT_DUMP             148 //ATTACHMENTS
#define CMD_CCLIENT_AT_SHOW             149
#define CMD_CCLIENT_AT_SAVE             150
#define CMD_CCLIENT_AT_ERASE            151
#define CMD_CCLIENT_AB                  152 //ADDRESSBOOK
#define CMD_CCLIENT_AB_SAVEENTRY        153
#define CMD_CCLIENT_AB_EDITENTRY        154
#define CMD_CCLIENT_AB_SHOWALL          155
#define CMD_CCLIENT_AB_FROM_CM          156
#define CMD_CCLIENT_AB_DELEENTRIES      157
#define CMD_CCLIENT_AB_NEWENTRY         158
#define CMD_CCLIENT_AB_SORT             159
#define CMD_CCLIENT_AB_TAKEADDRESS      160
#define CMD_CCLIENT_AB_DUMP             161
#define CMD_CCLIENT_AB_ADDFIELDS        162
#define CMD_CCLIENT_BD_UUDECODE         163 //FOR UUDECODE MESSAGE BODIES
#define CMD_CCLIENT_NW_LIST_DUMP        164 //FOR DUMP THE FULL NETNEWS GROUPS LIST

//COMMANDS FOR POPPASS SERVICE
#define CMD_POPPASS_DISPLAYPAGE         200
#define CMD_POPPASS_CHANGEPW            201

//COMMANDS FOR FINGER SERVICE
#define CMD_FINGER_DISPLAYPAGE          400
#define CMD_FINGER_GO                   401

//COMMANDS FOR FILEBROWSER SERVICE
#define CMD_FILEBROWSER_DISPLAYPAGE     500
#define CMD_FILEBROWSER_CWDUP           501
#define CMD_FILEBROWSER_CWD             502
#define CMD_FILEBROWSER_DUMP            503
#define CMD_FILEBROWSER_EDITSHOW        504
#define CMD_FILEBROWSER_EDITSAVE        505
#define CMD_FILEBROWSER_EDITCANCEL      506
#define CMD_FILEBROWSER_CREATEITEM      507
#define CMD_FILEBROWSER_DELETEITEM      508
#define CMD_FILEBROWSER_DELETEITEM_CONF 509
#define CMD_FILEBROWSER_LOADFILE        510
#define CMD_FILEBROWSER_COPY            511
#define CMD_FILEBROWSER_CUT             512
#define CMD_FILEBROWSER_PASTE           513
#define CMD_FILEBROWSER_RENAME          514
#define CMD_FILEBROWSER_CWDF            515
#define CMD_FILEBROWSER_RENAMECANCEL    516
#define CMD_FILEBROWSER_RENAMEOK        517
#define CMD_FILEBROWSER_SORTNAME        518
#define CMD_FILEBROWSER_SORTSIZE        519
#define CMD_FILEBROWSER_SORTDATE        520
#define CMD_FILEBROWSER_CHANGEDISK      521

//COMMANDS FOR FORWARDMAIL SERVICE
#define CMD_FORWARDMAIL_DISPLAYPAGE     600
#define CMD_FORWARDMAIL_ERASEALL        601
#define CMD_FORWARDMAIL_SET             602

//COMMANDS FOR SECVIRTUAL SERVICE
#define CMD_SECVIRTUAL_GOTO             700

//COMMANDS FOR DATABASES SERVICE
#define CMD_DATABASES_DISPLAYPAGE       800
#define CMD_DATABASES_DISPLAYRECORD     801
#define CMD_DATABASES_COPY              802
#define CMD_DATABASES_CUT               803
#define CMD_DATABASES_PASTE             804
#define CMD_DATABASES_DELETE            805
#define CMD_DATABASES_UNDELETE          806
#define CMD_DATABASES_NEWRECORD         807
#define CMD_DATABASES_EDIT              808
#define CMD_DATABASES_SYNC              809
#define CMD_DATABASES_EDITSAVE          810
#define CMD_DATABASES_EDITSHOW          811
#define CMD_DATABASES_SORT              812
#define CMD_DATABASES_SEARCH            813
#define CMD_DATABASES_DB_EXPUNGE        814
#define CMD_DATABASES_GO                815
#define CMD_DATABASES_DB_OPEN           816
#define CMD_DATABASES_MAINPAGE          817
#define CMD_DATABASES_DB_CREATE         818
#define CMD_DATABASES_DB_RENAME         819
#define CMD_DATABASES_DB_DELETE         820
#define CMD_DATABASES_DB_DUMP           821
#define CMD_DATABASES_DB_IMPORT         822
#define CMD_DATABASES_DB_EXPORT         823
#define CMD_DATABASES_DUPLICATE         824
#define CMD_DATABASES_DB_DEFINE         825
#define CMD_DATABASES_DB_CONFDELETE     826
#define CMD_DATABASES_DELETESEARCH      827

//COMMANDS FOR PERSONALDATA SERVICE
/*nothing*/

//COMMANDS FOR USERACCOUNTS SERVICE
#define CMD_USERACCOUNTS_GOTO           900

//COMMANDS FOR CONFIG SERVICE
#define CMD_CONFIG                     1000
#define CMD_CONFIG_CANCEL              1001
#define CMD_CONFIG_CCLIENT             1002
#define CMD_CONFIG_CCLIENT_SAVE        1003
#define CMD_CONFIG_NNTP                1004
#define CMD_CONFIG_NNTP_SAVE           1005
#define CMD_CONFIG_NNTP_SEARCH         1006
#define CMD_CONFIG_NNTP_ADDSELECTED    1007
#define CMD_CONFIG_APPEARANCE          1008
#define CMD_CONFIG_APPEARANCE_SAVE     1009

//COMMANDS FOR SIEVE SERVICE
#define CMD_SIEVE_FILTERS_SHOW         1100
#define CMD_SIEVE_FILTERS_EDIT         1101
#define CMD_SIEVE_FILTERS_CREATE       1102
#define CMD_SIEVE_FILTERS_DO           1103
#define CMD_SIEVE_FILTERS_DELETE       1104
#define CMD_SIEVE_FILTERS_SAVE         1105
#define CMD_SIEVE_FILTERS_CANCEL       1106
#define CMD_SIEVE_FILTERS_UP           1107
#define CMD_SIEVE_FILTERS_DOWN         1108
#define CMD_SIEVE_FILTERS_CONFDELETE   1109
#define CMD_SIEVE_FILTERS_PREDEFSPAM   1110
#define CMD_SIEVE_VACATIONS_SHOW       1111
#define CMD_SIEVE_VACATIONS_DO         1112
#define CMD_SIEVE_VACATIONS_SAVE       1113
#define CMD_SIEVE_VACATIONS_CANCEL     1114

//COMMANDS FOR CALENDAR SERVICE
#define CMD_CALENDAR_YEAR_SHOW         1200
#define CMD_CALENDAR_MONTH_SHOW        1201
#define CMD_CALENDAR_WEEK_SHOW         1202
#define CMD_CALENDAR_DAY_SHOW          1203
#define CMD_CALENDAR_EVENTS_SHOW       1204

//For future use
#define ACTION_RECONNECT 1

#include "Utils.h"

int TranslateService (const char *stservice);
const char *TranslateServiceR (int service);
int TranslateCmd (int service, const char *stcmd);
bool is_CMD_ALLOWED_ACTION (int ACTION, int service, int cmd);
int getiServiceFromCmd (int cmd);

#endif

