/*                               
Service_PopPass.cc
*/

#include "Service_PopPass.h"
#include "ClientPOPPASS.h"

extern Language *L;
extern Configuration *Conf;
extern Skin *skin;

class HTMLPages: public HTMLBasic
  {
  private:
    //
  public:
    void PrintPopPassDisplayPage (const char *stlang, const char *user, const char *connid, UserOptions *uo);
  };

//retrieve the url for the Service icon
const char *GetService_PopPass_ICO_URL (void)
  {
  return skin->getI(L_POPPASS);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_PopPass_ICO_ALT (void)
  {
  return L->get(L_POPPASS);
  }

//Retrieve the Service name
const char *GetService_PopPass_NAME (void)
  {
  return L->get(L_POPPASS);
  }

//Retrieve the Service Description
const char *GetService_PopPass_DESCRIPTION (void)
  {
  return L->get(L_POPPASS_DESCRIPTION);
  }

//Entry point to service init
bool DoService_PopPass_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  LOG ("Initializating Service PopPass for user=%s", pd->username);
  return true;
  }

//Entry point to service end
bool DoService_PopPass_END (TProgData *pd)
  {
  return true;
  }

//Entry point to execute a service command
bool DoService_PopPass_CMD (TProgData *pd)
  {
  HTMLPages *html;
  int cmd;

  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  cmd = pd->cmd;
    
  switch (pd->cmd)
    {
    case (CMD_POPPASS_DISPLAYPAGE):
      {
      pd->uo->InitStatusLine ();
      html->PrintPopPassDisplayPage (pd->stlang, pd->username, pd->connid, pd->uo);
      break;   
      }
    case (CMD_POPPASS_CHANGEPW):
      {
      bool b;
      TBuffer ErrMsg;
      ClientPOPPASS *CliPP;
      cgienv_GetSimpleVar (pd->envfile, "oldpassword",  pd->parm1, true);
      cgienv_GetSimpleVar (pd->envfile, "newpassword1", pd->parm2, true);
      cgienv_GetSimpleVar (pd->envfile, "newpassword2", pd->parm3, true);
      if (strcmp (pd->parm2, pd->parm3) != 0) 
        {
        html->ErrorPage("The two new passwords are different!");
        return false;
        }
      CliPP = new ClientPOPPASS (pd->uo->getPoppassServer(), pd->uo->getPoppassPort(), pd->username, pd->parm1, pd->parm2);
      b = CliPP->doChangePassword (ErrMsg);
      delete CliPP;
      if (b == true) 
        {
        xstrncpy (pd->password, CMAXBUFFER, pd->parm2);
        LOG ("POPPASS: Password changed Ok: server: %s, user: %s", pd->uo->getPoppassServer(), pd->username);
        html->OkPage_ReturnToBack (pd->stlang, pd->username, pd->connid, pd->uo, L->get(MSG_CHANGEPW_OK));
        }
      else 
        {
        LOG ("POPPASS: Error changing password: server: %s, user: %s", pd->uo->getPoppassServer(), pd->username);
        html->ErrorPage(ErrMsg);
        }
      break;   
      }      
    default: 
      {    
      LOG ("ERROR: Service_PopPass: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }         
    }
  return false;  
  }  

void HTMLPages::PrintPopPassDisplayPage 
    (const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_POPPASS_DISPLAYPAGE), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  
  BotoneraTop (CMD_POPPASS_DISPLAYPAGE, lang, user, connid, uo);
  BeginCenter();
  BeginFormPost ("PrintPopPassDisplayPage", PATH_CGI);
  FormHidden ("service", SERVICE_POPPASS);
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("cmd", "changepw");      
  FormHidden ("lastcmd", CMD_POPPASS_DISPLAYPAGE);    
  BeginTable (0, 0, 0, 30);
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "right");
        Text (L->get(L_USER)); 
      EndTD();
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "center");
        Label (user); 
      EndTD();
    EndTR();      
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "right");
        Text (L->get(L_PASSWORD_OLD)); EndTD();
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "center");
        FormPassword (8, 8, "oldpassword", ""); EndTD();
    EndTR();          
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "right");
        Text (L->get(L_PASSWORD_NEW1)); EndTD();
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "center");
        FormPassword (8, 8, "newpassword1", ""); EndTD();
    EndTR();      
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "right");
        Text (L->get(L_PASSWORD_NEW2)); EndTD();
      BeginTD (skin->getSkinAtribProp("COLOR_BGTABLE"), "center");
        FormPassword (8, 8, "newpassword2", ""); EndTD();
    EndTR();  
  EndTable();
  BR();
  FormButton ("theaction", L->get(L_CHANGEPASSWORD));
  EndForm ();
  EndCenter();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));            
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
