/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxmass-ui-main.h"
#include "polyxmass-main.h"
#include "polyxdef-ui-polchemdef.h"
#include "polyxdef-ui-atomdef.h"
#include "polyxcalc-main.h"
#include "polyxdef-main.h"
#include "polyxedit-main.h"
#include "polyxedit-ui-masses-display-wnd.h"
#include "polyxmass-ui-window-mngmt.h"


GtkWindow*
polyxmass_ui_main_setup_wnd (void)
{
  GtkWidget *widget = NULL;
  GladeXML *xml = NULL;
  
  gchar *gui_file = NULL;
  
  
  gui_file = 
    g_strdup_printf ("%s/polyxmass.glade", userspec->gladedir);

  xml = glade_xml_new (gui_file, "polyxmass_main_wnd", 
		       PACKAGE);

  g_free (gui_file);  

  if (xml == NULL)
    {
      g_error (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);
    }
  
  polyxmass_main_wnd = 
    (GtkWindow *) glade_xml_get_widget (xml, "polyxmass_main_wnd");
  
  if (polyxmass_main_wnd == NULL)
    {
      g_error (_("%s@%d: failed to create the program window\n"),
	     __FILE__, __LINE__);
    }
  
  /* Creation of the menubar.
   */
  widget = glade_xml_get_widget (xml, "polyxmass_main_menubar");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxmass_main_menubar", widget);

  /* Deal with the different menus and actions connected to them.
   */

  /* polyxmass menu.
   */
  widget = glade_xml_get_widget (xml, "polxymass_quit");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polxymass_quit", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polxymass_quit_activate),
		    polyxmass_main_wnd);

  widget = glade_xml_get_widget (xml, "polyxmass_console_window_visible");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxmass_console_window_visible", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxmass_console_window_visible_activate),
		    polyxmass_main_wnd);


  widget = glade_xml_get_widget (xml, "polyxmass_view_window_management");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxmass_view_window_management", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxmass_polyxmass_view_window_management_activate),
		    polyxmass_main_wnd);



  /* polyxdef menu (Atom Definition).
   */
  widget = glade_xml_get_widget (xml, "polyxdef_open_atom_definition");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxdef_open_atom_definition", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxdef_open_atom_definition_activate),
		    polyxmass_main_wnd);

  widget = glade_xml_get_widget (xml, "polyxdef_new_atom_definition");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxdef_new_atom_definition", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxdef_new_atom_definition_activate),
		    polyxmass_main_wnd);


  /* polyxdef menu (Polymer Definition).
   */
  widget = glade_xml_get_widget (xml, "polyxdef_open_polymer_definition");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxdef_open_polymer_definition", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxdef_open_polymer_definition_activate),
		    polyxmass_main_wnd);

  widget = glade_xml_get_widget (xml, "polyxdef_new_polymer_definition");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxdef_new_polymer_definition", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxdef_new_polymer_definition_activate),
		    polyxmass_main_wnd);


  /* polyxcalc menu.
   */
  widget = glade_xml_get_widget (xml, "new_calculator_without_polchemdef");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "new_calculator_without_polchemdef", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxcalc_new_calculator_without_polchemdef_activate),
		    polyxmass_main_wnd);

  widget = glade_xml_get_widget (xml, "new_calculator_with_polchemdef");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "new_calculator_with_polchemdef", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (on_polyxcalc_new_calculator_with_polchemdef_activate),
		    polyxmass_main_wnd);





  /* polyxedit menu.
   */
  widget = glade_xml_get_widget (xml, "polyxedit_open_sequence_file");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxedit_open_sequence_file", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK (on_polyxedit_open_sequence_file_activate),
		    polyxmass_main_wnd);


  widget = glade_xml_get_widget (xml, "polyxedit_new_sequence_file");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxedit_new_sequence_file", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK (on_polyxedit_new_sequence_file_activate),
		    polyxmass_main_wnd);


  widget = glade_xml_get_widget (xml, "polyxedit_display_masses_window");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxedit_display_masses_window", widget);

  /* Note that the polyxmass initialization function does not show the
     polyxmasse masses displaywnd. It is left to the user to ask that
     it be made visible.
  */
  gtk_check_menu_item_set_active ((GtkCheckMenuItem *) widget,
				  FALSE);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK (on_polyxedit_display_masses_window_activate),
		    polyxmass_main_wnd);


  /* about menu.
   */
  widget = glade_xml_get_widget (xml, "polyxmass_about");
  g_assert (widget != NULL);

  g_object_set_data (G_OBJECT (polyxmass_main_wnd),
		     "polyxmass_about", widget);

  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK (on_polyxmass_about_activate),
		    polyxmass_main_wnd);



  /* We don't need the GladeXML object any more, so unref it
   * to save some memory .
   */
  g_object_unref (G_OBJECT (xml));

  

  /* Connect some important signals for the window proper.
    */
  g_signal_connect (G_OBJECT (polyxmass_main_wnd),
		    "delete_event",
		    G_CALLBACK (polyxmass_ui_main_wnd_delete_event),
		    polyxmass_main_wnd);
  
  g_signal_connect (G_OBJECT (polyxmass_main_wnd),
		    "destroy_event",
		    G_CALLBACK (polyxmass_ui_main_wnd_destroy_event),
		    polyxmass_main_wnd);
  
  /*
    widget = glade_xml_get_widget (xml, "");
    g_object_set_data (G_OBJECT (polyxmass_main_wnd),
    "", widget);
  */
  
  return polyxmass_main_wnd;
}







/* polyxmass menu.
 */
void
on_polxymass_quit_activate (GtkWidget *widget,
			    gpointer data)
{
  polyxmass_main_uninit_program ();
}


void
on_polyxmass_console_window_visible_activate (GtkWidget *widget,
					      gpointer data)
{
  /* We are toggling the visibility of the console window. If the
     window is not visible then show it, otherwise hide it.
  */
  
  g_assert (polyxmass_console_wnd != NULL);
  
  if (FALSE == 
      GTK_WIDGET_VISIBLE (GTK_WIDGET (polyxmass_console_wnd)))
    {    
      gtk_window_present (GTK_WINDOW (polyxmass_console_wnd));
      gtk_check_menu_item_set_active  ((GtkCheckMenuItem *) widget,
				       TRUE);
    }
  
  else
    {    
      gtk_widget_hide (GTK_WIDGET (polyxmass_console_wnd));
      gtk_check_menu_item_set_active  ((GtkCheckMenuItem *) widget,
				       FALSE);
    }
}


GtkWidget *
on_polyxmass_polyxmass_view_window_management_activate (GtkWidget *widget,
						  gpointer data)
{
  GtkWidget *parent = data;
  GtkWidget *window = NULL;

  /* We do not use the widget parameter. Do not forget that this
     function can be called by other menus, like the menu of the
     polymer sequence editor. We only want one window like this one.
  */
  g_assert (parent != NULL);

  window = g_object_get_data (G_OBJECT (parent), "window_mngmt_wnd");
  
  if (window != NULL)
    {
      gtk_window_present (GTK_WINDOW (window));
  
      return window;
    }
  
  window = polyxmass_window_mngmt_wnd_setup (parent);
  
  if (window == NULL)
    g_critical (_("%s@%d: failed to create the window management window\n"),
		__FILE__, __LINE__);
  else
    {
      g_object_set_data (G_OBJECT (parent), "window_mngmt_wnd", window);
    }
  
  return window;
}



/* polyxdef menu (Atom Definition)..
 */
gint
on_polyxdef_open_atom_definition_activate (GtkWidget *widget,
					      gpointer data)
{
  GtkWidget *parent = data;
  GtkWidget *window = NULL;

  gchar *filename = NULL;

  
  g_assert (parent != NULL);
  
  window = polyxmass_filechoosers_show_wnd (parent,
					    PXM_FILE_CHOOSE_ATOMDEF
					    | PXM_FILE_CHOOSE_GTK);
  g_assert (window != NULL);

  filename = g_object_get_data (G_OBJECT (parent), 
				"atomdefs_filename");
  
  if (filename == NULL)
    {
      /*
	debug_printf (("nothing\n"));
      */
      return 0;
    }

  /* At this time we can start the creation of a new 
     atom definition context...
  */
  if (NULL == polyxdef_main_prepare_new_context (filename,
						 ATOM_DEF))
    g_critical (_("%s@%d: failed to create an atom definition context"
	     " for file: '%s'.\n"),
	   __FILE__, __LINE__, filename);
  
  /* The filename was set to this window as a full datum with name
     "atomdefs_filename"... Which means tha we MUST NOT free it
     using g_free() but by setting to the same window ('parent')
     either a NULL pointer, or doing nothing: in that latter case, the
     memory stays occupied until overwritten by another "opening
     process".
  */
  g_object_set_data (G_OBJECT (parent), "atomdefs_filename", NULL);
  
  return 1;
}

gint
on_polyxdef_new_atom_definition_activate (GtkWidget *widget,
					      gpointer data)
{
  /* We start the creation of a new atom definition context...
  */
  if (NULL == polyxdef_main_prepare_new_context (NULL,
						 ATOM_DEF))
    g_critical (_("%s@%d: failed to create an atom definition context\n"),
	   __FILE__, __LINE__);
  
  return 1;
}


/* polyxdef menu (Polymer Definition)..
 */
gint
on_polyxdef_open_polymer_definition_activate (GtkWidget *widget,
					      gpointer data)
{
  GtkWidget *parent = data;
  GtkWidget *window = NULL;

  PxmPolchemdefSpec *ps = NULL;

  
  g_assert (parent != NULL);
  
  window = polyxmass_filechoosers_show_wnd (parent,
					    PXM_FILE_CHOOSE_POLCHEMDEF
					    | PXM_FILE_CHOOSE_GTK);
  g_assert (window != NULL);

  ps = g_object_get_data (G_OBJECT (parent), "polchemdefspec");

  if (ps == NULL)
    {
      /*
	debug_printf (("nothing\n"));
      */
      return 0;
    }

  /*
    debug_printf (("ps has type value: '%s' and file value: '%s'\n", 
    ps->type, ps->file));
  */


  /* At this time we can start the creation of a new 
     polymer chemistry definition context...
  */
  if (NULL == polyxdef_main_prepare_new_context (ps->file,
						 POLCHEM_DEF))
    g_critical (_("%s@%d: failed to create an polymer chemistry "
	     "definition context for file: '%s'.\n"),
	   __FILE__, __LINE__, ps->file);
  

  /* The allocated ps object was set to this window as a full datum
     with name "polchemdefspec"... Which means tha we MUST NOT free it
     using libpolyxmass_polchemdefspec_free() but by setting to the
     same window ('parent') either a NULL pointer, or doing nothing:
     in that latter case, the memory stays occupied until overwritten
     by another "opening process".
  */
  g_object_set_data (G_OBJECT (parent), "polchemdefspec", NULL);
  
  return 1;
}

gint
on_polyxdef_new_polymer_definition_activate (GtkWidget *widget,
					      gpointer data)
{
  /* We start the creation of a new atom definition context...
  */
  if (NULL == polyxdef_main_prepare_new_context (NULL,
						 POLCHEM_DEF))
    g_critical (_("%s@%d: failed to create a new polymer"
	     " chemistry definition context\n"),
	   __FILE__, __LINE__);
  
  return 1;
}


/* polyxcalc menu.
 */
gint
on_polyxcalc_new_calculator_without_polchemdef_activate (GtkWidget *widget,
							 gpointer data)
{
  PxmCalcCtxt *calcctxt = NULL;

  calcctxt = polyxcalc_main_prepare_new_context (NULL);
  
  if (calcctxt == NULL)
    {
      g_critical (_("%s@%d: failed to create a new mass calculator context.\n"),
	     __FILE__, __LINE__);
      
      return 0;
    }

  return 1;
}


gint
on_polyxcalc_new_calculator_with_polchemdef_activate (GtkWidget *widget,
						      gpointer data)
{
  PxmCalcCtxt *calcctxt = NULL;
  
  GtkWidget *parent = data;
  GtkWidget *window = NULL;

  PxmPolchemdefSpec *ps = NULL;
    
  
  g_assert (parent != NULL);
  
  window = polyxmass_filechoosers_show_wnd (parent,
					    PXM_FILE_CHOOSE_POLCHEMDEF);
  g_assert (window != NULL);
  
  ps = g_object_get_data (G_OBJECT (parent), "polchemdefspec");

  if (ps == NULL)
    {
      /*
	debug_printf (("nothing\n"));
      */
      return 0;
    }

  /*
    debug_printf (("ps has type value: '%s'\n", ps->type));
  */

  calcctxt = polyxcalc_main_prepare_new_context (ps);
  
  if (calcctxt == NULL)
    {
      g_critical (_("%s@%d: failed to create a new mass calculator context.\n"),
	     __FILE__, __LINE__);
      
      return 0;
    }
  
  /* The allocated ps object was set to this window as a full datum
     with name "polchemdefspec"... Which means tha we MUST NOT free it
     using libpolyxmass_polchemdefspec_free() but by setting to the
     same window ('parent') either a NULL pointer, or doing nothing:
     in that latter case, the memory stays occupied until overwritten
     by another "opening process".
  */
  g_object_set_data (G_OBJECT (parent), "polchemdefspec", NULL);

  return 1;
}


/* polyxedit menu.
 */
gint
on_polyxedit_open_sequence_file_activate (GtkWidget *widget,
			    gpointer data)
{
  GtkWidget *parent = data;
  GtkWidget *dialog = NULL;
  
  gchar *filename = NULL;
  
  
  g_assert (parent != NULL);
  
  
  dialog = gtk_file_chooser_dialog_new (_("Open Polymer Sequence File"),
					GTK_WINDOW (parent),
					GTK_FILE_CHOOSER_ACTION_OPEN,
					GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
					NULL);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) != GTK_RESPONSE_ACCEPT)
    {
      gtk_widget_destroy (dialog);

      return 1;
    }
  
  /* At this point, something might be useful here.
   */
  filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  
  if (FALSE == g_file_test (filename, G_FILE_TEST_EXISTS))
    {
      g_free (filename);
      
       gtk_widget_destroy (dialog);

      return 1;
    }
     
  /* At this time we can start the creation of a new polymer sequence
     editing context...
  */
  if (NULL == polyxedit_main_prepare_new_context_open_file (filename))
    g_critical (_("%s@%d: failed to create a polymer sequence editor "
	     "context for file: '%s'.\n"),
	   __FILE__, __LINE__, filename);

  g_free (filename);

  gtk_widget_destroy (dialog);
  
  return 1;
}


gint
on_polyxedit_new_sequence_file_activate (GtkWidget *widget,
			    gpointer data)
{
  
  if (NULL == polyxedit_main_prepare_new_context_new_file ())
    g_critical (_("%s@%d: failed to create a new polymer sequence editor"
	     " context.\n"),
	   __FILE__, __LINE__);
  
  return 1;
}


gint
on_polyxedit_display_masses_window_activate (GtkWidget *widget,
					     gpointer data)
{
  /* The user wants that the small window where masses are displayed
     be either shown or hidden. 

     Note that this window belongs to the polyxedit module.
   */
  if (TRUE == gtk_check_menu_item_get_active ((GtkCheckMenuItem *) widget))
    polyxedit_ui_masses_display_wnd_make_visible (TRUE);
  else
    polyxedit_ui_masses_display_wnd_make_visible (FALSE);
  
  return 1; 
}


/* about menu.
 */
gint
on_polyxmass_about_activate (GtkWidget *widget,
				    gpointer data)
{
  GtkWidget *window = NULL;
  GtkWidget *label = NULL;
  GladeXML *xml = NULL;

  gchar *gui_file = NULL;
  

  gui_file = 
    g_strdup_printf ("%s/polyxmass.glade", userspec->gladedir);

  xml = glade_xml_new (gui_file, "polyxmass_about_wnd", 
		       PACKAGE);

  g_free (gui_file);
  
  if (xml == NULL)
    {
      g_error (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);
  
    return FALSE;
    }
  
  window = glade_xml_get_widget (xml, "polyxmass_about_wnd");
  
  if (window == NULL)
    {
      g_error (_("%s@%d: failed to create the program version display window\n"),
	     __FILE__, __LINE__);
    
    return FALSE;
    }
  
  /* Reuse the gui_file gchar * to construct the package/version 
     string of the information window.
  */
  gui_file = g_strdup_printf ("<span foreground=\"#397D39\" size=\"large\" style=\"normal\" weight=\"bold\">poly</span><span foreground=\"red\" size=\"x-large\" style=\"italic\" weight=\"bold\"> x </span><span foreground=\"#303c7b\" size=\"large\" style=\"normal\" weight=\"bold\">mass</span><span foreground=\"black\" style=\"normal\" weight=\"bold\"> version %s</span>", VERSION);
  
  /* Set this string to the relevant label in the window.
   */
  label = 
    glade_xml_get_widget (xml, "polyxmass_version_label");

  gtk_label_set_markup (GTK_LABEL (label), gui_file);
  
  g_free (gui_file);
  
  /* We don't need the GladeXML object any more, so unref it
   * to save some memory 
   */
  g_object_unref (G_OBJECT (xml));
  

  /* Connect the delete_event such that the window is destroyed.
   */
  g_signal_connect (G_OBJECT (window),
		    "delete_event",
		    G_CALLBACK (gtk_widget_destroy),
		    NULL);
  
  g_signal_connect (G_OBJECT (window),
		    "destroy_event",
		    G_CALLBACK (gtk_widget_destroy),
		    NULL);
  
  gtk_widget_show_all (window);
  
  return 1;
}






gboolean
polyxmass_ui_main_wnd_delete_event (GtkWidget *widget,
				     GdkEvent *event,
				     gpointer data)
{
  polyxmass_main_uninit_program ();
  
  return TRUE;
}

gboolean
polyxmass_ui_main_wnd_destroy_event (GtkWidget *widget,
				     GdkEvent *event,
				     gpointer data)
{
  polyxmass_main_uninit_program ();
  
  return TRUE;
}

