/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXEDIT_UI_SEQED_WND_H
#define POLYXEDIT_UI_SEQED_WND_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"
#include "polyxedit-seqeditorctxt.h"
#include "polyxmass-window-mngmt.h"


PxmRect monicon_rect;

gboolean scroll_size_changed;


GtkWidget *
polyxedit_seqed_wnd_setup (PxmEditCtxt *editctxt);


void
polyxedit_seqed_wnd_set_polymer_modified (PxmEditCtxt *editctxt, 
					  gboolean modified);

gboolean 
polyxedit_seqed_wnd_ensure_region_visible (PxmEditCtxt *editctxt,
					   gint start_idx,
					   gint end_idx);

gboolean
polyxedit_seqed_wnd_ensure_select_cursor_visible (GtkWidget *window, 
						  GdkEventConfigure *event, 
						  gpointer data);

gint
polyxedit_seqed_wnd_render_polseq (PxmEditCtxt *editctxt,
				   gboolean rerender);

gint
polyxedit_seqed_wnd_render_polseq_monicons (PxmEditCtxt *editctxt,
					    gboolean rerender);

gboolean
polyxedit_seqed_wnd_update_LR_end_modif_state (PxmEditCtxt *editctxt);




/*
****************************************************************
************* DRAWING FUNCTIONS THROUGHOUT THE FILE ************
****************************************************************
*/
gint 
polyxedit_seqed_wnd_redraw_sequence (PxmEditCtxt *editctxt);

void
polyxedit_seqed_wnd_draw_cursor (PxmSeqEditorCtxt *seqeditorctxt);

void
polyxedit_seqed_wnd_draw_sel_polygon (PxmSeqEditorCtxt *seqeditorctxt);

gboolean
polyxedit_seqed_wnd_update_sel_polygon (PxmSeqEditorCtxt *seqeditorctxt);

void 
polyxedit_seqed_wnd_remove_selection_polygon (PxmSeqEditorCtxt *seqeditorctxt);

void 
polyxedit_seqed_wnd_setup_monomer_flag (PxmEditCtxt *editctxt);

void 
polyxedit_seqed_wnd_update_monomer_flag (PxmEditCtxt *editctxt);





/*
****************************************************************
****** HELPER FUNCTIONS FOR HANDLING THE SEQUENCE DISPLAY ******
****************************************************************
*/
gboolean
polyxedit_seqed_wnd_monicon_get_pixel_coord (gint idx, 
					     PxmSeqEditorCtxt *seqeditorctxt, 
					     PxmRect *rect, 
					     PxmCoordsys coordsys1, 
					     PxmCoordsys coordsys2);

gint
polyxedit_seqed_wnd_get_mnm_idx_with_xy (PxmSeqEditorCtxt *seqeditorctxt, 
					 gdouble mouse_x, gdouble mouse_y);





/*
****************************************************************
**************** SEQUENCE MODIFYING  FUNCTIONS *****************
****************************************************************
*/
gboolean
polyxedit_seqed_wnd_remove_monomer (PxmEditCtxt *editctxt, gint idx);


gint
polyxedit_seqed_wnd_remove_sequence_indices (PxmEditCtxt *editctxt,
					     gint start, gint end);

gint
polyxedit_seqed_wnd_remove_selected_oligomer (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_wnd_integrate_monomer_at_idx (PxmMonomer *monomer,
					      gint idx,
					      PxmEditCtxt *editctxt);

gboolean
polyxedit_seqed_wnd_integrate_monomer_at_point (PxmMonomer *monomer,
						PxmEditCtxt *editctxt);

gint
polyxedit_seqed_wnd_integrate_sequence_at_point (GPtrArray *GPA,
						 PxmEditCtxt *editctxt);




/*
****************************************************************
**************** VARIOUS  UTILITY   FUNCTIONS ******************
****************************************************************
*/
gboolean
polyxedit_seqed_wnd_select_sequence (PxmEditCtxt *editctxt,
				     gint start_idx, gint end_idx);

gint
polyxedit_seqed_wnd_self_read_configuration (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_wnd_get_selection_indices (PxmEditCtxt *editctxt,
					   gint *start, gint * end);


PxmMonomer *
polyxedit_seqed_wnd_get_selected_monomer (PxmEditCtxt *editctxt,
					  gint *idx);







/*
****************************************************************
**************** E V E N T  HANDLING FUNCTIONS *****************
****************************************************************
*/

/* SEQEDITOR WINDOW ******************************
 */
void
polyxedit_seqed_wnd_sequence_data_button_clicked (GtkWidget *widget,
						  gpointer data);

void
polyxedit_seqed_wnd_editing_feedback_button_clicked (GtkWidget *widget,
						     gpointer data);

void
polyxedit_seqed_wnd_lr_end_modif_button_clicked (GtkWidget *widget,
						  gpointer data);
void
polyxedit_seqed_wnd_monicon_size_value_changed (GtkWidget *range,
						gpointer data);

gboolean
polyxedit_seqed_sw_size_allocate (GtkWidget *widget, 
			GtkAllocation *allocation,
				  gpointer data);


gboolean
polyxedit_seqed_wnd_focus_in_event (GtkWidget *widget, 
				    GdkEventFocus *event,
				    gpointer data);


gboolean
polyxedit_seqed_wnd_canvas_event (GtkWidget *widget,
				  GdkEvent *event,
				  gpointer data);

gboolean
polyxedit_seqed_wnd_sel_polygon_event (GtkWidget *widget,
				       GdkEvent *event,
				       gpointer data);


gboolean
polyxedit_seqed_wnd_canvas_item_event (GnomeCanvasItem *canvas_item,
				       GdkEvent *event, gpointer data);

gboolean
polyxedit_seqed_monomer_flag_expose_event (GtkWidget *widget,
					   GdkEventExpose *event, 
					   gpointer data);





/*
****************************************************************
******************** REPORTING FUNCTIONS ***********************
****************************************************************
*/
extern gchar *
polyxedit_seqed_wnd_make_report (PxmReportOpt* reportopt,
				 PxmWinMngmt* winmngmt);

gchar *
polyxedit_seqed_wnd_make_report_text_format (PxmReportOpt* reportopt,
					     PxmWinMngmt* winmngmt);

gchar *
polyxedit_seqed_wnd_make_report_latex_format (PxmReportOpt* reportopt,
					      PxmWinMngmt* winmngmt);



/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
gint 
polyxedit_seqed_wnd_delete_event (GtkWidget *window, GdkEventAny *event, 
			gpointer data);

void 
polyxedit_seqed_wnd_save_question (GtkWidget *widget,
				   gint arg,
				   gpointer data);


gboolean
polyxedit_seqed_wnd_save_and_close (PxmEditCtxt *editctxt);


void 
polyxedit_seqed_wnd_close (PxmEditCtxt *editctxt);



#endif /* ifndef POLYXEDIT_UI_SEQED_WND_H */
