/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-ui-seqed-canvas-menu.h"

#include "polyxedit-editctxt.h"
#include "polyxedit-seqeditorctxt.h"
#include "polyxedit-ui-seqed-wnd.h"
#include "polyxedit-ui-seqed-kbd.h"
#include "polyxedit-ui-seqed-clipboard.h"
#include "polyxedit-ui-calculations-opt.h"
#include "polyxedit-ui-monomer-modif.h"
#include "polyxedit-ui-polymer-modif.h"
#include "polyxedit-ui-cleave-options.h"
#include "polyxedit-ui-fragment-options.h"
#include "polyxedit-ui-elemcompos.h"
#include "polyxedit-ui-mnmcompos.h"
#include "polyxedit-ui-searchmass-options.h"
#include "polyxedit-ui-note.h"
#include "polyxedit-ui-findrep-options.h"
#include "polyxedit-acidobasic.h"
#include "polyxmass-ui-mz-ratio.h"



GtkWidget *
polyxedit_seqed_canvas_menu_setup (PxmEditCtxt *editctxt)
{
  GtkWidget *widget = NULL;

  GtkWidget *canvas_menu = NULL;
    
  GladeXML *xml = NULL;

  PxmSeqEditorCtxt *seqeditorctxt = NULL;
  
  gchar *gui_file = NULL;
  

  g_assert (editctxt != NULL);
  
  seqeditorctxt = editctxt->seqeditorctxt;
  g_assert (seqeditorctxt != NULL);
  
  g_assert (seqeditorctxt->sequence_editor_wnd != NULL);


  gui_file = 
    g_strdup_printf ("%s/polyxedit-seqeditor.glade", userspec->gladedir);

  xml = glade_xml_new (gui_file, "canvas_menu", 
		       PACKAGE);
  g_free (gui_file);

  if (xml == NULL)
    {
      g_error (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }
  

  /* Creation of the canvas menu.
   */
  canvas_menu = glade_xml_get_widget (xml, "canvas_menu");
  g_assert (canvas_menu != NULL);
  

  /* Now that we got grasp of the menu, we can attach all the handlers
     to its submenu items.
  */

  /* EDIT MENUITEM
   */
  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_canvas_menu_edit_monomer_note_single");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (canvas_menu),
		     "polyxedit_seqed_canvas_menu_edit_monomer_note_single", 
		     widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_canvas_menu_edit_monomer_note_single),
		    editctxt);


  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_canvas_menu_edit_monomer_note_range");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (canvas_menu),
		     "polyxedit_seqed_canvas_menu_edit_monomer_note_range", 
		     widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_canvas_menu_edit_monomer_note_range),
		    editctxt);


  widget = 
    glade_xml_get_widget (xml, 
			  "polyxedit_seqed_canvas_menu_edit_polymer_note");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (canvas_menu),
		     "polyxedit_seqed_canvas_menu_edit_polymer_note", 
		     widget);
  g_signal_connect (G_OBJECT (widget),
		    "activate",
		    G_CALLBACK 
		    (polyxedit_seqed_canvas_menu_edit_polymer_note),
		    editctxt);
  
  
  /* We don't need the GladeXML object any more, so unref it
   * to save some memory 
   */
  g_object_unref (G_OBJECT (xml));

  return GTK_WIDGET(canvas_menu);
}



/* EDIT MENUITEM
 */
void
polyxedit_seqed_canvas_menu_edit_monomer_note_single (GtkMenuItem *menuitem,
						      gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);


  /* We want to see/edit the notes for currently selected monomer or
     monomer below mouse cursor when the right mouse button was
     clicked. If -1 == last_point_3_idx, we just do not do anything.
  */
  if (editctxt->seqeditorctxt->last_point_3_idx == -1)
    return;
  
  if (NULL == polyxedit_note_setup_wnd (editctxt,
					NOTE_TARGET_MONOMER_SINGLE,
					-1,
					-1,
					editctxt->seqeditorctxt->
					last_point_3_idx))
    {
      g_critical (_("%s@%d: failed to display the monomer note editing window.\n"),
	     __FILE__, __LINE__);
    }
  
  return;
}


void
polyxedit_seqed_canvas_menu_edit_monomer_note_range (GtkMenuItem *menuitem,
						     gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;

  gint start = 0;
  gint end = 0;
  gint clicked = 0;
  


  g_assert (editctxt != NULL);


  clicked = editctxt->seqeditorctxt->last_point_3_idx;

  /* The user wants to edit the notes in a range of monomers. The range
     of monomer into which the notes are to be edited is defined as 
     the current selection. If there is no selection, than we should 
     alert the user and return without doing anything.
  */

  /* Also, we will have to make sure that the monomer onto which
     the cursor was lying when the right click occurred is indeed in
     the currently selected region, because this monomer is the one
     from which the PxmNotes properties are going to be displayed in
     the window to display.
  */
  
  if (FALSE == polyxedit_seqed_wnd_get_selection_indices (editctxt,
							  &start,
							  &end))
    {
      g_critical (_("%s@%d: please, select the range first.\n"),
	     __FILE__, __LINE__);
      
      return;
    }
  
  /* We want to see/edit the notes for currently selected monomer or
     monomer below mouse cursor when the right mouse button was
     clicked. If -1 == last_point_3_idx, we just do not do anything.
  */
  
  /* Remember that the function above returns an end index incremented
     by one value, so we have to decrement it.
  */
  end--;
  
  if (clicked > end || clicked < start)
    {
      g_critical (_("%s@%d: please, click one monomer of the selected range.\n"),
	     __FILE__, __LINE__);
      
      return;
    }

  if (NULL == polyxedit_note_setup_wnd (editctxt,
					NOTE_TARGET_MONOMER_RANGE,
					start,
					end,
					editctxt->seqeditorctxt->
					last_point_3_idx))
    {
      g_critical (_("%s@%d: failed to display the monomer note editing window.\n"),
	     __FILE__, __LINE__);
    }
  
  return;
}


void
polyxedit_seqed_canvas_menu_edit_polymer_note (GtkMenuItem *menuitem,
					       gpointer data)
{
  /* The data parameter is editctxt.
   */
  PxmEditCtxt *editctxt = data;
  

  g_assert (editctxt != NULL);

  /* We want to see/edit the notes for currently selected monomer or
     monomer below mouse cursor when the right mouse button was
     clicked.
  */
  if (NULL == polyxedit_note_setup_wnd (editctxt,
					NOTE_TARGET_POLYMER,
					-1,
					-1,
					-1))
    {
      g_critical (_("%s@%d: failed to display the polymer note editing window.\n"),
	     __FILE__, __LINE__);
    }

  return;
}

