/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-ui-polymer-modif.h"
#include "polyxedit-ui-seqed-wnd.h"
#include "polyxedit-ui-masses-display-wnd.h"




GtkWidget *
polyxedit_ui_polymer_modif_setup_wnd (PxmEditCtxt *editctxt)
{
  GtkWidget *window = NULL;
  GtkWidget *widget = NULL;
  GtkTreeView *treeview = NULL;
  
  PxmSeqEditorCtxt *seqeditorctxt = NULL;
  
  PxmProp *prop = NULL;
  
  GladeXML *xml = NULL;

  gchar *gui_file = NULL;
  gchar *help = NULL;


  g_assert (editctxt != NULL);
  
  seqeditorctxt = editctxt->seqeditorctxt;
  g_assert (seqeditorctxt != NULL);
  


  gui_file = 
    g_strdup_printf ("%s/polyxedit-polymer-modif.glade", userspec->gladedir);
  
  g_assert (gui_file != NULL);
  
  xml = glade_xml_new (gui_file, "polymer_modif_wnd", 
		       PACKAGE);
  if (xml == NULL)
    {
      g_error (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }
  
  window = glade_xml_get_widget (xml, "polymer_modif_wnd");
  
  if (window == NULL)
    {
      g_critical (_("%s@%d: failed to create the polymer modification window\n"),
	     __FILE__, __LINE__);

      g_object_unref (G_OBJECT (xml));

      return NULL;
    }

  /* Immediately set to the window a pointer to the editctxt:
   */
  g_object_set_data (G_OBJECT (window), "editctxt", editctxt);


  widget = glade_xml_get_widget (xml, "messages_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "messages_entry",
		     widget);


  /* Set the polymer name to the relative entry.
   */
  widget = glade_xml_get_widget (xml, "polymer_sequence_name_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "polymer_sequence_name_entry", 
		     widget);
  
  if (editctxt->polymer->plminfo->name != NULL)
    gtk_entry_set_text (GTK_ENTRY (widget), 
			editctxt->polymer->plminfo->name);
  else
    gtk_entry_set_text (GTK_ENTRY (widget), _("Not set"));
  

  widget = glade_xml_get_widget (xml, "polymer_sequence_id_number_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), "polymer_sequence_id_number_entry", 
		     widget);
  
  /* Set the polymer id number (the pointer to editctxt
     to the relative entry.
   */
  help = g_strdup_printf ("%p", editctxt);
  gtk_entry_set_text (GTK_ENTRY (widget), help);
  g_free (help);
  
  /* Now deal systematically with the widgets that we will use later.
   */
  widget = glade_xml_get_widget (xml, 
				 "left_end_modif_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "left_end_modif_entry",
		     widget);
  /* Get the current left end modification of the polymer and set
     its name (if any modif) to the entry.
  */
  prop = libpolyxmass_prop_find_prop (editctxt->polymer->propGPA,
				  NULL,
				  NULL,
				  "LEFT_END_MODIF",
				  NULL,
				  PXM_UNDEF_PROP_CMP);
  if (prop != NULL)
    gtk_entry_set_text (GTK_ENTRY (widget), (gchar *) prop->data);
  

  widget = glade_xml_get_widget (xml, 
				 "right_end_modif_entry");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "right_end_modif_entry",
		     widget);

  /* Get the current left end modification of the polymer and set
     its name (if any modif) to the entry.
  */
  prop = libpolyxmass_prop_find_prop (editctxt->polymer->propGPA,
				  NULL,
				  NULL,
				  "RIGHT_END_MODIF",
				  NULL,
				  PXM_UNDEF_PROP_CMP);
  if (prop != NULL)
    gtk_entry_set_text (GTK_ENTRY (widget), (gchar *) prop->data);
  

  widget = glade_xml_get_widget (xml, 
				 "available_modifications_treeview");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "available_modifications_treeview",
		     widget);

  widget = glade_xml_get_widget (xml, 
				 "target_left_end_radiobutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "target_left_end_radiobutton",
		     widget);

  widget = glade_xml_get_widget (xml, 
				 "target_right_end_radiobutton");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "target_right_end_radiobutton",
		     widget);

  
  /* The buttons are connected through signals to related functions.
   */
  widget = 
    glade_xml_get_widget (xml, "polymer_modification_modify_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polymer_modification_modify_button",
		     widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK (polyxedit_ui_polymer_modif_modify_button), 
		    window);

  widget = 
    glade_xml_get_widget (xml, "polymer_modification_un_modify_button");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (window), 
		     "polymer_modification_un_modify_button",
		     widget);

  g_signal_connect (G_OBJECT (widget),
		    "clicked",
		    G_CALLBACK (polyxedit_ui_polymer_modif_un_modify_button),
		    window);

  
  gtk_widget_show_all (GTK_WIDGET (window));
  
  /* We have finished setting up the window, and so also using
   * the xml data, unref them
   */
  g_object_unref (G_OBJECT (xml));

  /* And now that we know all the window is set up, we can fill the
     data in it: the list of available modifications, the list of the
     monomers in the polymer definition context, the position of the
     possibly selected monomer...
  */

  /* Fill the treeview of modifications avaialable to the polymer
     definition context of that specific polymer sequence.
  */
  treeview = 
    GTK_TREE_VIEW (g_object_get_data (G_OBJECT (window), 
				      "available_modifications_treeview"));

  if (FALSE == 
      polyxedit_ui_polymer_modif_setup_modifs_treeview (treeview,
							editctxt->
							polchemdefctxt->polchemdef))
    {
      g_critical (_("%s@%d: failed to fill the modifications list\n"),
	     __FILE__, __LINE__);
    }
  
  /* The signal of the window itself.
   */
  /* Signal / callback connections.
   */
  g_signal_connect 
    (G_OBJECT (window),
     "delete_event",
     G_CALLBACK (polyxedit_ui_polymer_modif_wnd_delete_event), 
     editctxt);



  return window;
}


gboolean
polyxedit_ui_polymer_modif_setup_modifs_treeview (GtkTreeView *treeview,
						     PxmPolchemdef *polchemdef)
{
  GPtrArray *GPA = NULL;

  GtkCellRenderer *renderer = NULL;
  GtkListStore *model;
  GtkTreeIter tree_iter;

  gint iter = 0;

  PxmModif *modif;


  g_assert (polchemdef != NULL);
  GPA = polchemdef->modifGPA;
  
  /* Create the list store.
   */
  model = gtk_list_store_new (COLUMN_MDF_COL_COUNT, /*Numb. of columns*/
			      G_TYPE_STRING,
			      G_TYPE_STRING,
			      G_TYPE_BOOLEAN /* editability */);

  /* Add the items if GPA is non-null and there are items in it.
   */
  if (GPA != NULL)
    {
      for (iter = 0 ; iter < GPA->len ; iter++)
	{
	  /* Acquire an iterator.
	   */
	  gtk_list_store_append (model, &tree_iter);
	  
	  modif = g_ptr_array_index (GPA, iter);
	  
	  gtk_list_store_set (model, &tree_iter,
			      
			      COLUMN_MDF_NAME, 
			      modif->name,
			      
			      COLUMN_MDF_ACTFORM, 
			      modif->actform,
			      
			      COLUMN_MDF_EDITABLE, FALSE,
			      -1);
	}
    }
  
  gtk_tree_view_set_model (treeview, GTK_TREE_MODEL (model));  

  g_object_unref (G_OBJECT (model));

  gtk_tree_selection_set_mode (gtk_tree_view_get_selection 
			       (GTK_TREE_VIEW (treeview)),
			       GTK_SELECTION_SINGLE);
  

  /* Modif Name column.
   */
  renderer = gtk_cell_renderer_text_new ();

  /*
    GtkTreeViewColumn *column = NULL;
    
    column = 
    gtk_tree_view_column_new_with_attributes (_("Name"), 
    renderer,
    "text", COLUMN_MDF_NAME,
    NULL); 
    
    gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  */
  
  gtk_tree_view_insert_column_with_attributes 
    (GTK_TREE_VIEW (treeview),
     -1, _("Name"), renderer,
     "text", COLUMN_MDF_NAME,
     "editable", COLUMN_MDF_EDITABLE,
     NULL);
  
  g_object_set_data (G_OBJECT (renderer), "column", 
		     (gint *) COLUMN_MDF_NAME);


  /* Modif Actform column.
   */
  renderer = gtk_cell_renderer_text_new ();

  gtk_tree_view_insert_column_with_attributes 
    (GTK_TREE_VIEW (treeview),
     -1, _("Actform"), renderer,
     "text", COLUMN_MDF_ACTFORM,
     "editable", COLUMN_MDF_EDITABLE,
     NULL);
  
  g_object_set_data (G_OBJECT (renderer), "column", 
		     (gint *) COLUMN_MDF_ACTFORM);

  return TRUE;
}


void
polyxedit_ui_polymer_modif_modify_button (GtkWidget *button,
					  gpointer data)
{
  gboolean target_left_end = FALSE;
    
  GtkWidget *window = data;
  GtkWidget *widget = NULL;
  GtkWidget *radio = NULL;

  GtkTreeView * treeview = NULL;
  GtkTreeIter treeiter;
  GtkTreeSelection* selection = NULL; 
  GtkTreeModel *model = NULL;

  PxmEditCtxt *editctxt = NULL;

  gchar *modif_name = NULL;


  g_assert (window != NULL);
  
  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);
  
  treeview = g_object_get_data (G_OBJECT (window), 
				      "available_modifications_treeview");
  
  /* Ensure right away that there is one modification selected.
   */
  model = gtk_tree_view_get_model (treeview);
  g_assert (model != NULL);
  
  selection = gtk_tree_view_get_selection (treeview);
  
  if (FALSE == gtk_tree_selection_get_selected (selection,
						NULL,
						&treeiter))
    {
      polyxmass_timeoutmsg_message_set ((GtkWindow *) window,
					 _("Select a modification to apply"),
					 POLYXMASS_NORM_MSG_TIMEOUT);
    
      return; /*no selection, just return. */
    }
  

  /* At this point treeiter points to the selected item in the treeview.
     This means that we must get the name out of the item.
   */
  /* Make sure you terminate calls to gtk_tree_model_get()
     with a '-1' value. We can do this call because we have the treeiter
     pointing to the selected node!
   */
  gtk_tree_model_get (model, &treeiter, 
		      COLUMN_MDF_NAME, &modif_name,
		      -1);

  g_assert (modif_name != NULL); /* Free it later.*/
  
  /*
    debug_printf (("modif name: %s\n", modif_name));
  */

  /* Get the target of the modification. The radiobuttons will tell.
   */

  radio = g_object_get_data (G_OBJECT (window), 
			     "target_left_end_radiobutton");
  g_assert (radio != NULL);

  target_left_end = 
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio));

  /* Do the modification proper.
   */  
  if (target_left_end == TRUE)
    {
      if (MODIF_SUCCESS != 
	  pxmchem_polymer_LE_modify (editctxt->polymer, modif_name))
	{
	  polyxmass_timeoutmsg_message_set ((GtkWindow *) window,
						 _("Failed to modify Left End"), 
						 POLYXMASS_NORM_MSG_TIMEOUT);
	}
      else
	{
	  polyxedit_seqed_wnd_set_polymer_modified (editctxt, TRUE);
	  
	  /* Set the modification name to the related entry.
	   */
	    widget = g_object_get_data (G_OBJECT (window), 
					   "left_end_modif_entry");
	    g_assert (widget != NULL);

	    gtk_entry_set_text (GTK_ENTRY (widget), modif_name);
	}
    }
  
  else /* (target_left_end == FALSE)*/
    {
      if (MODIF_SUCCESS !=
	  pxmchem_polymer_RE_modify (editctxt->polymer, modif_name))
	{
	  polyxmass_timeoutmsg_message_set 
	    ((GtkWindow *) window, 
	     _("Failed to modify Right End"), 
	     POLYXMASS_NORM_MSG_TIMEOUT);
	}
      else
	{
	  polyxedit_seqed_wnd_set_polymer_modified (editctxt, TRUE);
	  
	  /* Set the modification name to the related entry.
	   */
	    widget = g_object_get_data (G_OBJECT (window), 
					   "right_end_modif_entry");
	    g_assert (widget != NULL);

	    gtk_entry_set_text (GTK_ENTRY (widget), modif_name);
	}
    }
  
  /* Free the allocated modif_name.
   */
  g_free (modif_name);

  /* Now that chemistry was done, we can update the entries in the
     polymer sequence context's sequence editor window.
  */
  polyxedit_seqed_wnd_update_LR_end_modif_state (editctxt);
    

  /* The sequence and the selection.
   */
  polyxedit_ui_masses_display_wnd_update_sequence_masses
    ((PxmEditCtxt *) polyxedit_last_editctxt);
  
  polyxedit_ui_masses_display_wnd_update_selection_masses
    ((PxmEditCtxt *) polyxedit_last_editctxt);

  return;
}

void
polyxedit_ui_polymer_modif_un_modify_button (GtkWidget *button,
					     gpointer data)
{
  gboolean target_left_end = FALSE;
    
  GtkWidget *window = data;
  GtkWidget *widget = NULL;
  GtkWidget *radio = NULL;

  GtkTreeView * treeview = NULL;
  GtkTreeIter treeiter;
  GtkTreeSelection* selection = NULL; 
  GtkTreeModel *model = NULL;

  PxmEditCtxt *editctxt = NULL;

  gchar *modif_name = NULL;


  g_assert (window != NULL);
  
  editctxt = g_object_get_data (G_OBJECT (window), "editctxt");
  g_assert (editctxt != NULL);
  

  treeview = g_object_get_data (G_OBJECT (window), 
				      "available_modifications_treeview");
  
  /* Check if there is one modification selected. Indeed, the
     processing here is a bit different than for the modification:
     there can be no modification selected. If such is the case, that
     means that the un-modification processing will be performed
     whatever the current modification of the target monomers as
     determined later by the call to gtk_toggle_button_get_active ().
     Instead, if a modification is selected, then the un-modification
     will only effectively be performed on the polymer end selected if
     it is already modified with this modification precisely.
   */
  model = gtk_tree_view_get_model (treeview);
  g_assert (model != NULL);
  
  selection = gtk_tree_view_get_selection (treeview);
  
  if (FALSE == gtk_tree_selection_get_selected (selection,
						NULL,
						&treeiter))
    {
      /* No modification is selected. The un-modification will be
	 performed whatever the current modification on the polymer
	 sequence's end selected.
      */
    }
  else
    {
      /* At this point treeiter points to the selected item in the treeview.
	 This means that we must get the name out of the item.
      */
      /* Make sure you terminate calls to gtk_tree_model_get()
	 with a '-1' value. We can do this call because we have the treeiter
	 pointing to the selected node!
      */
      gtk_tree_model_get (model, &treeiter, 
			  COLUMN_MDF_NAME, &modif_name,
			  -1);
      
      g_assert (modif_name != NULL); /* Free it later.*/
    }
  
  /* Now modif_name is either NULL or points to an allocated string
     containing the modification name.
  */

  /* Get the target of the modification. The radiobuttons will tell.
   */

  radio = g_object_get_data (G_OBJECT (window), 
			     "target_left_end_radiobutton");
  g_assert (radio != NULL);

  target_left_end = 
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio));

  /* Do the modification proper.
   */  
  if (target_left_end == TRUE)
    {
      if (UN_MODIF_FAILURE == 
	  pxmchem_polymer_LE_un_modify (editctxt->polymer, modif_name))
	{
	  polyxmass_timeoutmsg_message_set 
	    ((GtkWindow *) window,
	     _("Failed to un-modify Left End"), 
	     POLYXMASS_NORM_MSG_TIMEOUT);
	}
      else
	{
	  polyxedit_seqed_wnd_set_polymer_modified (editctxt, TRUE);
	  
	  /* Set the modification name to the related entry.
	   */
	    widget = g_object_get_data (G_OBJECT (window), 
					   "left_end_modif_entry");
	    g_assert (widget != NULL);

	    gtk_entry_set_text (GTK_ENTRY (widget), _("Not set"));
	}
    }
  
  else /* (target_left_end == FALSE)*/
    {
      if (UN_MODIF_FAILURE == 
	  pxmchem_polymer_RE_un_modify (editctxt->polymer, modif_name))
	{
	  polyxmass_timeoutmsg_message_set 
	    ((GtkWindow *) window,
	     _("Failed to un-modify Right End"), 
	     POLYXMASS_NORM_MSG_TIMEOUT);
	}
      else
	{
	  polyxedit_seqed_wnd_set_polymer_modified (editctxt, TRUE);
	  
	  /* Set the modification name to the related entry.
	   */
	    widget = g_object_get_data (G_OBJECT (window), 
					   "right_end_modif_entry");
	    g_assert (widget != NULL);

	    gtk_entry_set_text (GTK_ENTRY (widget), _("Not set"));
	}
    }
  
  /* Free the allocated modif_name (if it was allocated!).
   */
  if (modif_name != NULL)
    g_free (modif_name);
  
  /* Now that chemistry was done, we can update the entries in the
     polymer sequence context's sequence editor window.
  */
  polyxedit_seqed_wnd_update_LR_end_modif_state (editctxt);


  /* The sequence and the selection.
   */
  polyxedit_ui_masses_display_wnd_update_sequence_masses
    ((PxmEditCtxt *) polyxedit_last_editctxt);
  
  polyxedit_ui_masses_display_wnd_update_selection_masses
    ((PxmEditCtxt *) polyxedit_last_editctxt);

  return;
}










gboolean
polyxedit_ui_polymer_modif_wnd_delete_event (GtkWidget *window, 
					     GdkEventAny *event, 
					     gpointer data)
{
  gint count = 0;
  

  /* 
     Prior to closing the window, we want to make sure that no
     pending timed-out messages are there...
  */
  count = polyxmass_timeoutmsg_messages_remove ((GtkWindow *) window);
  
  /*
    printf ("polyxedit_elemcompos_wnd_delete_event, count is %d\n",
    count);
  */
  return FALSE;
}
