//
// Channel.h
//
// $Id: //poco/1.3/Foundation/include/Poco/Channel.h#2 $
//
// Library: Foundation
// Package: Logging
// Module:  Channel
//
// Definition of the Channel class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_Channel_INCLUDED
#define Foundation_Channel_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/Configurable.h"
#include "Poco/Mutex.h"
#include "Poco/RefCountedObject.h"


namespace Poco {


class Message;


class Foundation_API Channel: public Configurable, public RefCountedObject
	/// The base class for all Channel classes.
	///
	/// Supports reference counting based garbage
	/// collection and provides trivial implementations
	/// of getProperty() and setProperty().
{
public:
	Channel();
		/// Creates the channel and initializes
		/// the reference count to one.

	virtual void open();
		/// Does whatever is necessary to open the channel. 
		/// The default implementation does nothing.
		
	virtual void close();
		/// Does whatever is necessary to close the channel.
		/// The default implementation does nothing.
		
	virtual void log(const Message& msg) = 0;
		/// Logs the given message to the channel. Must be
		/// overridden by subclasses.
		///
		/// If the channel has not been opened yet, the log()
		/// method will open it.
		
	void setProperty(const std::string& name, const std::string& value);
		/// Throws a PropertyNotSupportedException.

	std::string getProperty(const std::string& name) const;
		/// Throws a PropertyNotSupportedException.
		
protected:
	virtual ~Channel();
	
private:
	Channel(const Channel&);
	Channel& operator = (const Channel&);
};


} // namespace Poco


#endif // Foundation_Channel_INCLUDED
