//
// ValidatorTest.cpp
//
// $Id: //poco/1.2/Util/testsuite/src/ValidatorTest.cpp#1 $
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "ValidatorTest.h"
#include "CppUnit/TestCaller.h"
#include "CppUnit/TestSuite.h"
#include "Poco/Util/RegExpValidator.h"
#include "Poco/Util/IntValidator.h"
#include "Poco/Util/Option.h"
#include "Poco/Util/OptionException.h"
#include "Poco/AutoPtr.h"


using Poco::Util::Validator;
using Poco::Util::RegExpValidator;
using Poco::Util::IntValidator;
using Poco::Util::Option;
using Poco::Util::InvalidArgumentException;
using Poco::AutoPtr;


ValidatorTest::ValidatorTest(const std::string& name): CppUnit::TestCase(name)
{
}


ValidatorTest::~ValidatorTest()
{
}


void ValidatorTest::testRegExpValidator()
{
	Option option("option", "o");
	AutoPtr<Validator> pVal(new RegExpValidator("[0-9]+"));
	
	pVal->validate(option, "0");
	pVal->validate(option, "12345");

	try
	{
		pVal->validate(option, " 234");
		fail("does not match - must throw");
	}
	catch (InvalidArgumentException& exc)
	{
		std::string s(exc.message());
		assert (s == "argument for option does not match regular expression [0-9]+");
	}

	try
	{
		pVal->validate(option, "234asdf");
		fail("does not match - must throw");
	}
	catch (InvalidArgumentException& exc)
	{
		std::string s(exc.message());
		assert (s == "argument for option does not match regular expression [0-9]+");
	}

	try
	{
		pVal->validate(option, "abc");
		fail("does not match - must throw");
	}
	catch (InvalidArgumentException& exc)
	{
		std::string s(exc.message());
		assert (s == "argument for option does not match regular expression [0-9]+");
	}

	try
	{
		pVal->validate(option, "");
		fail("does not match - must throw");
	}
	catch (InvalidArgumentException& exc)
	{
		std::string s(exc.message());
		assert (s == "argument for option does not match regular expression [0-9]+");
	}
}


void ValidatorTest::testIntValidator()
{
	Option option("option", "o");
	AutoPtr<Validator> pVal(new IntValidator(0, 100));
	
	pVal->validate(option, "0");
	pVal->validate(option, "100");
	pVal->validate(option, "55");
	
	try
	{
		pVal->validate(option, "-1");
		fail("out of range - must throw");
	}
	catch (InvalidArgumentException& exc)
	{
		std::string s(exc.message());
		assert (s == "argument for option must be in range 0 to 100");
	}

	try
	{
		pVal->validate(option, "101");
		fail("out of range - must throw");
	}
	catch (InvalidArgumentException& exc)
	{
		std::string s(exc.message());
		assert (s == "argument for option must be in range 0 to 100");
	}

	try
	{
		pVal->validate(option, "asdf");
		fail("not a number - must throw");
	}
	catch (InvalidArgumentException& exc)
	{
		std::string s(exc.message());
		assert (s == "argument for option must be an integer");
	}
}


void ValidatorTest::setUp()
{
}


void ValidatorTest::tearDown()
{
}


CppUnit::Test* ValidatorTest::suite()
{
	CppUnit::TestSuite* pSuite = new CppUnit::TestSuite("ValidatorTest");

	CppUnit_addTest(pSuite, ValidatorTest, testRegExpValidator);
	CppUnit_addTest(pSuite, ValidatorTest, testIntValidator);

	return pSuite;
}
