/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.ExDataInputStream;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngImage;
import java.io.IOException;

class Chunk
implements Cloneable {
    static final int IHDR = Chunk.stringToType("IHDR");
    static final int PLTE = Chunk.stringToType("PLTE");
    static final int IDAT = Chunk.stringToType("IDAT");
    static final int IEND = Chunk.stringToType("IEND");
    static final int bKGD = Chunk.stringToType("bKGD");
    static final int cHRM = Chunk.stringToType("cHRM");
    static final int gAMA = Chunk.stringToType("gAMA");
    static final int hIST = Chunk.stringToType("hIST");
    static final int pHYs = Chunk.stringToType("pHYs");
    static final int sBIT = Chunk.stringToType("sBIT");
    static final int tEXt = Chunk.stringToType("tEXt");
    static final int tIME = Chunk.stringToType("tIME");
    static final int tRNS = Chunk.stringToType("tRNS");
    static final int zTXt = Chunk.stringToType("zTXt");
    static final int sRGB = Chunk.stringToType("sRGB");
    static final int sPLT = Chunk.stringToType("sPLT");
    static final int oFFs = Chunk.stringToType("oFFs");
    static final int sCAL = Chunk.stringToType("sCAL");
    static final int iCCP = Chunk.stringToType("iCCP");
    static final int pCAL = Chunk.stringToType("pCAL");
    static final int iTXt = Chunk.stringToType("iTXt");
    static final int gIFg = Chunk.stringToType("gIFg");
    static final int gIFx = Chunk.stringToType("gIFx");
    int length;
    int type;
    protected PngImage img;
    protected ExDataInputStream in_data;
    static /* synthetic */ Class class$com$sixlegs$image$png$Chunk;

    Chunk copy() {
        try {
            return (Chunk)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    boolean isAncillary() {
        boolean bl = false;
        if ((this.type & 0x20000000) != 0) {
            bl = true;
        }
        return bl;
    }

    final boolean isPrivate() {
        boolean bl = false;
        if ((this.type & 0x200000) != 0) {
            bl = true;
        }
        return bl;
    }

    final boolean isReservedSet() {
        boolean bl = false;
        if ((this.type & 0x2000) != 0) {
            bl = true;
        }
        return bl;
    }

    final boolean isSafeToCopy() {
        boolean bl = false;
        if ((this.type & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    final boolean isUnknown() {
        boolean bl = false;
        Class<?> clazz = this.getClass();
        Class clazz2 = class$com$sixlegs$image$png$Chunk;
        if (clazz2 == null) {
            clazz2 = class$com$sixlegs$image$png$Chunk = Chunk.class$("[Lcom.sixlegs.image.png.Chunk;", false);
        }
        if (clazz == clazz2) {
            bl = true;
        }
        return bl;
    }

    int bytesRemaining() {
        return Math.max(0, this.length + 4 - this.img.data.in_idat.count());
    }

    protected boolean multipleOK() {
        return true;
    }

    protected boolean beforeIDAT() {
        return false;
    }

    static String typeToString(int n) {
        return "" + (char)(n >>> 24 & 0xFF) + (char)(n >>> 16 & 0xFF) + (char)(n >>> 8 & 0xFF) + (char)(n & 0xFF);
    }

    static int stringToType(String string) {
        return (string.charAt(0) & 0xFF) << 24 | (string.charAt(1) & 0xFF) << 16 | (string.charAt(2) & 0xFF) << 8 | string.charAt(3) & 0xFF;
    }

    final void badLength(int n) throws PngException {
        throw new PngException("Bad " + Chunk.typeToString(this.type) + " chunk length: " + ExDataInputStream.unsign(this.length) + " (expected " + n + ')');
    }

    final void badLength() throws PngException {
        throw new PngException("Bad " + Chunk.typeToString(this.type) + " chunk length: " + ExDataInputStream.unsign(this.length));
    }

    protected void readData() throws IOException {
        this.in_data.skipBytes(this.length);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Chunk(int n) {
        this.type = n;
    }
}

