/*
 * TestStringBuilder.cs - Test class for "System.Text.StringBuilder" 
 *
 * Copyright (C) 2002  Southern Storm Software, Pty Ltd.
 * Copyright (C) 2002  FSF.
 * 
 * Authors : Autogenerated using csdoc2test 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using CSUnit;
using System;
using System.Text;

public class TestStringBuilder : TestCase
 {
	// Constructor.
	public TestStringBuilder(String name)	: base(name)
	{
		// Nothing to do here.
	}

	// Set up for the tests.
	protected override void Setup()
	{
		// Nothing to do here.
	}

	// Clean up after the tests.
	protected override void Cleanup()
	{
		// Nothing to do here.
	}
	public void TestStringBuilderConstructor()
	{
		StringBuilder sb;

		//  Empty constructor
		sb = new StringBuilder();
		AssertEquals("Empty Constructor",
				String.Empty, sb.ToString());

		//  String constructor, Empty String
		sb = new StringBuilder(String.Empty);
		AssertEquals("String Constructor, Empty String",
				String.Empty, sb.ToString());

		//  String constructor, Hello world
		string s = "Hello World";
		sb = new StringBuilder(s);
		AssertEquals("String constructor, Hello world",
				s, sb.ToString());
	}

	public void TestStringBuilderInsert()
	{
		StringBuilder sb;
		String path = "some/path";

		// Insert at 0 - Pre-populated sb
		sb = new StringBuilder(path);
		sb.Insert(0, "/");
		AssertEquals("Insert at 0 - Pre-populated sb",
				"/some/path", sb.ToString());

		// Insert at 0 w/o concatenation - empty sb
		sb = new StringBuilder();
		sb.Insert(0, path);
		AssertEquals("Insert at 0 w/o concatenation",
				"some/path", sb.ToString());

		// Insert at 0 w/ concatentation - empty sb
		sb = new StringBuilder();
		sb.Insert(0, "/"+path);
		AssertEquals("Insert at 0 w/ concatenation",
				"/some/path", sb.ToString());
	}
}
