/*
    pmacct (Promiscuous mode IP Accounting package)
    pmacct is Copyright (C) 2004 by Paolo Lucente
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* defines */
#define ARGS_DAEMON "n:NdDhP:b:f:F:c:i:m:p:r:s:S:"
#define ARGS_CLIENT "sc:etm:p:P:"
#define DEFAULT_DB_REFRESH_TIME 60
#define N_PRIMITIVES 8
#define MAX_N_PLUGINS 32
#define PROTO_LEN 12
#define DEFAULT_SNAPLEN 68
#define SRVBUFLEN 256
#define LONGSRVBUFLEN 384
#define LONGLONGSRVBUFLEN 1024
#define LARGEBUFLEN 8192

#define MANTAINER "Paolo Lucente <paolo.lucente@ic.cnr.it>"
#define PMACCTD_USAGE_HEADER "pmacct daemon 0.6.3"
#define PMACCT_USAGE_HEADER "pmacct client 0.6.3"
#define PMMYPLAY_USAGE_HEADER "pmacct MySQL logfile player 0.6.3"
#define PMPGPLAY_USAGE_HEADER "pmacct PGSQL logfile player 0.6.3"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ERR -1
#define SUCCESS 0

#define MIN(x, y) (x <= y ? x : y)

#define COUNT_SRC_HOST          0x00000001
#define COUNT_DST_HOST          0x00000002
#define COUNT_SUM_HOST          0x00000004
#define COUNT_SRC_PORT          0x00000008
#define COUNT_DST_PORT          0x00000010
#define COUNT_IP_PROTO          0x00000020
#define COUNT_SRC_MAC           0x00000040
#define COUNT_DST_MAC           0x00000080
#define COUNT_SRC_NET		0x00000100 
#define COUNT_DST_NET		0x00000200
#define TIMESTAMP               0x00000400 /* USE_TIMESTAMPS */
#define FAKE_SRC_MAC		0x00000800
#define FAKE_DST_MAC		0x00001000
#define FAKE_SRC_HOST		0x00002000
#define FAKE_DST_HOST		0x00004000

#define INSERT_ALREADY_DONE     0x00000001
#define INSERT_NOT_VALID        0x00000002

#define COUNT_MINUTELY          0x00000001
#define COUNT_HOURLY            0x00000002
#define COUNT_DAILY             0x00000004

#define WANT_STATS		1
#define WANT_ERASE		2
#define WANT_STATUS		3
#define WANT_MRTG		4
