/*
    pmacct (Promiscuous mode IP Accounting package)
    pmacct is Copyright (C) 2004 by Paolo Lucente
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#define DEFAULT_CHBUFLEN 4096

typedef void (*pkt_handler) (struct packet_ptrs *, struct pkt_data *);

struct channels_list_entry {
  unsigned int aggregation;
  char *buf;		/* ptr to buffer base address */
  char *bufptr;		/* ptr to buffer current address */
  char *bufend;		/* ptr to buffer end address */
  int bufsize;		
  pkt_handler phandler[N_PRIMITIVES];
  struct bpf_program *filter;
  int pipe;
};

struct ch_buf_hdr {
  int num;
};

#if (defined __PLUGIN_HOOKS_C)
extern struct channels_list_entry channels_list[MAX_N_PLUGINS];
#endif

/* Function prototypes */
#if (!defined __PLUGIN_HOOKS_C)
#define EXT extern
#else
#define EXT
#endif
EXT void load_plugins(struct pcap_device *);
EXT void exec_plugins(struct packet_ptrs *pptrs);
EXT int insert_pipe_channel(unsigned int, int, struct bpf_program *, int); 
EXT void delete_pipe_channel(int);
EXT void sort_pipe_channels();
#undef EXT

#if (defined __PLUGIN_HOOKS_C)
#define EXT extern
#else
#define EXT
#endif
EXT void imt_plugin(int, struct configuration *);

#ifdef WITH_MYSQL
EXT void mysql_plugin(int, struct configuration *);
#endif 

#ifdef WITH_PGSQL
EXT void pgsql_plugin(int, struct configuration *);
#endif

EXT char *extract_token(char **, int);
#undef EXT
