/////////////////////////////////////////////////////////////////////////
// $Id: system.cc,v 1.2 2002/07/21 23:14:55 DemonLord Exp $
/////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2002  MandrakeSoft S.A.
//
//    MandrakeSoft S.A.
//    43, rue d'Aboukir
//    75002 Paris - France
//    http://www.linux-mandrake.com/
//    http://www.mandrakesoft.com/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


#include "bochs.h"
#include "system.h"

#define LOG_THIS bx_devices.

bx_devices_c   bx_devices;


/* main memory size (in Kbytes)
 * subtract 1k for extended BIOS area
 * report only base memory, not extended mem
 */
#define BASE_MEMORY_IN_K  640


  int
plugin_init(plugin_t *plugin, int argc, char *argv[])
{
  bx_devices.init();

  return(0); // Success
}

  void
plugin_fini(void)
{
}


  // constructor for bx_devices_c
bx_devices_c::bx_devices_c(void)
{
  put("DEV");
  settype(DEVLOG);

}


bx_devices_c::~bx_devices_c(void)
{
  // nothing needed for now
}

  void
bx_devices_c::init(void)
{
  // system hardware
  pluginRegisterIOReadHandler( this,
                            read_handler,
                            0x0092,
                            "Port 92h System Control", 1 );
  pluginRegisterIOWriteHandler(this,
                            write_handler,
                            0x0092,
                            "Port 92h System Control", 1 );

  // misc. CMOS
  //Bit16u extended_memory_in_k = BX_MEM.get_memory_in_k() - 1024;
  Bit16u extended_memory_in_k = (vm_conf.max_memory - 1) * 1024;
  pluginSetCMOSReg(0x15, (Bit8u) BASE_MEMORY_IN_K);
  pluginSetCMOSReg(0x16, (Bit8u) (BASE_MEMORY_IN_K >> 8));
  pluginSetCMOSReg(0x17, (Bit8u) extended_memory_in_k);
  pluginSetCMOSReg(0x18, (Bit8u) (extended_memory_in_k >> 8));
  pluginSetCMOSReg(0x30, (Bit8u) extended_memory_in_k);
  pluginSetCMOSReg(0x31, (Bit8u) (extended_memory_in_k >> 8));
}


  Bit32u
bx_devices_c::read_handler(void *this_ptr, Bit32u address, unsigned io_len)
{
#if !BX_USE_DEV_SMF
  bx_devices_c *class_ptr = (bx_devices_c *) this_ptr;

  return( class_ptr->port92_read(address, io_len) );
}


  Bit32u
bx_devices_c::port92_read(Bit32u address, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif  // !BX_USE_DEV_SMF
  if (io_len > 1)
    BX_PANIC(("port 92h: io read from address %08x, len=%u",
             (unsigned) address, (unsigned) io_len));

  BX_INFO(("port92h read partially supported!!!"));
  BX_INFO(("  returning %02x", (unsigned) (BX_GET_ENABLE_A20() << 1)));
  return(BX_GET_ENABLE_A20() << 1);
}


  void
bx_devices_c::write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len)
{
#if !BX_USE_DEV_SMF
  bx_devices_c *class_ptr = (bx_devices_c *) this_ptr;

  class_ptr->port92_write(address, value, io_len);
}

  void
bx_devices_c::port92_write(Bit32u address, Bit32u value, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif  // !BX_USE_DEV_SMF
  Boolean bx_cpu_reset;

  if (io_len > 1)
    bx_panic("devices.c: port 92h: io read from address %08x, len=%u\n",
             (unsigned) address, (unsigned) io_len);

  BX_INFO(("devices: port92h write of %02x partially supported!!!",
    (unsigned) value));
BX_INFO(("devices: A20: set_enable_a20() called"));
  BX_SET_ENABLE_A20( (value & 0x02) >> 1 );
  BX_INFO(("A20: now %u", (unsigned) BX_GET_ENABLE_A20()));
  bx_cpu_reset  = (value & 0x01); /* high speed reset */
  if (bx_cpu_reset) {
    BX_PANIC(("PORT 92h write: CPU reset requested!"));
    }
}
