/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  instrument.h: Instrumentation header file
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __INSTRUMENT_H__
#define __INSTRUMENT_H__


#if SUPPORT_INSTRUMENTATION

/* Instrumentation supported */

#define InstrNonSIVFailIOPL    1
#define InstrNonSIVFailIF      2
#define InstrNonSIVFailVIPVIF  3
#define InstrNonSIVFailSReg    4 /* 4 .. 9 */
#define InstrNonSIVFailSRegES  4
#define InstrNonSIVFailSRegCS  5
#define InstrNonSIVFailSRegSS  6
#define InstrNonSIVFailSRegDS  7
#define InstrNonSIVFailSRegFS  8
#define InstrNonSIVFailSRegGS  9

/* Well, these _could_ actually call real functions etc. */
#define InstrNonSIVFail(reason)
#define InstrNonSIVPass()


#else  /* SUPPORT_INSTRUMENTATION */


/* Instrumentation not supported, calls are NOPs */
#define InstrNonSIVFail(reason)
#define InstrNonSIVPass()

#endif  /* SUPPORT_INSTRUMENTATION */


#endif  /* __INSTRUMENT_H__ */
