/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  segment_ctrl.c:  emulation of segment control instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"




  void
MOV_SwEw(vm_t *vm)
{
  Bit16u op2_16;

  if (vm->i.mod == 0xc0) {
    op2_16 = ReadReg16(vm, vm->i.rm);
    }
  else {
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &op2_16);
    }

  load_seg_reg(vm, vm->i.nnn, op2_16);

  if (vm->i.nnn == SRegSS) {
    /* MOV SS inhibits interrupts, debug exceptions and single-step */
    /* trap exceptions until the execution boundary following the */
    /* next instruction is reached. */
    /* Same code as POP_SS() */
    vm->guest_cpu.inhibit_mask |= INHIBIT_INTERRUPTS | INHIBIT_DEBUG;
    vm->guest_cpu.async_event = 1;
    }
}

  void
POP_SREG(vm_t *vm, unsigned sreg)
{
  Bit16u sel16;

  if (vm->i.os_32) {
    Bit32u sel32;
    pop32(vm, &sel32);
    sel16 = sel32;
    }
  else {
    pop16(vm, &sel16);
    }
  load_seg_reg(vm, sreg, sel16);

  if (sreg == SRegSS) {
    /* POP SS inhibits interrupts, debug exceptions and single-step */
    /* trap exceptions until the execution boundary following the */
    /* next instruction is reached. */
    /* Same code as MOV_SwEw() */
    vm->guest_cpu.inhibit_mask |= INHIBIT_INTERRUPTS | INHIBIT_DEBUG;
    vm->guest_cpu.async_event = 1;
    }
}

  void
LxS_GvMp(vm_t *vm, unsigned sreg)
{
  if (vm->i.mod == 0xc0) {
    /* (BW) NT seems to use this when booting. */
    monpanic(vm, "invalid use of LxS, must use memory reference!\n");
    UndefinedOpcode(vm);
    }
 
  if (vm->i.os_32) {
    Bit32u reg_32;
    Bit16u xs_raw;
 
    read_virtual_dword(vm, vm->i.seg, vm->i.rm_addr, &reg_32);
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr + 4, &xs_raw);
 
    load_seg_reg(vm, sreg, xs_raw);
 
    WriteReg32(vm, vm->i.nnn, reg_32);
    }
  else { /* 16 bit operand size */
    Bit16u reg_16;
    Bit16u xs_raw;
 
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr, &reg_16);
    read_virtual_word(vm, vm->i.seg, vm->i.rm_addr + 2, &xs_raw);
 
    load_seg_reg(vm, sreg, xs_raw);
 
    WriteReg16(vm, vm->i.nnn, reg_16);
    }
}
