/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999 - 2000 The plex86 Team
 *
 *  virtcode.c:  This file contains the test code to run in the VM
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include "virtcode.h"

#define BREAK_MASK 0x80
#define SCANCODE_MASK 0x7f
#define SHIFT 42
#define SHIFT2 0x36

unsigned char
shift_map[128] =
{0, 0x1b, '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', 0x8, 
 0x9, 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', 0xd,  0,  
 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', '"', '~', 0, '|', 
 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '<', '>', '?',0,0,0,' ',};

unsigned char 
normal_map[128] = 
{0, 0x1b, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', 0x8, 
 0x9, 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', 0xd,  0,  
 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '\'', '`', 0, '\\', 
 'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/',0,0,0,' ',};

int shift_state;

char 
get_key_code(int scancode)
{
  int make = !(scancode & BREAK_MASK);
  unsigned char *keymap;

  scancode &= SCANCODE_MASK;

  if ((scancode != SHIFT) && (scancode != SHIFT2)) {
    if (!shift_state)
      keymap = normal_map;
    else
      keymap = shift_map;
    if (make) {
      return keymap[scancode];
    } 
  }
  else {
    if (make) {
      shift_state = 1;
    }
    else {
      shift_state = 0;
    }
  }
  return 0;
}

int
getkey(void)
{
    int i;

    asm (
        "   xorl %%eax, %%eax    \n"
        "   inb  $0x64, %%al     \n"
        "   andb $0x01, %%al     \n"
        "   jz 2f                \n"
        "   inb  $0x60, %%al     \n"
        "   movl %%eax, %0       \n"
        "   inb  $0x61, %%al     \n"
        "   movb %%al,  %%ah     \n"
        "   orb  $0x80, %%al     \n"
        "   outb %%al,  $0x61    \n"
        "   movb %%ah,  %%al     \n"
        "   outb %%al,  $0x61    \n"
        "   jmp 3f               \n"
        "2: movl $-1,   %0       \n"
        "3:                      \n"
        : "=g" (i)
        :
        : "%eax"
    );

    return i;
}

int
init_keyboard(void)
{
  int i;

  /* keyboard self test */

  while(getkey() != -1);
  asm (
       "xorl %%eax,%%eax     \n"
       "movb $0xaa, %%al     \n"
       "outb %%al, $0x64     \n"
       "inb  $0x60, %%al     \n"
       "movl %%eax, %0       \n"
       : "=g" (i)
       :
       : "%eax"
       );

  if(i != 0x55) {
    printstr("Error: keyboard self-test failed.  Aborting...\n");
    return -1;
  }
  return 0;
}
