/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "../dt.h"
#include "decode.h"


static void
dump_code_fragment(char *eip, int size)
{
  struct i386_context ctx;
  struct i386_decode instr;
  char text[256];

  memset(&instr, 0, sizeof(instr));
  memset(&ctx, 0, sizeof(ctx));
  ctx.mode = CODE32;
  ctx.base = 0;
  ctx.offset = (int) eip;
  ctx.segment = 0;

  while (size > 0) {
    printf("0x%x\t", ctx.offset);

    if (!i386_decode(&ctx, &instr) ||
        !i386_decode_text(&ctx, &instr, text, SX_ATT)) {
      strcpy(text, "???");
      instr.length = 1;
      }

    printf("%s\n", text);

    size -= instr.length;
    }

  return;
}


void
debug_dump(void)
{
  int i;
  unsigned r, c, found;

  printf("\n\nDEBUG DUMP\n");

  printf("\nG2T Hits:");
  for (r = 0; r < DT_G2THashWidth; r++) {
    printf(" %u", instrG2THit[r]);
    }

  printf("\nG2T Misses: %u\n", instrG2TMiss);
  for (r = 0; r < DT_G2THashHeight; r++) {
    found = 0;
    if (dtG2THash[r][0].tOff) {
      found = 1;
      for (c = 0; c < DT_G2THashWidth; c++) {
        if (dtG2THash[r][c].tOff)
          printf("%u ", c);
        }
      }
    if (found)
      printf("\n");
    }

  printf("\nCode in guest_page0:\n");
  dump_code_fragment(guest_page0, (int) (gp0 - guest_page0));

  printf("\nCode in guest_page1:\n");
  dump_code_fragment(guest_page1, (int) (gp1 - guest_page1));

  printf("\nDump of the meta cache:\n");
  for (i = 0; i < dtMetaFreeIndex; i++) {
    printf("\nMeta entry %d: lpa = 0x%x\n", i,
           (unsigned int) dtMetaTable[i].lpa);
    dump_code_fragment(dtMetaTable[i].tcodeBuffer,
                       dtMetaTable[i].tcodeBufferFreeIndex);
    }

  return;
}


void
debug_signal(int signo)
{
  printf("\nSignal %d received, terminating\n", signo);

  exit(1);  /* Will perform debug dump */
}
