#! /bin/sh
# - remove unclear license files from upstream zipfile
# - repack upstream zip to xz

set -ue

UPSTREAM="pleaiades"
REMOVE="srctest/jp/sourceforge/mergedoc/pleiades/resource/3.*"


if [ ! -z $REMOVE ]; then
	for files in $REMOVE;
	do rm -rf $UPSTREAM-[0-9]*/$REMOVE
	done
	rename 's/*/*-dfsg/' $UPSTREAM-[0-9]*
fi

if [ $ZIP = YES ]; then
  tar cf $UPSTREAM-[0-9]*.tar $UPSTREAM-[0-9]*
fi

case )
	*.gz
	*.bz2
	*.zip
	*.7z

xz -9 $UPSTREAM-[0-9]*

exit 0

="$2"
FILE="$3"
PKG=`dpkg-parsechangelog|grep ^Source:|sed 's/^Source: //'`
REPACK_DIR="$PKG-$VER.orig"
echo -e "\nRepackaging $FILE\n"
DIR=`mktemp -d ./tmpRepackXXXXXX`
trap "rm -rf \"$DIR\"" QUIT INT EXIT
# Create an extra directory to cope with rootless tarballs
UP_BASE="$DIR/unpack"
mkdir "$UP_BASE"
tar xJf "$FILE" -C "$UP_BASE"

if [ `ls -1 "$UP_BASE" | wc -l` -eq 1 ]; then
        # Tarball does contain a root directory
        UP_BASE="$UP_BASE/`ls -1 "$UP_BASE"`"
fi
mv "$UP_BASE" "$DIR/$REPACK_DIR"
# Using a pipe hides tar errors!
tar cfC "$DIR/repacked.tar" "$DIR" "$REPACK_DIR"
xz --best  < "$DIR/repacked.tar" > "$DIR/repacked.tar.xz"
FILE="../${PKG}_${VER}.orig.tar.xz"
mv "$DIR/repacked.tar.xz" "$FILE"
echo "*** $FILE repackaged"

