/*
    Bear Engine - Level editor

    Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/base_item_filter.hpp
 * \brief Base object for filters on items.
 * \author Julien Jorge
 */
#ifndef __BF_BASE_ITEM_FILTER_HPP__
#define __BF_BASE_ITEM_FILTER_HPP__

#include <string>

namespace bf
{
  class item_instance;

  /**
   * \brief Base object for filters on items.
   * \author Julien Jorge
   */
  class base_item_filter
  {
  public:
    virtual ~base_item_filter() {}
    virtual base_item_filter* clone() const = 0;
    virtual bool evaluate( const item_instance& item ) const = 0;
    virtual std::string get_description() const = 0;

  }; // class base_item_filter
} // namespace bf

#endif // __BF_BASE_ITEM_FILTER_HPP__

