/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file boolean_constant_creator.hpp
 * \brief Class to create an item that is a boolean constant.
 * \author Sbastien Angibaud
 */
#ifndef __BEAR_BOOLEAN_CONSTANT_CREATOR_HPP__
#define __BEAR_BOOLEAN_CONSTANT_CREATOR_HPP__

#include "engine/base_item.hpp"
#include "expr/boolean_constant.hpp"
#include "engine/item_brick/with_boolean_expression_creation.hpp"

#include "engine/export.hpp"
#include "generic_items/class_export.hpp"

namespace bear
{
  /**
   * \brief This class is a boolean expression of type "boolean_constant".
   *
   * This item is a parameter for other items. He kills himself at the end of
   * his build() method.
   *
   * The fields of this item are
   *  - \a operand: (boolean) \c the value of the constant.
   *
   * \author Sbastien Angibaud
   */
  class GENERIC_ITEMS_EXPORT boolean_constant_creator:
    public engine::base_item,
    public engine::with_boolean_expression_creation
  {
    DECLARE_BASE_ITEM(boolean_constant_creator);

  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    boolean_constant_creator();

    bool set_bool_field( const std::string& name, bool value );

    void build();

  private:
    virtual expr::boolean_expression do_get_expression() const;

  private:
    /** \brief The expression created by this item. */
    expr::boolean_constant m_expr;

  }; // class boolean_constant_creator

} // namespace bear

#endif // __BEAR_BOOLEAN_CONSTANT_CREATOR_HPP__
