/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file block.hpp
 * \brief A class representing a block.
 * \author Sebastien Angibaud
 */
#ifndef __BEAR_BLOCK_HPP__
#define __BEAR_BLOCK_HPP__

#include "engine/item_brick/basic_renderable_item.hpp"
#include "engine/item_brick/item_with_activable_sides.hpp"
#include "engine/item_brick/item_with_decoration.hpp"
#include "engine/item_brick/item_with_friction.hpp"
#include "engine/item_brick/item_with_restricted_z_collision.hpp"
#include "engine/item_brick/item_with_z_shift.hpp"
#include "universe/zone.hpp"

#include "generic_items/class_export.hpp"

#include "engine/export.hpp"

namespace bear
{
  /**
   * \brief A class representing an block.
   *
   * The custom fields of this class are:
   * - collision_threshold: unsigned integer, a threshold for the collisions in
   *   the corners of the item, to choose if the other item is aligned on the
   *   collided side or the nearest adjacent one (default = 10).
   *
   * \author Sebastien Angibaud
   */
  class GENERIC_ITEMS_EXPORT block:
    public engine::item_with_friction
    < engine::item_with_restricted_z_collision
      < engine::item_with_z_shift
        < engine::item_with_activable_sides
          < engine::item_with_decoration
            < engine::basic_renderable_item<engine::base_item>
            >
          >
        >
      >
    >
  {
    DECLARE_BASE_ITEM(block);

    typedef engine::item_with_friction
    < engine::item_with_restricted_z_collision
      < engine::item_with_z_shift
        < engine::item_with_activable_sides
          < engine::item_with_decoration
            < engine::basic_renderable_item<engine::base_item>
            >
          >
        >
      >
    > super;

  public:
    block();

    bool set_u_integer_field( const std::string& name, unsigned int value );

  protected:
    void collision_check_and_align
    ( engine::base_item& that, universe::collision_info& info );

  private:
    universe::zone::position choose_alignment_side
    ( const engine::base_item& that,
      const universe::collision_info& info ) const;

    void collision
    ( engine::base_item& that, universe::collision_info& info );

  private:
    /** \brief A threshold for the collisions in the corners of the item, to
        choose if the other item is aligned on the collided side or the nearest
        adjacent one. */
    universe::coordinate_type m_collision_threshold;

  }; // class block
} // namespace bear

#endif // __BEAR_BLOCK_HPP__
