/*
  Bear Engine

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file equals.hpp
 * \brief A boolean expression that checks the equality of two linear
 *        expressions.
 * \author Julien Jorge
 */
#ifndef __EXPR_EQUALS_HPP__
#define __EXPR_EQUALS_HPP__

#include "expr/base_boolean_expression.hpp"
#include "expr/linear_expression.hpp"

namespace bear
{
  namespace expr
  {
    /**
     * \brief A boolean expression that checks the equality of two linear
     *        expressions.
     * \author Julien Jorge
     */
    class EXPR_EXPORT linear_equality:
      public base_boolean_expression
    {
    public:
      linear_equality
      ( const linear_expression& left, const linear_expression& right );

      base_boolean_expression* clone() const;
      bool evaluate() const;

    private:
      /** \brief The left operand. */
      linear_expression m_left;

      /** \brief The right operand. */
      linear_expression m_right;

    }; // class equals

  } // namespace expr
} // namespace bear

#endif // __EXPR_EQUALS_HPP__
