/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bonus_box.cpp
 * \brief Implementation of the ptb::bonus_box class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/bonus_box.hpp"

#include "universe/collision_info.hpp"
#include "generic_items/decorative_item.hpp"
#include "ptb/item/plee/plee.hpp"
#include "engine/game.hpp"

#include "engine/export.hpp"

BASE_ITEM_EXPORT( bonus_box, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialize the item.
 */
void ptb::bonus_box::build()
{
  super::build();

  m_broken_bottom =
    get_level_globals().auto_sprite
    ( "gfx/bonus-box-extra.png", "broken box bottom" );
  m_broken_top =
    get_level_globals().auto_sprite
    ( "gfx/bonus-box-extra.png", "broken box top" );

  switch(get_type())
    {
    case fire_power:
      set_animation
	( get_level_globals().get_animation("animation/powerup/fire.canim") );
      break;
    case air_power:
      set_animation
	( get_level_globals().get_animation("animation/powerup/air.canim") );
      break;
    case water_power:
      set_animation
	( get_level_globals().get_animation("animation/powerup/water.canim") );
      break;
    case invincibility_power:
      set_animation( get_level_globals().get_animation
		     ("animation/powerup/invincibility.canim") );
      break;
    case stones_stock:
      set_animation( get_level_globals().get_animation
		     ("animation/powerup/stones_stock.canim") );
      if (get_stock() == 0)
        set_stock(20);
      break;
    case stones_big_stock:
      set_animation( get_level_globals().get_animation
		     ("animation/powerup/stones_big_stock.canim") );
      if (get_stock() == 0)
        set_stock(50);
      break;
    case one_more_life:
      set_animation( get_level_globals().get_animation
		     ("animation/powerup/one_more_life.canim") );
      if (get_stock() == 0)
        set_stock(1);
      break;
      case increase_max_energy:
      set_animation( get_level_globals().get_animation
		     ("animation/powerup/increase_max_energy.canim") );
      if (get_stock() == 0)
        set_stock(20);
      break;
    default:
      {
        CLAW_ASSERT( false, "'unknown_type' is not a valid power." );
      }
    }

  set_size( 50, 80 );
  set_gap_x(-5);
} // bonus_box::build()

/*----------------------------------------------------------------------------*/
/**
 * \brief Check if the collision is with a player.
 * \param that The other item of the collision.
 * \param info Some informations about the collision.
 */
void ptb::bonus_box::collision_check_and_apply
( bear::engine::base_item& that, bear::universe::collision_info& info )
{
  plee* p = dynamic_cast<plee*>(&that);

  if ( p != NULL )
    {
      if ( !get_bonus_given() &&
	   ( ( info.get_collision_side() ==
	     bear::universe::zone::middle_left_zone ) ||
	   ( info.get_collision_side() ==
	     bear::universe::zone::middle_right_zone ) ) &&
	   p->is_in_offensive_phase() )
        {
          give_bonus(p);
          create_broken_bonus_box();
          create_broken_glass(p->get_rendering_attributes().is_mirrored());
        }
      else
        default_collision(info);
    }
  else
    default_collision(info);
} // bonus_box::collision_check_and_apply()

/*----------------------------------------------------------------------------*/
/**
 * \brief Call collision_check_and_apply().
 * \param that The other item of the collision.
 * \param info Some informations about the collision.
 */
void ptb::bonus_box::collision
( bear::engine::base_item& that, bear::universe::collision_info& info )
{
  collision_check_and_apply(that, info);
} // bonus_box::collision()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create a decoration of a broken bonus_box.
 */
void ptb::bonus_box::create_broken_bonus_box()
{
   bear::decorative_item* item = new bear::decorative_item;

   item->set_sprite(m_broken_bottom);
   item->set_z_position(get_z_position());

   new_item( *item );

   item->set_bottom_middle(get_bottom_middle());

   CLAW_ASSERT
     ( item->is_valid(),
       "The decoration of broken bonus_box isn't correctly initialized" );
} // bonus_box::create_broken_bonus_box()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create a decoration of a broken glass.
 * \param left_orientation Indicates if the glass go on the left.
 */
void ptb::bonus_box::create_broken_glass(bool left_orientation)
{
  bear::decorative_item* item = new bear::decorative_item;

  item->set_sprite(m_broken_top);
  item->get_rendering_attributes().set_angle(get_visual_angle());
  item->set_z_position(get_z_position());
  item->set_mass(80);
  item->set_density(2);
  item->set_phantom(false);
  item->set_artificial(false);

  bear::universe::force_type force(1500000, 3000000);
  if ( left_orientation )
    force.x *= -1;

  double a = (1.0 * rand() / RAND_MAX)+0.5;
  item->add_internal_force(force*a);

  new_item( *item );

  item->set_top_middle(get_top_middle());

  CLAW_ASSERT( item->is_valid(),
         "The decoration of broken glass isn't correctly initialized" );
} // bonus_box::create_broken_bonus_box()
