/*
    Bear Engine - Model editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/impl/fields_frame.tpp
 * \brief Implementation of the template methods of the bf::fields_frame
 *        class.
 * \author Julien Jorge
 */

#include "bf/model_frame.hpp"
#include "bf/history/action_set_item_field.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the value of a field.
 * \param item The item in which the field is changed.
 * \param name The name of the field.
 * \param v The new value.
 */
template<typename Type>
void bf::fields_frame::do_set_field_value
( item_instance& item, const std::string&name, const Type& v )
{
m_model_frame->do_action( new action_set_item_field<Type>( &item, name, v ) );
} // fields_frame::do_set_field_value()
